/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.io.efs;

import com.aptana.core.io.efs.Messages;
import com.aptana.core.io.efs.VirtualFile;
import com.aptana.core.io.vfs.IConnectionFileManager;
import com.aptana.core.io.vfs.VirtualConnectionManager;
import com.aptana.core.logging.IdeLog;
import com.aptana.ide.core.io.CoreIOPlugin;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.IFileTree;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;

public class VirtualFileSystem
extends FileSystem {
    public static final String SCHEME_VIRTUAL = "aptanavfs";
    private static VirtualFileSystem instance;
    private int attributes = -1;

    public VirtualFileSystem() {
        VirtualFileSystem.setInstance(this);
    }

    private static void setInstance(VirtualFileSystem object) {
        instance = object;
    }

    public static IFileSystem getInstance() {
        if (instance == null) {
            try {
                EFS.getFileSystem((String)SCHEME_VIRTUAL);
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return instance;
    }

    public int attributes() {
        if (this.attributes != -1) {
            return this.attributes;
        }
        this.attributes = 0;
        this.attributes |= 2;
        this.attributes |= 4;
        this.attributes |= 0x60;
        return this.attributes;
    }

    public boolean canDelete() {
        return true;
    }

    public boolean canWrite() {
        return true;
    }

    public IFileTree fetchFileTree(IFileStore root, IProgressMonitor monitor) {
        if (root instanceof VirtualFile) {
            try {
                return ((VirtualFile)root).fetchFileTree(null, monitor);
            }
            catch (CoreException e) {
                IdeLog.logWarning((Plugin)CoreIOPlugin.getDefault(), (String)Messages.VirtualFileSystem_ERR_FetchFileTree, (Throwable)e);
            }
        }
        return null;
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public IFileStore getStore(IPath path) {
        return EFS.getNullFileSystem().getStore(path);
    }

    public IFileStore getStore(URI uri) {
        if (SCHEME_VIRTUAL.equals(uri.getScheme())) {
            URI rootURI = VirtualConnectionManager.getVirtualRootURI(uri);
            IConnectionFileManager fileManager = VirtualConnectionManager.getInstance().getVirtualFileManager(rootURI);
            if (fileManager != null) {
                return new VirtualFile(fileManager, rootURI, (IPath)new Path(uri.getPath()));
            }
        }
        return EFS.getNullFileSystem().getStore(uri);
    }
}

