/*
 * Decompiled with CFR 0.152.
 */
package beaver.comp;

import beaver.comp.Action;
import beaver.comp.Configuration;
import beaver.spec.GrammarSymbol;
import java.util.HashMap;
import java.util.Map;

class State {
    State next;
    int id;
    Configuration.Set conf_set;
    Action.List actions;
    Action.List terminal_lookahead_actions;
    Action.List nonterminal_lookahead_actions;
    Action default_action;

    State(int num, Configuration.Set core) {
        this.id = num;
        this.conf_set = core;
        this.actions = new Action.List(this);
        this.terminal_lookahead_actions = new Action.List(this);
        this.nonterminal_lookahead_actions = new Action.List(this);
    }

    boolean findLookaheads() {
        boolean more_found = false;
        Configuration conf = this.conf_set.first_conf;
        while (conf != null) {
            if (!conf.has_contributed) {
                if (conf.findLookaheads()) {
                    more_found = true;
                }
                conf.has_contributed = true;
            }
            conf = conf.next;
        }
        return more_found;
    }

    void splitActions() {
        this.default_action = this.actions.split(this.terminal_lookahead_actions, this.nonterminal_lookahead_actions);
    }

    static class Factory {
        private State last_state;
        private int num_states;
        private Map states = new HashMap(89);
        private Configuration.Set.Factory conf_set_factory;

        Factory(Configuration.Set.Factory conf_set_factory) {
            this.conf_set_factory = conf_set_factory;
        }

        State getState(Configuration.Set core) {
            State state = (State)this.states.get(core);
            if (state == null) {
                core.buildClosure();
                state = new State(++this.num_states, core);
                this.states.put(core, state);
                this.last_state = this.last_state == null ? state : (this.last_state.next = state);
                this.buildShiftsFrom(state);
            } else {
                state.conf_set.appendReversePropagation(core);
            }
            return state;
        }

        private void buildShiftsFrom(State state) {
            state.conf_set.resetContributionFlags();
            Configuration conf = state.conf_set.first_conf;
            while (conf != null) {
                if (!conf.has_contributed && !conf.isDotAfterLastSymbol()) {
                    this.conf_set_factory.reset();
                    GrammarSymbol marked_symbol = conf.getSymbolAfterDot();
                    Configuration nconf = conf;
                    while (nconf != null) {
                        if (!nconf.has_contributed && !nconf.isDotAfterLastSymbol() && nconf.getSymbolAfterDot() == marked_symbol) {
                            Configuration new_core_conf = this.conf_set_factory.addConfiguration(nconf.rule, nconf.dot + 1);
                            new_core_conf.addReversePropagation(nconf);
                            nconf.has_contributed = true;
                        }
                        nconf = nconf.next;
                    }
                    State new_state = this.getState(this.conf_set_factory.getCore());
                    state.actions.add(new Action.Shift(marked_symbol, new_state));
                }
                conf = conf.next;
            }
        }
    }
}

