/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.snippets.ui.views;

import com.aptana.scripting.model.SnippetElement;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class SnippetsFilter
extends ViewerFilter {
    private Pattern pattern;

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.pattern != null && element instanceof SnippetElement) {
            SnippetElement snippetElement = (SnippetElement)element;
            if (snippetElement.getDisplayName() != null && this.pattern.matcher(snippetElement.getDisplayName()).find()) {
                return true;
            }
            if (snippetElement.getDescription() != null && this.pattern.matcher(snippetElement.getDescription()).find()) {
                return true;
            }
            if (snippetElement.getTags() != null) {
                for (String tag : snippetElement.getTags()) {
                    if (!this.pattern.matcher(tag).find()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

