/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.ProcessUtil;
import com.pandora.core.utils.StringUtil;
import com.pandora.core.utils.URLEncoder;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class URIUtils {
    public static String resolveURI(String baseURI, String refUri) {
        URI result;
        block3: {
            try {
                URI base = new URI(URIUtils.encodePath(baseURI));
                result = base.resolve(new URI(URIUtils.encodePath(refUri)));
                if (result != null) break block3;
                return null;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        return URIUtils.decodePath(result.toString());
    }

    public static String relativeURI(String parentPath, String absolutePath) {
        String dilimiter = "/";
        String[] parentPaths = parentPath.split(dilimiter);
        String[] editorPaths = absolutePath.split(dilimiter);
        int start = 0;
        int i = 0;
        while (i < parentPaths.length) {
            if (editorPaths.length - 1 < i || !parentPaths[i].equals(editorPaths[i])) break;
            ++start;
            ++i;
        }
        StringBuffer ends = new StringBuffer();
        int i2 = start + 1;
        while (i2 < parentPaths.length) {
            ends.append("../");
            ++i2;
        }
        i2 = start;
        while (i2 < editorPaths.length) {
            ends.append(editorPaths[i2]).append(i2 < editorPaths.length - 1 ? "/" : "");
            ++i2;
        }
        return ends.toString().replace("//", "/");
    }

    public static String resolveURIInProject(IFile baseFile, String refUri) {
        String basePath = baseFile.getLocation().makeAbsolute().toFile().getPath();
        basePath = URIUtils.encodePath(basePath);
        refUri = URIUtils.resolveURI(basePath, refUri);
        if ((refUri = URIUtils.decodePath(refUri)) == null) {
            return "";
        }
        String projectLocation = baseFile.getProject().getLocation().toOSString();
        if (!(projectLocation = projectLocation.replace("\\", "/")).endsWith("/")) {
            projectLocation = String.valueOf(projectLocation) + "/";
        }
        refUri = refUri.replaceFirst(projectLocation, "");
        return refUri;
    }

    public static String relativeLocation(String absolutePath, String containerPath) {
        return absolutePath.substring(containerPath.length());
    }

    public static String decodePath(String path) {
        if (StringUtil.isEmpty(path)) {
            return "";
        }
        try {
            return URLDecoder.decode(path, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String encodePath(String path) {
        if (StringUtil.isEmpty(path)) {
            return "";
        }
        String proto = "file:/";
        try {
            String s = URLEncoder.encode(new URL(String.valueOf(proto) + path)).getPath();
            if (s.startsWith("/")) {
                s = s.substring(1);
            }
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static boolean open(URI uri) {
        if (uri == null) {
            return false;
        }
        if (!"file".equalsIgnoreCase(uri.getScheme())) {
            return false;
        }
        File file = new File(uri);
        return URIUtils.open(file);
    }

    public static boolean open(File file) {
        if (Platform.getOS().equals("macosx")) {
            return URIUtils.openInFinder(file);
        }
        if (Platform.getOS().equals("win32")) {
            return URIUtils.openInWindowsExplorer(file);
        }
        return URIUtils.openOnLinux(file);
    }

    private static boolean openInWindowsExplorer(File file) {
        try {
            Runtime.getRuntime().exec("explorer " + (file.isFile() ? "/select,\"" : "") + file.getAbsolutePath() + "\"");
            return true;
        }
        catch (Exception e) {
            HBLog.logError((Plugin)Activator.getDefault(), e);
            return false;
        }
    }

    private static boolean openInFinder(File file) {
        return URIUtils.openInFinder(file, file.isFile());
    }

    public static boolean openInFinder(File file, boolean reveal) {
        String path = file.getAbsolutePath();
        String subcommand = reveal ? "reveal" : "open";
        String appleScript = "tell application \"Finder\" to " + subcommand + " (POSIX file \"" + path + "\")\ntell application \"Finder\" to activate";
        IStatus result = ProcessUtil.runInBackground("osascript", null, "-e", appleScript);
        return result != null && result.isOK();
    }

    private static boolean openOnLinux(File file) {
        IStatus result;
        if (file.isFile()) {
            file = file.getParentFile();
        }
        if ((result = ProcessUtil.runInBackground("nautilus", null, file.getAbsolutePath())) == null) {
            return false;
        }
        return result.isOK();
    }

    public static String getFileName(URI uri) {
        if (uri == null) {
            return null;
        }
        String uriPath = uri.getPath();
        IPath path = Path.fromPortableString((String)uriPath);
        if (path == null) {
            return null;
        }
        return path.lastSegment();
    }

    public static String decodeURI(String uri) {
        String result = null;
        if (uri != null) {
            try {
                result = URLDecoder.decode(uri, "utf-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return result;
    }
}

