/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class StringUtil {
    public static final String EMPTY = "";
    public static final String EMAIL_REGEX = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    public static final String LINE_SPLITTER_REGEX = "\r?\n|\r";
    public static final String REGEX_NEWLINE_GROUP = StringUtil.format("({0})", "\r?\n|\r");
    public static final Pattern LINE_SPLITTER = Pattern.compile("\r?\n|\r");
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("\\<.*?\\>");

    public static boolean areEqualIgnoreCase(String s1, String s2) {
        return s1 == null ? s2 == null : (s2 != null ? s1.equalsIgnoreCase(s2) : false);
    }

    public static int characterInstanceCount(String source, char c) {
        int result = -1;
        if (source != null) {
            int length = source.length();
            result = 0;
            int i = 0;
            while (i < length) {
                if (source.charAt(i) == c) {
                    ++result;
                }
                ++i;
            }
        }
        return result;
    }

    public static int compare(String s1, String s2) {
        s1 = StringUtil.getStringValue(s1);
        s2 = StringUtil.getStringValue(s2);
        return s1.compareTo(s2);
    }

    public static int compareCaseInsensitive(String s1, String s2) {
        s1 = StringUtil.getStringValue(s1);
        s2 = StringUtil.getStringValue(s2);
        return s1.compareToIgnoreCase(s2);
    }

    public static String concat(Collection<String> items) {
        return items != null ? StringUtil.join(null, items.toArray(new String[items.size()])) : null;
    }

    public static String concat(String ... items) {
        return StringUtil.join(null, items);
    }

    public static boolean contains(String[] set, String toFind) {
        if (set != null && toFind != null) {
            String[] stringArray = set;
            int n = set.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (value.equals(toFind)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static String ellipsify(String message) {
        return message == null ? null : String.valueOf(message) + "...";
    }

    public static int findNextWhitespaceOffset(String string, int offset) {
        int i = -1;
        if (string == null || EMPTY.equals(string) || offset > string.length()) {
            return i;
        }
        int j = offset;
        while (j < string.length()) {
            char ch = string.charAt(j);
            if (Character.isWhitespace(ch)) {
                i = j;
                break;
            }
            ++j;
        }
        return i;
    }

    public static int findPreviousWhitespaceOffset(String string, int offset) {
        int i = -1;
        if (string == null || EMPTY.equals(string) || offset > string.length()) {
            return i;
        }
        int j = offset;
        while (j > 0) {
            char ch = string.charAt(j - 1);
            if (Character.isWhitespace(ch)) {
                i = j - 1;
                break;
            }
            --j;
        }
        return i;
    }

    public static String format(String str, int replacement) {
        return MessageFormat.format(str, Integer.toString(replacement));
    }

    public static String format(String str, long replacement) {
        return MessageFormat.format(str, Long.toString(replacement));
    }

    public static String format(String str, Object replacement) {
        return MessageFormat.format(str, replacement.toString());
    }

    public static String format(String str, Object[] replacements) {
        return MessageFormat.format(str, replacements);
    }

    public static String format(String str, String replacement) {
        return MessageFormat.format(str, replacement);
    }

    public static String getStringValue(Object object) {
        return object != null ? object.toString() : EMPTY;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        int i = 0;
        while (i < strLen) {
            if (!Character.isWhitespace(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtil.isBlank(str);
    }

    public static String join(String delimiter, Collection<String> items) {
        return items != null ? StringUtil.join(delimiter, items.toArray(new String[items.size()])) : null;
    }

    public static String join(String delimiter, Object ... items) {
        String[] s = new String[items.length];
        int i = 0;
        while (i < items.length) {
            Object item = items[i];
            s[i] = item == null ? "null" : item.toString();
            ++i;
        }
        return StringUtil.join(delimiter, s);
    }

    public static String join(String delimiter, char ... items) {
        String[] strings = new String[items.length];
        int i = 0;
        while (i < items.length) {
            strings[i] = new String(items, i, 1);
            ++i;
        }
        return StringUtil.join(delimiter, strings);
    }

    public static String join(String delimiter, String ... items) {
        String result = null;
        if (items != null) {
            switch (items.length) {
                case 0: {
                    result = EMPTY;
                    break;
                }
                case 1: {
                    result = items[0];
                    break;
                }
                default: {
                    int lastIndex = items.length - 1;
                    int delimiterLength = delimiter != null ? delimiter.length() : 0;
                    int targetLength = lastIndex * delimiterLength;
                    int i = 0;
                    while (i <= lastIndex) {
                        targetLength += items[i].length();
                        ++i;
                    }
                    int offset = 0;
                    char[] accumulator = new char[targetLength];
                    if (delimiterLength != 0) {
                        int i2 = 0;
                        while (i2 < lastIndex) {
                            String item = items[i2];
                            int length = item.length();
                            item.getChars(0, length, accumulator, offset);
                            delimiter.getChars(0, delimiterLength, accumulator, offset += length);
                            offset += delimiterLength;
                            ++i2;
                        }
                        String item = items[lastIndex];
                        item.getChars(0, item.length(), accumulator, offset);
                    } else {
                        int i3 = 0;
                        while (i3 <= lastIndex) {
                            String item = items[i3];
                            int length = item.length();
                            item.getChars(0, length, accumulator, offset);
                            offset += length;
                            ++i3;
                        }
                    }
                    result = new String(accumulator);
                }
            }
        }
        return result;
    }

    public static String makeFormLabel(String message) {
        return message == null ? null : String.valueOf(message) + ":";
    }

    public static String pad(String string, int desiredLength, char padChar) {
        int diff;
        if (string == null) {
            string = EMPTY;
        }
        if ((diff = desiredLength - string.length()) > 0) {
            string = String.valueOf(StringUtil.repeat(padChar, diff)) + string;
        }
        return string;
    }

    public static String quote(String string) {
        return string == null ? null : String.valueOf('\'') + string + '\'';
    }

    public static String replace(String str, String pattern, String replace) {
        if (str == null) {
            return null;
        }
        int s = 0;
        int e = 0;
        StringBuilder result = new StringBuilder();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    public static String replaceAll(String template, Map<String, String> variables) {
        if (template == null || variables == null || variables.isEmpty()) {
            return template;
        }
        for (Map.Entry<String, String> entry : variables.entrySet()) {
            String value = entry.getValue();
            value = value == null ? EMPTY : value.replace('$', '\u0001');
            template = template.replaceAll(entry.getKey(), value).replace('\u0001', '$');
        }
        return template;
    }

    public static boolean startsWith(String string, char c) {
        return !StringUtil.isEmpty(string) && string.charAt(0) == c;
    }

    public static boolean startsWith(String string, String prefix) {
        return !StringUtil.isEmpty(string) && string.startsWith(prefix);
    }

    public static String stripUTF8BOM(String input) throws UnsupportedEncodingException {
        if (StringUtil.isEmpty(input) || input.length() < 2) {
            return input;
        }
        byte[] b = input.substring(0, 2).getBytes("UTF-8");
        if (Integer.toHexString(b[0] & 0xFF).equals("ef") && Integer.toHexString(b[1] & 0xFF).equals("bb") && Integer.toHexString(b[2] & 0xFF).equals("bf")) {
            input = input.substring(1, input.length());
        }
        return input;
    }

    public static String stripHTMLTags(String textWithHTML) {
        return !StringUtil.isEmpty(textWithHTML) ? HTML_TAG_PATTERN.matcher(textWithHTML).replaceAll(EMPTY) : textWithHTML;
    }

    public static List<String> tokenize(String inputString, String delim) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (inputString == null) {
            return tokens;
        }
        StringTokenizer tokenizer = new StringTokenizer(inputString, delim);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    public static String truncate(String text, int length) {
        if (text == null || text.length() <= length) {
            return text;
        }
        return new String(StringUtil.ellipsify(text.substring(0, length)));
    }

    public static String repeat(char c, int times) {
        char[] buf = new char[times];
        int i = 0;
        while (i < times) {
            buf[i] = c;
            ++i;
        }
        return new String(buf);
    }

    private StringUtil() {
    }

    public static List<String> split(String string, char toSplit) {
        ArrayList<String> ret = new ArrayList<String>();
        int len = string.length();
        int last = 0;
        char c = '\u0000';
        int i = 0;
        while (i < len) {
            c = string.charAt(i);
            if (c == toSplit) {
                if (last != i) {
                    ret.add(string.substring(last, i));
                }
                while (c == toSplit && i < len - 1) {
                    c = string.charAt(++i);
                }
                last = i;
            }
            ++i;
        }
        if (c != toSplit) {
            if (last == 0 && len > 0) {
                ret.add(string);
            } else if (last < len) {
                ret.add(string.substring(last, len));
            }
        }
        ret.trimToSize();
        return ret;
    }

    public static List<String> dotSplit(String string) {
        return StringUtil.split(string, '.');
    }

    public static String avoidNull(String str) {
        if (StringUtil.isEmpty(str)) {
            return EMPTY;
        }
        return str;
    }

    public static String dotFirst(String string) {
        int i = string.indexOf(46);
        return i != -1 ? string.substring(0, i) : string;
    }

    public static String stripQuotes(String text) {
        if (text.length() >= 2 && (text.charAt(0) == '\'' || text.charAt(0) == '\"')) {
            return text.substring(1, text.length() - 1);
        }
        return text;
    }

    public static String parseValue(byte[] buf) {
        if (buf == null) {
            return null;
        }
        String ret = new String(buf);
        try {
            ret = new String(buf, "gbk");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        if (ret.charAt(ret.length() - 1) == '\u0000') {
            return ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public static boolean isEmail(String s) {
        if (s == null) {
            return false;
        }
        return s.matches(EMAIL_REGEX);
    }

    public static boolean isInt(String s) {
        if (s == null) {
            return false;
        }
        try {
            Integer.parseInt(s);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isBoolean(String s) {
        if (s == null) {
            return false;
        }
        return "true".equals(s.toLowerCase()) || "false".equals(s.toLowerCase());
    }

    public static boolean isUrl(String s) {
        if (s == null) {
            return false;
        }
        try {
            new URL(s);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public static boolean isIdentifier(String name) {
        if (StringUtil.isEmpty(name)) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < name.length()) {
            if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String toBolder(String content) {
        return "<span style='font-size:14px;'>" + content + "</span>";
    }

    public static String abbreviate(String str, int maxWidth) {
        return StringUtil.abbreviate(str, 0, maxWidth);
    }

    public static String abbreviate(String str, int offset, int maxWidth) {
        if (str == null) {
            return null;
        }
        if (maxWidth < 4) {
            throw new IllegalArgumentException("Minimum abbreviation width is 4");
        }
        if (str.length() <= maxWidth) {
            return str;
        }
        if (offset > str.length()) {
            offset = str.length();
        }
        if (str.length() - offset < maxWidth - 3) {
            offset = str.length() - (maxWidth - 3);
        }
        if (offset <= 4) {
            return String.valueOf(str.substring(0, maxWidth - 3)) + "...";
        }
        if (maxWidth < 7) {
            throw new IllegalArgumentException("Minimum abbreviation width with offset is 7");
        }
        if (offset + (maxWidth - 3) < str.length()) {
            return "..." + StringUtil.abbreviate(str.substring(offset), maxWidth - 3);
        }
        return "..." + str.substring(str.length() - (maxWidth - 3));
    }

    public static String trimToEmpty(String str) {
        if (str == null) {
            return EMPTY;
        }
        return str.trim();
    }
}

