/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.utils;

import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class PlatformUtil {
    public static final PlatformOs platform;
    private static boolean IS_WINDOWS_XP;
    private static String OS_VERSION;

    static {
        PlatformOs tempPlatform;
        IS_WINDOWS_XP = false;
        String env = System.getProperty("os.name").toLowerCase();
        if (Activator.getDefault() != null) {
            String os = Platform.getOS();
            tempPlatform = os.equals("win32") ? PlatformOs.WINDOWS : (os.equals("macosx") ? PlatformOs.MAC : PlatformOs.LINUX);
            if ("windows xp".equals(env)) {
                IS_WINDOWS_XP = true;
            }
        } else {
            tempPlatform = env.indexOf("win") != -1 ? PlatformOs.WINDOWS : (env.startsWith("mac os") ? PlatformOs.MAC : PlatformOs.LINUX);
            if ("windows xp".equals(env)) {
                IS_WINDOWS_XP = true;
            }
        }
        platform = tempPlatform;
    }

    public static boolean isWindows() {
        return platform == PlatformOs.WINDOWS;
    }

    public static boolean isWindowsXP() {
        return IS_WINDOWS_XP;
    }

    public static boolean isMac() {
        return platform == PlatformOs.MAC;
    }

    public static double getDPIScale() {
        String dpi = System.getProperty("dpi-scale");
        if (dpi != null) {
            try {
                return Double.parseDouble(dpi);
            }
            catch (Exception exception) {}
        }
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getOSVersion() {
        if (OS_VERSION == null) {
            if (PlatformUtil.isWindows()) {
                try {
                    final Process process = Runtime.getRuntime().exec("cmd ver");
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                BufferedReader inputStream = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("gbk")));
                                OS_VERSION = inputStream.readLine();
                                Process process2 = process;
                                synchronized (process2) {
                                    process.notify();
                                }
                            }
                            catch (Exception e) {
                                HBLog.logError((Plugin)Activator.getDefault(), e);
                            }
                        }
                    }.start();
                    Process process2 = process;
                    synchronized (process2) {
                        try {
                            process.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    process.destroy();
                }
                catch (Exception e) {
                    HBLog.logError((Plugin)Activator.getDefault(), e);
                }
            }
            if (OS_VERSION == null) {
                OS_VERSION = String.valueOf(System.getProperty("os.name")) + " " + System.getProperty("os.version");
            }
        }
        return OS_VERSION;
    }

    public static enum PlatformOs {
        WINDOWS,
        MAC,
        LINUX;

    }
}

