/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.ui.notifications.internal;

import com.pandora.core.log.HBLog;
import com.pandora.core.ui.notifications.AbstractUiNotification;
import com.pandora.core.ui.notifications.NotificationAction;
import com.pandora.core.ui.notifications.internal.AbstractWorkbenchNotificationPopup;
import com.pandora.core.ui.notifications.internal.ScalingHyperlink;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.ImageUtils;
import com.pandora.core.utils.StringUtil;
import com.pandora.core.utils.ThemeUtil;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.internal.WorkbenchPage;

public class NotificationPopup
extends AbstractWorkbenchNotificationPopup {
    private static final int MAX_LABEL_CHAR_LENGTH = 120;
    private static final int MAX_DESCRIPTION_CHAR_LENGTH = 500;
    private static final int MIN_HEIGHT = 75;
    private static final int MIN_WIDTH = 200;
    private static final int MAX_WIDTH = 400;
    private static final int PADDING_EDGE = 5;
    private AbstractUiNotification notification;
    private List<ScalingHyperlink> links = new ArrayList<ScalingHyperlink>();
    private DisposeListener listener;
    private BlockPopupOnModalShellActivationListener blockPopupListener;

    private Label getTitleLabel(Control c) {
        if (c instanceof Label) {
            Label l = (Label)c;
            if (this.getPopupShellTitle().equals(l.getText())) {
                return l;
            }
        }
        if (c instanceof Composite) {
            Control[] controlArray = ((Composite)c).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control cc = controlArray[n2];
                Label l = this.getTitleLabel(cc);
                if (l != null) {
                    return l;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public void closeFade() {
        if (this.blockPopupListener.popupBlocked) {
            this.scheduleAutoClose();
            return;
        }
        if (this.blockPopupListener.popupReactivated) {
            this.blockPopupListener.popupReactivated = false;
            this.scheduleAutoClose();
            return;
        }
        super.closeFade();
    }

    public NotificationPopup(Shell shell) {
        super(shell);
    }

    public NotificationPopup(Shell shell, int style) {
        super(shell, style);
    }

    public AbstractUiNotification getNotification() {
        return this.notification;
    }

    public void setNotification(AbstractUiNotification notification) {
        this.notification = notification;
        if (this.notification != null && this.notification.getDelayClose() > 0L) {
            this.setDelayClose(this.notification.getDelayClose());
        }
    }

    @Override
    protected Image getPopupShellImage(int maximumHeight) {
        if (this.notification instanceof AbstractUiNotification) {
            Image image = this.notification.getNotificationImage();
            if (image != null) {
                ImageData imageData = image.getImageData();
                if (imageData.height > maximumHeight) {
                    try {
                        final Image newImage = ImageUtils.scaleImage(image, imageData.width, maximumHeight, false);
                        this.getShell().addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (newImage != null) {
                                    newImage.dispose();
                                }
                            }
                        });
                        return newImage;
                    }
                    catch (Exception e) {
                        HBLog.logError((Plugin)Activator.getDefault(), e);
                    }
                }
            }
            return image;
        }
        return super.getPopupShellImage(maximumHeight);
    }

    @Override
    protected void createContentArea(Composite parent) {
        Composite contentComposite = new Composite(parent, 524288);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginBottom = 0;
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)contentComposite);
        contentComposite.setLayout((Layout)gridLayout);
        Label labelText = new Label(contentComposite, 524352);
        labelText.setForeground(ThemeUtil.getForegroundColor());
        labelText.setText(StringUtil.abbreviate(this.notification.getLabel(), 120));
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)labelText);
        String description = this.notification.getDescription();
        if (StringUtil.isNotBlank(description)) {
            Label descriptionText = new Label(contentComposite, 64);
            descriptionText.setForeground(ThemeUtil.getForegroundColor());
            descriptionText.setText(StringUtil.abbreviate(description, 500));
            GridDataFactory.fillDefaults().span(2, -1).grab(true, false).align(4, 128).applyTo((Control)descriptionText);
        }
        if (this.notification instanceof AbstractUiNotification) {
            AbstractUiNotification executableNotification = this.notification;
            Composite linksComposite = new Composite(contentComposite, 655360);
            GridDataFactory.fillDefaults().span(2, -1).grab(true, false).align(0x1000008, 0x1000008).applyTo((Control)linksComposite);
            GridLayoutFactory.fillDefaults().numColumns(executableNotification.getActions().size()).applyTo(linksComposite);
            for (final NotificationAction action : executableNotification.getActions()) {
                if (action == null) continue;
                ScalingHyperlink actionLink = new ScalingHyperlink(linksComposite, 132096);
                GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)actionLink);
                Color linkColor = JFaceResources.getColorRegistry().get("HYPERLINK_COLOR");
                actionLink.setForeground(linkColor);
                actionLink.setText(action.getName());
                actionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        NotificationPopup.this.close(false);
                        try {
                            action.execute();
                        }
                        catch (Exception ex) {
                            HBLog.logError((Plugin)Activator.getDefault(), ex);
                        }
                    }
                });
                this.links.add(actionLink);
            }
        }
    }

    @Override
    protected String getPopupShellTitle() {
        return this.notification.getTitle();
    }

    @Override
    protected Color getTitleForeground() {
        return this.notification.getTitleForeground();
    }

    @Override
    protected Color getTitleBackground() {
        return this.notification.getTitleBackground();
    }

    @Override
    protected Color getContentBackground() {
        return this.notification.getContentBackground();
    }

    @Override
    protected void initializeBounds() {
        final Shell parentShell = this.getParentShell();
        Shell shell = this.getShell();
        if (this.listener != null) {
            shell.addDisposeListener(this.listener);
        }
        Point initialSize = shell.computeSize(-1, -1);
        int height = Math.max(initialSize.y, 75);
        int width = Math.min(initialSize.x, 400);
        width = Math.max(initialSize.x, 200);
        Point size = new Point(width, height);
        Control parent = this.setLcation(parentShell, shell, size, false);
        shell.setSize(size);
        final ControlListener changeLcationListener = new ControlListener(){

            public void controlResized(ControlEvent e) {
                NotificationPopup.this.resetLcation(e);
            }

            public void controlMoved(ControlEvent e) {
                NotificationPopup.this.resetLcation(e);
            }
        };
        final DisposeListener disposeListener = new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Shell shell = NotificationPopup.this.getShell();
                if (shell != null && !shell.isDisposed()) {
                    NotificationPopup.this.close();
                }
            }
        };
        final Control parentControl = parent;
        if (parentControl != parentShell) {
            parentControl.addControlListener(changeLcationListener);
            parentControl.addDisposeListener(disposeListener);
        }
        parentShell.addControlListener(changeLcationListener);
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (parentControl != parentShell) {
                    parentControl.removeControlListener(changeLcationListener);
                }
                parentControl.removeDisposeListener(disposeListener);
                parentShell.removeControlListener(changeLcationListener);
            }
        });
    }

    private void resetLcation(ControlEvent e) {
        try {
            Object obj = e.getSource();
            if (obj instanceof Control) {
                Control control = (Control)obj;
                if (control.isDisposed()) {
                    return;
                }
                if (this.getShell() != null && this.getShell().isDisposed()) {
                    return;
                }
                this.setLcation(this.getParentShell(), this.getShell(), null, true);
            }
        }
        catch (Exception ex) {
            HBLog.logError((Plugin)Activator.getDefault(), ex);
        }
    }

    protected Control setLcation(Shell parentShell, Shell shell, Point size, boolean resetLcation) {
        if (size == null) {
            size = shell.getSize();
        }
        Shell parent = null;
        Point point = null;
        if (this.notification.getLocation() == 2) {
            Control control = ((WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getEditorPresentation().getActiveWorkbook().getControl();
            parent = control;
            Rectangle locationArea = control.getBounds();
            point = control.toDisplay(0, 0);
            locationArea.x = point.x;
            locationArea.y = point.y;
            point = new Point(locationArea.x + (locationArea.width - size.x) / 2 - 5, locationArea.y + 5 + 5);
            point = this.notification.customPoint(locationArea, size, point);
        } else {
            parent = parentShell;
            Rectangle locationArea = parentShell.getBounds();
            point = new Point(locationArea.width + locationArea.x - size.x - 5 - 10, locationArea.height + locationArea.y - size.y - 5 - 10);
            point = this.notification.customPoint(locationArea, size, point);
        }
        if (resetLcation) {
            shell.setLocation(point.x, point.y + this.fadeJob.getMovingDistance());
        } else {
            shell.setLocation(point);
        }
        return parent;
    }

    @Override
    public boolean close() {
        return this.close(true);
    }

    public boolean close(boolean closeNotification) {
        if (closeNotification && this.notification != null) {
            this.notification.unhandledIfCan();
        }
        if (this.blockPopupListener != null) {
            PlatformUI.getWorkbench().getDisplay().removeFilter(26, (Listener)this.blockPopupListener);
        }
        this.blockPopupListener = null;
        this.listener = null;
        return super.close();
    }

    @Override
    public void create() {
        super.create();
        this.registerModalShellListener();
        Label titleLabel = this.getTitleLabel(this.getContents());
        if (titleLabel != null) {
            titleLabel.setCursor(this.getParentShell().getDisplay().getSystemCursor(0));
        }
    }

    private void registerModalShellListener() {
        this.blockPopupListener = new BlockPopupOnModalShellActivationListener();
        PlatformUI.getWorkbench().getDisplay().addFilter(26, (Listener)this.blockPopupListener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.listener = listener;
    }

    private final class BlockPopupOnModalShellActivationListener
    implements Listener {
        private boolean popupBlocked = false;
        private boolean popupReactivated = false;

        public BlockPopupOnModalShellActivationListener() {
            IWorkbench workbench = PlatformUI.getWorkbench();
            Shell[] shellArray = workbench.getDisplay().getShells();
            int n = shellArray.length;
            int n2 = 0;
            while (n2 < n) {
                Shell shell = shellArray[n2];
                if (this.isVisibleAndModal(shell) && !this.popupBlocked) {
                    this.deactivate();
                }
                ++n2;
            }
        }

        public void handleEvent(Event event) {
            if (!this.isPopupOpen()) {
                return;
            }
            Widget w = event.widget;
            if (w instanceof Shell) {
                Shell shell = (Shell)w;
                if (this.isVisibleAndModal(shell)) {
                    if (!this.popupBlocked) {
                        this.deactivate();
                    }
                } else if (this.popupBlocked) {
                    this.popupReactivated = true;
                    this.activate();
                }
            }
        }

        private boolean isPopupOpen() {
            return NotificationPopup.this.getShell() != null && !NotificationPopup.this.getShell().isDisposed();
        }

        private boolean isVisibleAndModal(Shell shell) {
            int modal = 229376;
            return shell.isVisible() && (shell.getStyle() & modal) != 0;
        }

        private void deactivate() {
            this.popupBlocked = true;
            for (ScalingHyperlink link : NotificationPopup.this.links) {
                link.setEnabled(false);
            }
        }

        private void activate() {
            this.popupBlocked = false;
            for (ScalingHyperlink link : NotificationPopup.this.links) {
                link.setEnabled(true);
            }
        }
    }
}

