/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.ui.notifications.internal;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class CommonImages {
    private static final URL baseUrl;
    private static ImageRegistry imageRegistry;
    public static final ImageDescriptor NOTIFICATION_CLOSE;
    public static final ImageDescriptor NOTIFICATION_CLOSE_HOVER;

    static {
        Bundle bundle = Platform.getBundle((String)"com.pandora.core.utils");
        if (bundle != null) {
            baseUrl = bundle.getEntry("/icons/");
        } else {
            URL iconsUrl = null;
            try {
                iconsUrl = new URL(CommonImages.class.getResource("CommonImages.class"), "../../../../../../icons/");
            }
            catch (MalformedURLException malformedURLException) {}
            baseUrl = iconsUrl;
        }
        NOTIFICATION_CLOSE = CommonImages.create("full", "notification-close.gif");
        NOTIFICATION_CLOSE_HOVER = CommonImages.create("full", "notification-close-active.gif");
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)CommonImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public static Image getImage(ImageDescriptor imageDescriptor) {
        ImageRegistry imageRegistry = CommonImages.getImageRegistry();
        Image image = imageRegistry.get("" + imageDescriptor.hashCode());
        if (image == null) {
            image = imageDescriptor.createImage(true);
            imageRegistry.put("" + imageDescriptor.hashCode(), image);
        }
        return image;
    }

    private static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry();
        }
        return imageRegistry;
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (baseUrl == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(baseUrl, buffer.toString());
    }
}

