/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.ui.notifications.internal;

import com.pandora.core.ui.notifications.internal.AbstractNotificationPopup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractWorkbenchNotificationPopup
extends AbstractNotificationPopup {
    public AbstractWorkbenchNotificationPopup(Shell shell, int style) {
        super(shell, style);
    }

    public AbstractWorkbenchNotificationPopup(Shell shell) {
        super(shell);
    }

    @Override
    protected Image getPopupShellImage(int maximumHeight) {
        return AbstractWorkbenchNotificationPopup.getWorkbenchShellImage(maximumHeight);
    }

    public static Image getWorkbenchShellImage(int maximumHeight) {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows != null && windows.length > 0 && (workbenchWindow = windows[0]) != null && !workbenchWindow.getShell().isDisposed()) {
            Image image = AbstractWorkbenchNotificationPopup.getWindowsShell().getImage();
            int diff = Integer.MAX_VALUE;
            if (image != null && image.getBounds().height <= maximumHeight) {
                diff = maximumHeight - image.getBounds().height;
            } else {
                image = null;
            }
            Image[] images = AbstractWorkbenchNotificationPopup.getWindowsShell().getImages();
            if (images != null && images.length > 0) {
                Image[] imageArray = images;
                int n = images.length;
                int n2 = 0;
                while (n2 < n) {
                    Image image2 = imageArray[n2];
                    int newDiff = maximumHeight - image2.getBounds().height;
                    if (newDiff >= 0 && newDiff <= diff) {
                        diff = newDiff;
                        image = image2;
                    }
                    ++n2;
                }
            }
            return image;
        }
        return null;
    }

    public static Shell getWindowsShell() {
        if (!PlatformUI.isWorkbenchRunning() || PlatformUI.getWorkbench().isClosing()) {
            return null;
        }
        Shell modal = AbstractWorkbenchNotificationPopup.getModalShellExcluding(null);
        if (modal != null) {
            return modal;
        }
        return AbstractWorkbenchNotificationPopup.getNonModalShell();
    }

    private static Shell getModalShellExcluding(Shell shell) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell[] shells = workbench.getDisplay().getShells();
        int modal = 229376;
        Shell[] shellArray = shells;
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            int style;
            Shell shell2 = shellArray[n2];
            if (shell2.equals(shell)) break;
            if (shell2.isVisible() && ((style = shell2.getStyle()) & modal) != 0) {
                return shell2;
            }
            ++n2;
        }
        return null;
    }

    public static Shell getNonModalShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 0) {
                return windows[0].getShell();
            }
        } else {
            return window.getShell();
        }
        return null;
    }
}

