/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.ui.notifications;

import com.pandora.core.ui.notifications.MessageNotification;
import com.pandora.core.ui.notifications.NotificationAction;
import java.util.Arrays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.FormColors;

public class NotificationFactory {
    private static NotificationFactory notificationHelper;
    private Image errorImage = null;
    private Image askImage = null;
    private Image infoImage = null;
    private FormColors formColors;

    public static NotificationFactory getInstance() {
        if (notificationHelper == null) {
            notificationHelper = new NotificationFactory();
        }
        return notificationHelper;
    }

    public Image getAskImage() {
        return this.askImage;
    }

    public Image getErrorImage() {
        return this.errorImage;
    }

    public Image getInfoImage() {
        return this.infoImage;
    }

    public MessageNotification createEditorInfoNotify(String title, String label, NotificationAction ... actions) {
        return this.createInfoNotify(title, label, 2, null, actions);
    }

    public MessageNotification createEditorInfoNotify(String title, String label, String eventId, NotificationAction ... actions) {
        return this.createInfoNotify(title, label, 2, eventId, actions);
    }

    public MessageNotification createWorkbenchInfoNotify(String title, String label, NotificationAction ... actions) {
        return this.createInfoNotify(title, label, 1, null, actions);
    }

    public MessageNotification createWorkbenchInfoNotify(String title, String label, String eventId, NotificationAction ... actions) {
        return this.createInfoNotify(title, label, 1, eventId, actions);
    }

    public MessageNotification createEditorErrorNotify(String title, String label, NotificationAction ... actions) {
        return this.createErrorNotify(title, label, 2, null, actions);
    }

    public MessageNotification createEditorErrorNotify(String title, String label, String eventId, NotificationAction ... actions) {
        return this.createErrorNotify(title, label, 2, eventId, actions);
    }

    public MessageNotification createWorkbenchErrorNotify(String title, String label, NotificationAction ... actions) {
        return this.createErrorNotify(title, label, 1, null, actions);
    }

    public MessageNotification createWorkbenchErrorNotify(String title, String label, String eventId, NotificationAction ... actions) {
        return this.createErrorNotify(title, label, 1, eventId, actions);
    }

    public MessageNotification createEditorAskNotify(String title, String label, NotificationAction ... actions) {
        return this.createAskNotify(title, label, 2, null, actions);
    }

    public MessageNotification createEditorAskNotify(String title, String label, String eventId, NotificationAction ... actions) {
        return this.createAskNotify(title, label, 2, eventId, actions);
    }

    public MessageNotification createWorkbenchAskNotify(String title, String label, NotificationAction ... actions) {
        return this.createAskNotify(title, label, 1, null, actions);
    }

    public MessageNotification createWorkbenchAskNotify(String title, String label, String eventId, NotificationAction ... actions) {
        return this.createAskNotify(title, label, 1, eventId, actions);
    }

    private MessageNotification createErrorNotify(String title, String label, int location, String eventId, NotificationAction ... actions) {
        return this.createNotify(title, label, this.errorImage, Display.getDefault().getSystemColor(3), location, eventId, actions);
    }

    private MessageNotification createInfoNotify(String title, String label, int location, String eventId, NotificationAction ... actions) {
        return this.createNotify(title, label, this.infoImage, this.getFormColors(Display.getDefault()).getColor("org.eclipse.ui.forms.TITLE"), location, eventId, actions);
    }

    private MessageNotification createAskNotify(String title, String label, int location, String eventId, NotificationAction ... actions) {
        return this.createNotify(title, label, this.askImage, this.getFormColors(Display.getDefault()).getColor("org.eclipse.ui.forms.TITLE"), location, eventId, actions);
    }

    public MessageNotification createNotify(String title, String label, Image titleImage, Color titleForeground, int location, String eventId, NotificationAction ... actions) {
        MessageNotification messageNotification = new MessageNotification(title, label, null, eventId);
        messageNotification.setNotificationImage(titleImage);
        if (actions != null && actions.length > 0) {
            messageNotification.setActions(Arrays.asList(actions));
        }
        messageNotification.setLocation(location);
        messageNotification.setTitleForeground(titleForeground);
        return messageNotification;
    }

    public FormColors getFormColors(final Display display) {
        if (this.formColors == null) {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    NotificationFactory.this.formColors = new FormColors(display);
                    NotificationFactory.this.formColors.markShared();
                }
            });
        }
        return this.formColors;
    }
}

