/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.ui;

import com.pandora.core.utils.QRCodeUtils;
import com.pandora.core.utils.StringUtil;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public class URL2QRCodeImage
extends PopupDialog {
    public static final int WIDTH = 160;
    private Shell parentShell;
    private Composite composite;
    private Label imageLabel;
    private Image image;
    private Link messageText;
    private String url;
    private Plugin plugin;
    private Point location;
    private String message;
    private SelectionListener messageSelectionListener;

    public URL2QRCodeImage(Shell parent, String url, Plugin plugin, Point location) {
        super(parent, 4, true, false, false, false, false, null, null);
        this.parentShell = parent;
        this.url = url;
        this.plugin = plugin;
        this.location = location;
    }

    public void setMessageAndListener(String message, SelectionListener messageSelectionListener) {
        this.message = message;
        this.messageSelectionListener = messageSelectionListener;
    }

    protected Control createDialogArea(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayoutData((Object)new GridData(1808));
        GridLayout fillLayout = new GridLayout(1, true);
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        this.composite.setLayout((Layout)fillLayout);
        this.imageLabel = new Label(this.composite, 0);
        this.imageLabel.setLayoutData((Object)new GridData());
        if (StringUtil.isNotBlank(this.message)) {
            this.messageText = new Link(this.composite, 64);
            GridData gridData = new GridData();
            gridData.widthHint = 140;
            this.messageText.setLayoutData((Object)gridData);
            this.messageText.setText(this.message);
            if (this.messageSelectionListener != null) {
                this.messageText.addSelectionListener(this.messageSelectionListener);
            }
        } else {
            if (this.messageText != null && !this.messageText.isDisposed()) {
                this.messageText.dispose();
            }
            this.messageText = null;
        }
        if (this.image != null && !this.image.isDisposed()) {
            this.image.dispose();
        }
        this.image = QRCodeUtils.createQRCodeByUrl(this.url);
        if (this.image == null) {
            MessageDialog.openError((Shell)this.parentShell, (String)"\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25", (String)"\u751f\u6210\u4e8c\u7ef4\u7801\u56fe\u7247\u5931\u8d25");
        } else {
            this.imageLabel.setImage(this.image);
        }
        return this.composite;
    }

    protected Color getBackground() {
        return this.parentShell.getBackground();
    }

    protected Point getInitialLocation(Point initialSize) {
        if (this.location != null) {
            return this.location;
        }
        return super.getInitialLocation(initialSize);
    }
}

