/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign.bouncycastle.util.encoders;

import com.pandora.core.sign.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class HexEncoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int i = 0;
        while (i < this.decodingTable.length) {
            this.decodingTable[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.encodingTable.length) {
            this.decodingTable[this.encodingTable[i]] = (byte)i;
            ++i;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public HexEncoder() {
        this.initialiseDecodingTable();
    }

    @Override
    public int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int i = off;
        while (i < off + length) {
            int v = data[i] & 0xFF;
            out.write(this.encodingTable[v >>> 4]);
            out.write(this.encodingTable[v & 0xF]);
            ++i;
        }
        return length * 2;
    }

    private static boolean ignore(char c) {
        return c == '\n' || c == '\r' || c == '\t' || c == ' ';
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        outLen = 0;
        end = off + length;
        while (end > off) {
            if (!HexEncoder.ignore((char)data[end - 1])) break;
            --end;
        }
        i = off;
        ** GOTO lbl20
        {
            ++i;
            do {
                if (i < end && HexEncoder.ignore((char)data[i])) continue block1;
                b1 = this.decodingTable[data[i++]];
                while (i < end && HexEncoder.ignore((char)data[i])) {
                    ++i;
                }
                if ((b1 | (b2 = this.decodingTable[data[i++]])) < 0) {
                    throw new IOException("invalid characters encountered in Hex data");
                }
                out.write(b1 << 4 | b2);
                ++outLen;
lbl20:
                // 2 sources

            } while (i < end);
        }
        return outLen;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public int decode(String data, OutputStream out) throws IOException {
        length = 0;
        end = data.length();
        while (end > 0) {
            if (!HexEncoder.ignore(data.charAt(end - 1))) break;
            --end;
        }
        i = 0;
        ** GOTO lbl20
        {
            ++i;
            do {
                if (i < end && HexEncoder.ignore(data.charAt(i))) continue block1;
                b1 = this.decodingTable[data.charAt(i++)];
                while (i < end && HexEncoder.ignore(data.charAt(i))) {
                    ++i;
                }
                if ((b1 | (b2 = this.decodingTable[data.charAt(i++)])) < 0) {
                    throw new IOException("invalid characters encountered in Hex string");
                }
                out.write(b1 << 4 | b2);
                ++length;
lbl20:
                // 2 sources

            } while (i < end);
        }
        return length;
    }
}

