/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign.bouncycastle.asn1.copy;

import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Encodable;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Exception;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1ParsingException;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Primitive;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1StreamParser;
import com.pandora.core.sign.bouncycastle.asn1.copy.DERExternal;
import com.pandora.core.sign.bouncycastle.asn1.copy.InMemoryRepresentable;
import java.io.IOException;

public class DERExternalParser
implements ASN1Encodable,
InMemoryRepresentable {
    private ASN1StreamParser _parser;

    public DERExternalParser(ASN1StreamParser parser) {
        this._parser = parser;
    }

    public ASN1Encodable readObject() throws IOException {
        return this._parser.readObject();
    }

    @Override
    public ASN1Primitive getLoadedObject() throws IOException {
        try {
            return new DERExternal(this._parser.readVector());
        }
        catch (IllegalArgumentException e) {
            throw new ASN1Exception(e.getMessage(), e);
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            return this.getLoadedObject();
        }
        catch (IOException ioe) {
            throw new ASN1ParsingException("unable to get DER object", ioe);
        }
        catch (IllegalArgumentException ioe) {
            throw new ASN1ParsingException("unable to get DER object", ioe);
        }
    }
}

