/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign.bouncycastle.asn1.copy;

import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Encodable;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1EncodableVector;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Exception;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1InputStream;
import com.pandora.core.sign.bouncycastle.asn1.copy.ASN1Primitive;
import com.pandora.core.sign.bouncycastle.asn1.copy.BERApplicationSpecificParser;
import com.pandora.core.sign.bouncycastle.asn1.copy.BERFactory;
import com.pandora.core.sign.bouncycastle.asn1.copy.BEROctetStringParser;
import com.pandora.core.sign.bouncycastle.asn1.copy.BERSequenceParser;
import com.pandora.core.sign.bouncycastle.asn1.copy.BERSetParser;
import com.pandora.core.sign.bouncycastle.asn1.copy.BERTaggedObject;
import com.pandora.core.sign.bouncycastle.asn1.copy.BERTaggedObjectParser;
import com.pandora.core.sign.bouncycastle.asn1.copy.DERApplicationSpecific;
import com.pandora.core.sign.bouncycastle.asn1.copy.DERExternalParser;
import com.pandora.core.sign.bouncycastle.asn1.copy.DERFactory;
import com.pandora.core.sign.bouncycastle.asn1.copy.DEROctetString;
import com.pandora.core.sign.bouncycastle.asn1.copy.DEROctetStringParser;
import com.pandora.core.sign.bouncycastle.asn1.copy.DERSequenceParser;
import com.pandora.core.sign.bouncycastle.asn1.copy.DERSetParser;
import com.pandora.core.sign.bouncycastle.asn1.copy.DERTaggedObject;
import com.pandora.core.sign.bouncycastle.asn1.copy.DefiniteLengthInputStream;
import com.pandora.core.sign.bouncycastle.asn1.copy.InMemoryRepresentable;
import com.pandora.core.sign.bouncycastle.asn1.copy.IndefiniteLengthInputStream;
import com.pandora.core.sign.bouncycastle.asn1.copy.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1StreamParser {
    private final InputStream _in;
    private final int _limit;
    private final byte[][] tmpBuffers;

    public ASN1StreamParser(InputStream in) {
        this(in, StreamUtil.findLimit(in));
    }

    public ASN1StreamParser(InputStream in, int limit) {
        this._in = in;
        this._limit = limit;
        this.tmpBuffers = new byte[11][];
    }

    public ASN1StreamParser(byte[] encoding) {
        this(new ByteArrayInputStream(encoding), encoding.length);
    }

    ASN1Encodable readIndef(int tagValue) throws IOException {
        switch (tagValue) {
            case 8: {
                return new DERExternalParser(this);
            }
            case 4: {
                return new BEROctetStringParser(this);
            }
            case 16: {
                return new BERSequenceParser(this);
            }
            case 17: {
                return new BERSetParser(this);
            }
        }
        throw new ASN1Exception("unknown BER object encountered: 0x" + Integer.toHexString(tagValue));
    }

    ASN1Encodable readImplicit(boolean constructed, int tag) throws IOException {
        if (this._in instanceof IndefiniteLengthInputStream) {
            if (!constructed) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            return this.readIndef(tag);
        }
        if (constructed) {
            switch (tag) {
                case 17: {
                    return new DERSetParser(this);
                }
                case 16: {
                    return new DERSequenceParser(this);
                }
                case 4: {
                    return new BEROctetStringParser(this);
                }
            }
        } else {
            switch (tag) {
                case 17: {
                    throw new ASN1Exception("sequences must use constructed encoding (see X.690 8.9.1/8.10.1)");
                }
                case 16: {
                    throw new ASN1Exception("sets must use constructed encoding (see X.690 8.11.1/8.12.1)");
                }
                case 4: {
                    return new DEROctetStringParser((DefiniteLengthInputStream)this._in);
                }
            }
        }
        throw new RuntimeException("implicit tagging not implemented");
    }

    ASN1Primitive readTaggedObject(boolean constructed, int tag) throws IOException {
        if (!constructed) {
            DefiniteLengthInputStream defIn = (DefiniteLengthInputStream)this._in;
            return new DERTaggedObject(false, tag, new DEROctetString(defIn.toByteArray()));
        }
        ASN1EncodableVector v = this.readVector();
        if (this._in instanceof IndefiniteLengthInputStream) {
            return v.size() == 1 ? new BERTaggedObject(true, tag, v.get(0)) : new BERTaggedObject(false, tag, BERFactory.createSequence(v));
        }
        return v.size() == 1 ? new DERTaggedObject(true, tag, v.get(0)) : new DERTaggedObject(false, tag, DERFactory.createSequence(v));
    }

    public ASN1Encodable readObject() throws IOException {
        int tag = this._in.read();
        if (tag == -1) {
            return null;
        }
        this.set00Check(false);
        int tagNo = ASN1InputStream.readTagNumber(this._in, tag);
        boolean isConstructed = (tag & 0x20) != 0;
        int length = ASN1InputStream.readLength(this._in, this._limit);
        if (length < 0) {
            if (!isConstructed) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indIn = new IndefiniteLengthInputStream(this._in, this._limit);
            ASN1StreamParser sp = new ASN1StreamParser(indIn, this._limit);
            if ((tag & 0x40) != 0) {
                return new BERApplicationSpecificParser(tagNo, sp);
            }
            if ((tag & 0x80) != 0) {
                return new BERTaggedObjectParser(true, tagNo, sp);
            }
            return sp.readIndef(tagNo);
        }
        DefiniteLengthInputStream defIn = new DefiniteLengthInputStream(this._in, length);
        if ((tag & 0x40) != 0) {
            return new DERApplicationSpecific(isConstructed, tagNo, defIn.toByteArray());
        }
        if ((tag & 0x80) != 0) {
            return new BERTaggedObjectParser(isConstructed, tagNo, new ASN1StreamParser(defIn));
        }
        if (isConstructed) {
            switch (tagNo) {
                case 4: {
                    return new BEROctetStringParser(new ASN1StreamParser(defIn));
                }
                case 16: {
                    return new DERSequenceParser(new ASN1StreamParser(defIn));
                }
                case 17: {
                    return new DERSetParser(new ASN1StreamParser(defIn));
                }
                case 8: {
                    return new DERExternalParser(new ASN1StreamParser(defIn));
                }
            }
            throw new IOException("unknown tag " + tagNo + " encountered");
        }
        switch (tagNo) {
            case 4: {
                return new DEROctetStringParser(defIn);
            }
        }
        try {
            return ASN1InputStream.createPrimitiveDERObject(tagNo, defIn, this.tmpBuffers);
        }
        catch (IllegalArgumentException e) {
            throw new ASN1Exception("corrupted stream detected", e);
        }
    }

    private void set00Check(boolean enabled) {
        if (this._in instanceof IndefiniteLengthInputStream) {
            ((IndefiniteLengthInputStream)this._in).setEofOn00(enabled);
        }
    }

    ASN1EncodableVector readVector() throws IOException {
        ASN1Encodable obj;
        ASN1EncodableVector v = new ASN1EncodableVector();
        while ((obj = this.readObject()) != null) {
            if (obj instanceof InMemoryRepresentable) {
                v.add(((InMemoryRepresentable)((Object)obj)).getLoadedObject());
                continue;
            }
            v.add(obj.toASN1Primitive());
        }
        return v;
    }
}

