/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign.bouncycastle.asn1;

import com.pandora.core.sign.bouncycastle.asn1.ASN1OctetString;
import com.pandora.core.sign.bouncycastle.asn1.ASN1OutputStream;
import com.pandora.core.sign.bouncycastle.asn1.ASN1Primitive;
import com.pandora.core.sign.bouncycastle.asn1.ASN1String;
import com.pandora.core.sign.bouncycastle.asn1.ASN1TaggedObject;
import com.pandora.core.sign.bouncycastle.asn1.StreamUtil;
import com.pandora.core.sign.bouncycastle.util.Arrays;
import com.pandora.core.sign.bouncycastle.util.Strings;
import java.io.IOException;

public class DERNumericString
extends ASN1Primitive
implements ASN1String {
    private byte[] string;

    public static DERNumericString getInstance(Object obj) {
        if (obj == null || obj instanceof DERNumericString) {
            return (DERNumericString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (DERNumericString)DERNumericString.fromByteArray((byte[])obj);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("encoding error in getInstance: " + e.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERNumericString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof DERNumericString) {
            return DERNumericString.getInstance(o);
        }
        return new DERNumericString(ASN1OctetString.getInstance(o).getOctets());
    }

    DERNumericString(byte[] string) {
        this.string = string;
    }

    public DERNumericString(String string) {
        this(string, false);
    }

    public DERNumericString(String string, boolean validate) {
        if (validate && !DERNumericString.isNumericString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.string = Strings.toByteArray(string);
    }

    @Override
    public String getString() {
        return Strings.fromByteArray(this.string);
    }

    public String toString() {
        return this.getString();
    }

    public byte[] getOctets() {
        return Arrays.clone(this.string);
    }

    @Override
    boolean isConstructed() {
        return false;
    }

    @Override
    int encodedLength() {
        return 1 + StreamUtil.calculateBodyLength(this.string.length) + this.string.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(18, this.string);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.string);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERNumericString)) {
            return false;
        }
        DERNumericString s = (DERNumericString)o;
        return Arrays.areEqual(this.string, s.string);
    }

    public static boolean isNumericString(String str) {
        int i = str.length() - 1;
        while (i >= 0) {
            char ch = str.charAt(i);
            if (ch > '\u007f') {
                return false;
            }
            if (('0' > ch || ch > '9') && ch != ' ') {
                return false;
            }
            --i;
        }
        return true;
    }
}

