/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.sign.bouncycastle.asn1;

import com.pandora.core.sign.bouncycastle.asn1.ASN1Encodable;
import com.pandora.core.sign.bouncycastle.asn1.ASN1EncodableVector;
import com.pandora.core.sign.bouncycastle.asn1.ASN1InputStream;
import com.pandora.core.sign.bouncycastle.asn1.ASN1Object;
import com.pandora.core.sign.bouncycastle.asn1.ASN1OutputStream;
import com.pandora.core.sign.bouncycastle.asn1.ASN1ParsingException;
import com.pandora.core.sign.bouncycastle.asn1.ASN1Primitive;
import com.pandora.core.sign.bouncycastle.asn1.ASN1Sequence;
import com.pandora.core.sign.bouncycastle.asn1.ASN1Set;
import com.pandora.core.sign.bouncycastle.asn1.StreamUtil;
import com.pandora.core.sign.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DERApplicationSpecific
extends ASN1Primitive {
    private final boolean isConstructed;
    private final int tag;
    private final byte[] octets;

    DERApplicationSpecific(boolean isConstructed, int tag, byte[] octets) {
        this.isConstructed = isConstructed;
        this.tag = tag;
        this.octets = octets;
    }

    public DERApplicationSpecific(int tag, byte[] octets) {
        this(false, tag, octets);
    }

    public DERApplicationSpecific(int tag, ASN1Encodable object) throws IOException {
        this(true, tag, object);
    }

    public DERApplicationSpecific(boolean explicit, int tag, ASN1Encodable object) throws IOException {
        ASN1Primitive primitive = object.toASN1Primitive();
        byte[] data = primitive.getEncoded("DER");
        this.isConstructed = explicit || primitive instanceof ASN1Set || primitive instanceof ASN1Sequence;
        this.tag = tag;
        if (explicit) {
            this.octets = data;
        } else {
            int lenBytes = this.getLengthOfHeader(data);
            byte[] tmp = new byte[data.length - lenBytes];
            System.arraycopy(data, lenBytes, tmp, 0, tmp.length);
            this.octets = tmp;
        }
    }

    public DERApplicationSpecific(int tagNo, ASN1EncodableVector vec) {
        this.tag = tagNo;
        this.isConstructed = true;
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        int i = 0;
        while (i != vec.size()) {
            try {
                bOut.write(((ASN1Object)vec.get(i)).getEncoded("DER"));
            }
            catch (IOException e) {
                throw new ASN1ParsingException("malformed object: " + e, e);
            }
            ++i;
        }
        this.octets = bOut.toByteArray();
    }

    public static DERApplicationSpecific getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof DERApplicationSpecific) {
            return (DERApplicationSpecific)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return DERApplicationSpecific.getInstance(DERApplicationSpecific.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct object from byte[]: " + e.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1Sequence) {
            return (DERApplicationSpecific)primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    private int getLengthOfHeader(byte[] data) {
        int length = data[1] & 0xFF;
        if (length == 128) {
            return 2;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IllegalStateException("DER length more than 4 bytes: " + size);
            }
            return size + 2;
        }
        return 2;
    }

    @Override
    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public ASN1Primitive getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public ASN1Primitive getObject(int derTagNo) throws IOException {
        if (derTagNo >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] orig = this.getEncoded();
        byte[] tmp = this.replaceTagNumber(derTagNo, orig);
        if ((orig[0] & 0x20) != 0) {
            tmp[0] = (byte)(tmp[0] | 0x20);
        }
        return new ASN1InputStream(tmp).readObject();
    }

    @Override
    int encodedLength() throws IOException {
        return StreamUtil.calculateTagLength(this.tag) + StreamUtil.calculateBodyLength(this.octets.length) + this.octets.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        int classBits = 64;
        if (this.isConstructed) {
            classBits |= 0x20;
        }
        out.writeEncoded(classBits, this.tag, this.octets);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific other = (DERApplicationSpecific)o;
        return this.isConstructed == other.isConstructed && this.tag == other.tag && Arrays.areEqual(this.octets, other.octets);
    }

    @Override
    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ Arrays.hashCode(this.octets);
    }

    /*
     * Unable to fully structure code
     */
    private byte[] replaceTagNumber(int newTag, byte[] input) throws IOException {
        block1: {
            tagNo = input[0] & 31;
            index = 1;
            if (tagNo != 31) break block1;
            tagNo = 0;
            if (((b = input[index++] & 255) & 127) != 0) ** GOTO lbl10
            throw new ASN1ParsingException("corrupted stream - invalid high tag number found");
lbl-1000:
            // 1 sources

            {
                tagNo |= b & 127;
                tagNo <<= 7;
                b = input[index++] & 255;
lbl10:
                // 2 sources

                ** while (b >= 0 && (b & 128) != 0)
            }
lbl11:
            // 1 sources

            tagNo |= b & 127;
        }
        tmp = new byte[input.length - index + 1];
        System.arraycopy(input, index, tmp, 1, tmp.length - 1);
        tmp[0] = (byte)newTag;
        return tmp;
    }
}

