/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.core.plist;

import com.pandora.core.log.HBLog;
import com.pandora.core.plist.IPListParser;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.preferences.Base64;
import org.eclipse.core.runtime.Plugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLPListParser
implements IPListParser {
    private static DateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    static {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        ISO_8601.setTimeZone(tz);
    }

    public Map<String, Object> parse(byte[] content) throws IOException {
        DocumentBuilder builder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            HBLog.logError((Plugin)Activator.getDefault(), e);
        }
        if (builder != null) {
            Element doc;
            Document d = null;
            try {
                d = builder.parse(new ByteArrayInputStream(content));
            }
            catch (Exception e1) {
                HBLog.logError((Plugin)Activator.getDefault(), e1);
            }
            if (d != null && (doc = d.getDocumentElement()) != null && doc.getFirstChild() != null && doc.getFirstChild().getNextSibling() != null) {
                Node root = doc.getFirstChild().getNextSibling();
                return (Map)this.parseNode((Element)root);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public Map<String, Object> parse(File file) throws IOException {
        DocumentBuilder builder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            HBLog.logError((Plugin)Activator.getDefault(), e);
        }
        if (builder != null) {
            Element doc;
            Document d = null;
            try {
                d = builder.parse(file);
            }
            catch (Exception exception) {
                String raw = IOUtil.read(new FileInputStream(file), "UTF-8");
                raw = XMLPListParser.stripNonValidXMLCharacters(raw);
                try {
                    d = builder.parse(new ByteArrayInputStream(raw.getBytes("UTF-8")));
                }
                catch (Exception e1) {
                    HBLog.logError((Plugin)Activator.getDefault(), e1);
                }
            }
            if (d != null && (doc = d.getDocumentElement()) != null && doc.getFirstChild() != null && doc.getFirstChild().getNextSibling() != null) {
                Node root = doc.getFirstChild().getNextSibling();
                return (Map)this.parseNode((Element)root);
            }
        }
        return Collections.emptyMap();
    }

    private static String stripNonValidXMLCharacters(String in) {
        if (in == null || "".equals(in)) {
            return "";
        }
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char current = in.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
                out.append(current);
            }
            ++i;
        }
        return out.toString();
    }

    private Object parseNode(Element node) {
        String tagName = node.getTagName();
        if (tagName.equals("string")) {
            return node.getTextContent();
        }
        if (tagName.equals("real")) {
            return Float.valueOf(Float.parseFloat(node.getTextContent()));
        }
        if (tagName.equals("integer")) {
            return Long.parseLong(node.getTextContent());
        }
        if (tagName.equals("true")) {
            return Boolean.TRUE;
        }
        if (tagName.equals("false")) {
            return Boolean.FALSE;
        }
        if (tagName.equals("date")) {
            try {
                String raw = node.getTextContent();
                return ISO_8601.parse(raw);
            }
            catch (Exception e) {
                HBLog.logError((Plugin)Activator.getDefault(), e);
                return new Date();
            }
        }
        if (tagName.equals("data")) {
            try {
                String raw = node.getTextContent();
                return Base64.decode((byte[])raw.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                HBLog.logError((Plugin)Activator.getDefault(), e);
                return new byte[0];
            }
        }
        if (tagName.equals("array")) {
            ArrayList<Object> array = new ArrayList<Object>();
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (child.getNodeType() == 1) {
                    array.add(this.parseNode((Element)child));
                }
                ++i;
            }
            return array;
        }
        if (tagName.equals("dict")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            NodeList children = node.getChildNodes();
            int i = 0;
            while (i < children.getLength()) {
                Node child;
                if ((child = children.item(i++)).getNodeType() != 1) continue;
                Node nextElement = children.item(i);
                while (nextElement.getNodeType() != 1) {
                    nextElement = children.item(i++);
                }
                map.put(child.getTextContent(), this.parseNode((Element)nextElement));
            }
            return map;
        }
        return null;
    }
}

