/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model.xhr;

import com.aptana.js.debug.core.model.xhr.IXHRTransfer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class XHRTransfer
implements IXHRTransfer {
    private String method;
    private String url;
    private boolean auth;
    private List<IXHRTransfer.IHeader> requestHeaders = new ArrayList<IXHRTransfer.IHeader>();
    private List<IXHRTransfer.IHeader> responseHeaders = new ArrayList<IXHRTransfer.IHeader>();
    private String requestBody;
    private String responseBody;
    private Date requestDate;
    private Date responseDate;
    private int statusCode;
    private String statusText;
    private boolean error;

    public XHRTransfer(String method, String url, boolean auth) {
        this.method = method;
        this.url = url;
        this.auth = auth;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Date getRequestDate() {
        return this.requestDate;
    }

    @Override
    public IXHRTransfer.IHeader[] getRequestHeaders() {
        return this.requestHeaders.toArray(new IXHRTransfer.IHeader[this.requestHeaders.size()]);
    }

    @Override
    public String getRequestBody() {
        return this.requestBody;
    }

    @Override
    public Date getResponseDate() {
        return this.responseDate;
    }

    @Override
    public IXHRTransfer.IHeader[] getResponseHeaders() {
        return this.responseHeaders.toArray(new IXHRTransfer.IHeader[this.responseHeaders.size()]);
    }

    @Override
    public String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getStatusText() {
        return this.statusText;
    }

    @Override
    public boolean hasError() {
        return this.error;
    }

    @Override
    public boolean isAuthenticated() {
        return this.auth;
    }

    protected void addRequestHeader(String name, String value) {
        this.requestHeaders.add(new Header(name, value));
    }

    protected void addResponseHeader(String name, String value) {
        this.responseHeaders.add(new Header(name, value));
    }

    protected void setRequestBody(String body) {
        this.requestBody = body;
        this.requestDate = new Date();
    }

    protected void setResponseBody(String body) {
        this.responseBody = body;
        this.responseDate = new Date();
    }

    protected void setResponseStatus(int statusCode, String statusText) {
        this.statusCode = statusCode;
        this.statusText = statusText;
    }

    protected void setError(boolean error) {
        this.error = error;
    }

    private static class Header
    implements IXHRTransfer.IHeader {
        private String name;
        private String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }
    }
}

