/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.js.debug.core.internal.model.JSDebugVariable;
import com.aptana.js.debug.core.internal.model.Messages;
import com.aptana.js.debug.core.model.IJSVariable;
import com.aptana.js.debug.core.model.provisional.IJSWatchpoint;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

public class JSDebugWatchpoint
extends Breakpoint
implements IJSWatchpoint {
    protected static final String ACCESS = "com.aptana.debug.core.watchpoint.access";
    protected static final String MODIFICATION = "com.aptana.debug.core.watchpoint.modification";
    protected static final String AUTO_DISABLED = "com.aptana.debug.core.watchpoint.auto_disabled";

    public JSDebugWatchpoint() {
    }

    public JSDebugWatchpoint(IJSVariable variable) throws CoreException {
        this((IResource)ResourcesPlugin.getWorkspace().getRoot(), variable, new HashMap<String, Object>(), true);
    }

    public JSDebugWatchpoint(final IResource resource, final IJSVariable variable, final Map<String, Object> attributes, final boolean register) throws CoreException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker("com.aptana.debug.core.watchpointMarker");
                JSDebugWatchpoint.this.setMarker(marker);
                attributes.put("org.eclipse.debug.core.enabled", Boolean.TRUE);
                attributes.put("com.aptana.js.debug.core.watchpointVariableAccessor", ((JSDebugVariable)variable).getQualifier());
                attributes.put("com.aptana.js.debug.core.watchpointVariableName", variable.getFullName());
                attributes.put("org.eclipse.debug.core.id", JSDebugWatchpoint.this.getModelIdentifier());
                attributes.put("message", MessageFormat.format(Messages.JSDebugWatchpoint_JS_Watchpoint, variable.getFullName()));
                JSDebugWatchpoint.this.addDefaultAccessAndModification(attributes);
                JSDebugWatchpoint.this.ensureMarker().setAttributes(attributes);
                JSDebugWatchpoint.this.register(register);
            }
        };
        this.run(this.getMarkerRule(resource), wr);
    }

    private void register(boolean register) throws CoreException {
        if (register) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    @Override
    public String getVariableName() throws CoreException {
        return this.ensureMarker().getAttribute("com.aptana.js.debug.core.watchpointVariableName", "");
    }

    public boolean isAccess() throws CoreException {
        return this.ensureMarker().getAttribute(ACCESS, false);
    }

    public boolean isModification() throws CoreException {
        return this.ensureMarker().getAttribute(MODIFICATION, false);
    }

    public void setAccess(boolean access) throws CoreException {
        if (access == this.isAccess()) {
            return;
        }
        this.setAttribute(ACCESS, access);
        if (access && !this.isEnabled()) {
            this.setEnabled(true);
        } else if (!access && !this.isModification()) {
            this.setEnabled(false);
        }
    }

    public void setModification(boolean modification) throws CoreException {
        if (modification == this.isModification()) {
            return;
        }
        this.setAttribute(MODIFICATION, modification);
        if (modification && !this.isEnabled()) {
            this.setEnabled(true);
        } else if (!modification && !this.isAccess()) {
            this.setEnabled(false);
        }
    }

    public void setEnabled(boolean enabled) throws CoreException {
        if (enabled && !this.isAccess() && !this.isModification()) {
            this.setDefaultAccessAndModification();
        }
        super.setEnabled(enabled);
    }

    public boolean supportsAccess() {
        return true;
    }

    public boolean supportsModification() {
        return true;
    }

    public String getModelIdentifier() {
        return "com.aptana.js.debug.core";
    }

    private void addDefaultAccessAndModification(Map<String, Object> attributes) {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] values = blArray;
        attributes.put(ACCESS, values[0] ? Boolean.TRUE : Boolean.FALSE);
        attributes.put(MODIFICATION, values[1] ? Boolean.TRUE : Boolean.FALSE);
        attributes.put(AUTO_DISABLED, Boolean.FALSE);
    }

    private void setDefaultAccessAndModification() throws CoreException {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        boolean[] def = blArray;
        Object[] values = new Object[def.length];
        int i = 0;
        while (i < def.length) {
            values[i] = def[i];
            ++i;
        }
        String[] attributes = new String[]{ACCESS, MODIFICATION};
        this.setAttributes(attributes, values);
    }
}

