/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.js.debug.core.internal.model.JSDebugElement;
import com.aptana.js.debug.core.internal.model.JSDebugTarget;
import com.aptana.js.debug.core.internal.model.JSDebugThread;
import com.aptana.js.debug.core.internal.model.JSDebugVariable;
import com.aptana.js.debug.core.model.IJSStackFrame;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class JSDebugStackFrame
extends JSDebugElement
implements IJSStackFrame {
    private static final String FRAME_0 = "frame[{0,number,integer}]";
    private final JSDebugThread thread;
    private int frameId;
    private final String function;
    private final URI sourceFile;
    private int sourceLine;
    private IVariable[] variables;
    long pc;
    int scriptTag;

    public JSDebugStackFrame(IDebugTarget target, JSDebugThread thread, int frameId, String function, URI sourceFile, int sourceLine, long pc, int scriptTag) {
        super(target);
        this.thread = thread;
        this.frameId = frameId;
        this.function = function;
        this.sourceFile = sourceFile;
        this.sourceLine = sourceLine;
        this.pc = pc;
        this.scriptTag = scriptTag;
    }

    public Object getAdapter(Class adapter) {
        if (IJSStackFrame.class == adapter) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    public IVariable[] getVariables() throws DebugException {
        this.getVariables0();
        return this.variables != null ? this.variables : new IVariable[]{};
    }

    public boolean hasVariables() throws DebugException {
        this.getVariables0();
        return this.variables != null && this.variables.length > 0;
    }

    public IThread getThread() {
        return this.thread;
    }

    public int getLineNumber() throws DebugException {
        return this.sourceLine;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this.function;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.thread.canStepInto() && this.isTopStackFrame();
    }

    public boolean canStepOver() {
        return this.thread.canStepOver();
    }

    public boolean canStepReturn() {
        if (!this.thread.canStepReturn()) {
            return false;
        }
        Object bottomFrame = null;
        try {
            IStackFrame[] frames = this.thread.getStackFrames();
            if (frames.length > 0) {
                bottomFrame = frames[frames.length - 1];
            }
        }
        catch (DebugException debugException) {}
        return bottomFrame != null && !bottomFrame.equals(this);
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public void stepInto() throws DebugException {
        if (!this.canStepInto()) {
            return;
        }
        this.thread.stepInto();
    }

    public void stepOver() throws DebugException {
        if (!this.canStepOver() || !this.isValid()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.thread.stepOver();
        } else {
            this.thread.stepToFrame(this);
        }
    }

    public void stepReturn() throws DebugException {
        if (!this.canStepReturn() || !this.isValid()) {
            return;
        }
        if (this.isTopStackFrame()) {
            this.thread.stepReturn();
        } else {
            IStackFrame[] frames = this.thread.getStackFrames();
            int i = frames.length - 2;
            while (i > 0) {
                if (frames[i].equals(this)) {
                    this.thread.stepToFrame(frames[i + 1]);
                }
                --i;
            }
        }
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    @Override
    public URI getSourceFileName() {
        return this.sourceFile;
    }

    @Override
    public IVariable findVariable(String variableName) throws DebugException {
        IVariable[] iVariableArray = this.getVariables();
        int n = iVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable var = iVariableArray[n2];
            if (var.getName().equals(variableName)) {
                return var;
            }
            ++n2;
        }
        return this.getJSDebugTarget().findVariable(variableName, (IDebugElement)this);
    }

    int getFrameId() {
        return this.frameId;
    }

    boolean isSameAs(JSDebugStackFrame other) {
        return this.scriptTag == other.scriptTag && this.pc == other.pc && this.sourceLine == other.sourceLine;
    }

    void invalidate() {
        this.frameId = -1;
    }

    void invalidate(int frameId, int sourceLine, long pc) {
        this.frameId = frameId;
        this.sourceLine = sourceLine;
        this.pc = pc;
        this.variables = null;
    }

    String getThreadId() {
        return this.thread.getThreadId();
    }

    private JSDebugTarget getJSDebugTarget() {
        return (JSDebugTarget)this.getDebugTarget();
    }

    private boolean isTopStackFrame() {
        IStackFrame tos = null;
        try {
            tos = this.thread.getTopStackFrame();
        }
        catch (DebugException debugException) {}
        return tos != null && tos.equals(this);
    }

    private void getVariables0() throws DebugException {
        if (this.variables != null || !this.isValid()) {
            return;
        }
        JSDebugTarget target = this.getJSDebugTarget();
        String command = MessageFormat.format(FRAME_0, this.frameId);
        IVariable[] iVariableArray = this.variables = target.loadVariables(this.thread.getThreadId(), command);
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable var = iVariableArray[n2];
            ((JSDebugVariable)var).flags |= 0x80;
            ++n2;
        }
    }

    private boolean isValid() {
        return this.frameId >= 0;
    }
}

