/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.js.debug.core.JSDebugPlugin;
import com.aptana.js.debug.core.internal.ProtocolLogger;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;

public class DebugConnection {
    protected static final int COMMAND_TIMEOUT = 20000;
    private static final String ARGS_SPLIT = "\\*";
    private Socket socket;
    private Reader reader;
    private Writer writer;
    private boolean connected = false;
    private boolean terminated = false;
    private final ProtocolLogger logger;
    private Map<String, Object> locks = new Hashtable<String, Object>();
    private volatile long lastReqId = System.currentTimeMillis();
    private IHandler handler;

    public static DebugConnection createConnection(Socket socket) throws DebugException {
        return DebugConnection.createConnection(socket, null);
    }

    public static DebugConnection createConnection(Socket socket, ProtocolLogger logger) throws DebugException {
        try {
            return new DebugConnection(socket, new InputStreamReader(socket.getInputStream()), new OutputStreamWriter(socket.getOutputStream()), logger);
        }
        catch (IOException e) {
            DebugConnection.throwDebugException(e);
            return null;
        }
    }

    protected DebugConnection(Socket socket, Reader reader, Writer writer, ProtocolLogger logger) {
        this.socket = socket;
        this.reader = reader;
        this.writer = writer;
        this.logger = logger;
    }

    public void start(IHandler handler) {
        this.handler = handler;
        this.connected = true;
        new Thread("Aptana: JS Debugger"){

            @Override
            public void run() {
                while (DebugConnection.this.socket != null && !DebugConnection.this.socket.isClosed() || DebugConnection.this.reader != null) {
                    try {
                        String message;
                        try {
                            message = DebugConnection.this.readMessage();
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            continue;
                        }
                        if (message == null) break;
                        if (DebugConnection.this.logger != null) {
                            DebugConnection.this.logger.log(true, message);
                        }
                        DebugConnection.this.handleMessage(message);
                    }
                    catch (SocketException socketException) {
                        break;
                    }
                    catch (Exception e) {
                        JSDebugPlugin.log(e);
                    }
                }
                if (DebugConnection.this.logger != null) {
                    DebugConnection.this.logger.close();
                }
                DebugConnection.this.handleConnectionTerminated();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        Map<String, Object> map = this.locks;
        synchronized (map) {
            Object[] list = this.locks.values().toArray();
            this.locks.clear();
            Object[] objectArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                Object lock;
                Object object = lock = objectArray[n2];
                synchronized (object) {
                    lock.notify();
                }
                ++n2;
            }
        }
    }

    public void dispose() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.writer.close();
            this.reader = null;
            this.writer = null;
        }
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(String message) {
        if (message.endsWith("*")) {
            message = String.valueOf(message) + "* ";
        }
        this.handler.handleMessage(message);
        if (!this.connected) {
            return;
        }
        String[] args = message.split(ARGS_SPLIT);
        String action = args[0];
        Object lock = this.locks.get(action);
        if (lock != null) {
            this.locks.put(action, args);
            Object object = lock;
            synchronized (object) {
                lock.notify();
            }
            return;
        }
    }

    private void handleConnectionTerminated() {
        if (this.terminated) {
            return;
        }
        this.terminated = true;
        this.handler.handleShutdown();
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    protected void sendCommand(String command) throws DebugException {
        this.sendCommand("", command);
    }

    protected void sendCommand(String reqid, String command) throws DebugException {
        try {
            String message = MessageFormat.format("{0}*{1}*{2}", Integer.toString(command.length() + reqid.length() + 1), reqid, command);
            if (this.logger != null) {
                this.logger.log(false, message);
            }
            this.writer.write(message);
            this.writer.flush();
        }
        catch (IOException e) {
            DebugConnection.throwDebugException(e);
        }
    }

    protected String[] sendCommandAndWait(String command) throws DebugException {
        long reqid = ++this.lastReqId;
        return this.sendCommandAndWait(command, Long.toString(reqid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String[] sendCommandAndWait(String command, String reqid) throws DebugException {
        Object lock;
        if (!this.connected) {
            return null;
        }
        Object object = lock = new Object();
        synchronized (object) {
            try {
                this.locks.put(reqid, lock);
                this.sendCommand(reqid, command);
                lock.wait(20000L);
            }
            catch (InterruptedException e) {
                DebugConnection.throwDebugException(e);
            }
        }
        lock = this.locks.remove(reqid);
        if (lock instanceof String[]) {
            return (String[])lock;
        }
        return null;
    }

    protected String readMessage() throws IOException {
        int i;
        StringBuffer sb = new StringBuffer();
        int messageSize = 0;
        while ((i = this.reader.read()) != -1) {
            char ch = (char)i;
            if (ch == '*' && sb.length() > 0) {
                try {
                    messageSize = Integer.parseInt(sb.toString());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    sb.setLength(0);
                    continue;
                }
            }
            if (ch >= '0' && ch <= '9') {
                sb.append(ch);
                continue;
            }
            if (sb.length() <= 0) continue;
            sb.setLength(0);
        }
        if (i == -1) {
            return null;
        }
        char[] buffer = new char[1024];
        sb.setLength(0);
        while (messageSize > sb.length()) {
            int n = this.reader.read(buffer, 0, Math.min(messageSize - sb.length(), buffer.length));
            if (n == -1) {
                return null;
            }
            sb.append(buffer, 0, n);
        }
        return sb.toString();
    }

    protected static void throwDebugException(Exception exception) throws DebugException {
        throw new DebugException((IStatus)new Status(4, "com.aptana.js.debug.core", 5010, "", (Throwable)exception));
    }

    public static interface IHandler {
        public void handleMessage(String var1);

        public void handleShutdown();
    }
}

