/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.core.internal.model;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.js.debug.core.internal.ProtocolLogger;
import com.aptana.js.debug.core.internal.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;

public abstract class AbstractDebugHost {
    protected static final String SUSPEND_ON_ERRORS = "suspendOnErrors";
    protected static final String SUSPEND_ON_EXCEPTIONS = "suspendOnExceptions";
    protected static final String SUSPEND_ON_KEYWORDS = "suspendOnKeywords";
    protected static final String SUSPEND_ON_FIRST_LINE = "suspendOnFirstLine";
    protected static final String UPDATE = "update";
    protected static final String VERSION = "version";
    protected static final String OPENED = "opened";
    protected static final String DETAILS = "details";
    protected static final String SET_VALUE = "setValue";
    protected static final String EVAL = "eval";
    protected static final String RESULT = "result";
    protected static final String THIS = "this";
    protected static final String THIS_DOT = "this.";
    protected static final String __PROTO__ = "__proto__";
    protected static final String VARIABLES = "variables";
    protected static final String OPTION = "option";
    protected static final String ENABLE = "enable";
    protected static final String STEP_FILTERS = "stepFilters";
    protected static final String DETAIL_FORMATTERS = "detailFormatters";
    protected static final String DISABLE = "disable";
    protected static final String CHANGE = "change";
    protected static final String CHANGED = "changed";
    protected static final String REMOVE = "remove";
    protected static final String REMOVED = "removed";
    protected static final String CREATE = "create";
    protected static final String UNDEFINED = "undefined";
    protected static final String SUSPENDED = "suspended";
    protected static final String RESUMED = "resumed";
    protected static final String ARGS_DELIMITER = "*";
    protected static final String SUBARGS_DELIMITER = "|";
    protected static final String ARGS_SPLIT = "\\*";
    protected static final String SUBARGS_SPLIT = "\\|";
    protected static final String VARIABLE_PARTS_SPLIT = "\\.";
    protected static final String _0_1_2 = "{0}*{1}*{2}";
    protected static final String _0_1 = "{0}*{1}";
    protected static final String OBJECT_0 = "[object {0}]";
    protected static final String QUOTES_0 = "\"{0}\"";
    protected static final String CREATED = "created";
    protected static final String TERMINATE = "terminate";
    protected static final String SUSPEND = "suspend";
    protected static final String FIRST_LINE = "firstLine";
    protected static final String EXCEPTION = "exception";
    protected static final String ERR = "err";
    protected static final String TRACE = "trace";
    protected static final String NULL = "null";
    protected static final String STRING = "String";
    protected static final String BOOLEAN = "Boolean";
    protected static final String NUMBER = "Number";
    protected static final String FUNCTION = "Function";
    protected static final String BREAKPOINT = "breakpoint";
    protected static final String WATCHPOINT = "watchpoint";
    protected static final String SCRIPTS = "scripts";
    protected static final String LOG = "log";
    protected static final String OUT = "out";
    protected static final String SUCCESS = "success";
    protected static final String FAILURE = "failure";
    protected static final String GET_SOURCE = "getSource";
    protected static final String STEP_INTO = "stepInto";
    protected static final String STEP_OVER = "stepOver";
    protected static final String RESUME = "resume";
    protected static final String ABORT = "abort";
    protected static final String START = "start";
    protected static final String STEP_RETURN = "stepReturn";
    protected static final String STEP_TO_FRAME = "stepToFrame";
    protected static final String FRAMES = "frames";
    protected static final String DBGSOURCE_SCHEME = "dbgsource://";
    protected static final String _0 = "0";
    protected static final String _1 = "1";
    protected static final String _R = "r";
    protected static final String _W = "w";
    protected static final String _RW = "rw";
    protected static final String ARG_FRAME_ID = "frameId";
    protected static final String ARG_VARIABLE_NAME = "variableName";
    protected static final String ARG_EVAL_ID = "evalId";
    protected static Pattern VARIABLE_FRAME_PATTERN = Pattern.compile("^frame\\[(\\d+)\\]\\.?(.*)$");
    protected static Pattern VARIABLE_EVAL_PATTERN = Pattern.compile("^eval\\[(\\d+)\\]\\.?(.*)$");
    protected static final String PROTOCOL_VERSION = "1";
    public static final int SOCKET_TIMEOUT = 1000;
    private Socket socket;
    private Reader reader;
    private Writer writer;
    private Plugin plugin;
    private File errorLogFile;
    private ProtocolLogger logger;
    protected boolean enabled;
    protected String suspendReason;
    protected String resumeReason;
    protected int targetFrameCount;
    protected String reqid;
    protected Map<String, Object> options = new HashMap<String, Object>();
    protected Set<String> exceptions = new HashSet<String>();

    protected AbstractDebugHost() {
        this.options.put(SUSPEND_ON_FIRST_LINE, false);
        this.options.put(SUSPEND_ON_KEYWORDS, true);
        this.options.put(SUSPEND_ON_EXCEPTIONS, false);
        this.options.put(SUSPEND_ON_ERRORS, false);
    }

    protected abstract Object getSyncObject();

    protected abstract boolean isConnected();

    protected abstract boolean isDebugging();

    protected abstract void initSession(ILaunch var1) throws CoreException;

    protected abstract void terminateSession();

    public final void start(final SocketAddress serverAddress, ILaunch launch) throws CoreException {
        new Thread("Aptana: Debugger Bridge"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void run() {
                var2_2 = syncObject = AbstractDebugHost.this.getSyncObject();
                synchronized (var2_2) {
                    try {
                        AbstractDebugHost.access$0(AbstractDebugHost.this, new Socket());
                        AbstractDebugHost.access$1(AbstractDebugHost.this).connect(serverAddress, 5000);
                        AbstractDebugHost.access$2(AbstractDebugHost.this, new InputStreamReader(AbstractDebugHost.access$1(AbstractDebugHost.this).getInputStream()));
                        AbstractDebugHost.access$3(AbstractDebugHost.this, new OutputStreamWriter(AbstractDebugHost.access$1(AbstractDebugHost.this).getOutputStream()));
                    }
                    catch (IOException e) {
                        AbstractDebugHost.this.logError(e);
                    }
                    if (true) ** GOTO lbl31
                }
                do {
                    try {
                        message = AbstractDebugHost.access$4(AbstractDebugHost.this);
                        if (message == null) break;
                        var3_5 = syncObject;
                        synchronized (var3_5) {
                            AbstractDebugHost.access$5(AbstractDebugHost.this, message);
                        }
                    }
                    catch (IOException v2) {
                        break;
                    }
                    catch (Exception e) {
                        AbstractDebugHost.this.logError(e);
                    }
lbl31:
                    // 3 sources

                } while (AbstractDebugHost.access$1(AbstractDebugHost.this) != null && !AbstractDebugHost.access$1(AbstractDebugHost.this).isClosed());
                AbstractDebugHost.this.terminate();
            }
        }.start();
        this.initSession(launch);
    }

    private String readMessage() throws IOException {
        int i;
        StringBuffer sb = new StringBuffer();
        int messageSize = 0;
        while ((i = this.reader != null ? this.reader.read() : -1) != -1) {
            char ch = (char)i;
            if (ch == '*' && sb.length() > 0) {
                try {
                    messageSize = Integer.parseInt(sb.toString());
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    sb.setLength(0);
                    continue;
                }
            }
            if (ch >= '0' && ch <= '9') {
                sb.append(ch);
                continue;
            }
            if (sb.length() <= 0) continue;
            sb.setLength(0);
        }
        if (i == -1) {
            return null;
        }
        char[] buffer = new char[1024];
        sb.setLength(0);
        while (messageSize > sb.length()) {
            int n = this.reader.read(buffer, 0, Math.min(messageSize - sb.length(), buffer.length));
            if (n == -1) {
                return null;
            }
            sb.append(buffer, 0, n);
        }
        return sb.toString();
    }

    private void handleMessage(String message) throws IOException {
        block48: {
            this.logger.log(true, message);
            if (message.endsWith(ARGS_DELIMITER)) {
                message = String.valueOf(message) + "* ";
            }
            String[] args = message.split(ARGS_SPLIT);
            this.reqid = args[0];
            if (args.length < 2) {
                this.sendResponse("!no command specified");
            }
            if (!this.isConnected()) {
                return;
            }
            String command = args[1];
            try {
                if (FRAMES.equals(command)) {
                    this.sendResponse(this.listFrames());
                    break block48;
                }
                if (VARIABLES.equals(command)) {
                    this.sendResponse(this.listVariables(Util.decodeData(args[2])));
                    break block48;
                }
                if (DETAILS.equals(command)) {
                    this.sendResponse(this.doGetDetails(Util.decodeData(args[2])));
                    break block48;
                }
                if (EVAL.equals(command)) {
                    this.sendResponse(this.doEval(Util.decodeData(args[2]), Util.decodeData(args[3])));
                    break block48;
                }
                if (STEP_INTO.equals(command) || STEP_OVER.equals(command) || STEP_RETURN.equals(command) || STEP_TO_FRAME.equals(command)) {
                    if (!this.isDebugging()) break block48;
                    this.suspendReason = command;
                    if (STEP_TO_FRAME.equals(command)) {
                        int frameId;
                        try {
                            frameId = Integer.parseInt(args[2]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException(ARG_FRAME_ID);
                        }
                        if (frameId == 0 || frameId >= this.frameCount()) {
                            this.stopDebugging(STEP_OVER);
                        } else {
                            this.targetFrameCount = frameId;
                            this.stopDebugging(STEP_RETURN);
                        }
                        break block48;
                    }
                    this.stopDebugging(command);
                    break block48;
                }
                if (ENABLE.equals(command)) {
                    this.enable();
                    this.sendResponse(null);
                    break block48;
                }
                if (DISABLE.equals(command)) {
                    this.disable();
                    this.sendResponse(null);
                    break block48;
                }
                if (OPTION.equals(command)) {
                    String option = args[2];
                    if (this.options.containsKey(option)) {
                        if (this.options.get(option) instanceof Boolean) {
                            this.options.put(option, (boolean)Boolean.valueOf(args[3]));
                        } else {
                            this.options.put(option, args[3]);
                        }
                        this.processOptionChange(option);
                        this.sendResponse(null);
                    } else {
                        this.sendResponse("!unknown option <" + option + ">");
                    }
                    break block48;
                }
                if (SUSPEND.equals(command)) {
                    this.suspend(command);
                    break block48;
                }
                if (RESUME.equals(command)) {
                    this.stopDebugging(RESUME);
                    break block48;
                }
                if (BREAKPOINT.equals(command)) {
                    int lineNo;
                    String action = args[2];
                    try {
                        lineNo = Integer.parseInt(args[4]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalArgumentException("lineNo");
                    }
                    BreakpointProperties props = null;
                    if (CREATE.equals(action) || CHANGE.equals(action)) {
                        int hitCount;
                        try {
                            hitCount = Integer.parseInt(args[6]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("hitCount");
                        }
                        props = new BreakpointProperties(_0.equals(args[5]), hitCount, Util.decodeData(args[7]), "1".equals(args[8]));
                    }
                    this.sendResponse(this.processBreakpoint(action, Util.decodeData(args[3]), lineNo, props));
                    break block48;
                }
                if (EXCEPTION.equals(command)) {
                    this.sendResponse(this.processExceptionBreakpoint(args[2], Util.decodeData(args[3])));
                } else if (STEP_FILTERS.equals(command)) {
                    this.sendResponse(null);
                } else if (DETAIL_FORMATTERS.equals(command)) {
                    String[] df = new String[args.length - 2];
                    System.arraycopy(args, 2, df, 0, df.length);
                    this.sendResponse(this.processDetailFormatters(df));
                } else if (SET_VALUE.equals(command)) {
                    this.sendResponse(this.doSetValue(Util.decodeData(args[2]), Util.decodeData(args[3])));
                } else if (GET_SOURCE.equals(command)) {
                    this.sendResponse(this.getSource(Util.decodeData(args[2])));
                } else if (TERMINATE.equals(command)) {
                    this.terminate();
                } else if (VERSION.equals(command)) {
                    this.sendResponse(MessageFormat.format(_0_1, "1", this.getVersion()));
                } else if (UPDATE.equals(command)) {
                    this.sendResponse(null);
                } else {
                    this.sendResponse("!unsupported command <" + command + ">");
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.sendResponse("!not enough arguments for <" + command + ">");
            }
            catch (IllegalArgumentException e) {
                this.sendResponse("!invalid argument value for <" + e.getMessage() + ">");
            }
            catch (Exception e) {
                this.logError(e);
            }
        }
    }

    protected final void sendResponse(String data) throws IOException {
        if (this.reqid == null) {
            throw new IllegalStateException("reqid is null");
        }
        this.sendData(this.reqid, data);
        this.reqid = null;
    }

    protected final void sendData(String[] data) throws IOException {
        this.sendData(null, StringUtil.join((String)ARGS_DELIMITER, (String[])data));
    }

    protected final void sendData(String reqid, String data) throws IOException {
        if (this.writer == null) {
            return;
        }
        String message = null;
        message = reqid != null && data != null ? MessageFormat.format(_0_1_2, Integer.toString(data.length() + reqid.length() + 1), reqid, data) : (reqid != null ? MessageFormat.format(_0_1, Integer.toString(reqid.length()), reqid) : MessageFormat.format(_0_1, Integer.toString(data.length()), data));
        this.writer.write(message);
        try {
            this.writer.flush();
        }
        catch (SocketException socketException) {}
        this.logger.log(false, message);
    }

    private String processBreakpoint(String action, String uri, int lineNo, BreakpointProperties props) {
        if (CREATE.equals(action)) {
            if (this.setBreakpoint(uri, lineNo, props)) {
                return CREATED;
            }
        } else if (CHANGE.equals(action) && this.removeBreakpoint(uri, lineNo)) {
            if (this.setBreakpoint(uri, lineNo, props)) {
                return CHANGED;
            }
        } else if (REMOVE.equals(action) && this.removeBreakpoint(uri, lineNo)) {
            return REMOVED;
        }
        return null;
    }

    private String processExceptionBreakpoint(String action, String exceptionType) {
        if (CREATE.equals(action)) {
            if (!this.exceptions.contains(exceptionType)) {
                this.exceptions.add(exceptionType);
                this.setExceptionBreakpoint(exceptionType);
                return CREATED;
            }
        } else {
            if (CHANGE.equals(action)) {
                this.exceptions.add(exceptionType);
                this.setExceptionBreakpoint(exceptionType);
                return CHANGED;
            }
            if (REMOVE.equals(action) && this.exceptions.remove(exceptionType)) {
                this.removeExceptionBreakpoint(exceptionType);
                return REMOVED;
            }
        }
        return null;
    }

    protected final void terminate() {
        this.checkCloseStreams();
        this.terminateSession();
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
            this.socket = null;
            this.checkCloseStreams();
        }
        this.logger.close();
    }

    private void checkCloseStreams() {
        if (this.socket == null || this.socket.isClosed()) {
            block13: {
                if (this.reader != null) {
                    try {
                        try {
                            this.reader.close();
                        }
                        catch (IOException iOException) {
                            this.reader = null;
                            break block13;
                        }
                    }
                    catch (Throwable throwable) {
                        this.reader = null;
                        throw throwable;
                    }
                    this.reader = null;
                }
            }
            if (this.writer != null) {
                try {
                    try {
                        this.writer.close();
                    }
                    catch (IOException iOException) {
                        this.writer = null;
                    }
                }
                finally {
                    this.writer = null;
                }
            }
        }
    }

    protected abstract void startDebugging() throws IOException;

    protected abstract void stopDebugging(String var1) throws IOException;

    protected abstract String listFrames();

    protected abstract int frameCount();

    protected abstract String listVariables(String var1);

    protected abstract String doGetDetails(String var1);

    protected abstract String doEval(String var1, String var2);

    protected abstract String doSetValue(String var1, String var2);

    protected abstract boolean suspend(String var1);

    protected abstract String processDetailFormatters(String[] var1);

    protected abstract String getSource(String var1);

    protected abstract boolean setBreakpoint(String var1, int var2, BreakpointProperties var3);

    protected abstract boolean removeBreakpoint(String var1, int var2);

    protected abstract void setExceptionBreakpoint(String var1);

    protected abstract void removeExceptionBreakpoint(String var1);

    protected abstract void processOptionChange(String var1);

    protected void enable() throws IOException {
        this.enabled = true;
        this.sendData(new String[]{RESUMED, START});
    }

    private void disable() throws IOException {
        this.enabled = false;
        this.stopDebugging(null);
    }

    protected final boolean getBooleanOption(String option) {
        Object value = this.options.get(option);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    protected String makeAbsoluteURI(String string) {
        URI uri = null;
        try {
            uri = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {}
        if (uri == null || uri.getScheme() == null) {
            return "app:///" + string;
        }
        return string;
    }

    protected String makeDebuggerURI(String string) {
        URI uri = null;
        try {
            uri = new URI(string);
            if ("app".equals(uri.getScheme())) {
                String path = uri.getPath();
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                return path;
            }
        }
        catch (URISyntaxException uRISyntaxException) {}
        return string;
    }

    protected static String addFlag(String flags, char flag) {
        if (flags.indexOf(flag) == -1) {
            flags = String.valueOf(flags) + flag;
        }
        return flags;
    }

    protected static String combineFlags(String flags, String additions) {
        if (additions == null) {
            return flags;
        }
        if (additions.length() == 1) {
            return AbstractDebugHost.addFlag(flags, additions.charAt(0));
        }
        if (additions.length() > 0) {
            int i = 0;
            while (i < additions.length()) {
                char ch = additions.charAt(i);
                flags = ch == '-' && i + 1 < additions.length() ? AbstractDebugHost.removeFlag(flags, additions.charAt(++i)) : AbstractDebugHost.addFlag(flags, additions.charAt(i));
                ++i;
            }
        }
        return flags;
    }

    protected static String removeFlag(String flags, char flag) {
        if (flags.indexOf(flag) != -1) {
            flags = flags.replace(String.valueOf(flag), "");
        }
        return flags;
    }

    protected final void initLogger(Plugin plugin, String basename) throws DebugException {
        this.plugin = plugin;
        IPath base = plugin.getStateLocation().append("logs");
        base.toFile().mkdirs();
        this.errorLogFile = base.append(String.valueOf(basename) + ".err").toFile();
        this.logger = new ProtocolLogger(basename, plugin.getBundle().getSymbolicName());
    }

    protected final void closeLogger() {
        this.logger.close();
    }

    protected final synchronized void logError(String message) {
        System.out.println(message);
        try {
            PrintWriter logWriter = new PrintWriter(new FileOutputStream(this.errorLogFile, true), true);
            logWriter.format("[%1$tc] %2$s\n", Calendar.getInstance(), message);
            logWriter.close();
        }
        catch (FileNotFoundException e) {
            IdeLog.logError((Plugin)this.plugin, (Throwable)e);
        }
    }

    protected final void logError(Exception e) {
        IdeLog.logError((Plugin)this.plugin, (Throwable)e);
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        this.logError(writer.toString());
    }

    private String getVersion() {
        return (String)this.plugin.getBundle().getHeaders().get("Bundle-Version");
    }

    static /* synthetic */ void access$0(AbstractDebugHost abstractDebugHost, Socket socket) {
        abstractDebugHost.socket = socket;
    }

    static /* synthetic */ Socket access$1(AbstractDebugHost abstractDebugHost) {
        return abstractDebugHost.socket;
    }

    static /* synthetic */ void access$2(AbstractDebugHost abstractDebugHost, Reader reader) {
        abstractDebugHost.reader = reader;
    }

    static /* synthetic */ void access$3(AbstractDebugHost abstractDebugHost, Writer writer) {
        abstractDebugHost.writer = writer;
    }

    static /* synthetic */ String access$4(AbstractDebugHost abstractDebugHost) throws IOException {
        return abstractDebugHost.readMessage();
    }

    static /* synthetic */ void access$5(AbstractDebugHost abstractDebugHost, String string) throws IOException {
        abstractDebugHost.handleMessage(string);
    }

    protected class BreakpointProperties {
        public boolean disabled;
        public int hitCount;
        public String condition;
        public boolean conditionOnTrue;

        BreakpointProperties(boolean disabled, int hitCount, String condition, boolean conditionOnTrue) {
            this.disabled = disabled;
            this.hitCount = hitCount;
            this.condition = condition;
            this.conditionOnTrue = conditionOnTrue;
        }
    }
}

