/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.text.hyperlink;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.ext.HTMLScript;
import com.aptana.editor.html.ext.ScriptRange;
import com.aptana.editor.html.text.hyperlink.StringSearchHyperlink;
import com.aptana.editor.js.hyperlink.JSHyperlinkDetector;
import com.aptana.editor.js.hyperlink.JSTargetRegionHyperlink;
import com.aptana.editor.js.parsing.ast.JSParseRootNode;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.lexer.IRange;
import com.pandora.core.stats.Stats;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class HTMLScriptHyperlinkDetector
extends JSHyperlinkDetector {
    private HTMLScript htmlScript = null;
    private String jsEventFuncName = "";
    private IRegion jsEventInvokeRegion = null;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IHyperlink[] result = null;
        if (textViewer != null && region != null) {
            AbstractThemeableEditor editor = this.getEditor(textViewer);
            result = this.detectHyperlinks(editor, region, canShowMultipleHyperlinks);
        }
        return result;
    }

    public IHyperlink[] detectHyperlinks(AbstractThemeableEditor editor, IRegion region, boolean canShowMultipleHyperlinks) {
        Object[] result = null;
        int offset = region.getOffset();
        IDocument doc = editor.getDocument();
        Object obj = editor.getEditorInput().getAdapter(IFile.class);
        IFile file = null;
        if (obj != null) {
            file = (IFile)obj;
        }
        IParseNode ast = null;
        try {
            IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)"create ast by htmlscript...");
            ast = this.getAST(doc, offset, file);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        if (ast != null && ast instanceof JSParseRootNode) {
            IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)"process ast to compute result ...");
            result = this.processAST(editor, (JSParseRootNode)ast, this.htmlScript.getOffset());
            result = this.recomputeHyperlink(editor, file, doc, (IHyperlink[])result);
        }
        if (!canShowMultipleHyperlinks && !ArrayUtil.isEmpty((Object[])result)) {
            result = new IHyperlink[]{result[0]};
        }
        return result;
    }

    private IHyperlink[] recomputeHyperlink(AbstractThemeableEditor editor, IFile file, IDocument doc, IHyperlink[] result) {
        if (result == null) {
            return null;
        }
        ArrayList<Object> links = new ArrayList<Object>();
        IHyperlink[] iHyperlinkArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            IHyperlink link = iHyperlinkArray[n2];
            JSTargetRegionHyperlink targetRegionHyperlink = null;
            if (!(link instanceof JSTargetRegionHyperlink)) {
                if (link instanceof StringSearchHyperlink) {
                    links.add(link);
                }
            } else {
                targetRegionHyperlink = (JSTargetRegionHyperlink)link;
                IRegion region = targetRegionHyperlink.getTargetRegion();
                List<IRange> ranges = this.htmlScript.getScriptsInHTML();
                int pos = 0;
                for (IRange r : ranges) {
                    String linkText;
                    ScriptRange scriptRange = (ScriptRange)r;
                    if (scriptRange.getFileName() != null) {
                        if (region.getOffset() > pos && (long)region.getOffset() < (long)pos + scriptRange.getFileLength()) {
                            String fileName = scriptRange.getFileName();
                            int offset = region.getOffset() - pos - ";\r\n".length();
                            Region targetRegion = new Region(offset, region.getLength());
                            IRegion linkRegion = targetRegionHyperlink.getHyperlinkRegion();
                            IRegion realLinkRegion = this.computeLinkRegion(linkRegion);
                            if (realLinkRegion == null) continue;
                            linkText = fileName;
                            if (fileName.startsWith("file:/") && (linkText = fileName.replaceFirst(file.getProject().getLocationURI().toString(), "")).startsWith("file:/")) {
                                linkText = linkText.replaceFirst("file:/", "");
                            }
                            if (StringUtil.isNotEmpty((String)targetRegionHyperlink.getHyperlinkText()) && targetRegionHyperlink.getHyperlinkText().startsWith("<") && targetRegionHyperlink.getHyperlinkText().endsWith(">")) {
                                linkText = String.valueOf(linkText) + targetRegionHyperlink.getHyperlinkText();
                            }
                            JSTargetRegionHyperlink realLink = new JSTargetRegionHyperlink(realLinkRegion, "invocation", linkText, fileName, (IRegion)targetRegion);
                            links.add(realLink);
                            break;
                        }
                        pos = (int)((long)pos + scriptRange.getFileLength());
                        continue;
                    }
                    if (region.getOffset() > pos && region.getOffset() < pos + scriptRange.getLength()) {
                        int offset = region.getOffset() - pos;
                        Region targetRegion = new Region(scriptRange.getStartingOffset() + offset, region.getLength());
                        IRegion linkRegion = targetRegionHyperlink.getHyperlinkRegion();
                        IRegion realLinkRegion = this.computeLinkRegion(linkRegion);
                        String fileName = targetRegionHyperlink.getTargetFilePath();
                        if (fileName.startsWith("file:/")) {
                            linkText = fileName.replaceFirst(file.getProject().getLocationURI().toString(), "");
                            if (linkText.startsWith("file:/")) {
                                linkText = linkText.replaceFirst("file:/", "");
                            }
                            targetRegionHyperlink.setHyperlinkText(linkText);
                        }
                        if (targetRegionHyperlink.getHyperlinkText().startsWith("<") && targetRegionHyperlink.getHyperlinkText().endsWith(">")) {
                            String prefix = targetRegionHyperlink.getTargetFilePath().replaceFirst(Platform.getLocation().toString(), "");
                            if (prefix.startsWith("file:/")) {
                                prefix = prefix.replaceFirst("file:/", "");
                            }
                            targetRegionHyperlink.setHyperlinkText(String.valueOf(prefix) + targetRegionHyperlink.getHyperlinkText());
                        }
                        JSTargetRegionHyperlink realLink = new JSTargetRegionHyperlink(realLinkRegion, "", targetRegionHyperlink.getHyperlinkText(), targetRegionHyperlink.getTargetFilePath(), (IRegion)targetRegion);
                        links.add(realLink);
                        break;
                    }
                    pos += scriptRange.getLength();
                }
            }
            ++n2;
        }
        return links.toArray(new IHyperlink[links.size()]);
    }

    private IRegion computeLinkRegion(IRegion linkRegion) {
        if (StringUtil.isNotEmpty((String)this.jsEventFuncName)) {
            try {
                int offset = this.jsEventFuncName.length() - ((String.valueOf(this.jsEventFuncName) + this.htmlScript.getSource()).length() - linkRegion.getOffset());
                if (offset >= 0) {
                    return new Region(this.jsEventInvokeRegion.getOffset() + offset, linkRegion.getLength());
                }
            }
            catch (Exception e) {
                Stats.addExceptionInfo((Throwable)e);
            }
            return null;
        }
        ScriptRange scriptRange = (ScriptRange)this.htmlScript.getActiveScriptRange();
        int sourceStartOffset = (int)scriptRange.getAllSourceStartOffset();
        int sourceOffset = linkRegion.getOffset();
        int subSourceOffset = sourceOffset - sourceStartOffset;
        return new Region(scriptRange.getStartingOffset() + subSourceOffset, linkRegion.getLength());
    }

    private IParseNode getAST(IDocument doc, int offset, IFile file) throws Exception {
        this.htmlScript = new HTMLScript(doc, offset, file, null, this.getRanges());
        String source = this.htmlScript.getSource();
        if (StringUtil.isNotEmpty((String)this.jsEventFuncName)) {
            source = String.valueOf(source) + this.jsEventFuncName;
            offset = this.jsEventInvokeRegion.getOffset() + this.jsEventInvokeRegion.getLength() - offset;
            this.htmlScript.setOffset(source.length() - offset);
        }
        return ParserPoolFactory.parse((String)"com.aptana.contenttype.js", (String)source).getRootNode();
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion lineRegion, boolean canShowMultipleHyperlinks, String jsEventFuncName, IRegion linkRegion) {
        AbstractThemeableEditor editor = this.getEditor(textViewer);
        IHyperlink[] result = this.detectHyperlinks(editor, lineRegion, canShowMultipleHyperlinks, jsEventFuncName, linkRegion);
        return result;
    }

    public IHyperlink[] detectHyperlinks(AbstractThemeableEditor editor, IRegion lineRegion, boolean canShowMultipleHyperlinks, String jsEventFuncName, IRegion linkRegion) {
        this.jsEventFuncName = jsEventFuncName;
        this.jsEventInvokeRegion = linkRegion;
        IHyperlink[] result = this.detectHyperlinks(editor, lineRegion, canShowMultipleHyperlinks);
        this.jsEventFuncName = null;
        this.jsEventInvokeRegion = null;
        return result;
    }
}

