/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext.inferrer;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.ext.inferrer.HTMLNodeInferrer;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.html.parsing.ast.HTMLSpecialNode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class GetElementsByClassNameInferrer
extends HTMLNodeInferrer {
    private String cls = null;
    private Set<HTMLElementNode> elements = new HashSet<HTMLElementNode>();

    public GetElementsByClassNameInferrer(String cls) {
        this.cls = cls;
        Assert.isNotNull((Object)cls);
    }

    @Override
    public void visit(HTMLSpecialNode specialNode) {
        String[] classes;
        String clss = specialNode.getCSSClass();
        if (StringUtil.isNotEmpty((String)clss) && Arrays.asList(classes = clss.split(" ")).contains(this.cls)) {
            this.elements.add(specialNode);
        }
        super.visit(specialNode);
    }

    @Override
    public void visit(HTMLElementNode elementNode) {
        String[] classes;
        String clss = elementNode.getCSSClass();
        if (StringUtil.isNotEmpty((String)clss) && Arrays.asList(classes = clss.split(" ")).contains(this.cls)) {
            this.elements.add(elementNode);
        }
        super.visit(elementNode);
    }

    public Set<HTMLElementNode> getElements() {
        return this.elements;
    }
}

