/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.TimeLogUtils;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.css.contentassist.CSSContentAssistProcessor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.xml.TagUtil;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class HTMLSingleStyleContentAssistProcessor
extends CSSContentAssistProcessor {
    public HTMLSingleStyleContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        try {
            this.initActiveRange(viewer, offset);
            return super.doComputeCompletionProposals(viewer, offset, activationChar, autoActivated);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return new ICompletionProposal[0];
        }
    }

    private void initActiveRange(ITextViewer viewer, int offset) throws BadLocationException {
        TimeLogUtils log = TimeLogUtils.getTimeLog();
        IDocument document = viewer.getDocument();
        ITypedRegion typedRegion = document.getPartition(offset);
        String partition = null;
        while ((partition = typedRegion.getType()) != null) {
            if (partition.startsWith("__html_")) break;
            typedRegion = document.getPartition(typedRegion.getOffset() - 1);
        }
        IRegion closeRegion = TagUtil.findMatchingClose((IDocument)document, (ITypedRegion)typedRegion, (String)document.get(typedRegion.getOffset(), typedRegion.getLength()));
        int scriptStartOffset = typedRegion.getOffset() + typedRegion.getLength();
        this.setActiveRange((IRange)new Range(scriptStartOffset, closeRegion.getOffset() - 1));
        log.logTaskCostTime("\u8ba1\u7b97\u5f53\u524dstyle\u533a\u57df", true);
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        try {
            this.initActiveRange(viewer, offset);
            return super.computeContextInformation(viewer, offset);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    public boolean isNeedComputeLocationType() {
        return true;
    }
}

