/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.ext.ScriptRange;
import com.aptana.editor.js.contentassist.PropertyElementProposal;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.parsing.lexer.IRange;
import com.pandora.core.utils.URIUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;

public class HTMLScriptPropertyElementProposal
extends PropertyElementProposal {
    private List<IRange> scripts = Collections.emptyList();
    private ScriptRange activeScriptRange = null;
    protected String insertReplaceString = "";
    protected AbstractThemeableEditor editor = null;

    public HTMLScriptPropertyElementProposal(AbstractThemeableEditor editor, PropertyElement property, int offset, int replaceLength, URI uri, List<IRange> scripts, IRange activeScriptRange) {
        super(property, offset, replaceLength, uri);
        this.scripts = scripts;
        this.activeScriptRange = (ScriptRange)activeScriptRange;
        this.editor = editor;
        this.setCompletionProposalType(CompletionProposalType.ATTRIBUTE);
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        super.apply(viewer, trigger, stateMask, offset);
        String fileLocation = this.getDefineJs();
        IEditorInput input = this.editor.getEditorInput();
        if (StringUtil.isNotEmpty((String)fileLocation) && fileLocation.endsWith(".js") && input instanceof FileEditorInput) {
            try {
                FileEditorInput fileInput = (FileEditorInput)input;
                String jsLocation = fileInput.getFile().getProject().getLocationURI().relativize(new URI(fileLocation)).toString();
                String htmlLocation = fileInput.getFile().getProject().getLocationURI().relativize(fileInput.getFile().getLocationURI()).toString();
                fileLocation = URIUtils.relativeURI((String)htmlLocation, (String)jsLocation);
            }
            catch (URISyntaxException e) {
                IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                return;
            }
            boolean importJSFile = false;
            for (IRange range : this.scripts) {
                ScriptRange script = (ScriptRange)range;
                if (!script.getWholeTag().contains(fileLocation)) continue;
                importJSFile = true;
                break;
            }
            if (!importJSFile) {
                IDocument doc = viewer.getDocument();
                String scriptTagTemplate = "<script type=\"text/javascript\" src=\"{0}\"></script>";
                String scriptTag = MessageFormat.format(scriptTagTemplate, fileLocation);
                try {
                    if (this.activeScriptRange != null) {
                        int insertOffset = this.activeScriptRange.getStartingOffset() - this.activeScriptRange.getWholeTag().length();
                        int line = doc.getLineOfOffset(insertOffset);
                        int lineOffset = doc.getLineOffset(line);
                        int tabLength = insertOffset - lineOffset;
                        this.insertReplaceString = String.valueOf(scriptTag) + "\r\n" + doc.get(lineOffset, tabLength);
                        doc.replace(insertOffset, 0, this.insertReplaceString);
                    }
                }
                catch (BadLocationException e) {
                    IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                }
            }
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this._replacementOffset + this._cursorPosition + this.insertReplaceString.length(), 0);
    }
}

