/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.html.ext.HTMLScriptPropertyElementProposal;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.parsing.lexer.IRange;
import java.net.URI;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Point;

public class HTMLScriptFunctionElementProposal
extends HTMLScriptPropertyElementProposal {
    public HTMLScriptFunctionElementProposal(AbstractThemeableEditor editor, PropertyElement property, int offset, int replaceLength, URI uri, List<IRange> scripts, IRange activeScriptRange) {
        super(editor, property, offset, replaceLength, uri, scripts, activeScriptRange);
        this.setCompletionProposalType(CompletionProposalType.FUNCTION);
    }

    @Override
    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        super.apply(viewer, trigger, stateMask, offset);
        this.applyLinkedModel(viewer, offset);
        this.showContentInfo(viewer);
    }

    protected void applyLinkedModel(ITextViewer viewer, int offset) {
        try {
            if (this._replacementString.indexOf("(") > 0 && this._replacementString.indexOf(")") > 0) {
                int[] _positions;
                IDocument document = viewer.getDocument();
                LinkedModeModel.closeAllModels((IDocument)document);
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                int shift = offset - this._replacementOffset;
                int[] nArray = _positions = new int[]{this._replacementString.length() - 1, this._replacementString.length()};
                int n = _positions.length;
                int n2 = 0;
                while (n2 < n) {
                    int pos = nArray[n2];
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, offset - shift + pos, 0, i++));
                    model.addGroup(group);
                    ++n2;
                }
                model.forceInstall();
                LinkedModeUI ui = new LinkedModeUI(model, viewer);
                ui.setCyclingMode(LinkedModeUI.CYCLE_ALWAYS);
                ui.setExitPosition(viewer, offset - shift + _positions[_positions.length - 1], 0, Integer.MAX_VALUE);
                ui.enter();
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)JSPlugin.getDefault(), (Throwable)e);
        }
    }

    @Override
    public Point getSelection(IDocument document) {
        if (this._replacementString.indexOf("(") > 0 && this._replacementString.indexOf(")") > 0) {
            int start = this._replacementString.indexOf("(") + 1;
            int end = this._replacementString.indexOf(",");
            if (end < 0) {
                end = this._replacementString.indexOf(")");
            }
            Point p = super.getSelection(document);
            p.x = p.x - this._replacementString.length() + start;
            p.y = end - start;
            return p;
        }
        return super.getSelection(document);
    }
}

