/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.ext.FileRange;
import com.aptana.editor.html.ext.HTMLScriptRange;
import com.aptana.editor.html.ext.ScriptRange;
import com.aptana.editor.js.htmlext.IScriptRange;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import com.pandora.core.utils.RegularUtils;
import com.pandora.core.utils.URIUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class HTMLScript {
    private IScriptRange range = null;
    private long maxSize = 65536L;
    private String source = null;
    private int offset = 0;
    private List<IRange> scriptsInHTML = Collections.emptyList();
    public static final String JS_TYPE = "text/javascript";
    public static final String NEW_LINE_CHAR = ";\r\n";
    protected IRange activeScriptRange = null;
    private int originalOffset = 0;
    private List<IRange> ranges;

    public HTMLScript(IDocument doc, int offset, IFile currentFile, IScriptRange activeRange, List<IRange> ranges) {
        this(doc, offset, currentFile, activeRange, true, ranges);
    }

    public HTMLScript(IDocument doc, int offset, IFile currentFile) {
        this(doc, offset, currentFile, null);
    }

    public HTMLScript(IDocument doc, int offset, IFile currentFile, boolean isParseRefJS) {
        this(doc, offset, currentFile, null, isParseRefJS);
    }

    public HTMLScript(IDocument doc, int offset, IFile currentFile, IScriptRange activeRange) {
        this(doc, offset, currentFile, activeRange, true);
    }

    public HTMLScript(IDocument doc, int offset, IFile currentFile, IScriptRange activeRange, boolean isParseRefJS) {
        try {
            this.originalOffset = offset;
            this.range = activeRange;
            this.initialize(doc, offset, currentFile, isParseRefJS);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
    }

    public HTMLScript(IDocument doc, int offset, IFile currentFile, IScriptRange activeRange, boolean isParseRefJS, List<IRange> ranges) {
        try {
            this.ranges = ranges;
            this.originalOffset = offset;
            this.range = activeRange;
            this.initialize(doc, offset, currentFile, isParseRefJS);
        }
        catch (BadLocationException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
    }

    protected void initialize(IDocument doc, int offset, IFile currentFile, boolean isParseRefJS) throws BadLocationException {
        int inScriptOffset = 0;
        StringBuffer sb = new StringBuffer();
        List<IRange> scripts = this.getRanges(doc, offset);
        IRange[] scritpsArr = this.sort(scripts);
        this.scriptsInHTML = Arrays.asList(scritpsArr);
        ArrayList<String> scriptSrcList = new ArrayList<String>();
        IRange[] iRangeArray = scritpsArr;
        int n = scritpsArr.length;
        int n2 = 0;
        while (n2 < n) {
            IRange range = iRangeArray[n2];
            if (range.getClass() == ScriptRange.class) {
                ScriptRange scriptRange = (ScriptRange)range;
                String scriptTag = String.valueOf(scriptRange.getWholeTag()) + "</script>";
                String scriptType = null;
                String scriptSrc = null;
                try {
                    Document scriptDoc = DocumentHelper.parseText((String)scriptTag);
                    Element root = scriptDoc.getRootElement();
                    scriptType = root.attributeValue("type");
                    scriptSrc = root.attributeValue("src");
                }
                catch (Exception exception) {
                    scriptType = RegularUtils.match((String)"type[\\s]*=[\\s]*[\"']([\\s/_a-zA-Z0-9]*)[\"']", (String)scriptRange.getWholeTag(), (int)1);
                    scriptSrc = RegularUtils.match((String)"src[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']", (String)scriptRange.getWholeTag(), (int)1);
                }
                if (StringUtil.isEmpty((String)scriptType) || JS_TYPE.equalsIgnoreCase(scriptType)) {
                    scriptRange.setAllSourceStartOffset(sb.length());
                    if (StringUtil.isNotEmpty((String)scriptSrc) && isParseRefJS && currentFile != null) {
                        if (!scriptSrcList.contains(scriptSrc = URIUtils.resolveURIInProject((IFile)currentFile, (String)scriptSrc))) {
                            scriptSrcList.add(scriptSrc);
                            inScriptOffset = this.handleReferenceScript(offset, currentFile, inScriptOffset, sb, scriptRange, scriptSrc);
                        }
                    } else {
                        inScriptOffset = this.handleNestedScript(doc, offset, inScriptOffset, sb, scriptRange);
                    }
                    scriptRange.setAllSourceEndOffset(sb.length());
                }
            }
            ++n2;
        }
        this.offset = inScriptOffset = this.handleOtherScriptRange(doc, offset, inScriptOffset, sb, scritpsArr);
        this.source = sb.toString();
    }

    public List<IRange> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<IRange> ranges) {
        this.ranges = ranges;
    }

    public List<IRange> getRanges(IDocument doc, int offset) {
        if (this.getRanges() != null) {
            return this.getRanges();
        }
        if (this.range == null) {
            this.range = this.getHTMLScriptActiveRange();
        }
        return this.range.computeAllScriptsRange(doc, offset);
    }

    protected int handleOtherScriptRange(IDocument doc, int offset, int inScriptOffset, StringBuffer sb, IRange[] scritpsArr) {
        return inScriptOffset;
    }

    protected IScriptRange getHTMLScriptActiveRange() {
        return new HTMLScriptRange();
    }

    protected int handleNestedScript(IDocument doc, int offset, int inScriptOffset, StringBuffer sb, ScriptRange scriptRange) throws BadLocationException {
        if (scriptRange.contain(offset)) {
            inScriptOffset += offset - scriptRange.getStartingOffset();
            this.activeScriptRange = scriptRange;
        } else if (scriptRange.getEndingOffset() < offset) {
            inScriptOffset += scriptRange.getLength();
        }
        sb.append(doc.get(scriptRange.getStartingOffset(), scriptRange.getLength()));
        return inScriptOffset;
    }

    protected int handleReferenceScript(int offset, IFile currentFile, int inScriptOffset, StringBuffer sb, ScriptRange scriptRange, String scriptSrc) {
        IProject project;
        block8: {
            block7: {
                if (currentFile != null) break block7;
                return 0;
            }
            project = currentFile.getProject();
            if (project != null) break block8;
            return 0;
        }
        try {
            IFile ifile = project.getFile(scriptSrc);
            File refJSFile = null;
            if (ifile.exists()) {
                refJSFile = FileUtil.convertIFileToFile((IFile)ifile);
            }
            if (refJSFile != null && refJSFile.exists() && refJSFile.getName().endsWith(".js") && refJSFile.length() < this.maxSize) {
                String jsContent = FileUtils.readFileToString((File)refJSFile);
                jsContent = StringUtil.stripUTF8BOM((String)jsContent);
                sb.append(NEW_LINE_CHAR + jsContent);
                int length = jsContent.length() + NEW_LINE_CHAR.length();
                if (scriptRange.getEndingOffset() < offset) {
                    inScriptOffset += length;
                }
                scriptRange.setFileName(ifile.getLocationURI().toString());
                scriptRange.setFileLength(length);
            }
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
        }
        return inScriptOffset;
    }

    protected IRange[] sort(List<IRange> scripts) {
        IRange[] scritpsArr = scripts.toArray(new IRange[scripts.size()]);
        Arrays.sort(scritpsArr, new Comparator<IRange>(){

            @Override
            public int compare(IRange arg0, IRange arg1) {
                return arg0.getStartingOffset() - arg1.getStartingOffset();
            }
        });
        return scritpsArr;
    }

    public String getSource() {
        return this.source == null ? "" : this.source;
    }

    public int getOffset() {
        return this.offset;
    }

    public FileRange findActualFileRange(int offsetInSource) {
        if (this.scriptsInHTML.isEmpty()) {
            return null;
        }
        for (IRange range : this.scriptsInHTML) {
            ScriptRange scriptRange = (ScriptRange)range;
            if ((long)offsetInSource < scriptRange.getAllSourceStartOffset() || (long)offsetInSource >= scriptRange.getAllSourceEndOffset()) continue;
            long actualOffset = 0L;
            if (scriptRange.getFileName() != null) {
                actualOffset = (long)offsetInSource - scriptRange.getAllSourceStartOffset() - (long)NEW_LINE_CHAR.length();
                FileRange fileRange = new FileRange((int)actualOffset);
                fileRange.setFileName(scriptRange.getFileName());
                return fileRange;
            }
            actualOffset = (long)scriptRange.getStartingOffset() + ((long)offsetInSource - scriptRange.getAllSourceStartOffset());
            FileRange fileRange = new FileRange((int)actualOffset);
            return fileRange;
        }
        return null;
    }

    public IRange computeReplaceRange(IRange replaceRange) {
        int x = this.originalOffset - replaceRange.getLength();
        int y = this.originalOffset - 1;
        return new Range(x, y);
    }

    public List<IRange> getScriptsInHTML() {
        return this.scriptsInHTML;
    }

    public IRange getActiveScriptRange() {
        return this.activeScriptRange;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }
}

