/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.css.contentassist.CSSContentAssistProcessor;
import com.aptana.editor.css.contentassist.CSSFontProposal;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.HTMLTagScanner;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.ext.CommonSpecialListHandler;
import com.aptana.editor.html.parsing.HTMLUtils;
import com.aptana.editor.html.parsing.lexer.HTMLLexemeProvider;
import com.aptana.editor.html.parsing.lexer.HTMLTokenType;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.rules.ITokenScanner;

public class FontSpecialListHandler
extends CommonSpecialListHandler {
    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange repalceRange, Set<ICompletionProposal> result, boolean isHTML) {
        HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();
        String[] list = queryHelper.getFontAttributeValueList();
        boolean isHTMLAttribute = false;
        boolean isJSAttribute = false;
        if (editor instanceof HTMLEditor) {
            IDocument document = editor.getDocument();
            HTMLLexemeProvider lexemeProvider = this.createLexemeProvider(document, offset > 0 ? offset - 1 : offset);
            String attributeName = this.getAttributeName((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
            try {
                ITypedRegion typedRegion = document.getPartition(offset);
                if (typedRegion.getType().startsWith("__html_") && !HTMLUtils.isCSSAttribute(attributeName)) {
                    isHTMLAttribute = true;
                } else if (typedRegion.getType().startsWith("__js_")) {
                    isJSAttribute = true;
                }
            }
            catch (BadLocationException badLocationException) {}
        } else if (editor instanceof JSSourceEditor) {
            isJSAttribute = true;
        }
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String fontName = stringArray[n2];
            if (!StringUtil.isBlank((String)fontName)) {
                if (fontName.indexOf("\"") > -1 || fontName.indexOf("'") > -1) {
                    fontName = fontName.replace("\"", "");
                    fontName = fontName.replace("'", "");
                }
                String font = fontName;
                if (!(isHTMLAttribute || fontName.indexOf(" ") < 0 && fontName.indexOf("\t") < 0 && !CSSContentAssistProcessor.pat.matcher(fontName).find() || isJSAttribute)) {
                    font = "\"" + font + "\"";
                }
                CSSFontProposal proposal = new CSSFontProposal(font, fontName, repalceRange, offset);
                proposal.setCompletionProposalType(CompletionProposalType.FONT);
                proposal.setIsHTML(isHTML);
                result.add((ICompletionProposal)proposal);
            }
            ++n2;
        }
    }

    HTMLLexemeProvider createLexemeProvider(IDocument document, int offset) {
        int documentLength = document.getLength();
        int lexemeProviderOffset = offset >= documentLength ? documentLength - 1 : offset;
        return new HTMLLexemeProvider(document, lexemeProviderOffset, (ITokenScanner)new HTMLTagScanner(false));
    }

    private String getAttributeName(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        String name = null;
        int index = lexemeProvider.getLexemeFloorIndex(offset);
        while (index >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index);
            if (lexeme.getType() == HTMLTokenType.EQUAL) {
                if (index < 1 || (lexeme = lexemeProvider.getLexeme(index - 1)) == null) break;
                name = lexeme.getText();
                break;
            }
            --index;
        }
        return name;
    }
}

