/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.contentassist.StringValueCompletionProposal;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.editor.html.ext.CommonSpecialListHandler;
import com.aptana.parsing.lexer.IRange;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class EventSpecialListHandler
extends CommonSpecialListHandler {
    private HTMLIndexQueryHelper _queryHelper = new HTMLIndexQueryHelper();
    private static final String EVENT_KEY = "_DC_EventStringValue";

    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange repalceRange, Set<ICompletionProposal> result, boolean isHTML) {
        List<AttributeElement> events = this._queryHelper.getAttribute(EVENT_KEY);
        if (!CollectionsUtil.isEmpty(events)) {
            for (AttributeElement event : events) {
                List<ValueElement> values = event.getValues();
                if (CollectionsUtil.isEmpty(values)) continue;
                for (ValueElement value : values) {
                    StringValueCompletionProposal proposal = new StringValueCompletionProposal(value.getName(), repalceRange, EVENT_ICON, value.getDescription());
                    Map userAgentIcons = UserAgentManager.getInstance().getUserAgentPath(this.getProject(editor), value.getUserAgentsNameWithVersion());
                    proposal.setIsHTML(isHTML);
                    proposal.setUserAgentImages(userAgentIcons);
                    result.add((ICompletionProposal)proposal);
                }
            }
        }
    }
}

