/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.StringValueCompletionProposal;
import com.aptana.editor.common.contentassist.UserAgentFilterType;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.extensions.ISpecialListHandler;
import com.aptana.editor.common.util.EditorUtil;
import com.aptana.editor.css.CSSSourceEditor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.parsing.HTMLParseRootNode;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.index.core.Index;
import com.aptana.parsing.IParseState;
import com.aptana.parsing.ParserPoolFactory;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Range;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;

public abstract class CommonSpecialListHandler
implements ISpecialListHandler {
    protected static final Image ATTRIBUTE_ICON = HTMLPlugin.getImage("/icons/assistant/attribute.png");
    protected static final Image EVENT_ICON = HTMLPlugin.getImage("/icons/assistant/event.png");
    protected static UserAgentFilterType _filterType = UserAgentFilterType.NO_FILTER;

    static {
        IPreferenceStore commonPreferences = CommonEditorPlugin.getDefault().getPreferenceStore();
        String filterTypeString = commonPreferences.getString("CONTENT_ASSIST_USER_AGENT_FILTER_TYPE");
        _filterType = UserAgentFilterType.get((String)filterTypeString);
    }

    protected void addProposals(IRange replaceRange, Set<ICompletionProposal> result, Map<String, String> resultMap, boolean isHTML) {
        for (Map.Entry<String, String> attr : resultMap.entrySet()) {
            replaceRange = new Range(replaceRange.getStartingOffset(), replaceRange.getEndingOffset());
            StringValueCompletionProposal proposal = new StringValueCompletionProposal(attr.getKey(), replaceRange, ATTRIBUTE_ICON, attr.getValue());
            proposal.setIsHTML(isHTML);
            result.add((ICompletionProposal)proposal);
        }
    }

    public IRange getReplaceRange() {
        return null;
    }

    protected void addProposals(IRange replaceRange, Set<ICompletionProposal> result, Map<String, String> resultMap, CompletionProposalType type, int relevance, boolean isHTML) {
        for (Map.Entry<String, String> attr : resultMap.entrySet()) {
            replaceRange = new Range(replaceRange.getStartingOffset(), replaceRange.getEndingOffset());
            StringValueCompletionProposal proposal = new StringValueCompletionProposal(attr.getKey(), replaceRange, ATTRIBUTE_ICON, attr.getValue());
            proposal.setRelevance(relevance);
            proposal.setCompletionProposalType(type);
            proposal.setIsHTML(isHTML);
            result.add((ICompletionProposal)proposal);
        }
    }

    protected void addSetProposals(IRange replaceRange, Set<ICompletionProposal> result, Map<String, Set<String>> classResults) {
        for (Map.Entry<String, Set<String>> entry : classResults.entrySet()) {
            replaceRange = new Range(replaceRange.getStartingOffset(), replaceRange.getEndingOffset());
            StringValueCompletionProposal proposal = new StringValueCompletionProposal(entry.getKey(), replaceRange, ATTRIBUTE_ICON, StringUtil.join((String)"<br />", (Collection)entry.getValue()));
            result.add((ICompletionProposal)proposal);
        }
    }

    protected IFile getFileByEditor(AbstractThemeableEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            return fileInput.getFile();
        }
        return null;
    }

    protected List<HTMLParseRootNode> getHTMLRootNodesByReference(AbstractThemeableEditor editor, HTMLIndexQueryHelper queryHelper) {
        ArrayList<HTMLParseRootNode> rootNodes = new ArrayList<HTMLParseRootNode>();
        IFile file = this.getFileByEditor(editor);
        if (file == null) {
            return rootNodes;
        }
        Map<String, Set<String>> jsRefs = null;
        if (editor instanceof JSSourceEditor) {
            jsRefs = queryHelper.getJSReferences(EditorUtil.getIndex((AbstractThemeableEditor)editor));
        } else if (editor instanceof CSSSourceEditor) {
            jsRefs = queryHelper.getCSSReferences(EditorUtil.getIndex((AbstractThemeableEditor)editor));
        }
        if (jsRefs == null) {
            return rootNodes;
        }
        String location = file.getLocationURI().toString();
        Set<String> htmlFiles = jsRefs.get(location);
        if (htmlFiles == null || htmlFiles.isEmpty()) {
            return rootNodes;
        }
        for (String htmlFile : htmlFiles) {
            try {
                File html = file.getProject().getLocation().append(htmlFile).makeAbsolute().toFile();
                HTMLParseState htmlParseState = new HTMLParseState(FileUtils.readFileToString((File)html));
                IParseRootNode rootNode = ParserPoolFactory.parse((String)"com.aptana.contenttype.html", (IParseState)htmlParseState).getRootNode();
                if (!(rootNode instanceof HTMLParseRootNode)) continue;
                rootNodes.add((HTMLParseRootNode)rootNode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return rootNodes;
    }

    public boolean checkNeedReContentAssist(String dispalyName, char activationChar) {
        return true;
    }

    public boolean isActiveByUserAgent(String[] userAgents, AbstractThemeableEditor editor) {
        boolean result = false;
        if (userAgents == null || userAgents.length == 0) {
            result = true;
        } else {
            block0 : switch (_filterType) {
                case NO_FILTER: {
                    result = true;
                    break;
                }
                case ONE_OR_MORE: {
                    String[] userAgentIds = UserAgentManager.getInstance().getActiveUserAgentIDs(this.getProject(editor));
                    HashSet<String> activeNameSet = new HashSet<String>(Arrays.asList(userAgentIds));
                    String[] stringArray = userAgents;
                    int n = userAgents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        if (activeNameSet.contains(id)) {
                            result = true;
                            break block0;
                        }
                        ++n2;
                    }
                    break;
                }
                case ALL: {
                    HashSet<String> nameSet = new HashSet<String>(Arrays.asList(userAgents));
                    String[] activeUserAgentIds = UserAgentManager.getInstance().getActiveUserAgentIDs(this.getProject(editor));
                    result = nameSet.containsAll(Arrays.asList(activeUserAgentIds));
                    break;
                }
            }
        }
        return result;
    }

    protected IProject getProject(AbstractThemeableEditor editor) {
        return EditorUtil.getProject((AbstractThemeableEditor)editor);
    }

    protected URI getURI(AbstractThemeableEditor editor) {
        return EditorUtil.getURI((IEditorPart)editor);
    }

    protected URI getProjectURI(AbstractThemeableEditor editor) {
        return EditorUtil.getProjectURI((AbstractThemeableEditor)editor);
    }

    protected Index getIndex(AbstractThemeableEditor editor) {
        return EditorUtil.getIndex((AbstractThemeableEditor)editor);
    }

    public int getRealOffset(AbstractThemeableEditor editor, int offset) {
        ISelection s = editor.getSelectionProvider().getSelection();
        if (s instanceof TextSelection) {
            TextSelection ts = (TextSelection)s;
            offset = ts.getOffset();
        }
        return offset;
    }
}

