/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.ext;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.css.htmlext.IPrefixAttributeSelectors;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.ext.CommonSpecialListHandler;
import com.aptana.editor.html.ext.inferrer.GetElementByIdInferrer;
import com.aptana.editor.html.ext.inferrer.GetElementsByClassNameInferrer;
import com.aptana.editor.html.ext.inferrer.HTMLNodeInferrer;
import com.aptana.editor.html.parsing.HTMLParseRootNode;
import com.aptana.editor.html.parsing.ast.HTMLElementNode;
import com.aptana.editor.js.htmlext.DomProperties;
import com.aptana.editor.js.htmlext.IHTMLDomPropertiesAware;
import com.aptana.parsing.ast.IParseNode;
import com.aptana.parsing.ast.IParseNodeAttribute;
import com.aptana.parsing.ast.IParseRootNode;
import com.aptana.parsing.lexer.IRange;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class AttrSpecialListHandler
extends CommonSpecialListHandler
implements IHTMLDomPropertiesAware,
IPrefixAttributeSelectors {
    private static Map<String, String> allAttrs = new HashMap<String, String>();
    protected DomProperties domProperties = null;

    public void doComputeSpecialProposals(AbstractThemeableEditor editor, int offset, IRange replaceRange, Set<ICompletionProposal> result, boolean isHTML) {
        HTMLIndexQueryHelper queryHelper = new HTMLIndexQueryHelper();
        if (allAttrs.isEmpty()) {
            this.initAttrs(queryHelper, allAttrs);
        }
        Map<String, String> resultMap = new HashMap<String, String>();
        if (this.domProperties != null) {
            HashSet<HTMLElementNode> elements = new HashSet<HTMLElementNode>();
            HashSet<ElementElement> els = new HashSet<ElementElement>();
            if (editor instanceof HTMLEditor) {
                this.processScriptAttrResults((HTMLEditor)editor, elements);
            } else {
                this.processScriptAttrResults(editor, queryHelper, elements);
            }
            this.initReferenceTags(queryHelper, resultMap, els);
            this.processHTMLElementNodeAttrs(queryHelper, resultMap, elements);
        }
        if (resultMap.isEmpty() && (this.domProperties == null || CollectionsUtil.isEmpty((Collection)this.domProperties.getTags()))) {
            resultMap = allAttrs;
        }
        this.addProposals(replaceRange, result, resultMap, isHTML);
    }

    protected void processScriptAttrResults(AbstractThemeableEditor jsEditor, HTMLIndexQueryHelper queryHelper, Set<HTMLElementNode> elements) {
        List<HTMLParseRootNode> rootNodes = this.getHTMLRootNodesByReference(jsEditor, queryHelper);
        for (HTMLParseRootNode rootNode : rootNodes) {
            HTMLNodeInferrer inferrer;
            for (String domId : this.domProperties.getIds()) {
                inferrer = new GetElementByIdInferrer(domId);
                inferrer.visit((IParseNode)rootNode);
                elements.addAll(((GetElementByIdInferrer)inferrer).getElements());
            }
            for (String domCls : this.domProperties.getClasses()) {
                inferrer = new GetElementsByClassNameInferrer(domCls);
                inferrer.visit((IParseNode)rootNode);
                elements.addAll(((GetElementsByClassNameInferrer)inferrer).getElements());
            }
        }
    }

    protected void processHTMLElementNodeAttrs(HTMLIndexQueryHelper queryHelper, Map<String, String> resultMap, Set<HTMLElementNode> elements) {
        for (HTMLElementNode elNode : elements) {
            IParseNodeAttribute[] attrs;
            String tag = elNode.getName();
            ElementElement el = queryHelper.getElement(tag);
            List<AttributeElement> attrElements = queryHelper.getAttributes(el);
            if (attrElements != null) {
                for (AttributeElement attr : attrElements) {
                    resultMap.put(attr.getName(), attr.getDescription());
                }
            }
            if ((attrs = elNode.getAttributes()) == null) continue;
            IParseNodeAttribute[] iParseNodeAttributeArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                IParseNodeAttribute attr = iParseNodeAttributeArray[n2];
                String description = attr.getValue();
                if (StringUtil.isNotEmpty((String)description)) {
                    description = "value = \"" + description + "\"";
                }
                resultMap.put(attr.getName(), description);
                ++n2;
            }
        }
    }

    protected void initReferenceTags(HTMLIndexQueryHelper queryHelper, Map<String, String> resultMap, Set<ElementElement> els) {
        for (String tag : this.domProperties.getTags()) {
            ElementElement el = queryHelper.getElement(tag);
            if (el == null) continue;
            els.add(el);
        }
        for (ElementElement ee : els) {
            List<AttributeElement> attrs = queryHelper.getAttributes(ee);
            for (AttributeElement attr : attrs) {
                resultMap.put(attr.getName(), attr.getDescription());
            }
        }
    }

    protected void processScriptAttrResults(HTMLEditor htmlEditor, Set<HTMLElementNode> elements) {
        IParseRootNode rootNode = htmlEditor.getAST();
        if (rootNode instanceof HTMLParseRootNode) {
            HTMLNodeInferrer inferrer;
            HTMLParseRootNode htmlRootNode = (HTMLParseRootNode)rootNode;
            for (String id : this.domProperties.getIds()) {
                inferrer = new GetElementByIdInferrer(id);
                inferrer.visit((IParseNode)htmlRootNode);
                elements.addAll(((GetElementByIdInferrer)inferrer).getElements());
            }
            for (String domCls : this.domProperties.getClasses()) {
                inferrer = new GetElementsByClassNameInferrer(domCls);
                inferrer.visit((IParseNode)rootNode);
                elements.addAll(((GetElementsByClassNameInferrer)inferrer).getElements());
            }
        }
    }

    protected List<AttributeElement> initAttrs(HTMLIndexQueryHelper queryHelper, Map<String, String> allAttrs) {
        List<AttributeElement> attrs = queryHelper.getAttributes();
        for (AttributeElement attr : attrs) {
            if (attr.getName().startsWith("_DC_")) continue;
            allAttrs.put(attr.getName(), attr.getDescription());
        }
        return attrs;
    }

    public void setDomProperties(DomProperties domProperties) {
        this.domProperties = domProperties;
    }

    public void setPrefix(String prefix) {
        if (StringUtil.isBlank((String)prefix)) {
            this.domProperties = null;
        } else {
            this.domProperties = new DomProperties();
            if (prefix.startsWith("#")) {
                this.domProperties.addId(prefix);
            } else {
                this.domProperties.addTag(prefix);
            }
        }
    }
}

