/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.model;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.contentassist.model.Messages;
import com.aptana.index.core.ui.views.IPropertyInformation;
import com.aptana.jetty.util.epl.ajax.JSON;
import java.util.Map;

public class EntityElement
extends BaseElement<Property> {
    private static final String DECIMAL_VALUE_PROPERTY = "decimalValue";
    private static final String HEX_VALUE_PROPERTY = "hexValue";
    private String _decimalValue;
    private String _hexValue;

    @Override
    public void fromJSON(Map object) {
        super.fromJSON(object);
        this.setHexValue(StringUtil.getStringValue(object.get(HEX_VALUE_PROPERTY)));
        this.setDecimalValue(StringUtil.getStringValue(object.get(DECIMAL_VALUE_PROPERTY)));
    }

    public String getDecimalValue() {
        return StringUtil.getStringValue((Object)this._decimalValue);
    }

    public String getHexValue() {
        return StringUtil.getStringValue((Object)this._hexValue);
    }

    public void setDecimalValue(String value) {
        this._decimalValue = value;
    }

    public void setHexValue(String value) {
        this._hexValue = value;
    }

    @Override
    public void toJSON(JSON.Output out) {
        super.toJSON(out);
        out.add(HEX_VALUE_PROPERTY, (Object)this.getHexValue());
        out.add(DECIMAL_VALUE_PROPERTY, (Object)this.getDecimalValue());
    }

    static enum Property implements IPropertyInformation<EntityElement>
    {
        NAME(Messages.EntityElement_NameLabel){

            public Object getPropertyValue(EntityElement node) {
                return node.getName();
            }
        };

        private String header;
        private String category;

        private Property(String header) {
            this.header = header;
        }

        private Property(String header, String category) {
            this.category = category;
        }

        public String getCategory() {
            return this.category;
        }

        public String getHeader() {
            return this.header;
        }
    }
}

