/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist.index;

import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.RegexUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.EntityElement;
import com.aptana.editor.html.contentassist.model.EventElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexReader;
import com.aptana.index.core.QueryResult;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;

public class HTMLIndexReader
extends IndexReader {
    private AttributeElement createAttribute(QueryResult attribute) {
        return (AttributeElement)this.populateElement(new AttributeElement(), attribute, 1);
    }

    private ElementElement createElement(QueryResult element) {
        return (ElementElement)this.populateElement(new ElementElement(), element, 1);
    }

    private EntityElement createEntity(QueryResult entity) {
        return (EntityElement)this.populateElement(new EntityElement(), entity, 1);
    }

    private EventElement createEvent(QueryResult event) {
        return (EventElement)this.populateElement(new EventElement(), event, 1);
    }

    public List<AttributeElement> getAttribute(Index index, String name) {
        if (index == null || StringUtil.isEmpty((String)name)) {
            return Collections.emptyList();
        }
        List attributes = index.query(new String[]{"html.attribute"}, String.valueOf(name) + "\u0000", 1);
        return CollectionsUtil.map((Collection)attributes, (IMap)new QueryResultToAttributeElementMapper());
    }

    private String getAttributePattern(List<String> names) {
        String namePattern = RegexUtil.createQuotedListPattern(names);
        return MessageFormat.format("^{1}{0}", this.getDelimiter(), namePattern);
    }

    public List<AttributeElement> getAttributes(Index index, List<String> names) {
        if (index == null || CollectionsUtil.isEmpty(names)) {
            return Collections.emptyList();
        }
        List attributes = index.query(new String[]{"html.attribute"}, this.getAttributePattern(names), 16);
        return CollectionsUtil.map((Collection)attributes, (IMap)new QueryResultToAttributeElementMapper());
    }

    public List<AttributeElement> getAttributes(Index index) {
        if (index == null) {
            return Collections.emptyList();
        }
        List attributes = index.query(new String[]{"html.attribute"}, "*", 2);
        return CollectionsUtil.map((Collection)attributes, (IMap)new QueryResultToAttributeElementMapper());
    }

    protected String getDelimiter() {
        return "\u0000";
    }

    public List<ElementElement> getElements(Index index) {
        if (index == null) {
            return Collections.emptyList();
        }
        List elements = index.query(new String[]{"html.element"}, "*", 2);
        return CollectionsUtil.map((Collection)elements, (IMap)new QueryResultToElementElementMapper());
    }

    public List<ElementElement> getElements(Index index, String ... names) {
        if (index == null || ArrayUtil.isEmpty((Object[])names)) {
            return Collections.emptyList();
        }
        ArrayList<ElementElement> result = new ArrayList<ElementElement>();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            name = name.toLowerCase();
            List elements = index.query(new String[]{"html.element"}, String.valueOf(name) + "\u0000", 9);
            result.addAll(CollectionsUtil.map((Collection)elements, (IMap)new QueryResultToElementElementMapper()));
            ++n2;
        }
        result.trimToSize();
        return result;
    }

    public List<EntityElement> getEntities(Index index) {
        if (index == null) {
            return Collections.emptyList();
        }
        List entities = index.query(new String[]{"html.entity"}, "*", 2);
        return CollectionsUtil.map((Collection)entities, (IMap)new QueryResultToEntityElementMapper());
    }

    public EntityElement getEntity(Index index, String name) {
        Iterator iterator;
        List entities;
        EntityElement result = null;
        if (index != null && (entities = index.query(new String[]{"html.entity"}, String.valueOf(name) + "\u0000", 1)) != null && (iterator = entities.iterator()).hasNext()) {
            QueryResult entity = (QueryResult)iterator.next();
            result = this.createEntity(entity);
        }
        return result;
    }

    public EventElement getEvent(Index index, String name) {
        Iterator iterator;
        List events;
        EventElement result = null;
        if (index != null && (events = index.query(new String[]{"html.event"}, String.valueOf(name) + "\u0000", 1)) != null && (iterator = events.iterator()).hasNext()) {
            QueryResult event = (QueryResult)iterator.next();
            result = this.createEvent(event);
        }
        return result;
    }

    public List<EventElement> getEvents(Index index) {
        if (index == null) {
            return Collections.emptyList();
        }
        List events = index.query(new String[]{"html.event"}, "*", 2);
        return CollectionsUtil.map((Collection)events, (IMap)new QueryResultToEventElementMapper());
    }

    public List<EventElement> getEvents(Index index, List<String> names) {
        if (index == null || CollectionsUtil.isEmpty(names)) {
            return Collections.emptyList();
        }
        List events = index.query(new String[]{"html.event"}, this.getAttributePattern(names), 16);
        return CollectionsUtil.map((Collection)events, (IMap)new QueryResultToEventElementMapper());
    }

    protected String getSubDelimiter() {
        return ",";
    }

    public Map<String, String> getValues(Index index, String category) {
        String pattern;
        List items;
        HashMap<String, String> result = null;
        if (index != null && !StringUtil.isEmpty((String)category) && (items = index.query(new String[]{category}, pattern = "*", 2)) != null && items.size() > 0) {
            result = new HashMap<String, String>();
            for (QueryResult item : items) {
                Set paths = item.getDocuments();
                String path = paths != null && !paths.isEmpty() ? (String)paths.iterator().next() : "";
                try {
                    URI uri = index.getRelativeDocumentPath(new URI(path));
                    result.put(item.getWord(), uri.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    result.put(item.getWord(), path);
                }
            }
        }
        return result;
    }

    public Map<String, Set<String>> getSetValues(Index index, String category) {
        String pattern;
        List items;
        HashMap result = null;
        if (index != null && !StringUtil.isEmpty((String)category) && (items = index.query(new String[]{category}, pattern = "*", 2)) != null && items.size() > 0) {
            result = new HashMap();
            for (QueryResult item : items) {
                Set paths = item.getDocuments();
                for (String path : paths) {
                    HashSet<String> sets = (HashSet<String>)result.get(item.getWord());
                    if (sets == null) {
                        sets = new HashSet<String>();
                        result.put(item.getWord(), sets);
                    }
                    try {
                        URI uri = index.getRelativeDocumentPath(new URI(path));
                        sets.add(uri.toString());
                    }
                    catch (URISyntaxException e) {
                        IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
                        sets.add(path);
                    }
                }
            }
        }
        return result;
    }

    private final class QueryResultToAttributeElementMapper
    implements IMap<QueryResult, AttributeElement> {
        private QueryResultToAttributeElementMapper() {
        }

        public AttributeElement map(QueryResult attribute) {
            return HTMLIndexReader.this.createAttribute(attribute);
        }
    }

    private final class QueryResultToElementElementMapper
    implements IMap<QueryResult, ElementElement> {
        private QueryResultToElementElementMapper() {
        }

        public ElementElement map(QueryResult element) {
            return HTMLIndexReader.this.createElement(element);
        }
    }

    private final class QueryResultToEntityElementMapper
    implements IMap<QueryResult, EntityElement> {
        private QueryResultToEntityElementMapper() {
        }

        public EntityElement map(QueryResult entity) {
            return HTMLIndexReader.this.createEntity(entity);
        }
    }

    private final class QueryResultToEventElementMapper
    implements IMap<QueryResult, EventElement> {
        private QueryResultToEventElementMapper() {
        }

        public EventElement map(QueryResult event) {
            return HTMLIndexReader.this.createEvent(event);
        }
    }
}

