/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.css.CSSSourceEditor;
import com.aptana.editor.html.HTMLEditor;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.IndexQuickSearchIndexResult;
import com.aptana.editor.js.JSPlugin;
import com.aptana.editor.js.JSSourceEditor;
import com.aptana.editor.js.contentassist.JSContentAssistProcessor;
import com.aptana.editor.js.contentassist.JSIndexQueryHelper;
import com.aptana.editor.js.contentassist.model.FunctionElement;
import com.aptana.editor.js.contentassist.model.PropertyElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexPlugin;
import com.pandora.core.index.IQuickSearchIndexQuery;
import com.pandora.core.index.QuickSearchIndexResult;
import com.pandora.core.index.QuickSearchType;
import com.pandora.core.utils.ProjectUtils;
import com.pandora.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class QuickSearchIndexQuery
implements IQuickSearchIndexQuery {
    private boolean isHTML = false;
    private boolean isJS = false;
    private boolean isCSS = false;
    private HTMLIndexQueryHelper htmlIndexQueryHelper;
    private JSIndexQueryHelper jsIndexHelper;
    private Index index;
    private IFile iFile;

    public List<QuickSearchIndexResult> getQuickSearchIndexResult(QuickSearchType type, String fileName) {
        this.isHTML = false;
        this.isJS = false;
        this.isCSS = false;
        if (type == null) {
            return Collections.emptyList();
        }
        this.htmlIndexQueryHelper = new HTMLIndexQueryHelper();
        this.jsIndexHelper = new JSIndexQueryHelper();
        this.iFile = this.getActiceFile(fileName);
        if (this.iFile == null || !this.iFile.exists()) {
            return Collections.emptyList();
        }
        boolean isSpeFile = StringUtil.isNotBlank((String)fileName);
        this.index = this.getIndex(this.iFile.getProject());
        ArrayList<QuickSearchIndexResult> results = new ArrayList<QuickSearchIndexResult>();
        if (this.isHTML) {
            this.getHTMLFileResult(this.iFile, results, isSpeFile);
        } else if (this.isJS) {
            this.getJSFileResult(this.iFile, results, QuickSearchIndexResult.FileType.JS_FILE, isSpeFile);
        } else if (this.isCSS) {
            this.getCSSFileResult(this.iFile, results, isSpeFile);
        }
        return results;
    }

    private void getCSSFileResult(IFile file, List<QuickSearchIndexResult> results, boolean isSpeFile) {
        String fPath = file.getProjectRelativePath().toString();
        Map<String, Set<String>> map = this.htmlIndexQueryHelper.getCSSReferences(this.index);
        Set<String> htmlFileList = null;
        if (map != null) {
            htmlFileList = map.get(fPath);
        }
        HashMap<String, String> cssRefsIds = new HashMap<String, String>();
        HashMap<String, String> cssRefsClasses = new HashMap<String, String>();
        this.getIDAndCLASSResult(results, fPath, htmlFileList, cssRefsIds, cssRefsClasses, QuickSearchIndexResult.FileType.CSS_FILE);
        if (!isSpeFile) {
            this.getIdAndClassResult(results, cssRefsIds, cssRefsClasses, QuickSearchIndexResult.FileType.HTML_FILE);
            if (htmlFileList == null) {
                return;
            }
            for (String htmlFile : htmlFileList) {
                this.getJSFileResult(file.getProject().getFile(htmlFile), results, QuickSearchIndexResult.FileType.HTML_FILE, isSpeFile);
            }
        }
    }

    public void getIDAndCLASSResult(List<QuickSearchIndexResult> results, String fPath, Set<String> fileList, Map<String, String> cssRefsIds, Map<String, String> cssRefsClasses, QuickSearchIndexResult.FileType fileType) {
        Map<String, Set<String>> classes;
        Map<String, Set<String>> idMaps = this.htmlIndexQueryHelper.getIDList(this.index);
        if (idMaps != null && !idMaps.isEmpty()) {
            for (Map.Entry<String, Set<String>> entry : idMaps.entrySet()) {
                Set<String> flocations = entry.getValue();
                for (String location : flocations) {
                    if (StringUtil.isBlank((String)location)) continue;
                    if (location.equals(fPath)) {
                        this.processResult(entry.getKey(), fPath, results, QuickSearchIndexResult.ResultType.ID, fileType);
                    }
                    if (fileList == null || !fileList.contains(location) || cssRefsIds == null) continue;
                    cssRefsIds.put(location, entry.getKey());
                }
            }
        }
        if ((classes = this.htmlIndexQueryHelper.getClassList(this.index)) != null && !classes.isEmpty()) {
            for (Map.Entry<String, Set<String>> entry : classes.entrySet()) {
                Set<String> flocations = entry.getValue();
                for (String location : flocations) {
                    if (StringUtil.isBlank((String)location)) continue;
                    if (location.equals(fPath)) {
                        this.processResult(entry.getKey(), fPath, results, QuickSearchIndexResult.ResultType.CLASS, fileType);
                    }
                    if (fileList == null || !fileList.contains(location) || cssRefsClasses == null) continue;
                    cssRefsClasses.put(location, entry.getKey());
                }
            }
        }
    }

    private void getHTMLFileResult(IFile file, List<QuickSearchIndexResult> results, boolean isSpeFile) {
        String fPath = file.getProjectRelativePath().toString();
        Set<String> cssFileList = this.getCSSFileRefrences();
        HashMap<String, String> cssRefsIds = new HashMap<String, String>();
        HashMap<String, String> cssRefsClasses = new HashMap<String, String>();
        this.getIDAndCLASSResult(results, fPath, cssFileList, cssRefsIds, cssRefsClasses, QuickSearchIndexResult.FileType.HTML_FILE);
        this.getJSFileResult(file, results, QuickSearchIndexResult.FileType.HTML_FILE, isSpeFile);
        if (!isSpeFile) {
            Map<String, Set<String>> jsRefs = this.htmlIndexQueryHelper.getJSReferences(this.index);
            if (jsRefs != null) {
                for (Map.Entry<String, Set<String>> entry : jsRefs.entrySet()) {
                    if (!entry.getValue().contains(fPath)) continue;
                    String path = entry.getKey().substring(this.iFile.getProject().getLocationURI().toString().length() + 1);
                    this.getJSFileResult(file.getProject().getFile(path), results, QuickSearchIndexResult.FileType.JS_FILE, isSpeFile);
                }
            }
            this.getIdAndClassResult(results, cssRefsIds, cssRefsClasses, QuickSearchIndexResult.FileType.CSS_FILE);
        }
    }

    public void getIdAndClassResult(List<QuickSearchIndexResult> results, Map<String, String> cssRefsIds, Map<String, String> cssRefsClasses, QuickSearchIndexResult.FileType fileType) {
        if (cssRefsIds != null) {
            for (Map.Entry<String, String> entry : cssRefsIds.entrySet()) {
                this.processResult(entry.getValue(), entry.getKey(), results, QuickSearchIndexResult.ResultType.ID, fileType);
            }
        }
        if (cssRefsClasses != null) {
            for (Map.Entry<String, String> entry : cssRefsClasses.entrySet()) {
                this.processResult(entry.getValue(), entry.getKey(), results, QuickSearchIndexResult.ResultType.CLASS, fileType);
            }
        }
    }

    private void processResult(String id, String fPath, List<QuickSearchIndexResult> results, QuickSearchIndexResult.ResultType type, QuickSearchIndexResult.FileType fileType) {
        if (StringUtil.isBlank((String)id) || StringUtil.isBlank((String)fPath)) {
            return;
        }
        IndexQuickSearchIndexResult result = new IndexQuickSearchIndexResult();
        result.setImage(JSContentAssistProcessor.JS_PROPERTY);
        result.setName(id);
        result.setPath(fPath);
        result.setType(type);
        result.setFileType(fileType);
        results.add(result);
    }

    private Set<String> getCSSFileRefrences() {
        HashSet<String> list = new HashSet<String>();
        Map<String, Set<String>> map = this.htmlIndexQueryHelper.getCSSReferences(this.index);
        if (map == null || map.isEmpty()) {
            return list;
        }
        Set<Map.Entry<String, Set<String>>> resourceEntrySet = map.entrySet();
        if (resourceEntrySet == null) {
            return list;
        }
        String fPath = this.iFile.getProjectRelativePath().toString();
        for (Map.Entry<String, Set<String>> entry : resourceEntrySet) {
            String path;
            Set<String> set = entry.getValue();
            if (!set.contains(fPath) || !(path = entry.getKey()).startsWith(this.iFile.getProject().getLocationURI().toString())) continue;
            path = path.substring(this.iFile.getProject().getLocationURI().toString().length() + 1);
            list.add(path);
        }
        return list;
    }

    public void getJSFileResult(IFile file, List<QuickSearchIndexResult> results, QuickSearchIndexResult.FileType fileType, boolean isSpeFile) {
        List typeNames = CollectionsUtil.newList((Object[])new String[]{"Window", "Global"});
        Collection propertyElements = this.jsIndexHelper.getMembers(this.index, typeNames, file.getLocationURI());
        this.processJSFileResult(propertyElements, results, fileType);
        if (!isSpeFile) {
            Map<String, Set<String>> jsRefs = this.htmlIndexQueryHelper.getJSReferences(this.index);
            if (jsRefs == null) {
                return;
            }
            String fPath = file.getProjectRelativePath().toString();
            Set<String> htmlFileList = jsRefs.get(fPath);
            if (htmlFileList == null) {
                return;
            }
            for (String htmlFile : htmlFileList) {
                this.getIDAndCLASSResult(results, htmlFile, null, null, null, QuickSearchIndexResult.FileType.HTML_FILE);
                this.getJSFileResult(file.getProject().getFile(htmlFile), results, fileType, isSpeFile);
            }
        }
    }

    private void processJSFileResult(Collection<PropertyElement> propertyElements, List<QuickSearchIndexResult> results, QuickSearchIndexResult.FileType fileType) {
        if (CollectionsUtil.isEmpty(propertyElements)) {
            return;
        }
        for (PropertyElement propertyElement : propertyElements) {
            IndexQuickSearchIndexResult result = new IndexQuickSearchIndexResult();
            boolean isFunction = propertyElement instanceof FunctionElement;
            result.setImage(isFunction ? JSContentAssistProcessor.JS_FUNCTION : JSContentAssistProcessor.JS_PROPERTY);
            result.setName(propertyElement.getName());
            result.setPath(propertyElement.getSource());
            result.setType(isFunction ? QuickSearchIndexResult.ResultType.JS_FUNCTION : QuickSearchIndexResult.ResultType.JS_VAR);
            result.setFileType(fileType);
            results.add(result);
        }
    }

    private Index getIndex(IProject project) {
        return IndexPlugin.getDefault().getIndexManager().getIndex(project.getLocationURI());
    }

    private IFile getActiceFile(String fileName) {
        IEditorInput editorInput;
        IWorkbenchWindow workbenchWindow = JSPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        if (StringUtil.isBlank((String)fileName)) {
            if (editor instanceof HTMLEditor) {
                this.isHTML = true;
                this.isCSS = false;
                this.isJS = false;
            } else if (editor instanceof CSSSourceEditor) {
                this.isCSS = true;
                this.isHTML = false;
                this.isJS = false;
            } else if (editor instanceof JSSourceEditor) {
                this.isJS = true;
                this.isHTML = false;
                this.isCSS = false;
            }
        }
        if ((editorInput = editor.getEditorInput()) == null) {
            return null;
        }
        IFile iFile = null;
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            iFile = fileEditorInput.getFile();
        }
        if (iFile != null) {
            if (StringUtil.isNotBlank((String)fileName)) {
                iFile = iFile.getProject().getFile(fileName);
            }
            if (iFile == null) {
                return null;
            }
        } else {
            if (StringUtil.isBlank((String)fileName)) {
                return null;
            }
            IProject project = ProjectUtils.getCurrentProject();
            if (project == null) {
                return null;
            }
            iFile = project.getFile(fileName);
            if (iFile == null) {
                return null;
            }
        }
        String extend = iFile.getFileExtension();
        String[] cssExtends = this.htmlIndexQueryHelper.getCSSUriExtendValueList();
        String[] jsExtends = this.htmlIndexQueryHelper.getJSUriExtendValueList();
        if (!this.isJS && StringUtil.contains((String[])jsExtends, (String)extend)) {
            this.isJS = true;
            this.isHTML = false;
            this.isCSS = false;
        } else if (!this.isCSS && StringUtil.contains((String[])cssExtends, (String)extend)) {
            this.isCSS = true;
            this.isHTML = false;
            this.isJS = false;
        } else if (extend.contains("html")) {
            this.isCSS = false;
            this.isHTML = true;
            this.isJS = false;
        }
        return iFile;
    }
}

