/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.index.IReferIndexQueryHelper;
import com.aptana.editor.html.contentassist.index.HTMLIndexReader;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.EntityElement;
import com.aptana.editor.html.contentassist.model.EventElement;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.index.core.Index;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;

public class HTMLIndexQueryHelper
implements IReferIndexQueryHelper {
    protected static final String FONTVALUEATTRIBUTE = "_DC_FontStringValue";
    protected static final String IMAGEURIEXTENDATTRIBUTE = "_DC_ImageURIStringValue";
    protected static final String MULTIMEDIAEXTENDATTRIBUTE = "_DC_MultimediaStringValue";
    protected static final String JSURIEXTENDATTRIBUTE = "_DC_JSURIStringValue";
    protected static final String CSSURIEXTENDATTRIBUTE = "_DC_CSSURIStringValue";
    protected static final String COLORSTRINGATTRIBUTE = "_DC_ColorStringValue";
    protected static String[] jsExtends = null;
    protected static String[] cssExtends = null;
    protected static String[] multiMediaExtends = null;
    protected static String[] imageExtends = null;
    protected static String[] fontValues = null;
    protected static String[] colorValues = null;
    private HTMLIndexReader _reader = new HTMLIndexReader();
    protected static List<AttributeElement> attributeElementList = null;
    protected static List<ElementElement> elementElementList = null;
    protected static List<EntityElement> entityElementList = null;
    protected static List<EventElement> eventElementList = null;

    public static Index getIndex() {
        return HTMLIndexQueryHelper.getIndexManager().getIndex(URI.create("metadata:/html"));
    }

    protected static IndexManager getIndexManager() {
        return IndexPlugin.getDefault().getIndexManager();
    }

    public List<AttributeElement> getAttribute(String name) {
        if (name != null && name.length() > 0) {
            return this._reader.getAttribute(HTMLIndexQueryHelper.getIndex(), name);
        }
        return Collections.emptyList();
    }

    public AttributeElement getAttribute(String elementName, String attributeName) {
        AttributeElement result = null;
        if (elementName != null && elementName.length() > 0) {
            ElementElement element = this.getElement(elementName);
            if (element == null) {
                return result;
            }
            List<String> attributes = element.getAttributes();
            if (attributes == null) {
                return result;
            }
            boolean haAttribute = attributes.contains(attributeName);
            AttributeElement defaultAttribute = null;
            AttributeElement candidateAttribute = null;
            for (AttributeElement attribute : this.getAttribute(attributeName)) {
                String elementRef = attribute.getElement();
                if (elementRef != null && elementRef.length() > 0) {
                    if (!elementName.equals(elementRef)) continue;
                    candidateAttribute = attribute;
                    continue;
                }
                defaultAttribute = attribute;
            }
            if (candidateAttribute != null) {
                result = candidateAttribute;
            } else if (defaultAttribute != null && haAttribute) {
                result = defaultAttribute;
            }
        }
        return result;
    }

    public List<AttributeElement> getAttributes() {
        if (attributeElementList != null) {
            return attributeElementList;
        }
        attributeElementList = this._reader.getAttributes(HTMLIndexQueryHelper.getIndex());
        return attributeElementList;
    }

    public List<AttributeElement> getAttributes(ElementElement element) {
        List<AttributeElement> attributes;
        List<AttributeElement> result = Collections.emptyList();
        if (element != null && (attributes = this._reader.getAttributes(HTMLIndexQueryHelper.getIndex(), element.getAttributes())) != null && !attributes.isEmpty()) {
            String elementName = element.getName();
            HashMap<String, AttributeElement> attributeMap = new HashMap<String, AttributeElement>();
            for (AttributeElement attribute : attributes) {
                boolean previousHasElement;
                boolean validAttribute;
                String attributeName = attribute.getName();
                String owningElement = attribute.getElement();
                boolean bl = validAttribute = owningElement == null || owningElement.length() == 0 || owningElement.equals(elementName);
                if (!validAttribute) continue;
                AttributeElement previousAttribute = (AttributeElement)attributeMap.get(attributeName);
                if (previousAttribute == null) {
                    attributeMap.put(attributeName, attribute);
                    continue;
                }
                boolean currentHasElement = !StringUtil.isEmpty((String)owningElement);
                boolean bl2 = previousHasElement = !StringUtil.isEmpty((String)previousAttribute.getName());
                if (currentHasElement && previousHasElement || !currentHasElement && !previousHasElement) {
                    attributeMap.put(attributeName, attribute);
                    continue;
                }
                if (!currentHasElement) continue;
                attributeMap.put(attributeName, attribute);
            }
            result = new ArrayList(attributeMap.values());
        }
        return result;
    }

    public Map<String, String> getClasses(Index index) {
        return this._reader.getValues(index, "css.class");
    }

    public Map<String, Set<String>> getClassList(Index index) {
        return this._reader.getSetValues(index, "css.class");
    }

    public Map<String, String> getTplStrs(Index index) {
        return this._reader.getValues(index, "html.string.tpl");
    }

    public Map<String, Set<String>> getCSSReferences(Index index) {
        return this._reader.getSetValues(index, "html.resource.css");
    }

    public ElementElement getElement(String name) {
        List<ElementElement> elements;
        if (name != null && name.length() > 0 && !(elements = this._reader.getElements(HTMLIndexQueryHelper.getIndex(), name)).isEmpty()) {
            return elements.get(0);
        }
        return null;
    }

    public List<ElementElement> getElements() {
        if (elementElementList != null) {
            return elementElementList;
        }
        elementElementList = this._reader.getElements(HTMLIndexQueryHelper.getIndex());
        return elementElementList;
    }

    public List<EntityElement> getEntities() {
        if (entityElementList != null) {
            return entityElementList;
        }
        entityElementList = this._reader.getEntities(HTMLIndexQueryHelper.getIndex());
        return entityElementList;
    }

    public List<EventElement> getEvents() {
        if (eventElementList != null) {
            return eventElementList;
        }
        eventElementList = this._reader.getEvents(HTMLIndexQueryHelper.getIndex());
        return eventElementList;
    }

    public List<EventElement> getEvents(ElementElement element) {
        ArrayList<EventElement> result = new ArrayList<EventElement>();
        if (element != null) {
            List<String> names = element.getEvents();
            List<EventElement> eventElements = this._reader.getEvents(HTMLIndexQueryHelper.getIndex(), names);
            if (eventElements == null || eventElements.isEmpty()) {
                return Collections.emptyList();
            }
            String elementName = element.getName();
            HashMap<String, EventElement> eventMap = new HashMap<String, EventElement>();
            for (EventElement eventElement : eventElements) {
                boolean isElementEvent;
                if (eventElement == null) continue;
                String eventElementOwner = eventElement.getElement();
                boolean bl = isElementEvent = StringUtil.isBlank((String)eventElementOwner) || eventElementOwner.equals(elementName);
                if (!isElementEvent) continue;
                String eventName = eventElement.getName();
                EventElement mapEvent = (EventElement)eventMap.get(eventName);
                if (mapEvent == null) {
                    eventMap.put(eventName, eventElement);
                } else {
                    String mapEventElement = mapEvent.getElement();
                    boolean eoHasElement = StringUtil.isNotBlank((String)eventElementOwner);
                    boolean meHasElemet = StringUtil.isNotBlank((String)mapEventElement);
                    if (eoHasElement && meHasElemet || !eoHasElement && !meHasElemet) {
                        eventMap.put(eventName, eventElement);
                    } else if (eoHasElement) {
                        eventMap.put(eventName, eventElement);
                    }
                }
                result.add(eventElement);
            }
            result = new ArrayList(eventMap.values());
        }
        return result;
    }

    public List<EventElement> getEvents(String elementName) {
        return this.getEvents(this.getElement(elementName));
    }

    public Map<String, String> getIDs(Index index) {
        return this._reader.getValues(index, "css.identifier");
    }

    public Map<String, Set<String>> getIDList(Index index) {
        return this._reader.getSetValues(index, "css.identifier");
    }

    public Map<String, Set<String>> getJSReferences(Index index) {
        if (index == null) {
            return Collections.emptyMap();
        }
        return this._reader.getSetValues(index, "html.resource.js");
    }

    public String[] getFontAttributeValueList() {
        if (fontValues == null) {
            fontValues = this.getValueStringList(FONTVALUEATTRIBUTE);
        }
        return fontValues;
    }

    public String[] getColorAttributeValueList() {
        if (colorValues == null) {
            colorValues = this.getValueStringList(COLORSTRINGATTRIBUTE);
        }
        return colorValues;
    }

    public String[] getImageExtendValueList() {
        if (imageExtends == null) {
            imageExtends = this.getValueStringList(IMAGEURIEXTENDATTRIBUTE);
        }
        return imageExtends;
    }

    public String[] getMultiMediaExtendValueList() {
        if (multiMediaExtends == null) {
            multiMediaExtends = this.getValueStringList(MULTIMEDIAEXTENDATTRIBUTE);
        }
        return multiMediaExtends;
    }

    public String[] getJSUriExtendValueList() {
        if (jsExtends == null) {
            jsExtends = this.getValueStringList(JSURIEXTENDATTRIBUTE);
        }
        return jsExtends;
    }

    public String[] getCSSUriExtendValueList() {
        if (cssExtends == null) {
            cssExtends = this.getValueStringList(CSSURIEXTENDATTRIBUTE);
        }
        return cssExtends;
    }

    private String[] getValueStringList(String attribute) {
        List<AttributeElement> list = this.getAttribute(attribute);
        ArrayList<String> nameList = new ArrayList<String>();
        for (AttributeElement attributeElement : list) {
            List<ValueElement> listValue = attributeElement.getValues();
            for (ValueElement valueElement : listValue) {
                if (!StringUtil.isNotBlank((String)valueElement.getName())) continue;
                nameList.add(valueElement.getName().toLowerCase());
            }
        }
        String[] values = new String[nameList.size()];
        return nameList.toArray(values);
    }

    public Set<String> getFileReference(IProject project, String reFerenceFile) {
        Map<String, Set<String>> cssRefs;
        Map<String, Set<String>> jsRefs;
        if (StringUtil.isEmpty((String)reFerenceFile) || project == null) {
            return Collections.emptySet();
        }
        File file = new File(reFerenceFile);
        URI uri = null;
        try {
            uri = file.toURI();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (uri == null) {
            return Collections.emptySet();
        }
        IndexManager indexManager = IndexPlugin.getDefault().getIndexManager();
        if (!indexManager.isExistsUri(project.getLocationURI())) {
            return Collections.emptySet();
        }
        String fname = file.getName();
        int index = fname.lastIndexOf(".");
        String extend = fname.substring(index + 1);
        String[] cssExtends = this.getCSSUriExtendValueList();
        String[] jsExtends = this.getJSUriExtendValueList();
        boolean isJS = false;
        boolean isCSS = false;
        if (StringUtil.contains((String[])jsExtends, (String)extend)) {
            isJS = true;
        }
        if (StringUtil.contains((String[])cssExtends, (String)extend)) {
            isCSS = true;
        }
        Set<String> results = null;
        if (isJS && (jsRefs = this.getJSReferences(indexManager.getIndex(project.getLocationURI()))) != null) {
            results = jsRefs.get(uri.toString());
        }
        if (isCSS && (cssRefs = this.getCSSReferences(indexManager.getIndex(project.getLocationURI()))) != null) {
            results = cssRefs.get(uri.toString());
        }
        if (results == null) {
            results = Collections.emptySet();
        }
        return results;
    }

    public Map<String, Set<String>> getJSReferences(IProject project) {
        IndexManager indexManager = IndexPlugin.getDefault().getIndexManager();
        return this.getJSReferences(indexManager.getIndex(project.getLocationURI()));
    }

    public Map<String, Set<String>> getCSSReferences(IProject project) {
        IndexManager indexManager = IndexPlugin.getDefault().getIndexManager();
        return this.getCSSReferences(indexManager.getIndex(project.getLocationURI()));
    }
}

