/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html.contentassist;

import com.aptana.core.IMap;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonContentAssistProcessor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.contentassist.CommonCompletionProposal;
import com.aptana.editor.common.contentassist.CompletionProposalType;
import com.aptana.editor.common.contentassist.ICommonCompletionProposal;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.common.contentassist.ProposalShowInfo;
import com.aptana.editor.common.contentassist.UserAgentManager;
import com.aptana.editor.common.extensions.ISpecialListHandler;
import com.aptana.editor.common.extensions.ISpecialValueListLocationType;
import com.aptana.editor.common.extensions.SpecialValueLocationType;
import com.aptana.editor.common.scripting.snippets.SnippetType;
import com.aptana.editor.css.contentassist.CSSContentAssistProcessor;
import com.aptana.editor.html.HTMLPlugin;
import com.aptana.editor.html.HTMLTagScanner;
import com.aptana.editor.html.HTMLTagUtil;
import com.aptana.editor.html.HTMLTemplatePartitionUtils;
import com.aptana.editor.html.contentassist.HTMLAttributeProposal;
import com.aptana.editor.html.contentassist.HTMLAttributeValueProposal;
import com.aptana.editor.html.contentassist.HTMLCommentProposal;
import com.aptana.editor.html.contentassist.HTMLContextInformationValidator;
import com.aptana.editor.html.contentassist.HTMLElementProposal;
import com.aptana.editor.html.contentassist.HTMLEventProposal;
import com.aptana.editor.html.contentassist.HTMLIndexQueryHelper;
import com.aptana.editor.html.contentassist.HTMLMetaContentValue;
import com.aptana.editor.html.contentassist.HTMLModelFormatter;
import com.aptana.editor.html.contentassist.HTMLTagProposal;
import com.aptana.editor.html.contentassist.LocationType;
import com.aptana.editor.html.contentassist.Messages;
import com.aptana.editor.html.contentassist.model.AttributeElement;
import com.aptana.editor.html.contentassist.model.BaseElement;
import com.aptana.editor.html.contentassist.model.ElementElement;
import com.aptana.editor.html.contentassist.model.EntityElement;
import com.aptana.editor.html.contentassist.model.EventElement;
import com.aptana.editor.html.contentassist.model.SpecificationElement;
import com.aptana.editor.html.contentassist.model.ValueElement;
import com.aptana.editor.html.ext.HTMLScriptContentAssistProcessor;
import com.aptana.editor.html.ext.ScriptHTMLContentAssistProcessor;
import com.aptana.editor.html.parsing.HTMLParseState;
import com.aptana.editor.html.parsing.HTMLUtils;
import com.aptana.editor.html.parsing.lexer.HTMLLexemeProvider;
import com.aptana.editor.html.parsing.lexer.HTMLTokenType;
import com.aptana.editor.js.contentassist.JSContentAssistProcessor;
import com.aptana.parsing.lexer.IRange;
import com.aptana.parsing.lexer.Lexeme;
import com.aptana.parsing.lexer.Range;
import com.aptana.ui.util.UIUtils;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.pandora.core.project.HMobileProject;
import com.pandora.core.utils.RegularUtils;
import com.pandora.core.utils.URIUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;

public class HTMLContentAssistProcessor
extends CommonContentAssistProcessor {
    private static final String CLASS = "class";
    private static final String ID = "id";
    private static final String SCRIPT_SRC__LEAD = "script:";
    private static final String LINK_HREF_LEAD = "link:";
    public static String[] HTML_SRC_ATTRIBUTE = new String[]{"src", "url", "href", "action", "background", "download", "refresh"};
    public static String[] HTML_FOLDER_ATTRIBUTE = new String[]{"src", "url", "href", "refresh", "action"};
    public static String[] HTML_EXCLUDE_PROJECT_FILE = new String[]{"manifest.json"};
    public static String[] HTML_EXCLUDE_FILE = new String[]{"js", "css"};
    public static String[] HTML_IMG_TAG = new String[]{"<input", "<img"};
    public static String[] HTML_IMG_ATTRIBUTE = new String[]{"background"};
    public static String[] HTML_LOCAL_FILE_ATTRIBUTE = new String[]{"action", "refresh"};
    public static String[] HTML_SCRIPTTAG_ATTRIBUTE = new String[]{"<script"};
    public static String[] HTML_CSSTAG_ATTRIBUTE = new String[]{"<link"};
    public static String[] HTML_SOURCETAG_ATTRIBUTE = new String[]{"<source"};
    public static String[] ANCHOR_ATTRIBUTE = new String[]{"href", "action", "refresh"};
    public static String[] ANCHOR_TAG = new String[]{"iframe", "frame"};
    public static boolean IS_CHINESE_CHARACTER = false;
    private static String[] SPEC_NUMBER_STRING = new String[]{"IDString"};
    public static final String[] JS_EXTENDTIONS = new String[]{"script", "js", "jsx", "js.erb"};
    public static final String[] CSS_EXTENDTIONS = new String[]{"css", "css.erb"};
    public static final String[] HTML_EXTENDTIONS = new String[]{"rhtml", "html.erb", "htm", "shtml", "xhtml", "phtml", "html"};
    public static Set<String> COLOR_PROPERTY_NAMES = CollectionsUtil.newSet((Object[])new String[]{"bgcolor", "color", "background-color"});
    public static final String[] ZIP_EXTENDTIONS = new String[]{"zip", "rar", "tar", "z", "7-zip", "gzip", "bz2"};
    public static final String[] XML_EXTENDTIONS = new String[]{"xml", "dtd"};
    public static final String[] XSL_EXTENDTIONS = new String[]{"xsl"};
    public static final String[] JSON_EXTENDTIONS = new String[]{"json"};
    private static final String DOCTYPE_PRECEDING_TEXT = "!";
    private boolean autoActivated;
    public static final Image ELEMENT_ICON = HTMLPlugin.getImage("/icons/assistant/element.png");
    public static final Image ATTRIBUTE_ICON = HTMLPlugin.getImage("/icons/assistant/attribute.png");
    public static final Image EVENT_ICON = HTMLPlugin.getImage("/icons/assistant/event.png");
    public static final Image FOLDER_ICON = HTMLPlugin.getImage("/icons/assistant/folder.png");
    public static final Image CSS_ICON = HTMLPlugin.getImage("/icons/assistant/css.png");
    public static final Image HTML_ICON = HTMLPlugin.getImage("/icons/assistant/html.png");
    public static final Image JS_ICON = HTMLPlugin.getImage("/icons/assistant/js.png");
    public static final Image JSON_ICON = HTMLPlugin.getImage("/icons/assistant/json.png");
    public static final Image XML_ICON = HTMLPlugin.getImage("/icons/assistant/xml.png");
    public static final Image XSL_ICON = HTMLPlugin.getImage("/icons/assistant/xsl.png");
    public static final Image TEXT_ICON = HTMLPlugin.getImage("/icons/assistant/text.png");
    public static final Image ZIP_ICON = HTMLPlugin.getImage("/icons/assistant/zip.png");
    public static final Image IMG_ICON = HTMLPlugin.getImage("/icons/assistant/img.png");
    public static final Map<String, LocationType> locationMap = CollectionsUtil.newTypedMap(String.class, LocationType.class, (Object[])new Object[]{"__html__dftl_partition_content_type", LocationType.IN_TEXT, "__html_comment", LocationType.IN_COMMENT, "__html_php", LocationType.IN_UNDEFINED, "__html_sp", LocationType.IN_UNDEFINED, "__html_doctype", LocationType.IN_DOCTYPE, "__html_script", LocationType.IN_OPEN_TAG, "__html_style", LocationType.IN_OPEN_TAG, "__html_tag", LocationType.IN_OPEN_TAG, "__html_tag_close", LocationType.IN_CLOSE_TAG, "__js__dftl_partition_content_type", LocationType.IN_SCRIPT, "__css___dftl_partition_content_type", LocationType.IN_STYLE, "__dftl_partition_content_type", LocationType.IN_TEXT});
    private static final Map<String, String> DOCTYPES = CollectionsUtil.newMap((Object[])new String[]{"HTML 5", "HTML", "HTML 4.01 Strict", "HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\n\"http://www.w3.org/TR/html4/strict.dtd\"", "HTML 4.01 Transitional", "HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n\"http://www.w3.org/TR/html4/loose.dtd\"", "HTML 4.01 Transitional (Quirks)", "HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"", "HTML 4.01 Frameset", "HTML PUBLIC \"-//W3C//DTD HTML 4.01 Frameset//EN\"\n\"http://www.w3.org/TR/html4/frameset.dtd\"", "XHTML 1.1", "html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\" \"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd\"", "XHTML 1.0 Strict", "html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\"", "XHTML 1.0 Transitional", "html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"", "XHTML 1.0 Frameset", "html PUBLIC \"-//W3C//DTD XHTML 1.0 Frameset//EN\"\n\"http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd\"", "HTML 3.2", "HTML PUBLIC \"-//W3C//DTD HTML 3.2 Final//EN\"", "HTML 2.0", "HTML PUBLIC \"-//IETF//DTD HTML//EN\""});
    private HTMLIndexQueryHelper _queryHelper;
    private IContextInformationValidator _validator;
    private Lexeme<HTMLTokenType> _currentLexeme;
    private IRange _replaceRange;
    private IDocument _document;
    private JSContentAssistProcessor fJSProcessor;
    private CSSContentAssistProcessor fCSSProcessor;
    private IFile iFile;
    private IProject project;
    private LocationType fineLocation = null;
    private boolean showSnippetProposals = false;
    private boolean autoSnippet = true;
    private boolean isTMEditor = false;
    private LocationType newLocationType;
    private IRange _activeRange;
    private IRange _lexemeRange;
    private int dynamicPage = -1;

    public boolean isAutoActivated() {
        return this.autoActivated;
    }

    public void setAutoActivated(boolean autoActivated) {
        this.autoActivated = autoActivated;
    }

    public HTMLContentAssistProcessor(AbstractThemeableEditor editor) {
        super(editor);
        IEditorInput editorInput;
        if (editor != null && (editorInput = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            this.iFile = fileEditorInput.getFile();
            this.project = this.iFile.getProject();
        }
        this._queryHelper = new HTMLIndexQueryHelper();
    }

    protected List<ICompletionProposal> addAttributeAndEventProposals(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String elementName = this.getElementName(lexemeProvider, offset);
        ElementElement element = this._queryHelper.getElement(elementName);
        Point selection = null;
        if (element != null) {
            int[] positions;
            String replaceString;
            String name;
            Map userAgentIcons;
            String postfix = "=\"\"";
            switch ((HTMLTokenType)((Object)this._currentLexeme.getType())) {
                case EQUAL: {
                    int index = lexemeProvider.getLexemeFloorIndex(offset);
                    if (index <= 0) break;
                    this._currentLexeme = lexemeProvider.getLexeme(index - 1);
                    this._replaceRange = this._currentLexeme;
                    postfix = "";
                    Lexeme next = lexemeProvider.getNextLexeme(offset);
                    selection = this.getSelectionPoint((Lexeme<HTMLTokenType>)next);
                    break;
                }
                case INLINE_TAG: 
                case TAG_END: 
                case TAG_SELF_CLOSE: {
                    this._replaceRange = null;
                    break;
                }
                default: {
                    int index = lexemeProvider.getLexemeFloorIndex(offset);
                    Lexeme nextlexeme = lexemeProvider.getLexeme(++index);
                    if (nextlexeme == null || nextlexeme.getType() != HTMLTokenType.EQUAL || (nextlexeme = lexemeProvider.getLexeme(++index)) == null) break;
                    postfix = "";
                    selection = this.getSelectionPoint((Lexeme<HTMLTokenType>)nextlexeme);
                }
            }
            int replaceLength = 0;
            if (this._replaceRange != null) {
                offset = this._replaceRange.getStartingOffset();
                replaceLength = this._replaceRange.getLength();
            }
            if (IdeLog.isTraceEnabled((Plugin)HTMLPlugin.getDefault(), (String)"com.aptana.editor.html/debug/content_assist")) {
                IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Current element: {0}, Current lexeme: {1}, Replace offset: {2}. Replace length: {3}", elementName, this._currentLexeme, offset, replaceLength), (String)"com.aptana.editor.html/debug/content_assist");
            }
            for (AttributeElement attribute : this._queryHelper.getAttributes(element)) {
                userAgentIcons = UserAgentManager.getInstance().getUserAgentPath(this.getProject(), attribute.getUserAgentsNameWithVersion());
                name = attribute.getName();
                replaceString = String.valueOf(name) + postfix;
                positions = postfix.length() == 0 ? new int[]{replaceString.length()} : new int[]{replaceString.length() - 1, replaceString.length()};
                boolean isApplyNeedReContentAssist = this.checkNeedReContentAssist(attribute.getName());
                HTMLAttributeProposal p = new HTMLAttributeProposal(attribute, String.valueOf(name) + postfix, userAgentIcons, offset, replaceLength, positions);
                this.setProposalShowInfo(attribute, p);
                p.setApplyNeedReContentAssist(isApplyNeedReContentAssist);
                p.setCompletionProposalType(CompletionProposalType.ATTRIBUTE);
                if (selection != null) {
                    p.setSelection(selection);
                }
                proposals.add((ICompletionProposal)p);
            }
            for (EventElement event : this._queryHelper.getEvents(element)) {
                userAgentIcons = UserAgentManager.getInstance().getUserAgentPath(this.getProject(), event.getUserAgentsNameWithVersion());
                name = event.getName();
                replaceString = String.valueOf(name) + postfix;
                positions = postfix.length() == 0 ? new int[]{replaceString.length()} : new int[]{replaceString.length() - 1, replaceString.length()};
                HTMLEventProposal p = new HTMLEventProposal(event, String.valueOf(name) + postfix, userAgentIcons, offset, replaceLength, positions);
                this.setProposalShowInfo(event, p);
                p.setCompletionProposalType(CompletionProposalType.ATTRIBUTE);
                proposals.add((ICompletionProposal)p);
            }
        } else {
            IdeLog.logInfo((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Current element: {0}, Current lexeme: {1}", elementName, this._currentLexeme), (String)"com.aptana.editor.html/debug/content_assist");
        }
        return proposals;
    }

    private Point getSelectionPoint(Lexeme<HTMLTokenType> next) {
        String result = next.getText();
        Point selection = null;
        if (StringUtil.isNotBlank((String)result)) {
            int startOffset = next.getStartingOffset();
            int length = next.getLength();
            if (result.startsWith("\"") || result.startsWith("'")) {
                ++startOffset;
                --length;
            } else {
                return null;
            }
            if (result.length() > 1 && (result.endsWith("\"") || result.endsWith("'"))) {
                --length;
            }
            selection = new Point(startOffset, length);
        }
        return selection;
    }

    private boolean checkNeedReContentAssist(String dispalyName) {
        return true;
    }

    private boolean checkNeedReContentAssist(String attributeName, char activationChar) {
        if (!this.isAutoActivated()) {
            return true;
        }
        String activeChar = String.valueOf(activationChar);
        String[] chars = new String[]{"\"", "'", " "};
        return this.checkNeedReContentAssist(attributeName) || !StringUtil.contains((String[])chars, (String)activeChar);
    }

    private List<ICompletionProposal> addAttributeValueProposals(int offset, String elementName, String attributeName, AttributeElement attribute) {
        final IRange range = this.getIRange(offset);
        if (attribute == null) {
            attribute = this._queryHelper.getAttribute(elementName, attributeName);
        }
        if (!this.isTMEditor() && elementName.equals("meta") && attributeName.equals("content")) {
            try {
                ITypedRegion region = this._document.getPartition(offset);
                String pString = this._document.get(region.getOffset(), region.getLength());
                String REG = "http-equiv[\\s]*=[\\s]*[\"']([&\\=\\?\\s\\.:/_a-zA-Z0-9\u4e00-\u9fa5-\\\\]*)[\"']";
                String httpEquivValue = RegularUtils.match((String)REG, (String)pString, (int)1);
                if (StringUtil.isBlank((String)httpEquivValue)) {
                    return Collections.emptyList();
                }
                if (!httpEquivValue.equals("content-type")) {
                    boolean isExist = HTMLMetaContentValue.METACONTENT.containsKey(httpEquivValue);
                    if (isExist) {
                        return Collections.emptyList();
                    }
                    return Collections.emptyList();
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        if (attribute != null) {
            final boolean isContainNumber = HTMLContentAssistProcessor.checkTypesContainsNumber(attribute.getTypes());
            return CollectionsUtil.map(attribute.getValues(), (IMap)new IMap<ValueElement, ICompletionProposal>(){

                public ICompletionProposal map(ValueElement value) {
                    Map uAgents = UserAgentManager.getInstance().getUserAgentPath(HTMLContentAssistProcessor.this.getProject(), value.getUserAgentsNameWithVersion());
                    HTMLAttributeValueProposal htmlAttributeValueProposal = new HTMLAttributeValueProposal(value, range, uAgents);
                    if (isContainNumber) {
                        htmlAttributeValueProposal.setCompletionProposalType(CompletionProposalType.NUMBER);
                    } else {
                        htmlAttributeValueProposal.setCompletionProposalType(CompletionProposalType.DEFALUT);
                    }
                    htmlAttributeValueProposal.setIsHTML(true);
                    return htmlAttributeValueProposal;
                }
            });
        }
        return Collections.emptyList();
    }

    private List<ICompletionProposal> addAttributeValueProposals(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset, char activationChar) {
        boolean isApplyNeedReContentAssist;
        String attributeName = this.getAttributeName(lexemeProvider, offset);
        String elementName = this.getElementName(lexemeProvider, offset);
        AttributeElement attributeElement = this._queryHelper.getAttribute(elementName, attributeName);
        List<String> types = null;
        if (attributeElement != null) {
            types = attributeElement.getTypes();
        }
        if (!(isApplyNeedReContentAssist = this.checkNeedReContentAssist(attributeName, activationChar))) {
            return Collections.emptyList();
        }
        if (attributeName != null && attributeName.length() > 0) {
            switch ((HTMLTokenType)((Object)this._currentLexeme.getType())) {
                case DOUBLE_QUOTED_STRING: 
                case SINGLE_QUOTED_STRING: {
                    if (this._currentLexeme.getLength() < 2) break;
                    Range range = null;
                    if (ID.equals(attributeName) || CLASS.equals(attributeName)) {
                        range = HTMLUtils.getAttributeValueRange(this._currentLexeme, offset);
                    }
                    if (range == null) {
                        int startingOffset = this._currentLexeme.getStartingOffset() + 1;
                        int endingOffset = this._currentLexeme.getEndingOffset() - 1;
                        range = new Range(startingOffset, endingOffset);
                    }
                    this._replaceRange = range;
                    break;
                }
                case EQUAL: {
                    this._replaceRange = new Range(offset, offset - 1);
                    break;
                }
                case TAG_END: 
                case TAG_SELF_CLOSE: {
                    this._replaceRange = new Range(offset, offset - 1);
                    break;
                }
                default: {
                    if (this._currentLexeme.getText().equals(attributeName)) break;
                    int startingOffset = this._currentLexeme.getStartingOffset();
                    int endingOffset = this._currentLexeme.getEndingOffset();
                    this._replaceRange = new Range(startingOffset, endingOffset);
                }
            }
            ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
            if (types != null && !types.isEmpty()) {
                HashSet result = new HashSet();
                for (String type : types) {
                    ISpecialListHandler handler = (ISpecialListHandler)SPEC_MAPS.get(type);
                    if (handler == null) continue;
                    if (handler instanceof ISpecialValueListLocationType) {
                        ((ISpecialValueListLocationType)handler).setLocationType(SpecialValueLocationType.IN_HTML);
                    }
                    IRange replaceRange = this.getIRange(offset);
                    if (StringUtil.contains((String[])SPEC_NUMBER_STRING, (String)type)) {
                        HashSet numResult = new HashSet();
                        handler.doComputeSpecialProposals(this.editor, offset, replaceRange, numResult, true);
                        if (numResult == null || numResult.isEmpty()) continue;
                        for (ICompletionProposal iCompletionProposal : numResult) {
                            if (!(iCompletionProposal instanceof CommonCompletionProposal)) continue;
                            CommonCompletionProposal commonCompletionProposal = (CommonCompletionProposal)iCompletionProposal;
                            commonCompletionProposal.setCompletionProposalType(CompletionProposalType.NUMBER);
                        }
                        result.addAll(numResult);
                        continue;
                    }
                    handler.doComputeSpecialProposals(this.editor, offset, replaceRange, result, true);
                }
                if (!result.isEmpty()) {
                    proposals.addAll(result);
                }
            }
            proposals.addAll(this.addAttributeValueProposals(offset, elementName, attributeName, attributeElement));
            return proposals;
        }
        return Collections.emptyList();
    }

    private boolean isHTML(String valuePrefix) {
        boolean isHtml = false;
        if (StringUtil.isNotBlank((String)valuePrefix)) {
            valuePrefix = valuePrefix.toLowerCase();
            String[] stringArray = HTML_EXTENDTIONS;
            int n = HTML_EXTENDTIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (valuePrefix.endsWith("." + key)) {
                    isHtml = true;
                    break;
                }
                ++n2;
            }
        }
        return isHtml;
    }

    private boolean isJS(String valuePrefix) {
        boolean isjs = false;
        if (StringUtil.isNotBlank((String)valuePrefix)) {
            valuePrefix = valuePrefix.toLowerCase();
            String[] stringArray = this._queryHelper.getJSUriExtendValueList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (valuePrefix.endsWith("." + key.toLowerCase())) {
                    isjs = true;
                    break;
                }
                ++n2;
            }
        }
        return isjs;
    }

    private boolean isCSSExtend(String valuePrefix) {
        boolean isCSS = false;
        if (StringUtil.isNotBlank((String)valuePrefix)) {
            valuePrefix = valuePrefix.toLowerCase();
            String[] stringArray = this._queryHelper.getCSSUriExtendValueList();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String key = stringArray[n2];
                if (valuePrefix.endsWith("." + key)) {
                    isCSS = true;
                    break;
                }
                ++n2;
            }
        }
        return isCSS;
    }

    private boolean checkCommonTag(int offset) {
        String pInfo = this.getPInfo(offset);
        boolean isCSS = this.isCSS(pInfo);
        boolean isImg = this.isImg(pInfo);
        boolean isJS = this.isScript(pInfo);
        boolean check = !isCSS && !isImg && !isJS;
        return check;
    }

    private boolean isImg(String pInfo) {
        boolean isImg = false;
        String[] stringArray = HTML_IMG_TAG;
        int n = HTML_IMG_TAG.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (pInfo.startsWith(tag)) {
                isImg = true;
                break;
            }
            ++n2;
        }
        return isImg;
    }

    private boolean isScript(String pInfo) {
        boolean isScript = false;
        String[] stringArray = HTML_SCRIPTTAG_ATTRIBUTE;
        int n = HTML_SCRIPTTAG_ATTRIBUTE.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (pInfo.startsWith(tag)) {
                isScript = true;
                break;
            }
            ++n2;
        }
        return isScript;
    }

    private IRange getIRange(int offset) {
        IRange range = this._replaceRange != null ? this._replaceRange : new Range(offset, offset - 1);
        return range;
    }

    protected List<ICompletionProposal> addClassProposals(int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Map<String, Set<String>> classes = this._queryHelper.getClassList(this.getIndex());
        List<String> list = this.getCSSFileRefrences(this.iFile);
        if (classes != null) {
            for (Map.Entry<String, Set<String>> entry : classes.entrySet()) {
                boolean hasCheck = this.checkLocation(list, entry.getValue());
                if (!hasCheck) {
                    this.addProposalWithOutUserAgent(proposals, entry.getKey(), ATTRIBUTE_ICON, null, "", offset, CompletionProposalType.CLASS, 50);
                    continue;
                }
                this.addProposalWithOutUserAgent(proposals, entry.getKey(), ATTRIBUTE_ICON, null, "", offset, CompletionProposalType.CLASS, 90);
            }
        }
        return proposals;
    }

    protected List<ICompletionProposal> addURIPathProposals(int offset, String attributeName) {
        boolean isRelative = false;
        try {
            String valuePrefix = this._currentLexeme.getText();
            int length = offset - this._currentLexeme.getStartingOffset();
            valuePrefix = valuePrefix.substring(0, length);
            if (valuePrefix.length() > 0 && (valuePrefix.charAt(0) == '\"' || valuePrefix.charAt(0) == '\'')) {
                valuePrefix = valuePrefix.substring(1);
                offset = this._currentLexeme.getStartingOffset() + 1;
            }
            URI editorStoreURI = this.getURI();
            IFileStore editorStore = null;
            if (editorStoreURI != null) {
                editorStore = EFS.getStore((URI)editorStoreURI);
            }
            IFileStore baseStore = null;
            if (valuePrefix.length() > 0 && valuePrefix.charAt(0) == '/') {
                URI projectUri = this.getProjectAppSourceURI();
                if (projectUri != null) {
                    baseStore = EFS.getStore((URI)projectUri);
                    IServer serverConfiguration = null;
                    if (serverConfiguration == null) {
                        for (IServer server : WebServerCorePlugin.getDefault().getServerManager().getServers()) {
                            if (server.resolve(editorStore) == null) continue;
                            serverConfiguration = server;
                            break;
                        }
                    }
                    if (serverConfiguration != null) {
                        URI documentRoot = serverConfiguration.getDocumentRoot();
                        if (documentRoot != null) {
                            baseStore = EFS.getStore((URI)documentRoot);
                        }
                    } else {
                        IFileStore publicDir = baseStore.getChild("public");
                        if (publicDir.fetchInfo().exists()) {
                            baseStore = publicDir;
                        }
                    }
                }
            } else if (valuePrefix.contains(":/")) {
                if (valuePrefix.endsWith(":/")) {
                    return Collections.emptyList();
                }
                if ("file://".equals(valuePrefix)) {
                    baseStore = EFS.getLocalFileSystem().getStore((IPath)Path.ROOT);
                    offset += valuePrefix.length();
                    valuePrefix = "";
                } else {
                    try {
                        URI parsed = null;
                        int lastSlash = valuePrefix.lastIndexOf(47);
                        if (lastSlash != -1 && lastSlash < valuePrefix.length() - 1) {
                            parsed = URI.create(valuePrefix.substring(0, lastSlash));
                            offset += lastSlash + 1;
                            valuePrefix = valuePrefix.substring(lastSlash + 1);
                        } else {
                            parsed = URI.create(valuePrefix);
                            offset += valuePrefix.length();
                            valuePrefix = "";
                        }
                        baseStore = EFS.getStore((URI)parsed);
                    }
                    catch (Exception exception) {
                        return Collections.emptyList();
                    }
                }
            } else if (valuePrefix.startsWith("../")) {
                if (this.iFile != null) {
                    String path = URIUtils.resolveURI((String)this.iFile.getLocationURI().toString(), (String)valuePrefix);
                    baseStore = EFS.getStore((URI)URI.create(path));
                    isRelative = true;
                }
            } else {
                boolean check = this.checkCommonTag(offset);
                boolean isHtml = this.isHTML(valuePrefix);
                if (StringUtil.contains((String[])HTML_FOLDER_ATTRIBUTE, (String)attributeName) && check && !isHtml) {
                    if (editorStore != null) {
                        baseStore = editorStore.getParent();
                    }
                } else {
                    baseStore = null;
                }
            }
            if (baseStore == null || !this.efsFileSystemCanGrabChildren(baseStore.toURI().getScheme())) {
                return Collections.emptyList();
            }
            boolean hitRemote = Platform.getPreferencesService().getBoolean("com.aptana.editor.html", "HTML_REMOTE_HREF_PROPOSALS", true, null);
            if (!hitRemote && this.isRemoteURI(baseStore)) {
                return Collections.emptyList();
            }
            int lastSlash = valuePrefix.lastIndexOf(47);
            if (lastSlash != -1) {
                if (!isRelative) {
                    IFileStore possibleChild = baseStore.getChild(valuePrefix.substring(0, lastSlash));
                    if (possibleChild.fetchInfo().exists()) {
                        baseStore = possibleChild;
                    } else {
                        return Collections.emptyList();
                    }
                }
                offset += lastSlash + 1;
                valuePrefix = valuePrefix.substring(lastSlash + 1);
            }
            this._replaceRange = new Range(offset, this._currentLexeme.getEndingOffset() - 1);
            return this.suggestChildrenOfFileStore(offset, valuePrefix, editorStoreURI, baseStore, attributeName);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private URI getProjectAppSourceURI() {
        URI projectUri = this.getProjectURI();
        if (projectUri != null) {
            String wpath = projectUri.toString();
            try {
                projectUri = new URI(wpath);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return projectUri;
    }

    private String getPInfo(int offset) {
        String pInfo = null;
        try {
            ITypedRegion partition = this._document.getPartition(offset);
            pInfo = this._document.get(partition.getOffset(), partition.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return pInfo;
    }

    private boolean isCSS(String pInfo) {
        boolean isCSS = false;
        String[] stringArray = HTML_CSSTAG_ATTRIBUTE;
        int n = HTML_CSSTAG_ATTRIBUTE.length;
        int n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            if (pInfo.startsWith(tag)) {
                isCSS = true;
                break;
            }
            ++n2;
        }
        return isCSS;
    }

    protected List<ICompletionProposal> suggestChildrenOfFileStore(int offset, String valuePrefix, URI editorStoreURI, IFileStore parent, String attributeName) throws CoreException {
        IFileStore[] children = parent.childStores(0, (IProgressMonitor)new NullProgressMonitor());
        if (children == null || children.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String pInfo = this.getPInfo(offset);
        boolean isCSS = this.isCSS(pInfo);
        boolean isImg = this.isImg(pInfo);
        boolean isJS = this.isScript(pInfo);
        IRange range = this.getIRange(offset);
        IFileStore[] iFileStoreArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IFileStore f = iFileStoreArray[n2];
            String name = f.getName();
            if (name.charAt(0) != '.' && !f.toURI().equals(editorStoreURI)) {
                String projectName;
                String parentName = f.getParent().getName();
                String string = projectName = this.project == null ? "" : this.project.getName();
                if (!(parentName.equals(projectName) && HMobileProject.isFilterFile((String)name) || valuePrefix != null && valuePrefix.length() > 0 && !name.startsWith(valuePrefix) && !valuePrefix.endsWith("url=") || name.equals(valuePrefix))) {
                    String extend = this.getExtention(name);
                    String[] cssExtends = this._queryHelper.getJSUriExtendValueList();
                    if (!(StringUtil.isNotBlank((String)extend) && StringUtil.contains((String[])HTML_LOCAL_FILE_ATTRIBUTE, (String)attributeName) && (StringUtil.contains((String[])cssExtends, (String)extend.toLowerCase()) || StringUtil.contains((String[])this._queryHelper.getCSSUriExtendValueList(), (String)extend.toLowerCase()) || StringUtil.contains((String[])this._queryHelper.getImageExtendValueList(), (String)extend.toLowerCase())) || StringUtil.isNotBlank((String)extend) && (isCSS && !StringUtil.contains((String[])this._queryHelper.getCSSUriExtendValueList(), (String)extend.toLowerCase()) || isImg && !StringUtil.contains((String[])this._queryHelper.getImageExtendValueList(), (String)extend.toLowerCase()) || isJS && !StringUtil.contains((String[])cssExtends, (String)extend.toLowerCase())))) {
                        ValueElement value = this.createValueElement(name);
                        HTMLAttributeValueProposal proposal = new HTMLAttributeValueProposal(value, range, null);
                        File file = new File(f.toURI());
                        proposal.setFileInfo(file, true);
                        if (StringUtil.isNotBlank((String)extend) && StringUtil.contains((String[])this._queryHelper.getImageExtendValueList(), (String)extend.toLowerCase()) && file.exists()) {
                            proposal.setShowImage(true);
                            proposal.setShowImagePath(file.getPath());
                        }
                        if (file.isDirectory() || StringUtil.contains((String[])HTML_EXTENDTIONS, (String)extend)) {
                            proposal.setApplyNeedReContentAssist(true);
                        }
                        if (file.isFile()) {
                            proposal.setCompletionProposalType(CompletionProposalType.FILE);
                            proposal = this.setImageIcon(proposal, extend);
                        } else {
                            proposal.setCompletionProposalType(CompletionProposalType.FOLDER);
                            proposal.setImage(FOLDER_ICON);
                        }
                        proposal.setIsHTML(true);
                        proposals.add((ICompletionProposal)proposal);
                    }
                }
            }
            ++n2;
        }
        return proposals;
    }

    private HTMLAttributeValueProposal setImageIcon(HTMLAttributeValueProposal proposal, String extend) {
        if (StringUtil.isNotBlank((String)(extend = extend.toLowerCase()))) {
            if (StringUtil.contains((String[])this._queryHelper.getCSSUriExtendValueList(), (String)extend)) {
                proposal.setImage(CSS_ICON);
            } else if (StringUtil.contains((String[])this._queryHelper.getJSUriExtendValueList(), (String)extend)) {
                proposal.setImage(JS_ICON);
            } else if (StringUtil.contains((String[])HTML_EXTENDTIONS, (String)extend)) {
                proposal.setImage(HTML_ICON);
            } else if (StringUtil.contains((String[])this._queryHelper.getImageExtendValueList(), (String)extend)) {
                proposal.setImage(IMG_ICON);
            } else if (StringUtil.contains((String[])ZIP_EXTENDTIONS, (String)extend)) {
                proposal.setImage(ZIP_ICON);
            } else if (StringUtil.contains((String[])XML_EXTENDTIONS, (String)extend)) {
                proposal.setImage(XML_ICON);
            } else if (StringUtil.contains((String[])XSL_EXTENDTIONS, (String)extend)) {
                proposal.setImage(XSL_ICON);
            } else if (StringUtil.contains((String[])JSON_EXTENDTIONS, (String)extend)) {
                proposal.setImage(JSON_ICON);
            } else {
                proposal.setImage(TEXT_ICON);
            }
        } else {
            proposal.setImage(TEXT_ICON);
        }
        return proposal;
    }

    private ValueElement createValueElement(String name) {
        ValueElement value = new ValueElement();
        value.setName(name);
        return value;
    }

    private String getExtention(String name) {
        if (StringUtil.isNotBlank((String)name) && name.lastIndexOf(".") > -1) {
            int index = name.lastIndexOf(".") + 1;
            return name.substring(index);
        }
        return null;
    }

    private boolean isRemoteURI(IFileStore baseStore) {
        try {
            return baseStore.toLocalFile(0, (IProgressMonitor)new NullProgressMonitor()) == null;
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return true;
        }
    }

    protected boolean efsFileSystemCanGrabChildren(String scheme) {
        if (scheme == null) {
            return false;
        }
        return !"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme);
    }

    protected List<ICompletionProposal> addElementProposals(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        List<ElementElement> elementList = this._queryHelper.getElements();
        HashSet<ElementElement> elements = new HashSet<ElementElement>();
        elements.addAll(elementList);
        if (elements != null) {
            Lexeme nextLexeme;
            Lexeme previousLexeme;
            int index;
            boolean close = true;
            int replaceLength = 0;
            int replaceOffset = offset;
            if (this._currentLexeme.getType() == HTMLTokenType.META) {
                replaceOffset = this._currentLexeme.getStartingOffset();
                replaceLength = this._currentLexeme.getLength();
                index = lexemeProvider.getLexemeIndex(this._currentLexeme.getStartingOffset());
                previousLexeme = lexemeProvider.getLexeme(index - 1);
                if (previousLexeme.getText().equals(DOCTYPE_PRECEDING_TEXT)) {
                    replaceOffset = previousLexeme.getStartingOffset();
                    replaceLength = this._currentLexeme.getEndingOffset() - replaceOffset + 1;
                }
            } else if (this._currentLexeme.getType() == HTMLTokenType.TEXT && this._currentLexeme.getText().equals(DOCTYPE_PRECEDING_TEXT)) {
                replaceOffset = this._currentLexeme.getStartingOffset();
                replaceLength = this._currentLexeme.getLength();
                index = lexemeProvider.getLexemeIndex(this._currentLexeme.getStartingOffset());
                nextLexeme = lexemeProvider.getLexeme(index + 1);
                if (nextLexeme != null && nextLexeme.getType() == HTMLTokenType.TAG_END) {
                    replaceLength = nextLexeme.getEndingOffset() - replaceOffset;
                }
            } else if (this._currentLexeme.getType() == HTMLTokenType.TAG_END) {
                replaceLength = 1;
                index = lexemeProvider.getLexemeIndex(this._currentLexeme.getStartingOffset());
                previousLexeme = lexemeProvider.getLexeme(index - 1);
                if (previousLexeme.getText().equals(DOCTYPE_PRECEDING_TEXT)) {
                    replaceOffset = previousLexeme.getStartingOffset();
                    replaceLength += previousLexeme.getLength();
                }
            } else if (this._currentLexeme.getType() != HTMLTokenType.TAG_START) {
                index = lexemeProvider.getLexemeCeilingIndex(this._currentLexeme.getEndingOffset() + 1);
                if (index == -1 || index >= lexemeProvider.size()) {
                    index = lexemeProvider.size() - 1;
                }
                if ((nextLexeme = lexemeProvider.getLexeme(index)) != null) {
                    replaceOffset = this._currentLexeme.getStartingOffset();
                    replaceLength = this._currentLexeme.getLength();
                    if (!nextLexeme.equals(this._currentLexeme)) {
                        if (nextLexeme.getType() == HTMLTokenType.TAG_END) {
                            replaceLength += nextLexeme.getEndingOffset() - this._currentLexeme.getEndingOffset();
                        } else if (nextLexeme.getType() != HTMLTokenType.TAG_START) {
                            close = false;
                        }
                    }
                }
            }
            boolean addCloseTag = HTMLPlugin.getDefault().getPreferenceStore().getBoolean("HTML_AUTO_CLOSE_TAG_PAIRS");
            boolean isClosed = false;
            try {
                String reString = "";
                if (!this.isTMEditor()) {
                    ITypedRegion region = this._document.getPartition(offset);
                    reString = this._document.get(region.getOffset(), region.getLength());
                } else if (this.getActiveRange() != null) {
                    reString = this._document.get(this.getActiveRange().getStartingOffset(), this.getActiveRange().getLength());
                    int c = (reString = reString.trim()).lastIndexOf("<");
                    if (c != 0) {
                        reString = "";
                    }
                    if ((c = reString.indexOf(">")) != reString.length() - 1) {
                        reString = "";
                    }
                }
                if (StringUtil.isNotBlank((String)reString)) {
                    if (reString.endsWith(">")) {
                        isClosed = true;
                    } else {
                        replaceLength = 0;
                    }
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            for (ElementElement element : elements) {
                StringBuilder replacement = new StringBuilder(element.getName());
                ArrayList<Integer> positions = new ArrayList<Integer>();
                int cursorPosition = replacement.length();
                if (close) {
                    if (element.getName().charAt(0) == '!') {
                        ++cursorPosition;
                        int index2 = lexemeProvider.getLexemeIndex(this._currentLexeme.getStartingOffset());
                        Lexeme nextLexeme2 = lexemeProvider.getLexeme(index2 + 1);
                        if (nextLexeme2 == null || nextLexeme2.getType() == HTMLTokenType.TAG_START) {
                            replacement.append(" >");
                        }
                    } else if (HTMLParseState.isEmptyTagType(element.getName())) {
                        if (!isClosed) {
                            replacement.append(" />");
                            positions.add(cursorPosition + 3);
                        }
                    } else if (!this.isTMEditor() || !isClosed) {
                        if (addCloseTag) {
                            replacement.append("></").append(element.getName()).append('>');
                            positions.add(cursorPosition + 1);
                            positions.add(cursorPosition + 4 + element.getName().length());
                        } else {
                            replacement.append('>');
                            positions.add(cursorPosition + 1);
                        }
                    }
                }
                positions.add(0, cursorPosition);
                HTMLTagProposal proposal = new HTMLTagProposal(replacement.toString(), replaceOffset, replaceLength, element, this.getProject(), positions.toArray(new Integer[positions.size()]));
                this.setProposalShowInfo(element, proposal);
                proposal.setCompletionProposalType(CompletionProposalType.ELEMENT);
                proposal.setCurrentElementName(this._currentLexeme.getText());
                proposals.add((ICompletionProposal)proposal);
            }
            StringBuilder scriptReplacement = new StringBuilder("");
            scriptReplacement.append("script type=").append('\"').append("text/javascript").append('\"').append(" src=").append('\"');
            StringBuilder linkReplacement = new StringBuilder("");
            linkReplacement.append("link rel=").append('\"').append("stylesheet").append('\"').append(" href=").append('\"');
            String scriptSrcName = SCRIPT_SRC__LEAD;
            String linkHrefName = LINK_HREF_LEAD;
            proposals.addAll(this.addScpiptAndLinkProposals(lexemeProvider, offset, scriptSrcName, linkHrefName, scriptReplacement, linkReplacement));
        }
        return proposals;
    }

    private List<ICompletionProposal> addScpiptAndLinkProposals(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset, String scriptSrcName, String linkHrefName, StringBuilder scriptReplacement, StringBuilder linkReplacement) {
        try {
            return this.suggestScriptAndLinkChildrenOfFileStore(lexemeProvider, offset, scriptSrcName, linkHrefName, scriptReplacement, linkReplacement);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)HTMLPlugin.getDefault(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<ICompletionProposal> suggestScriptAndLinkChildrenOfFileStore(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset, String scriptSrcName, String linkHrefName, StringBuilder scriptReplacement, StringBuilder linkReplacement) throws CoreException {
        int replaceLength = 0;
        int replaceOffset = offset;
        if (this._currentLexeme.getType() != HTMLTokenType.TAG_START) {
            Lexeme nextLexeme;
            int index = lexemeProvider.getLexemeCeilingIndex(this._currentLexeme.getEndingOffset() + 1);
            if (index == -1 || index >= lexemeProvider.size()) {
                index = lexemeProvider.size() - 1;
            }
            if ((nextLexeme = lexemeProvider.getLexeme(index)) != null) {
                replaceOffset = this._currentLexeme.getStartingOffset();
                replaceLength = this._currentLexeme.getLength();
                if (!nextLexeme.equals(this._currentLexeme) && nextLexeme.getType() == HTMLTokenType.TAG_END) {
                    replaceLength += nextLexeme.getEndingOffset() - this._currentLexeme.getEndingOffset();
                }
            }
        }
        return this.getChildCompletionProposal(scriptReplacement, linkReplacement, scriptSrcName, linkHrefName, replaceOffset, replaceLength);
    }

    private String getRelativePath(IFileStore parent, URI editorStoreURI) {
        URI parentUri = parent.toURI();
        String parentPath = parentUri.getPath();
        String editorPath = editorStoreURI.getPath();
        parentPath.replace("\\", "/");
        editorPath.replace("\\", "/");
        char dilimiter = '/';
        int parentCount = StringUtil.characterInstanceCount((String)parentPath, (char)dilimiter);
        int editorCount = StringUtil.characterInstanceCount((String)editorPath, (char)dilimiter);
        StringBuilder relativePath = new StringBuilder();
        int relativeCount = editorCount - (parentCount + 1);
        int i = 0;
        while (i < relativeCount) {
            relativePath.append("../");
            ++i;
        }
        return relativePath.toString();
    }

    private List<ICompletionProposal> getChildCompletionProposal(StringBuilder scriptReplacement, StringBuilder linkReplacement, String scriptSrcName, String linkHrefName, int replaceOffset, int replaceLength) throws CoreException {
        if (this.project == null) {
            return Collections.emptyList();
        }
        CollectingResourceVisitor visitor = new CollectingResourceVisitor(scriptReplacement, linkReplacement, scriptSrcName, linkHrefName, replaceOffset, replaceLength);
        this.project.accept((IResourceVisitor)visitor);
        if (visitor.proposals == null || visitor.proposals.size() < 1) {
            return Collections.emptyList();
        }
        return visitor.proposals;
    }

    private void addEntityProposals(List<ICompletionProposal> proposals, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        this.setEntityRange(offset);
        if (this._replaceRange == null) {
            return;
        }
        String text = null;
        int startingOffset = this._replaceRange.getStartingOffset();
        int length = this._replaceRange.getLength();
        try {
            text = this._document.get(startingOffset, length);
        }
        catch (BadLocationException e) {
            IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format(Messages.HTMLContentAssistProcessor_ErrorFetchingText, startingOffset, length), (Throwable)e, (String)"com.aptana.editor.html/debug/content_assist");
        }
        if (text == null || text.charAt(0) != '&') {
            return;
        }
        List<EntityElement> entities = this._queryHelper.getEntities();
        if (entities != null) {
            for (EntityElement entity : entities) {
                this.addProposalWithOutUserAgent(proposals, entity.getName(), ELEMENT_ICON, entity.getDescription(), "", offset, CompletionProposalType.DEFALUT, 90);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void addDoctypeProposals(List<ICompletionProposal> proposals, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        this._replaceRange = null;
        ptr = this._currentLexeme;
        if (ptr == null || ptr.getType() != HTMLTokenType.META || !ptr.contains(offset)) ** GOTO lbl9
        proposals.addAll(this.addElementProposals(lexemeProvider, offset));
        return;
lbl-1000:
        // 1 sources

        {
            index = lexemeProvider.getLexemeIndex(ptr.getStartingOffset());
            ptr = lexemeProvider.getLexeme(index + 1);
lbl9:
            // 2 sources

            ** while (ptr != null && ptr.getType() != HTMLTokenType.TAG_END)
        }
lbl10:
        // 1 sources

        if (ptr != null) {
            this._replaceRange = new Range(offset - 1, offset - 1);
        }
        for (Map.Entry<String, String> entry : HTMLContentAssistProcessor.DOCTYPES.entrySet()) {
            src = entry.getValue();
            try {
                if (offset > 0 && (charAtOffset = this._document.getChar(offset - 1)) == ' ') {
                    src = " " + src;
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            name = entry.getKey();
            proposal = this.createProposal(name, src, HTMLContentAssistProcessor.ELEMENT_ICON, MessageFormat.format("&lt;!DOCTYPE {0}&gt;", new Object[]{src}), UserAgentManager.getInstance().getAllUserAgentPathWithoutSDK(this.getProject()), "", offset);
            if (src.equalsIgnoreCase("HTML")) {
                proposal.setRelevance(50);
            }
            proposal.setCompletionProposalType(CompletionProposalType.DEFALUT);
            proposals.add((ICompletionProposal)proposal);
        }
    }

    protected List<ICompletionProposal> addIDProposals(int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        Map<String, Set<String>> ids = this._queryHelper.getIDList(this.getIndex());
        List<String> list = this.getCSSFileRefrences(this.iFile);
        if (ids != null) {
            for (Map.Entry<String, Set<String>> entry : ids.entrySet()) {
                boolean hasCheck = this.checkLocation(list, entry.getValue());
                if (!hasCheck) {
                    this.addProposalWithOutUserAgent(proposals, entry.getKey(), ATTRIBUTE_ICON, null, "", offset, CompletionProposalType.CLASS, 50);
                    continue;
                }
                this.addProposalWithOutUserAgent(proposals, entry.getKey(), ATTRIBUTE_ICON, null, "", offset, CompletionProposalType.ID, 90);
            }
        }
        return proposals;
    }

    private boolean checkLocation(List<String> list, Set<String> flocations) {
        boolean hasCheck = false;
        if (this.iFile == null) {
            return hasCheck;
        }
        for (String flocation : flocations) {
            if (!this.checkLocation(flocation, list, this.iFile)) continue;
            hasCheck = true;
        }
        return hasCheck;
    }

    private boolean checkLocation(String flocation, List<String> list, IFile file) {
        if (StringUtil.isBlank((String)flocation)) {
            return false;
        }
        String fPath = file.getProjectRelativePath().toString();
        return flocation.equals(fPath) || list.contains(flocation);
    }

    private List<String> getCSSFileRefrences(IFile file) {
        ArrayList<String> list = new ArrayList<String>();
        if (this.project == null || file == null) {
            return list;
        }
        Map<String, Set<String>> map = this._queryHelper.getCSSReferences(this.getIndex());
        if (map == null || map.isEmpty()) {
            return list;
        }
        Set<Map.Entry<String, Set<String>>> resourceEntrySet = map.entrySet();
        String fPath = file.getProjectRelativePath().toString();
        for (Map.Entry<String, Set<String>> entry : resourceEntrySet) {
            Set<String> set = entry.getValue();
            if (!set.contains(fPath)) continue;
            String path = entry.getKey();
            path = path.substring(this.project.getLocationURI().toString().length() + 1);
            list.add(path);
        }
        return list;
    }

    private void addOpenTagProposals(LocationType fineLocation, List<ICompletionProposal> proposals, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset, char activationChar) {
        switch (fineLocation) {
            case IN_ELEMENT_NAME: {
                proposals.addAll(this.addElementProposals(lexemeProvider, offset));
                break;
            }
            case IN_ATTRIBUTE_NAME: {
                proposals.addAll(this.addAttributeAndEventProposals(lexemeProvider, offset));
                break;
            }
            case IN_ATTRIBUTE_VALUE: {
                proposals.addAll(this.addAttributeValueProposals(lexemeProvider, offset, activationChar));
                break;
            }
        }
    }

    private boolean addUnclosedTagProposals(LocationType fineLocation, List<ICompletionProposal> proposals, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        boolean addedProposal = false;
        List<String> unclosedElements = HTMLTagUtil.getUnclosedTagName(this._document, offset);
        if (unclosedElements != null && !unclosedElements.isEmpty()) {
            int relevance = 89;
            for (String unclosedElement : unclosedElements) {
                ElementElement element = this._queryHelper.getElement(unclosedElement);
                if (element == null) continue;
                proposals.add((ICompletionProposal)this.createCloseTagProposal(element, lexemeProvider, offset, relevance));
                addedProposal = true;
                --relevance;
            }
        }
        return addedProposal;
    }

    private boolean addDefaultCloseTagProposals(LocationType fineLocation, List<ICompletionProposal> proposals, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        HTMLParseState state = null;
        boolean addedProposal = false;
        List<ElementElement> elements = this._queryHelper.getElements();
        if (elements != null) {
            for (ElementElement element : elements) {
                if (state == null) {
                    state = new HTMLParseState(this._document.get());
                }
                if (HTMLParseState.isEmptyTagType(element.getName())) continue;
                proposals.add((ICompletionProposal)this.createCloseTagProposal(element, lexemeProvider, offset, 90));
                addedProposal = true;
            }
        }
        return addedProposal;
    }

    private CommonCompletionProposal createCloseTagProposal(ElementElement element, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset, int relevance) {
        Map userAgentIcons = UserAgentManager.getInstance().getUserAgentPath(this.getProject(), element.getUserAgentsNameWithVersion());
        String replaceString = "/" + element.getName();
        Lexeme firstLexeme = lexemeProvider.getFirstLexeme();
        Lexeme tagLexeme = lexemeProvider.getLexeme(1);
        Lexeme closeLexeme = lexemeProvider.getLexeme(2);
        int replaceLength = 0;
        if (tagLexeme != null && tagLexeme.contains(offset)) {
            replaceLength += tagLexeme.getLength();
        }
        int replaceOffset = offset;
        if (offset > firstLexeme.getStartingOffset()) {
            replaceOffset = firstLexeme.getStartingOffset() + 1;
            if ("</".equals(firstLexeme.getText())) {
                ++replaceLength;
            }
            if (tagLexeme != null) {
                HTMLTagUtil.isTag((Lexeme<HTMLTokenType>)tagLexeme);
            }
            if (closeLexeme == null || !HTMLTokenType.TAG_END.equals(closeLexeme.getType())) {
                replaceString = String.valueOf(replaceString) + ">";
            }
        } else {
            int newOffset = offset - 1;
            int length = 1;
            try {
                replaceString = String.valueOf(replaceString) + ">";
                String previous = this._document.get(newOffset, length);
                if ("/".equals(previous)) {
                    --replaceOffset;
                    ++replaceLength;
                }
            }
            catch (BadLocationException e) {
                IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format(Messages.HTMLContentAssistProcessor_ErrorFetchingText, newOffset, length), (Throwable)e, (String)"com.aptana.editor.html/debug/content_assist");
            }
        }
        int cursorPosition = replaceString.length();
        String description = HTMLModelFormatter.ADDITIONAL_INFO.getDocumentation(element);
        HTMLElementProposal proposal = new HTMLElementProposal(replaceString, replaceOffset, replaceLength, cursorPosition, ELEMENT_ICON, "/" + element.getName(), null, description);
        proposal.setFileLocation("");
        proposal.setUserAgentImages(userAgentIcons);
        proposal.setRelevance(relevance);
        proposal.setCompletionProposalType(CompletionProposalType.ELEMENT);
        if (firstLexeme != null && tagLexeme != null && closeLexeme != null) {
            proposal.setCurrentElementName(String.valueOf(firstLexeme.getText()) + tagLexeme.getText() + closeLexeme.getText());
        }
        this.setProposalShowInfo(element, proposal);
        return proposal;
    }

    private void setProposalShowInfo(BaseElement element, CommonCompletionProposal proposal) {
        HashMap<String, String> specification = new HashMap<String, String>();
        List<Object> list = new ArrayList();
        String reference = "";
        if (element instanceof ElementElement) {
            ElementElement elementElement = (ElementElement)element;
            list = elementElement.getSpecifications();
            reference = elementElement.getRelatedClass();
        } else if (element instanceof AttributeElement) {
            AttributeElement attributeElement = (AttributeElement)element;
            list = attributeElement.getSpecifications();
            reference = attributeElement.getType();
        } else if (element instanceof EventElement) {
            EventElement eventElement = (EventElement)element;
            list = eventElement.getSpecifications();
            reference = eventElement.getType();
        }
        for (SpecificationElement specificationElement : list) {
            if (specificationElement == null) continue;
            specification.put(specificationElement.getName(), specificationElement.getVersion());
        }
        ProposalShowInfo proposalShowInfo = new ProposalShowInfo(specification, reference);
        String name = element.getName();
        if (StringUtil.isNotBlank((String)name)) {
            proposalShowInfo.setName(name);
        }
        proposal.setProposalShowInfo(proposalShowInfo);
    }

    private void addProposalWithOutUserAgent(List<ICompletionProposal> proposals, String name, Image image, String description, String fileLocation, int offset, CompletionProposalType completionProposalType, int relevance) {
        CommonCompletionProposal proposal = this.createProposal(name, name, image, description, null, fileLocation, offset);
        proposal.setCompletionProposalType(completionProposalType);
        proposal.setRelevance(relevance);
        proposals.add((ICompletionProposal)proposal);
    }

    protected CommonCompletionProposal createProposal(String displayName, String name, Image image, String description, Map<String, String> userAgents, String fileLocation, int offset) {
        if (this._replaceRange != null) {
            offset = this._replaceRange.getStartingOffset();
        }
        ValueElement value = this.createValueElement(name);
        value.setDisplayName(displayName);
        value.setDescription(description);
        IRange range = this.getIRange(offset);
        HTMLAttributeValueProposal proposal = new HTMLAttributeValueProposal(value, range, userAgents);
        proposal.setImage(image);
        proposal.setIsHTML(true);
        return proposal;
    }

    protected ICompletionProposal[] doComputeCompletionProposals(ITextViewer viewer, int offset, char activationChar, boolean autoActivated) {
        this.setAutoActivated(autoActivated);
        this._document = this.getDocument(viewer);
        HTMLLexemeProvider lexemeProvider = this.createLexemeProvider(this._document, offset > 0 ? offset - 1 : offset);
        Lexeme tempLexeme = lexemeProvider.getLexemeFromOffset(offset);
        if (tempLexeme != null) {
            this._currentLexeme = tempLexeme;
            this._replaceRange = this._currentLexeme;
        } else {
            this._replaceRange = null;
            this._currentLexeme = lexemeProvider.getFloorLexeme(offset);
        }
        this.fineLocation = this.getCoarseLocationType(this._document, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        switch (this.fineLocation) {
            case IN_OPEN_TAG: {
                this.fineLocation = this.getOpenTagLocationType((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                if (this.fineLocation == LocationType.IN_ELEMENT_NAME) {
                    this.addUnclosedTagProposals(this.fineLocation, result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                } else if (this.fineLocation == LocationType.IN_ATTRIBUTE_VALUE) {
                    String elementName = this.getElementName((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                    String attributeName = this.getAttributeName((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                    IRange activeRange = this.getAttributeValueRange((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                    boolean isOther = false;
                    ICompletionProposal[] other = null;
                    if (HTMLUtils.isCSSAttribute(attributeName)) {
                        isOther = true;
                        if (this.fCSSProcessor == null) {
                            this.fCSSProcessor = new CSSContentAssistProcessor(this.editor, activeRange);
                            this.fCSSProcessor.setNeedComputeLocationType(false);
                        } else {
                            this.fCSSProcessor.setActiveRange(activeRange);
                        }
                        if (this instanceof ScriptHTMLContentAssistProcessor) {
                            this.fCSSProcessor.setSubDocument(this._document);
                        }
                        other = this.fCSSProcessor.computeCompletionProposals(viewer, offset, activationChar, autoActivated);
                    } else if (HTMLUtils.isJSAttribute(elementName, attributeName)) {
                        isOther = true;
                        if (this.fJSProcessor == null) {
                            this.fJSProcessor = new JSContentAssistProcessor(this.editor, activeRange);
                        } else {
                            this.fJSProcessor.setActiveRange(activeRange);
                        }
                        ElementElement element = this._queryHelper.getElement(elementName);
                        String elementClazz = element.getRelatedClass();
                        this.fJSProcessor.enterEvent(elementClazz);
                        if (this instanceof ScriptHTMLContentAssistProcessor) {
                            this.fJSProcessor.setSubDocument(this._document);
                        }
                        other = this.fJSProcessor.computeCompletionProposals(viewer, offset, activationChar, autoActivated);
                        this.fJSProcessor.exitEvent(elementClazz);
                    }
                    if (isOther) {
                        if (other != null && other.length > 0) {
                            this.escapeAttributeValue(other);
                        }
                        return other;
                    }
                }
                if (activationChar == '<' || IS_CHINESE_CHARACTER) {
                    boolean insertComment = true;
                    try {
                        ITypedRegion region = viewer.getDocument().getPartition(viewer.getTextWidget().getCaretOffset());
                        if (region.getType().startsWith("__js_")) {
                            insertComment = false;
                        }
                    }
                    catch (Exception exception) {}
                    if (insertComment) {
                        this.addCommentProposals(result, offset);
                        this.addDynamicTagProposals(result, offset, this.getDynamicPage());
                    }
                }
                this.addOpenTagProposals(this.fineLocation, result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset, activationChar);
                break;
            }
            case IN_CLOSE_TAG: {
                boolean added = this.addUnclosedTagProposals(this.fineLocation, result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                if (added) break;
                this.addDefaultCloseTagProposals(this.fineLocation, result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                break;
            }
            case IN_TEXT: {
                String[] chars = new String[]{">", " ", "\"", "=", ":", "'"};
                this.autoSnippet = !autoActivated || !StringUtil.contains((String[])chars, (String)String.valueOf(activationChar));
                this.fineLocation = LocationType.IN_TEXT;
                this.addEntityProposals(result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                break;
            }
            case IN_DOCTYPE: {
                this.addDoctypeProposals(result, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                break;
            }
            case IN_STYLE: {
                if (this.fCSSProcessor == null) {
                    this.fCSSProcessor = new CSSContentAssistProcessor(this.editor);
                }
                return this.fCSSProcessor.computeCompletionProposals(viewer, offset, activationChar, autoActivated);
            }
            case IN_SCRIPT: {
                if (this.fJSProcessor == null) {
                    this.fJSProcessor = new HTMLScriptContentAssistProcessor(this.editor);
                }
                return this.fJSProcessor.computeCompletionProposals(viewer, offset, activationChar, autoActivated);
            }
        }
        ICompletionProposal[] proposals = result.toArray(new ICompletionProposal[result.size()]);
        if (IdeLog.isTraceEnabled((Plugin)HTMLPlugin.getDefault(), (String)"com.aptana.editor.html/debug/content_assist")) {
            IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Generated {0} proposals", proposals.length), (String)"com.aptana.editor.html/debug/content_assist");
        }
        if (this._replaceRange != null) {
            int startingOffset = this._replaceRange.getStartingOffset();
            int length = this._replaceRange.getLength();
            try {
                String text = this._document.get(this._replaceRange.getStartingOffset(), this._replaceRange.getLength());
                if (this.fineLocation == LocationType.IN_CLOSE_TAG) {
                    text = "/" + text;
                }
                this.setSelectedProposal(text, proposals);
            }
            catch (BadLocationException e) {
                IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format(Messages.HTMLContentAssistProcessor_ErrorFetchingText, startingOffset, length), (Throwable)e, (String)"com.aptana.editor.html/debug/content_assist");
            }
        }
        if (proposals.length == 0 && (this.fineLocation == LocationType.IN_ATTRIBUTE_VALUE || this.fineLocation == LocationType.ERROR)) {
            try {
                IDocument doc2 = HTMLTemplatePartitionUtils.getDocument(this._document.get());
                ITypedRegion region = doc2.getPartition(offset);
                if (region != null && "__html_template".equals(region.getType())) {
                    return HTMLTemplatePartitionUtils.doComputeCompletionProposals(this.getIndex(), doc2, offset, activationChar, autoActivated);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
        return proposals;
    }

    protected IDocument getDocument(ITextViewer viewer) {
        return viewer.getDocument();
    }

    private void escapeAttributeValue(ICompletionProposal[] completionProposals) {
        if (completionProposals == null || completionProposals.length == 0) {
            return;
        }
        ICompletionProposal[] iCompletionProposalArray = completionProposals;
        int n = completionProposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal c = iCompletionProposalArray[n2];
            if (c instanceof CommonCompletionProposal) {
                ((CommonCompletionProposal)c).replaceReplacementStringChar('\"', '\'');
            }
            ++n2;
        }
    }

    private void addCommentProposals(List<ICompletionProposal> result, int offset) {
        if (IS_CHINESE_CHARACTER) {
            IS_CHINESE_CHARACTER = false;
            CommonCompletionProposal proposals = new CommonCompletionProposal("\u300a", offset - 1, 1, 1, ATTRIBUTE_ICON, "<", null, "");
            proposals.setFileLocation("");
            proposals.setCompletionProposalType(CompletionProposalType.COMMENT);
            proposals.setIsHTML(true);
            proposals.setAutoReplace(false);
            result.add((ICompletionProposal)proposals);
        }
        String template = "<!--\r\n{0}\t\u4f5c\u8005\uff1a{1}\r\n{0}\t\u65f6\u95f4\uff1a{2}\r\n{0}\t\u63cf\u8ff0\uff1a$cursor$\r\n{0}-->";
        HTMLCommentProposal proposals = new HTMLCommentProposal("<!-- -->", offset - 1, 0, offset - 1, CommonEditorPlugin.getDefault().getImageFromImageRegistry("/icons/assistant/snippet.png"), "<!-- -->", null, "Quikly insert html comment", template);
        proposals.setFileLocation("");
        proposals.setCompletionProposalType(CompletionProposalType.COMMENT);
        result.add((ICompletionProposal)proposals);
    }

    private void addDynamicTagProposals(List<ICompletionProposal> result, int offset, int page) {
        if (page < 0) {
            return;
        }
        switch (page) {
            case 0: 
            case 1: {
                CommonCompletionProposal proposals = new CommonCompletionProposal("<%%>", offset - 1, 0, 2, CommonEditorPlugin.getDefault().getImageFromImageRegistry("/icons/assistant/snippet.png"), "<%%>", null, "Quikly insert scriptlet");
                proposals.setFileLocation("");
                proposals.setCompletionProposalType(CompletionProposalType.COMMENT);
                result.add((ICompletionProposal)proposals);
                break;
            }
            case 2: {
                CommonCompletionProposal proposals = new CommonCompletionProposal("<??>", offset - 1, 0, 2, CommonEditorPlugin.getDefault().getImageFromImageRegistry("/icons/assistant/snippet.png"), "<??>", null, "Quikly insert scriptlet");
                proposals.setFileLocation("");
                proposals.setCompletionProposalType(CompletionProposalType.COMMENT);
                result.add((ICompletionProposal)proposals);
                break;
            }
        }
    }

    protected void setSelectedProposal(String prefix, ICompletionProposal[] proposals) {
        if (prefix == null || prefix.equals("") || proposals == null) {
            return;
        }
        ICompletionProposal[] iCompletionProposalArray = proposals;
        int n = proposals.length;
        int n2 = 0;
        while (n2 < n) {
            ICompletionProposal proposal = iCompletionProposalArray[n2];
            String displayString = proposal.getDisplayString();
            int comparison = displayString.compareToIgnoreCase(prefix);
            if (comparison >= 0 && displayString.toLowerCase().startsWith(prefix.toLowerCase())) {
                if (displayString.startsWith(prefix)) {
                    ((ICommonCompletionProposal)proposal).setRelevance(90);
                } else {
                    ((ICommonCompletionProposal)proposal).setRelevance(50);
                }
            }
            ++n2;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fCSSProcessor != null && !this.fCSSProcessor.isDisposed()) {
            this.fCSSProcessor.dispose();
        }
        if (this.fJSProcessor != null && !this.fJSProcessor.isDisposed()) {
            this.fJSProcessor.dispose();
        }
        this._document = null;
        this._validator = null;
        this._currentLexeme = null;
        this._queryHelper = null;
        this._replaceRange = null;
    }

    HTMLLexemeProvider createLexemeProvider(IDocument document, int offset) {
        if (this.getLexemeRange() != null) {
            return new HTMLLexemeProvider(document, this.getLexemeRange(), (ITokenScanner)new HTMLTagScanner(false));
        }
        int documentLength = document.getLength();
        int lexemeProviderOffset = offset >= documentLength ? documentLength - 1 : offset;
        return new HTMLLexemeProvider(document, lexemeProviderOffset, (ITokenScanner)new HTMLTagScanner(false));
    }

    private String getAttributeName(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        String name = null;
        int index = lexemeProvider.getLexemeFloorIndex(offset);
        while (index >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index);
            if (lexeme.getType() == HTMLTokenType.EQUAL) {
                if (index < 1 || (lexeme = lexemeProvider.getLexeme(index - 1)) == null) break;
                name = lexeme.getText();
                break;
            }
            --index;
        }
        return name;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this._validator == null) {
            this._validator = new HTMLContextInformationValidator();
        }
        return this._validator;
    }

    private String getElementName(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        int index;
        String result = null;
        int i = index = lexemeProvider.getLexemeFloorIndex(offset);
        while (i >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(i);
            if (lexeme.getType() == HTMLTokenType.TAG_START) {
                Lexeme nextLexeme = lexemeProvider.getLexeme(i + 1);
                if (nextLexeme == null) break;
                result = nextLexeme.getText();
                break;
            }
            --i;
        }
        return result;
    }

    protected IRange getAttributeValueRange(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        Lexeme attribute = lexemeProvider.getLexemeFromOffset(offset);
        Range result = Range.EMPTY;
        if (attribute != null) {
            String attributeContent = attribute.getText();
            if (attributeContent.length() > 1) {
                attributeContent = attributeContent.substring(1, attributeContent.length() - 1);
            }
            String content = attributeContent.trim();
            int index = attributeContent.indexOf(content);
            int length = index + content.length();
            int prefix = attributeContent.length() - length;
            ++prefix;
            switch ((HTMLTokenType)((Object)attribute.getType())) {
                case DOUBLE_QUOTED_STRING: 
                case SINGLE_QUOTED_STRING: {
                    result = new Range(attribute.getStartingOffset() + 1, attribute.getEndingOffset() - prefix);
                }
            }
        }
        return result;
    }

    LocationType getCoarseLocationType(IDocument document, ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        LocationType result;
        block16: {
            result = LocationType.ERROR;
            try {
                if (this.isTMEditor()) {
                    result = this.getNewLocationType();
                } else {
                    ITypedRegion partition = document.getPartition(offset > 0 ? offset - 1 : offset);
                    String type = partition.getType();
                    if (!locationMap.containsKey(type)) {
                        return result;
                    }
                    result = locationMap.get(type);
                    if (("__html_script".equals(type) || "__html_style".equals(type)) && partition.getOffset() + partition.getLength() == offset) {
                        LocationType locationType = result = "__html_script".equals(type) ? LocationType.IN_SCRIPT : LocationType.IN_STYLE;
                    }
                }
                if (result.equals((Object)LocationType.IN_STYLE) || result.equals((Object)LocationType.IN_SCRIPT)) {
                    return result;
                }
                Lexeme firstLexeme = lexemeProvider.getFirstLexeme();
                if (firstLexeme != null) {
                    Lexeme lastLexeme = lexemeProvider.getLastLexeme();
                    HTMLTokenType lastLexemeType = (HTMLTokenType)((Object)lastLexeme.getType());
                    switch (result) {
                        case IN_OPEN_TAG: 
                        case IN_CLOSE_TAG: {
                            if (offset <= firstLexeme.getStartingOffset()) {
                                result = LocationType.IN_TEXT;
                                break;
                            }
                            if (lastLexeme.getEndingOffset() < offset && (lastLexemeType == HTMLTokenType.TAG_END || lastLexemeType == HTMLTokenType.TAG_SELF_CLOSE)) {
                                result = LocationType.IN_TEXT;
                                break;
                            }
                            break block16;
                        }
                        case IN_TEXT: {
                            if (firstLexeme.getType() == HTMLTokenType.TAG_START && lastLexemeType == HTMLTokenType.META && lastLexeme.getText().equalsIgnoreCase("DOCTYPE")) {
                                result = LocationType.IN_DOCTYPE;
                                break;
                            }
                            break block16;
                        }
                    }
                    break block16;
                }
                result = LocationType.IN_TEXT;
            }
            catch (BadLocationException e) {
                IdeLog.logWarning((Plugin)HTMLPlugin.getDefault(), (String)StringUtil.format((String)Messages.HTMLContentAssistProcessor_ErrorFetchingPartition, (int)offset), (Throwable)e, (String)"com.aptana.editor.html/debug/content_assist");
            }
        }
        if (IdeLog.isTraceEnabled((Plugin)HTMLPlugin.getDefault(), (String)"com.aptana.editor.html/debug/content_assist")) {
            IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Coarse location: {0}", new Object[]{result}), (String)"com.aptana.editor.html/debug/content_assist");
        }
        return result;
    }

    LocationType getOpenTagLocationType(ILexemeProvider<HTMLTokenType> lexemeProvider, int offset) {
        LocationType result = LocationType.ERROR;
        int index = lexemeProvider.getLexemeIndex(offset);
        if (index < 0) {
            int candidateIndex = lexemeProvider.getLexemeFloorIndex(offset);
            Lexeme lexeme = lexemeProvider.getLexeme(candidateIndex);
            if (lexeme != null && lexeme.getEndingOffset() == offset - 1) {
                index = candidateIndex;
            } else {
                result = LocationType.IN_ATTRIBUTE_NAME;
            }
        }
        while (index >= 0) {
            Lexeme lexeme = lexemeProvider.getLexeme(index);
            block0 : switch ((HTMLTokenType)((Object)lexeme.getType())) {
                case ATTR_ID: 
                case ATTR_CLASS: 
                case ATTR_STYLE: 
                case ATTR_SCRIPT: {
                    this._currentLexeme = lexeme;
                    this._replaceRange = this._currentLexeme;
                    result = LocationType.IN_ATTRIBUTE_NAME;
                    break;
                }
                case EQUAL: {
                    result = offset <= lexeme.getStartingOffset() ? LocationType.IN_ATTRIBUTE_NAME : LocationType.IN_ATTRIBUTE_VALUE;
                    break;
                }
                case TAG_START: {
                    result = LocationType.IN_ELEMENT_NAME;
                    break;
                }
                case TAG_END: 
                case TAG_SELF_CLOSE: {
                    Lexeme previous;
                    if (index < 1 || (previous = lexemeProvider.getLexeme(index - 1)).getEndingOffset() >= offset - 1) break;
                    result = LocationType.IN_ATTRIBUTE_NAME;
                    break;
                }
                case ATTRIBUTE: 
                case META: 
                case STRUCTURE_TAG: 
                case BLOCK_TAG: 
                case INLINE_TAG: 
                case NEW_H5_TAG: {
                    Lexeme previous;
                    if (index >= 1) {
                        previous = lexemeProvider.getLexeme(index - 1);
                        switch ((HTMLTokenType)((Object)previous.getType())) {
                            case DOUBLE_QUOTED_STRING: 
                            case SINGLE_QUOTED_STRING: 
                            case META: 
                            case STRUCTURE_TAG: 
                            case BLOCK_TAG: 
                            case INLINE_TAG: 
                            case NEW_H5_TAG: {
                                this._currentLexeme = lexeme;
                                this._replaceRange = this._currentLexeme;
                                result = LocationType.IN_ATTRIBUTE_NAME;
                                break block0;
                            }
                            case TAG_START: {
                                this._currentLexeme = lexeme;
                                this._replaceRange = this._currentLexeme;
                                result = LocationType.IN_ELEMENT_NAME;
                                break block0;
                            }
                        }
                        break;
                    }
                    result = LocationType.IN_ELEMENT_NAME;
                    break;
                }
                case DOUBLE_QUOTED_STRING: 
                case SINGLE_QUOTED_STRING: {
                    if (lexeme.getEndingOffset() < offset && lexeme.getLength() > 1) {
                        int lastChar;
                        String text = lexeme.getText();
                        int n = lastChar = StringUtil.isEmpty((String)text) ? 0 : (int)text.charAt(text.length() - 1);
                        if (lastChar == 34 || lastChar == 39) {
                            result = LocationType.IN_ATTRIBUTE_NAME;
                            this._replaceRange = null;
                            break;
                        }
                        result = LocationType.IN_ATTRIBUTE_VALUE;
                        break;
                    }
                    result = LocationType.IN_ATTRIBUTE_VALUE;
                    break;
                }
            }
            if (result != LocationType.ERROR) break;
            --index;
        }
        if (IdeLog.isTraceEnabled((Plugin)HTMLPlugin.getDefault(), (String)"com.aptana.editor.html/debug/content_assist")) {
            IdeLog.logTrace((Plugin)HTMLPlugin.getDefault(), (String)MessageFormat.format("Find location: {0}", new Object[]{result}), (String)"com.aptana.editor.html/debug/content_assist");
        }
        return result;
    }

    private void setEntityRange(int offset) {
        try {
            int start = -1;
            int end = -1;
            int i = offset - 1;
            while (i >= 0) {
                char c = this._document.getChar(i);
                if ('&' == c) {
                    start = i;
                    break;
                }
                if (Character.isWhitespace(c) || c == '>') {
                    this._replaceRange = null;
                    return;
                }
                --i;
            }
            int length = this._document.getLength();
            int i2 = offset;
            while (i2 < length) {
                char c = this._document.getChar(i2);
                if (';' == c) {
                    end = i2;
                    break;
                }
                if (Character.isWhitespace(c) || c == '<') {
                    end = offset - 1;
                    break;
                }
                ++i2;
            }
            this._replaceRange = new Range(start, end);
        }
        catch (BadLocationException badLocationException) {
            this._replaceRange = null;
        }
    }

    public boolean isValidAutoActivationLocation(char c, int keyCode, IDocument document, int offset) {
        HTMLLexemeProvider lexemeProvider = this.createLexemeProvider(document, offset);
        LocationType location = this.getCoarseLocationType(document, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
        switch (location) {
            case IN_OPEN_TAG: {
                if (c == ' ' || c == '\t') {
                    return true;
                }
                LocationType fineLocation = this.getOpenTagLocationType((ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
                if (fineLocation == LocationType.IN_ATTRIBUTE_NAME && c == '/') {
                    return false;
                }
                return fineLocation == LocationType.IN_ATTRIBUTE_NAME || fineLocation == LocationType.IN_ATTRIBUTE_VALUE;
            }
        }
        return false;
    }

    public boolean isValidIdentifier(char c, int keyCode) {
        String chars = ".#:</>-=&'\"$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ ";
        if (chars.indexOf(c) > -1) {
            return true;
        }
        return 65 <= keyCode && keyCode <= 90 || 97 <= keyCode && keyCode <= 122;
    }

    protected String getPreferenceNodeQualifier() {
        return "com.aptana.editor.html";
    }

    protected List<ICompletionProposal> addRubleProposals(ITextViewer viewer, int offset) {
        if (this.showSnippetProposals) {
            this.showSnippetProposals = false;
            return super.addRubleProposals(viewer, offset);
        }
        return new ArrayList<ICompletionProposal>(0);
    }

    public SnippetType getSnippetType() {
        if (this.fineLocation == null) {
            return new SnippetType(SnippetType.Type.NO_TYPE);
        }
        switch (this.fineLocation) {
            case IN_ATTRIBUTE_NAME: {
                return new SnippetType(HTMLTokenType.ATTRIBUTE.getScope(), SnippetType.Type.HTML_ATTRIBUTE);
            }
            case IN_OPEN_TAG: 
            case IN_TEXT: {
                if (this.autoSnippet) {
                    return new SnippetType(HTMLTokenType.TEXT.getScope(), SnippetType.Type.DEFAULT);
                }
                return new SnippetType(HTMLTokenType.TEXT.getScope(), SnippetType.Type.NO_TYPE);
            }
            case IN_ELEMENT_NAME: {
                return new SnippetType(HTMLTokenType.INLINE_TAG.getScope(), SnippetType.Type.NO_TYPE);
            }
            case IN_ATTRIBUTE_VALUE: {
                return new SnippetType(HTMLTokenType.DOUBLE_QUOTED_STRING.getScope(), SnippetType.Type.NO_TYPE);
            }
        }
        return null;
    }

    public boolean isEnableEmmet(IDocument document, int offset) {
        HTMLLexemeProvider lexemeProvider = this.createLexemeProvider(document, offset);
        LocationType location = this.getCoarseLocationType(document, (ILexemeProvider<HTMLTokenType>)lexemeProvider, offset);
        switch (location) {
            case IN_TEXT: {
                return true;
            }
        }
        return false;
    }

    public boolean isTMEditor() {
        return this.isTMEditor;
    }

    public void setIsTMEditor(boolean isTMEditor) {
        this.isTMEditor = isTMEditor;
    }

    public LocationType getNewLocationType() {
        return this.newLocationType;
    }

    public void setNewLocationType(LocationType newLocationType) {
        this.newLocationType = newLocationType;
    }

    public void setActiveRange(IRange activeRange) {
        this._activeRange = activeRange;
    }

    public IRange getActiveRange() {
        return this._activeRange;
    }

    public IRange getLexemeRange() {
        return this._lexemeRange;
    }

    public void setLexemeRange(IRange _lexemeRange) {
        this._lexemeRange = _lexemeRange;
    }

    public int getDynamicPage() {
        return this.dynamicPage;
    }

    public void setDynamicPage(int b) {
        this.dynamicPage = b;
    }

    private class CollectingResourceVisitor
    implements IResourceVisitor {
        List<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        StringBuilder scriptReplacement;
        StringBuilder linkReplacement;
        String scriptSrcName;
        String linkHrefName;
        int replaceOffset;
        int replaceLength;

        private CollectingResourceVisitor(StringBuilder scriptReplacement, StringBuilder linkReplacement, String scriptSrcName, String linkHrefName, int replaceOffset, int replaceLength) {
            this.scriptReplacement = scriptReplacement;
            this.linkReplacement = linkReplacement;
            this.linkHrefName = linkHrefName;
            this.scriptSrcName = scriptSrcName;
            this.replaceOffset = replaceOffset;
            this.replaceLength = replaceLength;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (1 == resource.getType()) {
                IFile file = (IFile)resource;
                String name = file.getName();
                boolean isJs = false;
                boolean isCSS = false;
                if (HTMLContentAssistProcessor.this.isJS(name)) {
                    isJs = true;
                } else if (HTMLContentAssistProcessor.this.isCSSExtend(name)) {
                    isCSS = true;
                } else {
                    return false;
                }
                String childName = file.getProjectRelativePath().toString();
                String filePath = HTMLContentAssistProcessor.this.iFile.getProjectRelativePath().toString();
                if (StringUtil.isBlank((String)childName)) {
                    return false;
                }
                String path = URIUtils.relativeURI((String)filePath, (String)childName);
                if (StringUtil.isBlank((String)path)) {
                    return false;
                }
                StringBuilder scriptReplacementExt = new StringBuilder();
                StringBuilder linkReplacementExt = new StringBuilder();
                scriptReplacementExt.append((CharSequence)this.scriptReplacement);
                linkReplacementExt.append((CharSequence)this.linkReplacement);
                ArrayList<Integer> positions = new ArrayList<Integer>();
                String elementName = "";
                String replacement = "";
                if (isJs) {
                    elementName = String.valueOf(this.scriptSrcName) + path;
                    replacement = scriptReplacementExt.append(path).append('\"').append(" ></script>").toString();
                } else if (isCSS) {
                    elementName = String.valueOf(this.linkHrefName) + path;
                    replacement = linkReplacementExt.append(path).append('\"').append(" />").toString();
                }
                int cursorPosition = replacement.length();
                positions.add(cursorPosition + 1);
                positions.add(0, cursorPosition);
                ElementElement element = new ElementElement();
                element.setName(elementName);
                String desc = "<" + replacement;
                desc = desc.replace("<", "&lt;");
                desc = desc.replace(">", "&gt;");
                element.setDescription(desc);
                HTMLTagProposal proposal = new HTMLTagProposal(replacement, this.replaceOffset, this.replaceLength, element, HTMLContentAssistProcessor.this.getProject(), positions.toArray(new Integer[positions.size()]));
                proposal.setCompletionProposalType(CompletionProposalType.ELEMENT);
                this.proposals.add((ICompletionProposal)proposal);
                return false;
            }
            return 2 != resource.getType() || !"unpackage".equals(resource.getName()) && !"node_modules".equals(resource.getName());
        }
    }

    private static final class URIPathProposal
    extends CommonCompletionProposal {
        private final boolean isDirectory;

        private URIPathProposal(String replacementString, int replacementOffset, int replacementLength, boolean isDirectory, Map<String, String> userAgentIcons) {
            super(replacementString, replacementOffset, replacementLength, replacementString.length(), null, replacementString, null, null);
            this.isDirectory = isDirectory;
            if (isDirectory) {
                this.setTriggerCharacters(new char[]{'/'});
            }
            this.setUserAgentImages(userAgentIcons);
        }

        public synchronized Image getImage() {
            if (this._image == null) {
                Image image = null;
                if (this.isDirectory) {
                    image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                } else {
                    ImageDescriptor imageDesc = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.getDisplayString());
                    if (imageDesc != null) {
                        final Image theImage = image = imageDesc.createImage();
                        UIUtils.getDisplay().disposeExec(new Runnable(){

                            @Override
                            public void run() {
                                if (theImage != null && !theImage.isDisposed()) {
                                    theImage.dispose();
                                }
                            }
                        });
                    }
                    if (image == null) {
                        image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                    }
                }
                this._image = image;
            }
            return this._image;
        }

        public void apply(final ITextViewer viewer, char trigger, int stateMask, int offset) {
            super.apply(viewer, trigger, stateMask, offset);
            if (viewer instanceof ITextOperationTarget && this.isDirectory) {
                UIUtils.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (((ITextOperationTarget)viewer).canDoOperation(13)) {
                            ((ITextOperationTarget)viewer).doOperation(13);
                        }
                    }
                });
            }
        }
    }
}

