/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.html;

import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.editor.common.CommonUtil;
import com.aptana.editor.common.IPartitioningConfiguration;
import com.aptana.editor.common.ISourceViewerConfiguration;
import com.aptana.editor.common.TextUtils;
import com.aptana.editor.common.scripting.IContentTypeTranslator;
import com.aptana.editor.common.scripting.QualifiedContentType;
import com.aptana.editor.common.text.SingleTokenScanner;
import com.aptana.editor.common.text.rules.CaseInsensitiveMultiLineRule;
import com.aptana.editor.common.text.rules.CommentScanner;
import com.aptana.editor.common.text.rules.ExtendedToken;
import com.aptana.editor.common.text.rules.ISubPartitionScanner;
import com.aptana.editor.common.text.rules.PartitionerSwitchingIgnoreRule;
import com.aptana.editor.common.text.rules.TagRule;
import com.aptana.editor.common.text.rules.ThemeingDamagerRepairer;
import com.aptana.editor.css.CSSSourceConfiguration;
import com.aptana.editor.html.HTMLDoctypeScanner;
import com.aptana.editor.html.HTMLScanner;
import com.aptana.editor.html.HTMLSubPartitionScanner;
import com.aptana.editor.html.HTMLTagScanner;
import com.aptana.editor.html.contentassist.HTMLContentAssistProcessor;
import com.aptana.editor.html.ext.HTMLSingleScriptContentAssistProcessor;
import com.aptana.editor.html.ext.HTMLSingleStyleContentAssistProcessor;
import com.aptana.editor.html.internal.text.rules.DocTypeRule;
import com.aptana.editor.js.JSSourceConfiguration;
import com.aptana.editor.js.sdoc.SDocContentAssistProcessor;
import com.aptana.editor.svg.SVGSourceConfiguration;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.source.ISourceViewer;

public class HTMLSourceConfiguration
implements IPartitioningConfiguration,
ISourceViewerConfiguration {
    public static final String PREFIX = "__html_";
    public static final String DEFAULT = "__html__dftl_partition_content_type";
    public static final String HTML_COMMENT = "__html_comment";
    public static final String HTML_PHP = "__html_php";
    public static final String HTML_SP = "__html_sp";
    public static final String CDATA = "__html_cdata";
    public static final String HTML_DOCTYPE = "__html_doctype";
    public static final String HTML_SCRIPT = "__html_script";
    public static final String HTML_STYLE = "__html_style";
    public static final String HTML_TAG = "__html_tag";
    public static final String HTML_TAG_CLOSE = "__html_tag_close";
    public static final String HTML_TEMPLATE = "__html_template";
    protected static final String[] CONTENT_TYPES = new String[]{"__html__dftl_partition_content_type", "__html_comment", "__html_php", "__html_sp", "__html_cdata", "__html_doctype", "__html_script", "__html_style", "__html_tag", "__html_tag_close", "__html_template"};
    private static final String[][] TOP_CONTENT_TYPES = new String[][]{{"com.aptana.contenttype.html"}, {"com.aptana.contenttype.html", "com.aptana.contenttype.js"}, {"com.aptana.contenttype.html", "com.aptana.contenttype.css"}, {"com.aptana.contenttype.html", "com.aptana.contenttype.svg"}};
    private IPredicateRule[] partitioningRules = new IPredicateRule[]{new CaseInsensitiveMultiLineRule("<!DOCTYPE ", ">", HTMLSourceConfiguration.getToken("__html_doctype")), new DocTypeRule(HTMLSourceConfiguration.getToken("__html_cdata")), new PartitionerSwitchingIgnoreRule((IPredicateRule)new MultiLineRule("<!--", "-->", HTMLSourceConfiguration.getToken("__html_comment"), '\u0000', true)), new PartitionerSwitchingIgnoreRule((IPredicateRule)new MultiLineRule("<?", "?>", HTMLSourceConfiguration.getToken("__html_php"), '\u0000', true)), new PartitionerSwitchingIgnoreRule((IPredicateRule)new MultiLineRule("<%", "%>", HTMLSourceConfiguration.getToken("__html_sp"), '\u0000', true)), new TagRule("script", (IToken)new ExtendedToken(HTMLSourceConfiguration.getToken("__html_script")), true), new TagRule("style", (IToken)new ExtendedToken(HTMLSourceConfiguration.getToken("__html_style")), true), new TagRule("/", HTMLSourceConfiguration.getToken("__html_tag_close")), new TagRule((IToken)new ExtendedToken(HTMLSourceConfiguration.getToken("__html_tag"))), new SingleLineRule("{{", "}}", HTMLSourceConfiguration.getToken("__html_template"))};
    private static HTMLSourceConfiguration instance;

    static {
        IContentTypeTranslator c = CommonEditorPlugin.getDefault().getContentTypeTranslator();
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html"}), new QualifiedContentType(new String[]{"text.html.basic"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html", "com.aptana.contenttype.css"}), new QualifiedContentType(new String[]{"text.html.basic", "source.css.embedded.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html", "com.aptana.contenttype.js"}), new QualifiedContentType(new String[]{"text.html.basic", "source.js.embedded.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{"com.aptana.contenttype.html", "com.aptana.contenttype.svg"}), new QualifiedContentType(new String[]{"text.html.basic", "source.svg.embedded.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{HTML_COMMENT}), new QualifiedContentType(new String[]{"comment.block.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{HTML_PHP}), new QualifiedContentType(new String[]{"undefined.block.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{HTML_SP}), new QualifiedContentType(new String[]{"undefined.block.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{HTML_TAG}), new QualifiedContentType(new String[]{"meta.tag.block.any.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{HTML_TAG_CLOSE}), new QualifiedContentType(new String[]{"meta.tag.block.any.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{HTML_SCRIPT}), new QualifiedContentType(new String[]{"meta.tag.block.any.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{HTML_STYLE}), new QualifiedContentType(new String[]{"meta.tag.block.any.html"}));
        c.addTranslation(new QualifiedContentType(new String[]{CDATA}), new QualifiedContentType(new String[]{"string.unquoted.cdata.xml"}));
        c.addTranslation(new QualifiedContentType(new String[]{HTML_DOCTYPE}), new QualifiedContentType(new String[]{"meta.tag.sgml.html", "meta.tag.sgml.doctype.html"}));
    }

    private HTMLSourceConfiguration() {
    }

    public static synchronized HTMLSourceConfiguration getDefault() {
        if (instance == null) {
            instance = new HTMLSourceConfiguration();
        }
        return instance;
    }

    public String[] getContentTypes() {
        return TextUtils.combine((String[][])new String[][]{CONTENT_TYPES, JSSourceConfiguration.CONTENT_TYPES, CSSSourceConfiguration.CONTENT_TYPES, SVGSourceConfiguration.CONTENT_TYPES});
    }

    public String[][] getTopContentTypes() {
        return TOP_CONTENT_TYPES;
    }

    public IPredicateRule[] getPartitioningRules() {
        return this.partitioningRules;
    }

    public ISubPartitionScanner createSubPartitionScanner() {
        return new HTMLSubPartitionScanner();
    }

    public String getDocumentContentType(String contentType) {
        if (contentType.startsWith(PREFIX)) {
            return "com.aptana.contenttype.html";
        }
        String result = JSSourceConfiguration.getDefault().getDocumentContentType(contentType);
        if (result != null) {
            return result;
        }
        result = CSSSourceConfiguration.getDefault().getDocumentContentType(contentType);
        if (result != null) {
            return result;
        }
        result = SVGSourceConfiguration.getDefault().getDocumentContentType(contentType);
        if (result != null) {
            return result;
        }
        return null;
    }

    public void setupPresentationReconciler(PresentationReconciler reconciler, ISourceViewer sourceViewer) {
        JSSourceConfiguration.getDefault().setupPresentationReconciler(reconciler, sourceViewer);
        CSSSourceConfiguration.getDefault().setupPresentationReconciler(reconciler, sourceViewer);
        SVGSourceConfiguration.getDefault().setupPresentationReconciler(reconciler, sourceViewer);
        ThemeingDamagerRepairer dr = new ThemeingDamagerRepairer(this.getHTMLScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        reconciler.setDamager((IPresentationDamager)dr, DEFAULT);
        reconciler.setRepairer((IPresentationRepairer)dr, DEFAULT);
        dr = new ThemeingDamagerRepairer(this.getHTMLTagScanner());
        reconciler.setDamager((IPresentationDamager)dr, HTML_SCRIPT);
        reconciler.setRepairer((IPresentationRepairer)dr, HTML_SCRIPT);
        reconciler.setDamager((IPresentationDamager)dr, HTML_STYLE);
        reconciler.setRepairer((IPresentationRepairer)dr, HTML_STYLE);
        reconciler.setDamager((IPresentationDamager)dr, HTML_TAG);
        reconciler.setRepairer((IPresentationRepairer)dr, HTML_TAG);
        reconciler.setDamager((IPresentationDamager)dr, HTML_TAG_CLOSE);
        reconciler.setRepairer((IPresentationRepairer)dr, HTML_TAG_CLOSE);
        dr = new ThemeingDamagerRepairer(this.getHTMLCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, HTML_COMMENT);
        reconciler.setRepairer((IPresentationRepairer)dr, HTML_COMMENT);
        dr = new ThemeingDamagerRepairer(this.getDoctypeScanner());
        reconciler.setDamager((IPresentationDamager)dr, HTML_DOCTYPE);
        reconciler.setRepairer((IPresentationRepairer)dr, HTML_DOCTYPE);
        dr = new ThemeingDamagerRepairer(this.getCDATAScanner());
        reconciler.setDamager((IPresentationDamager)dr, CDATA);
        reconciler.setRepairer((IPresentationRepairer)dr, CDATA);
    }

    public IContentAssistProcessor getContentAssistProcessor(AbstractThemeableEditor editor, String contentType) {
        if (contentType.startsWith("__js_")) {
            if ("__js_sdoc_comment".equals(contentType)) {
                return new SDocContentAssistProcessor(editor);
            }
            if ("__js_multiline_comment".equals(contentType) || "__js_singleline_comment".equals(contentType)) {
                return null;
            }
            if (editor != null) {
                return new HTMLSingleScriptContentAssistProcessor(editor);
            }
        }
        if (contentType.startsWith("__css_")) {
            return new HTMLSingleStyleContentAssistProcessor(editor);
        }
        if (contentType.startsWith("__svg_")) {
            return SVGSourceConfiguration.getDefault().getContentAssistProcessor(editor, contentType);
        }
        return new HTMLContentAssistProcessor(editor);
    }

    private ITokenScanner getHTMLCommentScanner() {
        return new CommentScanner(HTMLSourceConfiguration.getToken("comment.block.html"));
    }

    private ITokenScanner getHTMLScanner() {
        return new HTMLScanner();
    }

    private ITokenScanner getCDATAScanner() {
        return new SingleTokenScanner(HTMLSourceConfiguration.getToken("string.unquoted.cdata.xml"));
    }

    private ITokenScanner getHTMLTagScanner() {
        return new HTMLTagScanner();
    }

    private ITokenScanner getDoctypeScanner() {
        return new HTMLDoctypeScanner();
    }

    private static IToken getToken(String tokenName) {
        return CommonUtil.getToken((String)tokenName);
    }
}

