/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.stats.core.persistent.impl;

import com.pandora.stats.core.Activator;
import com.pandora.stats.core.api.Stats;
import com.pandora.stats.core.dto.ExceptionInfo;
import com.pandora.stats.core.dto.OperateInfo;
import com.pandora.stats.core.persistent.DataPersistent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class DefaultDataPersistent
implements DataPersistent {
    private String bundlePath = null;
    private static final String dbPath = "" + File.separatorChar;
    private static final String operateDbName = "usageData.dat";
    private static final String exceptionDbName = "exceptionData.dat";
    private static final String encoding = "utf-8";
    private static final String separateLine = "+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+";
    private SimpleDateFormat format = new SimpleDateFormat("yyyy" + File.separatorChar + "MM" + File.separatorChar + "dd" + File.separatorChar);
    private SimpleDateFormat monthFormat = new SimpleDateFormat("yyyy" + File.separatorChar + "MM" + File.separatorChar);

    public DefaultDataPersistent() {
        File basePath = Activator.getDefault().getBundle().getDataFile("db" + File.separatorChar);
        this.bundlePath = basePath.getAbsolutePath();
    }

    public String getBasePath() {
        return String.valueOf(this.bundlePath) + dbPath;
    }

    @Override
    public void persistent(Map<String, List<Object>> datas) throws IOException {
        File exfile;
        String dailyDbPath = this.format.format(new Date());
        File folder = new File(String.valueOf(this.bundlePath) + dbPath + dailyDbPath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        if ((exfile = new File(String.valueOf(this.bundlePath) + dbPath + dailyDbPath + exceptionDbName)).exists()) {
            this.appendMapToExFile(datas, exfile);
        } else {
            this.writeMapToExFile(datas, exfile);
        }
        File opfile = new File(String.valueOf(this.bundlePath) + dbPath + dailyDbPath + operateDbName);
        if (opfile.exists()) {
            this.appendMapToOpFile(datas, opfile);
        } else {
            this.writeMapToOpFile(datas, opfile);
        }
    }

    private void appendMapToOpFile(Map<String, List<Object>> datas, File opfile) throws IOException {
        List<Object> operateInfos = datas.get("operate");
        RandomAccessFile raf = new RandomAccessFile(opfile, "rw");
        raf.seek(raf.length());
        try {
            try {
                for (Object obj : operateInfos) {
                    OperateInfo info = (OperateInfo)obj;
                    StringBuffer sb = new StringBuffer();
                    sb.append(String.valueOf(DefaultDataPersistent.encode(info.getCategory())) + "\n");
                    sb.append(String.valueOf(DefaultDataPersistent.encode(info.getTarget())) + "\n");
                    sb.append(String.valueOf(DefaultDataPersistent.encode(info.getDesc())) + "\n");
                    sb.append("+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+\n");
                    raf.write(sb.toString().getBytes());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    raf.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                raf.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String encode(String source) throws UnsupportedEncodingException {
        if (source == null) {
            return "";
        }
        return URLEncoder.encode(source, encoding);
    }

    private static String decode(String source) throws UnsupportedEncodingException {
        if (source == null) {
            return "";
        }
        return URLDecoder.decode(source, encoding);
    }

    private void writeMapToOpFile(Map<String, List<Object>> datas, File opFile) throws IOException {
        List<Object> operateInfos = datas.get("operate");
        FileOutputStream fos = new FileOutputStream(opFile);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fos));
        try {
            try {
                writer.write("+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+\n");
                for (Object obj : operateInfos) {
                    OperateInfo info = (OperateInfo)obj;
                    writer.write(String.valueOf(DefaultDataPersistent.encode(info.getCategory())) + "\n");
                    writer.write(String.valueOf(DefaultDataPersistent.encode(info.getTarget())) + "\n");
                    writer.write(String.valueOf(DefaultDataPersistent.encode(info.getDesc())) + "\n");
                    writer.write("+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+\n");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    writer.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void appendMapToExFile(Map<String, List<Object>> datas, File file) throws IOException {
        List<Object> exceptionInfos = datas.get("exception");
        RandomAccessFile raf = new RandomAccessFile(file, "rw");
        raf.seek(raf.length());
        try {
            try {
                for (Object obj : exceptionInfos) {
                    ExceptionInfo info = (ExceptionInfo)obj;
                    StringBuffer sb = new StringBuffer();
                    sb.append(String.valueOf(DefaultDataPersistent.encode(info.getExceptionName())) + "\n").append(String.valueOf(DefaultDataPersistent.encode(info.getClassName())) + "\n").append(String.valueOf(DefaultDataPersistent.encode(info.getLineNum())) + "\n").append(String.valueOf(DefaultDataPersistent.encode(info.getDetail())) + "\n").append("+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+\n");
                    raf.write(sb.toString().getBytes());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    raf.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                raf.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void writeMapToExFile(Map<String, List<Object>> datas, File file) throws IOException {
        List<Object> exceptionInfos = datas.get("exception");
        FileOutputStream fos = new FileOutputStream(file);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(fos));
        try {
            try {
                writer.write("+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+\n");
                for (Object obj : exceptionInfos) {
                    ExceptionInfo info = (ExceptionInfo)obj;
                    StringBuffer sb = new StringBuffer();
                    sb.append(String.valueOf(DefaultDataPersistent.encode(info.getExceptionName())) + "\n").append(String.valueOf(DefaultDataPersistent.encode(info.getClassName())) + "\n").append(String.valueOf(DefaultDataPersistent.encode(info.getLineNum())) + "\n").append(String.valueOf(DefaultDataPersistent.encode(info.getDetail())) + "\n").append("+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+_+\n");
                    writer.write(sb.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    writer.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteFile(String dbPath) throws IOException {
        File[] files;
        File db = new File(dbPath);
        if (!db.exists() || !db.isDirectory()) {
            return;
        }
        File[] fileArray = files = db.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.exists()) {
                file.delete();
            }
            ++n2;
        }
    }

    public boolean haveDbFile(String dbPath) {
        String month = this.monthFormat.format(new Date());
        File file = new File(dbPath);
        if (!file.exists()) {
            return false;
        }
        if (file.isFile()) {
            return false;
        }
        File[] dbFiles = file.listFiles();
        if (dbFiles.length == 2 && dbFiles[0].isFile() && dbFiles[1].isFile()) {
            return file.getAbsolutePath().indexOf(month) != -1;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load(String dbPath) throws IOException {
        String line;
        BufferedReader reader;
        FileInputStream fis;
        File opDbFile;
        block30: {
            System.out.println("DB\u8def\u5f84\uff1a" + dbPath);
            File db = new File(dbPath);
            if (!db.exists()) return;
            if (!db.isDirectory()) {
                return;
            }
            String exDbFilePath = String.valueOf(dbPath) + File.separatorChar + exceptionDbName;
            String opDbFilePath = String.valueOf(dbPath) + File.separatorChar + operateDbName;
            File exDbFile = new File(exDbFilePath);
            opDbFile = new File(opDbFilePath);
            fis = null;
            reader = null;
            try {
                try {
                    if (exDbFile.exists()) {
                        fis = new FileInputStream(exDbFile);
                        reader = new BufferedReader(new InputStreamReader(fis));
                        line = null;
                        while ((line = reader.readLine()) != null && line.equals(separateLine)) {
                            String exceptionName = DefaultDataPersistent.decode(reader.readLine());
                            String className = DefaultDataPersistent.decode(reader.readLine());
                            String lineNum = DefaultDataPersistent.decode(reader.readLine());
                            String detail = DefaultDataPersistent.decode(reader.readLine());
                            Stats.addExceptionInfo(exceptionName, className, lineNum, detail);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Exception e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block30;
                }
            }
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                try {
                    reader.close();
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            try {
                if (!opDbFile.exists()) return;
                fis = new FileInputStream(opDbFile);
                reader = new BufferedReader(new InputStreamReader(fis));
                line = null;
                while (true) {
                    line = reader.readLine();
                    if (line == null) return;
                    if (!line.equals(separateLine)) {
                        return;
                    }
                    String category = DefaultDataPersistent.decode(reader.readLine());
                    String target = DefaultDataPersistent.decode(reader.readLine());
                    String desc = DefaultDataPersistent.decode(reader.readLine());
                    Stats.addOperateInfo(category, target, desc);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (Exception e3) {
                    e3.printStackTrace();
                    return;
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void cleanDB() {
        File basePath = new File(this.getBasePath());
        this.delete(basePath);
    }

    private void delete(File basePath) {
        if (!basePath.exists()) {
            return;
        }
        if (basePath.listFiles() == null || basePath.listFiles().length == 0) {
            basePath.delete();
        } else {
            File[] fileArray = basePath.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.delete(file);
                ++n2;
            }
        }
    }
}

