/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.stats.core;

import at.jta.Regor;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.plist.PListParserFactory;
import com.pandora.stats.core.Activator;
import com.pandora.stats.core.UploadStatsSchedule;
import com.pandora.stats.core.dto.OperateInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.wink.json4j.JSONObject;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class UserTypeStatistics {
    public static final String UPLOAD_USER_TYPE_STATISTICS_TIME = "USER_TYPE_STATISTICS_TIME";
    public static final String USER_TYPE_STATISTICS_SYSTEM_TIME = "USER_TYPE_STATISTICS_SYSTEM_TIME";
    public static final String USER_TYPE_STATISTICS_SYSTEM_COMPETITIVE_CONTENT = "USER_TYPE_STATISTICS_SYSTEM_CONTENT";
    public static final String USER_TYPE_STATISTICS_SYSTEM_OTHER_CONTENT = "USER_TYPE_STATISTICS_OTHER_CONTENT";
    public static final String USER_TYPE_STATISTICS_RESOURCE_TIME = "USER_TYPE_STATISTICS_RESOURCE_TIME";
    public static final String USER_TYPE_STATISTICS_RESOURCE_FILETYPE_CONTENT = "USER_TYPE_STATISTICS_RESOURCE_FILETYPE_CONTENT";
    public static final String USER_TYPE_STATISTICS_RESOURCE_FRAMEWORK_CONTENT = "USER_TYPE_STATISTICS_RESOURCE_FRAMEWORK_CONTENT";
    public static final String FRAMEWORK_REGULAR = "^[a-z]+(([\\.\\-\\_\\s]{1}\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})?([\\.\\_\\-]min)?)?\\.(css|js){1}$";
    public static final int CYCLE_DAYS = 10;
    public static final int MAX_SYSTEM_COUNT = 5000;
    public static final int MAX_RESOURCE_COUNT = 20000;
    public static final String[] WIN_USER_DIR = new String[]{"Desktop", "\u684c\u9762", "AppData/Roaming/Microsoft/Internet Explorer/Quick Launch", "AppData/Roaming/Microsoft/Internet Explorer/Quick Launch/User Pinned/TaskBar", "Application Data/Microsoft/Internet Explorer/Quick Launch", "AppData/Roaming/Microsoft/Internet Explorer/Quick Launch/User Pinned/StartMenu", "AppData/Roaming/Microsoft/Windows/Start Menu", "AppData/Roaming/Microsoft/Windows/Start Menu/Programs", "\u300c\u5f00\u59cb\u300d\u83dc\u5355", "\u300c\u5f00\u59cb\u300d\u83dc\u5355/\u7a0b\u5e8f", "Start Menu", "Start Menu/Programs", "AppData/Roaming", "Application Data"};
    public static final String[] WIN_SYSTEM_DIR = new String[]{"ProgramData/Microsoft/Windows/Start Menu", "ProgramData/Microsoft/Windows/Start Menu/Programs", "Program Files", "Program Files (x86)", "ProgramData"};
    public static final String[] MAC_USER_DIR = new String[]{"Desktop", "Downloads"};
    public static final String[] MAC_SYSTEM_DIR = new String[]{"Applications"};
    public static final String[] COMPETITIVE_KEYS = new String[]{"sublime", "webstorm", "brackets", "dreamweaver", "visual studio", "phonegap", "xdk", "appcan", "apicloud", "zendstudio", "phpstorm"};
    public static final String[] FILEEXTENSION_KEYS = new String[]{"less", "saas", "scss", "php", "jsp", "aspx", "rb", "py", "jade", "ejs", "coffee", "ts", "dart"};
    public static final String[] FRAMEWORK_KEYS = new String[]{"angular", "ionic", "bootstrap", "sea", "require"};
    private static UserTypeStatistics userTypeStatistics = new UserTypeStatistics();
    private Job scanner = null;
    private int needTosleepNum = 0;

    private UserTypeStatistics() {
    }

    public static UserTypeStatistics getInstance() {
        return userTypeStatistics;
    }

    public synchronized void startStatistics() {
        try {
            if (this.scanner == null || this.scanner.getState() == 0) {
                this.scanner = new Job("nonproductive task"){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            UserTypeStatistics.this.log("\u5f00\u59cb list...");
                            long allStart = System.currentTimeMillis();
                            IEclipsePreferences node = EclipseUtil.instanceScope().getNode("com.pandora.stats.core");
                            long lastTime = node.getLong(UserTypeStatistics.UPLOAD_USER_TYPE_STATISTICS_TIME, 0L);
                            long alertDays = UserTypeStatistics.this.numberOfDays(lastTime);
                            if (alertDays >= 10L) {
                                try {
                                    HashSet competitiveResult = new HashSet();
                                    HashSet otherResult = new HashSet();
                                    HashSet<String> competitiveKeys = new HashSet<String>(Arrays.asList(COMPETITIVE_KEYS));
                                    UserTypeStatistics.this.statisticalSystem(competitiveResult, otherResult, competitiveKeys, node);
                                    UserTypeStatistics.this.mainSleep();
                                    HashSet frameworkResult = new HashSet();
                                    HashSet filetypeResult = new HashSet();
                                    HashSet<String> fileextensionKeys = new HashSet<String>(Arrays.asList(FILEEXTENSION_KEYS));
                                    HashSet<String> frameworkKeys = new HashSet<String>(Arrays.asList(FRAMEWORK_KEYS));
                                    UserTypeStatistics.this.statisticalResource(frameworkResult, filetypeResult, fileextensionKeys, frameworkKeys, node);
                                    UserTypeStatistics.this.log(competitiveResult);
                                    UserTypeStatistics.this.log(otherResult);
                                    UserTypeStatistics.this.log(frameworkResult);
                                    UserTypeStatistics.this.log(filetypeResult);
                                    JSONObject json = new JSONObject();
                                    json.put("filetype", filetypeResult);
                                    json.put("framework", frameworkResult);
                                    json.put("competitive", competitiveResult);
                                    json.put("other", otherResult);
                                    json.put("time", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
                                    UserTypeStatistics.this.log(json.toString());
                                    UploadStatsSchedule.getInstance().persistent(new OperateInfo("statistics", "UserType", json.toString()));
                                    node.putLong(UserTypeStatistics.UPLOAD_USER_TYPE_STATISTICS_TIME, System.currentTimeMillis());
                                    node.flush();
                                }
                                catch (Throwable e) {
                                    IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                                }
                            }
                            IdeLog.logError((Plugin)Activator.getDefault(), (String)("list job time: " + (System.currentTimeMillis() - allStart)));
                        }
                        finally {
                            this.schedule(864000000L);
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.scanner.setSystem(true);
                this.scanner.setPriority(50);
                this.scanner.schedule(60000L);
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    private void statisticalSystem(Set<String> competitiveResult, Set<String> otherResult, Set<String> competitiveKeys, IEclipsePreferences node) {
        try {
            long lastTime = node.getLong(USER_TYPE_STATISTICS_SYSTEM_TIME, 0L);
            long alertDays = this.numberOfDays(lastTime);
            if (alertDays >= 10L) {
                long start = System.currentTimeMillis();
                String userHome = System.getProperty("user.home");
                if (PlatformUtil.isWindows()) {
                    this.listDir(competitiveResult, userHome, WIN_USER_DIR, competitiveKeys);
                    this.mainSleep();
                    this.log("list win user Dir\u8017\u65f6: " + (System.currentTimeMillis() - start));
                    start = System.currentTimeMillis();
                    this.listDir(competitiveResult, System.getenv("SystemDrive"), WIN_SYSTEM_DIR, competitiveKeys);
                    this.log("list win system Dir\u8017\u65f6: " + (System.currentTimeMillis() - start));
                    this.mainSleep();
                    start = System.currentTimeMillis();
                    this.listWinRegistry(competitiveResult, competitiveKeys);
                    this.log("list win Registry\u8017\u65f6: " + (System.currentTimeMillis() - start));
                    this.mainSleep();
                    start = System.currentTimeMillis();
                    this.listProcesses(competitiveResult, "tasklist.exe /fo csv /nh", competitiveKeys);
                    this.log("list win Processes\u8017\u65f6: " + (System.currentTimeMillis() - start));
                } else if (PlatformUtil.isMac()) {
                    this.listDir(competitiveResult, userHome, MAC_USER_DIR, competitiveKeys);
                    this.log("list mac user Dir\u8017\u65f6: " + (System.currentTimeMillis() - start));
                    this.mainSleep();
                    start = System.currentTimeMillis();
                    this.listDir(competitiveResult, "/", MAC_SYSTEM_DIR, competitiveKeys);
                    this.log("list mac system Dir\u8017\u65f6: " + (System.currentTimeMillis() - start));
                    this.mainSleep();
                    start = System.currentTimeMillis();
                    this.listMacDock(competitiveResult, competitiveKeys);
                    this.log("list mac Dock\u8017\u65f6: " + (System.currentTimeMillis() - start));
                    this.mainSleep();
                    start = System.currentTimeMillis();
                    this.listProcesses(competitiveResult, "ps axc -eo comm", competitiveKeys);
                    this.log("list mac Processes\u8017\u65f6: " + (System.currentTimeMillis() - start));
                }
                this.mainSleep();
                start = System.currentTimeMillis();
                UserTypeStatistics.listNodeJS(otherResult);
                this.log("list nodejs \u8017\u65f6: " + (System.currentTimeMillis() - start));
                node.put(USER_TYPE_STATISTICS_SYSTEM_COMPETITIVE_CONTENT, competitiveResult.isEmpty() ? "" : StringUtil.join((String)",", competitiveResult));
                node.put(USER_TYPE_STATISTICS_SYSTEM_OTHER_CONTENT, otherResult.isEmpty() ? "" : StringUtil.join((String)",", otherResult));
                node.put(USER_TYPE_STATISTICS_SYSTEM_TIME, String.valueOf(System.currentTimeMillis()));
                node.flush();
            } else {
                String competitive = node.get(USER_TYPE_STATISTICS_SYSTEM_COMPETITIVE_CONTENT, null);
                String other = node.get(USER_TYPE_STATISTICS_SYSTEM_OTHER_CONTENT, null);
                if (StringUtil.isNotBlank((String)competitive)) {
                    competitiveResult.addAll(Arrays.asList(competitive.split(",")));
                }
                this.mainSleep();
                if (StringUtil.isNotBlank((String)other)) {
                    otherResult.addAll(Arrays.asList(other.split(",")));
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    private void statisticalResource(final Set<String> frameworkResult, final Set<String> filetypeResult, final Set<String> fileExtensionKeys, final Set<String> frameworkKeys, IEclipsePreferences node) {
        long start;
        block7: {
            start = System.currentTimeMillis();
            try {
                long lastTime = node.getLong(USER_TYPE_STATISTICS_RESOURCE_TIME, 0L);
                long alertDays = this.numberOfDays(lastTime);
                if (alertDays >= 10L) {
                    final long[] num = new long[1];
                    try {
                        ResourcesPlugin.getWorkspace().getRoot().accept(new IResourceProxyVisitor(){

                            public boolean visit(IResourceProxy resource) throws CoreException {
                                int type = resource.getType();
                                if (resource.getType() == 1) {
                                    String name = resource.getName().toLowerCase();
                                    UserTypeStatistics.this.filterExtensionName(filetypeResult, name, fileExtensionKeys);
                                    if (name.endsWith(".css") || name.endsWith(".js")) {
                                        UserTypeStatistics.this.filterFrameworkName(frameworkResult, name, frameworkKeys);
                                    }
                                }
                                UserTypeStatistics.this.subSleep();
                                num[0] = num[0] + 1L;
                                if (num[0] >= 20000L) {
                                    throw new IllegalArgumentException("\u8d85\u51fa\u6570\u91cf\u4e0a\u9650");
                                }
                                if (type == 2 && "node_modules".equals(resource.getName().toLowerCase())) {
                                    return false;
                                }
                                return type == 8 || type == 2 || type == 4;
                            }
                        }, 0);
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                    node.put(USER_TYPE_STATISTICS_RESOURCE_FRAMEWORK_CONTENT, frameworkResult.isEmpty() ? "" : StringUtil.join((String)",", frameworkResult));
                    node.put(USER_TYPE_STATISTICS_RESOURCE_FILETYPE_CONTENT, filetypeResult.isEmpty() ? "" : StringUtil.join((String)",", filetypeResult));
                    node.put(USER_TYPE_STATISTICS_RESOURCE_TIME, String.valueOf(System.currentTimeMillis()));
                    node.flush();
                    this.log("\u603b\u6587\u4ef6\u6570: " + num[0]);
                    break block7;
                }
                String framework = node.get(USER_TYPE_STATISTICS_RESOURCE_FRAMEWORK_CONTENT, null);
                String fileType = node.get(USER_TYPE_STATISTICS_RESOURCE_FILETYPE_CONTENT, null);
                if (StringUtil.isNotBlank((String)framework)) {
                    frameworkResult.addAll(Arrays.asList(framework.split(",")));
                }
                this.mainSleep();
                if (StringUtil.isNotBlank((String)fileType)) {
                    filetypeResult.addAll(Arrays.asList(fileType.split(",")));
                }
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
        this.log("list resource\u8017\u65f6: " + (System.currentTimeMillis() - start));
    }

    private long numberOfDays(long lastTime) {
        return (System.currentTimeMillis() - lastTime) / 86400000L;
    }

    private void listDir(final Set<String> competitiveResult, String root, String[] toList, final Set<String> competitiveKeys) {
        if (!competitiveKeys.isEmpty()) {
            String[] stringArray = toList;
            int n = toList.length;
            int n2 = 0;
            while (n2 < n) {
                String f = stringArray[n2];
                try {
                    File dir = new File(root, f);
                    if (dir.exists()) {
                        final long[] num = new long[1];
                        dir.list(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                block3: {
                                    num[0] = num[0] + 1L;
                                    if (num[0] < 5000L) break block3;
                                    return false;
                                }
                                try {
                                    UserTypeStatistics.this.filterName(competitiveResult, name, competitiveKeys);
                                }
                                catch (Throwable e) {
                                    IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                                }
                                return false;
                            }
                        });
                    }
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                }
                ++n2;
            }
        }
    }

    private void listWinRegistry(Set<String> competitiveResult, Set<String> competitiveKeys) {
        try {
            if (!competitiveKeys.isEmpty()) {
                Regor regor = new Regor();
                List list = regor.listKeys(Regor.HKEY_CURRENT_USER, "Software");
                long num = 0L;
                for (Object key : list) {
                    try {
                        if (++num >= 5000L) {
                            return;
                        }
                        this.filterName(competitiveResult, key.toString(), competitiveKeys);
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    private void listMacDock(Set<String> competitiveResult, Set<String> competitiveKeys) {
        try {
            Map map;
            Object apps;
            File dockList;
            if (!competitiveKeys.isEmpty() && (dockList = new File("/Users/IDE/Library/Preferences/com.apple.dock.plist")).exists() && dockList.canRead() && (apps = (map = PListParserFactory.parse((File)dockList)).get("persistent-apps")) != null && apps instanceof List) {
                for (Object app : (List)apps) {
                    Object tileData;
                    if (!(app instanceof Map) || !((tileData = ((Map)app).get("tile-data")) instanceof Map)) continue;
                    String fileLabel = (String)((Map)tileData).get("file-label");
                    this.filterName(competitiveResult, fileLabel.toString(), competitiveKeys);
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    private void listProcesses(Set<String> competitiveResult, String command, Set<String> competitiveKeys) {
        if (!competitiveKeys.isEmpty()) {
            ArrayList<String> processes;
            block17: {
                processes = new ArrayList<String>();
                Process p = null;
                BufferedReader input = null;
                try {
                    try {
                        String line;
                        p = Runtime.getRuntime().exec(command);
                        input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        while ((line = input.readLine()) != null) {
                            processes.add(line);
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                        IOUtils.closeQuietly(input);
                        if (p != null) {
                            try {
                                p.destroy();
                            }
                            catch (Throwable e2) {
                                IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e2);
                            }
                        }
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(input);
                    if (p != null) {
                        try {
                            p.destroy();
                        }
                        catch (Throwable e) {
                            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)input);
                if (p != null) {
                    try {
                        p.destroy();
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    }
                }
            }
            for (String processe : processes) {
                this.filterName(competitiveResult, processe, competitiveKeys);
            }
        }
    }

    private static boolean listNodeJS(Set<String> otherResult) {
        block19: {
            BufferedReader input = null;
            Process p = null;
            try {
                p = Runtime.getRuntime().exec("node -v");
                input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                String line = input.readLine();
                if (line != null && line != null && line.startsWith("v")) {
                    otherResult.add("nodejs");
                }
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(input);
                if (p != null) {
                    try {
                        p.destroy();
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    }
                }
                break block19;
            }
            catch (Throwable e) {
                try {
                    IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                    break block19;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    IOUtils.closeQuietly(input);
                    if (p != null) {
                        try {
                            p.destroy();
                        }
                        catch (Throwable e2) {
                            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e2);
                        }
                    }
                }
            }
            IOUtils.closeQuietly((Reader)input);
            if (p != null) {
                try {
                    p.destroy();
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
                }
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean filterName(Set<String> result, String name, Set<String> keys) {
        try {
            String key;
            if (keys.isEmpty()) return false;
            Iterator<String> it = keys.iterator();
            do {
                if (!it.hasNext()) {
                    this.subSleep();
                    return false;
                }
                key = it.next();
            } while (!name.toLowerCase().contains(key));
            result.add(key);
            it.remove();
            return true;
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean filterExtensionName(Set<String> result, String name, Set<String> keys) {
        try {
            String key;
            if (keys.isEmpty()) return false;
            Iterator<String> it = keys.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!name.endsWith("." + (key = it.next())));
            result.add(key);
            it.remove();
            return true;
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean filterFrameworkName(Set<String> result, String name, Set<String> keys) {
        try {
            String key;
            if (keys.isEmpty()) return false;
            Iterator<String> it = keys.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!name.startsWith(key = it.next()) || !name.matches(FRAMEWORK_REGULAR));
            result.add(key);
            it.remove();
            return true;
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
        return false;
    }

    private void subSleep() {
        try {
            if (++this.needTosleepNum == 20) {
                Thread.sleep(10L);
                this.needTosleepNum = 0;
            }
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    private void mainSleep() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
        }
    }

    private void log(Object message) {
        if (Platform.inDevelopmentMode()) {
            System.out.println(message);
        }
    }
}

