/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.stats.core;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.httpclient.HttpClientUtils;
import com.pandora.core.httpclient.ResponseObj;
import com.pandora.stats.core.Activator;
import com.pandora.stats.core.Messages;
import com.pandora.stats.core.UserTypeStatistics;
import com.pandora.stats.core.api.Stats;
import com.pandora.stats.core.dto.EnvironmentInfo;
import com.pandora.stats.core.dto.ExceptionInfo;
import com.pandora.stats.core.dto.OperateInfo;
import com.pandora.stats.core.exception.UploadFailedException;
import com.pandora.stats.core.manage.StatsInfoManage;
import com.pandora.stats.core.persistent.impl.DefaultDataPersistent;
import com.pandora.stats.core.utils.ListUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;

public class UploadStatsSchedule
implements IStartup {
    private static final long START_DELAY = 10000L;
    private static final long CIRCLE = 600000L;
    private static final long TEST_CIRCLE = 600000L;
    private static UploadStatsSchedule instance;
    private static Object lock;
    private Job job = null;
    private DefaultDataPersistent dataPersistent = new DefaultDataPersistent();

    static {
        lock = new Object();
    }

    public static UploadStatsSchedule getInstance() {
        return instance;
    }

    public void execute() {
        this.handleDataStatsUpload();
    }

    public void schedule() {
        this.job = new Job(Messages.UploadStatsSchedule_StatsStart){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        UploadStatsSchedule.this.handleDataStatsUpload();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    if (PlatformUI.isWorkbenchRunning()) {
                        if (Platform.inDevelopmentMode()) {
                            this.schedule(600000L);
                        } else {
                            this.schedule(600000L);
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
        this.job.setSystem(true);
        if (Platform.inDevelopmentMode()) {
            this.job.schedule(10000L);
        } else {
            this.job.schedule(10000L);
        }
        UserTypeStatistics.getInstance().startStatistics();
    }

    protected synchronized void handleDataStatsUpload() {
        try {
            try {
                this.uploadMemoryData();
                StatsInfoManage.instance().reinit();
            }
            catch (UploadFailedException uploadFailedException) {
                this.dataPersistent.persistent(StatsInfoManage.instance().getInfos());
                StatsInfoManage.instance().reinit();
                return;
            }
            this.uploadHardWareData(this.dataPersistent.getBasePath());
            this.dataPersistent.cleanDB();
        }
        catch (Exception e) {
            Stats.addExceptionInfo(e);
        }
    }

    private void uploadMemoryData() throws UploadFailedException {
        Map<String, List<Object>> infosInMemory = StatsInfoManage.instance().getInfos();
        List<Object> exInfosObj = infosInMemory.get("exception");
        List<ExceptionInfo> exinfos = ListUtils.convertTo(exInfosObj, ExceptionInfo.class);
        List<Object> opInfosObj = infosInMemory.get("operate");
        List<OperateInfo> opInfos = ListUtils.convertTo(opInfosObj, OperateInfo.class);
        UploadStatsSchedule.uploadNow(exinfos, opInfos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadNow(List<ExceptionInfo> exinfos, List<OperateInfo> opInfos) throws UploadFailedException {
        Object object = lock;
        synchronized (object) {
            HttpClientUtils client = HttpClientUtils.getInstance((String)"StatsAction!stats");
            client.addRequestheader("account", UserAuth.isLoginSucess() == -2 ? UserAuth.getToken() : UserAuth.getUsername());
            if (exinfos != null && !exinfos.isEmpty()) {
                client.addClassInfoRequestBody(ExceptionInfo.class, exinfos);
            }
            if (opInfos != null && !opInfos.isEmpty()) {
                client.addClassInfoRequestBody(OperateInfo.class, opInfos);
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("type", "StatsInfo");
            map.put("desc", "");
            client.addRequestBody(map);
            try {
                ResponseObj rsp = client.excute();
                Assert.isNotNull((Object)rsp);
                if ("999".equals(rsp.getRspcode())) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), (String)("Feedback Failed:" + rsp.getRspcode()));
                    throw new UploadFailedException(rsp.getRspcode());
                }
            }
            catch (Exception e) {
                if (!(e instanceof UploadFailedException)) {
                    Stats.addExceptionInfo(e);
                }
                throw new UploadFailedException();
            }
        }
    }

    private void uploadHardWareData(String basePath) throws UploadFailedException {
        block9: {
            File file = new File(basePath);
            if (this.dataPersistent.haveDbFile(basePath)) {
                try {
                    try {
                        this.dataPersistent.load(basePath);
                        this.uploadMemoryData();
                        this.dataPersistent.deleteFile(basePath);
                        break block9;
                    }
                    catch (IOException iOException) {
                        throw new UploadFailedException();
                    }
                    catch (UploadFailedException e) {
                        throw e;
                    }
                }
                finally {
                    StatsInfoManage.instance().reinit();
                }
            }
            if (file.listFiles() != null) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    this.uploadHardWareData(f.getAbsolutePath());
                    ++n2;
                }
            }
        }
    }

    public void earlyStartup() {
        instance = this;
        ILog log = Activator.getDefault().getLog();
        log.log((IStatus)new Status(1, "com.pandora.stats.core", Messages.UploadStatsSchedule_8));
        this.initialize();
        this.schedule();
    }

    private void initialize() {
        EnvironmentInfo.getDefault();
    }

    public synchronized void persistent(OperateInfo operateInfo) throws IOException {
        StatsInfoManage.instance().recordOperate(operateInfo);
        this.dataPersistent.persistent(StatsInfoManage.instance().getInfos());
        StatsInfoManage.instance().reinit();
    }
}

