/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.theme.internal.ControlThemer;
import com.aptana.ui.util.SWTUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;

public class StyledFontThemer
extends ControlThemer {
    int fontStyle;
    Font styledFont = null;
    Font defaultStyledFont = null;

    public StyledFontThemer(Control control, int fontStyle, Color defaultBg) {
        super(control, defaultBg);
        this.fontStyle = fontStyle;
        this.defaultStyledFont = new Font((Device)control.getDisplay(), SWTUtils.styleFont((Font)control.getFont(), (int)fontStyle));
    }

    @Override
    protected void applyControlFont() {
        if (!this.controlIsDisposed()) {
            if (this.useEditorFont()) {
                this.getControl().setFont(this.getFont());
            } else {
                this.getControl().setFont(this.defaultStyledFont);
            }
        }
    }

    @Override
    protected Font getFont() {
        Font font = super.getFont();
        FontData[] fontData = SWTUtils.styleFont((Font)font, (int)this.fontStyle);
        if (this.styledFont != null && !this.fontDataEquals(fontData, this.styledFont.getFontData())) {
            this.styledFont.dispose();
            this.styledFont = null;
        }
        if (this.styledFont == null) {
            this.styledFont = new Font((Device)this.getControl().getDisplay(), fontData);
        }
        return this.styledFont;
    }

    private boolean fontDataEquals(FontData[] fd1, FontData[] fd2) {
        if (fd1 != null && fd2 != null && fd1.length == fd2.length) {
            int i = 0;
            while (i < fd1.length) {
                if (!fd1[i].equals((Object)fd2[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    protected void unapplyControlFont() {
        if (!this.controlIsDisposed()) {
            this.getControl().setFont(this.defaultStyledFont != null && !this.defaultStyledFont.isDisposed() ? this.defaultStyledFont : null);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.styledFont != null && !this.styledFont.isDisposed()) {
            this.styledFont.dispose();
        }
        if (this.defaultStyledFont != null && !this.defaultStyledFont.isDisposed()) {
            this.defaultStyledFont.dispose();
        }
    }
}

