/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme.internal;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.theme.ColorManager;
import com.aptana.theme.IControlThemerFactory;
import com.aptana.theme.Theme;
import com.aptana.theme.ThemePlugin;
import com.aptana.ui.util.UIUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.console.ConsoleView;
import org.eclipse.ui.internal.progress.ProgressView;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.properties.PropertySheet;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class InvasiveThemeHijacker
extends UIJob
implements IPartListener2,
IEclipsePreferences.IPreferenceChangeListener,
IStartup,
IPageChangedListener {
    private static final String ORG_ECLIPSE_WST_JSDT_UI = "org.eclipse.wst.jsdt.ui";
    private static final String ORG_ECLIPSE_JDT_UI = "org.eclipse.jdt.ui";
    private static final String ORG_ECLIPSE_ANT_UI = "org.eclipse.ant.ui";
    private static final String ORG_ECLIPSE_PDE_UI = "org.eclipse.pde.ui";
    private ISelectionChangedListener pageListener;
    private Map<IViewPart, IQueryListener> queryListeners = new HashMap<IViewPart, IQueryListener>(3);
    private boolean fIsPartListener;
    private static boolean ranEarlyStartup = false;

    public InvasiveThemeHijacker() {
        super("Installing invasive theme hijacker!");
        EclipseUtil.setSystemForJob((Job)this);
    }

    protected boolean applyToViews() {
        return ThemePlugin.applyToViews();
    }

    public synchronized IStatus runInUIThread(IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)4);
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && window.getActivePage() != null) {
            if (this.fIsPartListener && !this.applyToAllEditors() && !this.applyToViews()) {
                window.getActivePage().removePartListener((IPartListener2)this);
                this.fIsPartListener = false;
            } else if (!this.fIsPartListener) {
                window.getActivePage().addPartListener((IPartListener2)this);
                this.fIsPartListener = true;
            }
        }
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        sub.setWorkRemaining(3);
        this.applyThemeToEclipseEditors(this.getCurrentTheme(), !this.applyToAllEditors(), (IProgressMonitor)sub.newChild(1));
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.applyThemeToConsole(this.getCurrentTheme(), !this.applyToViews(), (IProgressMonitor)sub.newChild(1));
        if (sub.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        this.hijackCurrentViews(window, !this.applyToViews(), (IProgressMonitor)sub.newChild(1));
        sub.done();
        return Status.OK_STATUS;
    }

    public void initApplyTeme() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            this.applyThemeToConsole(this.getCurrentTheme(), !this.applyToViews(), null);
            this.hijackCurrentViews(window, !this.applyToViews(), null);
        }
    }

    private boolean applyToAllEditors() {
        return ThemePlugin.applyToAllEditors();
    }

    private void applyThemeToConsole(Theme currentTheme, boolean revertToDefaults, IProgressMonitor monitor) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("org.eclipse.debug.ui");
        if (revertToDefaults) {
            prefs.remove("org.eclipse.debug.ui.errorColor");
            prefs.remove("org.eclipse.debug.ui.outColor");
            prefs.remove("org.eclipse.debug.ui.inColor");
            prefs.remove("org.eclipse.debug.ui.consoleBackground");
            prefs.remove("org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND");
        } else {
            this.setColor(prefs, "org.eclipse.debug.ui.errorColor", currentTheme, "console.error", currentTheme.getForegroundAsRGB("console.error"));
            this.setColor(prefs, "org.eclipse.debug.ui.outColor", currentTheme, "console.output", currentTheme.getForeground());
            this.setColor(prefs, "org.eclipse.debug.ui.inColor", currentTheme, "console.input", currentTheme.getForegroundAsRGB("console.input"));
            prefs.put("org.eclipse.debug.ui.consoleBackground", StringConverter.asString((RGB)currentTheme.getBackground()));
            prefs.put("org.eclipse.debug.ui.PREF_CHANGED_VALUE_BACKGROUND", StringConverter.asString((RGB)currentTheme.getBackgroundAsRGB("markup.changed.variable")));
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void setColor(IEclipsePreferences prefs, String prefKey, Theme currentTheme, String tokenName, RGB defaultColor) {
        RGB rgb = defaultColor;
        if (currentTheme.hasEntry(tokenName)) {
            rgb = currentTheme.getForegroundAsRGB(tokenName);
        }
        prefs.put(prefKey, StringConverter.asString((RGB)rgb));
    }

    protected void hijackCurrentViews(IWorkbenchWindow window, boolean revertToDefaults, IProgressMonitor monitor) {
        IEditorReference[] editorRefs;
        IViewReference[] refs;
        if (window == null || window.getActivePage() == null) {
            return;
        }
        IViewReference[] iViewReferenceArray = refs = window.getActivePage().getViewReferences();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            this.hijackView(ref.getView(false), revertToDefaults);
            ++n2;
        }
        IEditorReference[] iEditorReferenceArray = editorRefs = window.getActivePage().getEditorReferences();
        int n3 = editorRefs.length;
        n = 0;
        while (n < n3) {
            IEditorReference ref = iEditorReferenceArray[n];
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            this.hijackEditor(ref.getEditor(false), revertToDefaults);
            ++n;
        }
    }

    protected void hijackView(IViewPart view, boolean revertToDefaults) {
        if (view == null || !this.applyToViews()) {
            return;
        }
        if (view instanceof IResourceNavigator) {
            IResourceNavigator navigator = (IResourceNavigator)view;
            this.hookTheme((Viewer)navigator.getViewer(), revertToDefaults);
            return;
        }
        if (view instanceof ExtendedMarkersView) {
            if (new Version(EclipseUtil.getPluginVersion((String)"org.eclipse.ui.ide")).compareTo(Version.parseVersion((String)"3.6.0")) >= 0) {
                try {
                    Method m = ExtendedMarkersView.class.getDeclaredMethod("getViewer", new Class[0]);
                    m.setAccessible(true);
                    TreeViewer treeViewer = (TreeViewer)m.invoke((Object)view, new Object[0]);
                    this.hookTheme((Viewer)treeViewer, revertToDefaults);
                }
                catch (Exception exception) {}
            }
            return;
        }
        if (view instanceof ProgressView) {
            try {
                Method m = ProgressView.class.getDeclaredMethod("getViewer", new Class[0]);
                m.setAccessible(true);
                Viewer treeViewer = (Viewer)m.invoke((Object)view, new Object[0]);
                this.hookTheme(treeViewer, revertToDefaults);
            }
            catch (Exception exception) {}
            return;
        }
        if (view instanceof ContentOutline) {
            ContentOutline outline = (ContentOutline)view;
            IPage page = outline.getCurrentPage();
            String name = page.getClass().getName();
            if (name.endsWith("CommonOutlinePage") || name.endsWith("PyOutlinePage")) {
                return;
            }
            Control control = page.getControl();
            if (control instanceof PageBook) {
                PageBook book = (PageBook)control;
                Control[] children = book.getChildren();
                if (children != null && children.length > 0) {
                    Control[] controlArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control child = controlArray[n2];
                        this.hookTheme(child, revertToDefaults);
                        ++n2;
                    }
                }
                return;
            }
            if (page instanceof MessagePage) {
                control = ((Composite)control).getChildren()[0];
            }
            this.hookTheme(control, revertToDefaults);
            return;
        }
        if (view instanceof PropertySheet) {
            PropertySheet outline = (PropertySheet)view;
            IPage page = outline.getCurrentPage();
            this.hookTheme(page.getControl(), revertToDefaults);
            return;
        }
        if (view instanceof IDebugView) {
            IDebugView debug = (IDebugView)view;
            Viewer viewer = debug.getViewer();
            this.hookTheme(viewer, revertToDefaults);
            return;
        }
        if (view instanceof MemoryView) {
            IMemoryViewPane[] memPaneArray;
            MemoryView memory = (MemoryView)view;
            IMemoryViewPane[] iMemoryViewPaneArray = memPaneArray = memory.getViewPanes();
            int n = memPaneArray.length;
            int n3 = 0;
            while (n3 < n) {
                IMemoryViewPane memPane = iMemoryViewPaneArray[n3];
                this.hookTheme(memPane.getControl(), revertToDefaults);
                ++n3;
            }
            return;
        }
        if (view instanceof ConsoleView) {
            this.hijackConsole(view);
            return;
        }
        if (view.getClass().getName().equals("org.eclipse.search2.internal.ui.SearchView")) {
            this.hijackSearchView(view, revertToDefaults);
            return;
        }
        if (view.getClass().getName().equals("org.eclipse.ui.navigator.resources.ProjectExplorer")) {
            try {
                Method m = view.getClass().getMethod("getCommonViewer", new Class[0]);
                TreeViewer treeViewer = (TreeViewer)m.invoke((Object)view, new Object[0]);
                this.hookTheme((Viewer)treeViewer, revertToDefaults);
            }
            catch (Exception exception) {}
            return;
        }
        if (view.getClass().getName().equals("org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart")) {
            try {
                Method m = view.getClass().getMethod("getTreeViewer", new Class[0]);
                TreeViewer treeViewer = (TreeViewer)m.invoke((Object)view, new Object[0]);
                this.hookTheme((Viewer)treeViewer, revertToDefaults);
            }
            catch (Exception exception) {}
            return;
        }
        if (view.getClass().getName().endsWith("CallHierarchyViewPart")) {
            this.hijackCallHierarchy(view, revertToDefaults);
            return;
        }
        if (view.getClass().getName().endsWith("TypeHierarchyViewPart")) {
            this.hijackCallHierarchy(view, revertToDefaults);
            return;
        }
    }

    protected void hijackSearchView(final IViewPart view, final boolean revertToDefaults) {
        IQueryListener listener;
        PageBookView outline = (PageBookView)view;
        IPage page = outline.getCurrentPage();
        if (page != null) {
            if (page instanceof AbstractTextSearchViewPage) {
                try {
                    AbstractTextSearchViewPage blah = (AbstractTextSearchViewPage)page;
                    Method m = blah.getClass().getDeclaredMethod("getViewer", new Class[0]);
                    m.setAccessible(true);
                    Viewer v = (Viewer)m.invoke((Object)blah, new Object[0]);
                    this.hookTheme(v, revertToDefaults);
                }
                catch (Exception exception) {}
            } else {
                if (page.getClass().getName().endsWith("EmptySearchView")) {
                    Composite comp = (Composite)page.getControl();
                    Control label = comp.getChildren()[0];
                    this.hookTheme(label, revertToDefaults);
                    comp.layout();
                }
                this.hookTheme(page.getControl(), revertToDefaults);
            }
        }
        if ((listener = this.queryListeners.get(view)) == null) {
            listener = new IQueryListener(){

                public void queryStarting(ISearchQuery query) {
                }

                public void queryRemoved(ISearchQuery query) {
                    InvasiveThemeHijacker.this.hijackView(view, revertToDefaults);
                }

                public void queryFinished(ISearchQuery query) {
                }

                public void queryAdded(ISearchQuery query) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            InvasiveThemeHijacker.this.hijackView(view, revertToDefaults);
                        }
                    });
                }
            };
            NewSearchUI.addQueryListener((IQueryListener)listener);
            this.queryListeners.put(view, listener);
        }
    }

    protected void hijackCallHierarchy(IViewPart view, boolean revertToDefaults) {
        try {
            Field f = view.getClass().getDeclaredField("fPagebook");
            f.setAccessible(true);
            PageBook pageBook = (PageBook)f.get(view);
            f = pageBook.getClass().getDeclaredField("currentPage");
            f.setAccessible(true);
            Control control = (Control)f.get(pageBook);
            if (control instanceof Label) {
                this.hookTheme(control, revertToDefaults);
                return;
            }
            Method m = view.getClass().getMethod("getViewer", new Class[0]);
            TreeViewer treeViewer = (TreeViewer)m.invoke((Object)view, new Object[0]);
            this.hookTheme((Viewer)treeViewer, revertToDefaults);
            m = view.getClass().getDeclaredMethod("getLocationViewer", new Class[0]);
            if (m != null) {
                m.setAccessible(true);
                Viewer viewer = (Viewer)m.invoke((Object)view, new Object[0]);
                this.hookTheme(viewer, revertToDefaults);
            }
        }
        catch (Exception exception) {}
    }

    protected void hookTheme(Control control, boolean revert) {
        if (revert) {
            this.getControlThemerFactory().dispose(control);
        } else {
            this.getControlThemerFactory().apply(control);
        }
    }

    protected void hookTheme(Viewer viewer, boolean revert) {
        if (revert) {
            this.getControlThemerFactory().dispose(viewer);
        } else {
            this.getControlThemerFactory().apply(viewer);
        }
    }

    protected IControlThemerFactory getControlThemerFactory() {
        return ThemePlugin.getDefault().getControlThemerFactory();
    }

    protected Theme getCurrentTheme() {
        return ThemePlugin.getDefault().getThemeManager().getCurrentTheme();
    }

    protected void applyThemeToEclipseEditors(Theme theme, boolean revertToDefaults, IProgressMonitor monitor) {
        Bundle wstBundle;
        this.setHyperlinkValues(theme, EclipseUtil.instanceScope().getNode("org.eclipse.ui.workbench"), revertToDefaults);
        this.setHyperlinkValues(theme, EclipseUtil.instanceScope().getNode("com.aptana.theme"), revertToDefaults);
        this.setGitAndMercurialValues(theme, EclipseUtil.instanceScope().getNode("org.eclipse.ui.workbench"), revertToDefaults);
        this.setGeneralEditorValues(theme, EclipseUtil.instanceScope().getNode("org.eclipse.ui.texteditor"), revertToDefaults);
        this.setEditorValues(theme, EclipseUtil.instanceScope().getNode("org.eclipse.ui.editors"), revertToDefaults);
        if (monitor.isCanceled()) {
            return;
        }
        Bundle pde = Platform.getBundle((String)ORG_ECLIPSE_PDE_UI);
        if (pde != null) {
            IEclipsePreferences pdePrefs = EclipseUtil.instanceScope().getNode(ORG_ECLIPSE_PDE_UI);
            this.setGeneralEditorValues(theme, pdePrefs, revertToDefaults);
            this.setPDEEditorValues(theme, pdePrefs, revertToDefaults);
        }
        if (monitor.isCanceled()) {
            return;
        }
        Bundle ant = Platform.getBundle((String)ORG_ECLIPSE_ANT_UI);
        if (ant != null) {
            IEclipsePreferences antPrefs = EclipseUtil.instanceScope().getNode(ORG_ECLIPSE_ANT_UI);
            this.setGeneralEditorValues(theme, antPrefs, revertToDefaults);
            this.setAntEditorValues(theme, antPrefs, revertToDefaults);
        }
        if (monitor.isCanceled()) {
            return;
        }
        Bundle jdt = Platform.getBundle((String)ORG_ECLIPSE_JDT_UI);
        if (jdt != null) {
            this.applyThemetoJDT(theme, revertToDefaults);
        }
        if ((wstBundle = Platform.getBundle((String)ORG_ECLIPSE_WST_JSDT_UI)) != null) {
            this.applyThemetoWST(theme, revertToDefaults);
        }
    }

    protected void applyThemetoWST(Theme theme, boolean revertToDefaults) {
        this.applyToWST_JSDTEditor(theme, revertToDefaults);
        this.applyToWST_CSSEditor(theme, revertToDefaults);
        this.applyToWST_HTMLEditor(theme, revertToDefaults);
        this.applyToWST_XMLEditor(theme, revertToDefaults);
    }

    private void applyToWST_HTMLEditor(Theme theme, boolean revertToDefaults) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("org.eclipse.wst.html.ui");
        this.setGeneralEditorValues(theme, prefs, revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.definition.tag.html", "tagBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.name.tag.html", "tagName", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.other.attribute-name.html", "tagAttributeName", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.separator.key-value.html", "tagAttributeEquals", revertToDefaults);
        this.setWSTToken(prefs, theme, "string.quoted.html", "tagAttributeValue", revertToDefaults);
        this.setWSTToken(prefs, theme, "text.html", "xmlContent", revertToDefaults);
        this.setWSTToken(prefs, theme, "comment.block.html", "commentBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "comment.block.html", "commentText", revertToDefaults);
        this.setWSTToken(prefs, theme, "constant.character.entity.html", "entityReference", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.name.tag.doctype.html", "doctypeName", revertToDefaults);
        this.setWSTToken(prefs, theme, "text.html", "doctypeExternalPubref", revertToDefaults);
        this.setWSTToken(prefs, theme, "text.html", "doctypeExtrenalSysref", revertToDefaults);
        this.setWSTToken(prefs, theme, "text.html", "doctypeExternalId", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.definition.tag.html", "declBoder", revertToDefaults);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void applyToWST_JSDTEditor(Theme theme, boolean revertToDefaults) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(ORG_ECLIPSE_WST_JSDT_UI);
        this.setGeneralEditorValues(theme, prefs, revertToDefaults);
        this.setToken(prefs, theme, "source.js", "java_default", revertToDefaults);
        this.setToken(prefs, theme, "comment.line.double-slash.js", "java_single_line_comment", revertToDefaults);
        this.setToken(prefs, theme, "comment.block", "java_multi_line_comment", revertToDefaults);
        this.setToken(prefs, theme, "string.quoted.double.js", "java_string", revertToDefaults);
        this.setToken(prefs, theme, "keyword", "java_keyword", revertToDefaults);
        this.setToken(prefs, theme, "keyword.operator", "java_operator", revertToDefaults);
        this.setToken(prefs, theme, "keyword.control.js", "java_keyword_return", revertToDefaults);
        this.setToken(prefs, theme, "punctuation.bracket.js", "java_bracket", revertToDefaults);
        this.setToken(prefs, theme, "keyword.other.documentation.task", "commentTaskTag", revertToDefaults);
        this.setToken(prefs, theme, "keyword.other.documentation.js", "java_doc_keyword", revertToDefaults);
        this.setToken(prefs, theme, "entity.name.tag.inline.any.html", "java_doc_tag", revertToDefaults);
        this.setToken(prefs, theme, "markup.underline.link.javadoc", "java_doc_link", revertToDefaults);
        this.setToken(prefs, theme, "comment.block.documentation.javadoc", "java_doc_default", revertToDefaults);
        this.setToken(prefs, theme, "meta.tag.documentation.js", "tagName", revertToDefaults);
        this.setSemanticToken(prefs, theme, "entity.name.function.js", "methodDeclarationName", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.js", "localVariable", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.js", "localVariableDeclaration", revertToDefaults);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void applyToWST_CSSEditor(Theme theme, boolean revertToDefaults) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("org.eclipse.wst.css.ui");
        this.setGeneralEditorValues(theme, prefs, revertToDefaults);
        this.setWSTToken(prefs, theme, "meta.property-name.css support.type.property-name.css", "PROPERTY_NAME", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.other.attribute-name.class.css", "CLASS", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "ATTRIBUTE_VALUE", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "UNIVERSAL", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.css", "COMBINATOR", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.terminator.rule.css", "SEMI_COLON", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.bracket.css", "ATTRIBUTE_DELIM", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.name.tag.css", "SELECTOR", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "URI", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "ATTRIBUTE_NAME", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.separator.key-value.css", "COLON", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.other.attribute-name.id.css", "ID", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "NORMAL", revertToDefaults);
        this.setWSTToken(prefs, theme, "string.quoted.css", "STRING", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.section.property-list.css", "CURLY_BRACE", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "PSEUDO", revertToDefaults);
        this.setWSTToken(prefs, theme, "comment.block.css", "COMMENT", revertToDefaults);
        this.setWSTToken(prefs, theme, "support.constant.property-value.css", "PROPERTY_VALUE", revertToDefaults);
        this.setWSTToken(prefs, theme, "keyword.control.at-rule.css", "ATMARK_RULE", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.css", "ATTRIBUTE_OPERATOR", revertToDefaults);
        this.setWSTToken(prefs, theme, "support.constant.media.css", "MEDIA", revertToDefaults);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void applyToWST_XMLEditor(Theme theme, boolean revertToDefaults) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("org.eclipse.wst.xml.ui");
        this.setGeneralEditorValues(theme, prefs, revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.definition.tag.xml", "tagBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.name.tag.xml", "tagName", revertToDefaults);
        this.setWSTToken(prefs, theme, "entity.other.attribute-name.xml", "tagAttributeName", revertToDefaults);
        this.setWSTToken(prefs, theme, "punctuation.separator.key-value.xml", "tagAttributeEquals", revertToDefaults);
        this.setWSTToken(prefs, theme, "string.quoted.xml", "tagAttributeValue", revertToDefaults);
        this.setWSTToken(prefs, theme, "text.xml", "xmlContent", revertToDefaults);
        this.setWSTToken(prefs, theme, "comment.block.xml", "commentBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "comment.block.xml", "commentText", revertToDefaults);
        this.setWSTToken(prefs, theme, "constant.character.entity.xml", "entityReference", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.dtd", "doctypeName", revertToDefaults);
        this.setWSTToken(prefs, theme, "keyword.operator.dtd", "doctypeExternalPubref", revertToDefaults);
        this.setWSTToken(prefs, theme, "keyword.operator.dtd", "doctypeExtrenalSysref", revertToDefaults);
        this.setWSTToken(prefs, theme, "keyword.operator.dtd", "doctypeExternalId", revertToDefaults);
        this.setWSTToken(prefs, theme, "source.dtd", "declBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "string.unquoted.cdata.xml", "cdataBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "string.unquoted.cdata.xml", "cdataText", revertToDefaults);
        this.setWSTToken(prefs, theme, "meta.tag.preprocessor.xml", "piBorder", revertToDefaults);
        this.setWSTToken(prefs, theme, "meta.tag.preprocessor.xml", "piContent", revertToDefaults);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void applyThemetoJDT(Theme theme, boolean revertToDefaults) {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(ORG_ECLIPSE_JDT_UI);
        this.setGeneralEditorValues(theme, prefs, revertToDefaults);
        this.setToken(prefs, theme, "string.quoted.double.java", "java_string", revertToDefaults);
        this.setToken(prefs, theme, "source.java", "java_default", revertToDefaults);
        this.setToken(prefs, theme, "keyword", "java_keyword", revertToDefaults);
        this.setToken(prefs, theme, "keyword.operator", "java_operator", revertToDefaults);
        this.setToken(prefs, theme, "keyword.control.java", "java_keyword_return", revertToDefaults);
        this.setToken(prefs, theme, "comment.line.double-slash.java", "java_single_line_comment", revertToDefaults);
        this.setToken(prefs, theme, "comment.block", "java_multi_line_comment", revertToDefaults);
        this.setToken(prefs, theme, "punctuation.bracket.java", "java_bracket", revertToDefaults);
        this.setToken(prefs, theme, "keyword.other.documentation.java", "java_doc_keyword", revertToDefaults);
        this.setToken(prefs, theme, "entity.name.tag.inline.any.html", "java_doc_tag", revertToDefaults);
        this.setToken(prefs, theme, "markup.underline.link.javadoc", "java_doc_link", revertToDefaults);
        this.setToken(prefs, theme, "comment.block.documentation.javadoc", "java_doc_default", revertToDefaults);
        this.setToken(prefs, theme, "entity.name.type.class.java", "java_type", revertToDefaults);
        this.setToken(prefs, theme, "storage.type.annotation.java", "java_annotation", revertToDefaults);
        this.setSemanticToken(prefs, theme, "entity.name.type.class.java", "class", revertToDefaults);
        this.setSemanticToken(prefs, theme, "entity.name.type.enum.java", "enum", revertToDefaults);
        this.setSemanticToken(prefs, theme, "entity.name.type.interface.java", "interface", revertToDefaults);
        this.setSemanticToken(prefs, theme, "constant.numeric.java", "number", revertToDefaults);
        this.setSemanticToken(prefs, theme, "variable.parameter.java", "parameterVariable", revertToDefaults);
        this.setSemanticToken(prefs, theme, "constant.other.java", "staticField", revertToDefaults);
        this.setSemanticToken(prefs, theme, "constant.other.java", "staticFinalField", revertToDefaults);
        this.setSemanticToken(prefs, theme, "entity.name.function.java", "methodDeclarationName", revertToDefaults);
        this.setSemanticToken(prefs, theme, "invalid.deprecated.java", "deprecatedMember", revertToDefaults);
        this.setSemanticToken(prefs, theme, "storage.type.annotation.java", "annotation", revertToDefaults);
        this.setSemanticToken(prefs, theme, "constant.other.key.java", "annotationElementReference", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "localVariable", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "field", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "staticMethodInvocation", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "inheritedMethodInvocation", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "abstractMethodInvocation", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "localVariableDeclaration", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "method", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "typeParameter", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "autoboxing", revertToDefaults);
        this.setSemanticToken(prefs, theme, "source.java", "typeArgument", revertToDefaults);
        this.setToken(prefs, theme, "keyword.other.java-props", "pf_coloring_key", revertToDefaults);
        this.setToken(prefs, theme, "comment.line.number-sign.java-props", "pf_coloring_comment", revertToDefaults);
        this.setToken(prefs, theme, "string.java-props", "pf_coloring_value", revertToDefaults);
        this.setToken(prefs, theme, "punctuation.separator.key-value.java-props", "pf_coloring_assignment", revertToDefaults);
        this.setToken(prefs, theme, "string.interpolated.java-props", "pf_coloring_argument", revertToDefaults);
        if (!revertToDefaults) {
            prefs.put("matchingBracketsColor", StringConverter.asString((RGB)theme.getCharacterPairColor()));
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
        Font fFont = JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        JFaceResources.getFontRegistry().put("org.eclipse.jdt.ui.editors.textfont", fFont.getFontData());
    }

    private void setGitAndMercurialValues(Theme theme, IEclipsePreferences prefs, boolean revertToDefaults) {
        if (prefs == null) {
            return;
        }
        if (revertToDefaults) {
            prefs.remove("org.eclipse.egit.ui.UncommittedChangeBackgroundColor");
            prefs.remove("org.eclipse.egit.ui.UncommittedChangeForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.addedForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.addedBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.changedForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.changedBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.removedForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.removedBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictBackgroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.IgnoredForegroundColor");
            prefs.remove("com.vectrace.mercurialeclipse.ui.colorsandfonts.IgnoredBackgroundColor");
        } else {
            TextAttribute changedFile = theme.getTextAttribute("markup.changed");
            TextAttribute addedFile = theme.getTextAttribute("markup.inserted");
            TextAttribute deletedFile = theme.getTextAttribute("markup.deleted");
            TextAttribute conflictFile = theme.getTextAttribute("invalid");
            prefs.put("org.eclipse.egit.ui.UncommittedChangeForegroundColor", StringConverter.asString((RGB)addedFile.getForeground().getRGB()));
            prefs.put("org.eclipse.egit.ui.UncommittedChangeBackgroundColor", StringConverter.asString((RGB)addedFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.addedForegroundColor", StringConverter.asString((RGB)addedFile.getForeground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.addedBackgroundColor", StringConverter.asString((RGB)addedFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.changedForegroundColor", StringConverter.asString((RGB)changedFile.getForeground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.changedBackgroundColor", StringConverter.asString((RGB)changedFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedForegroundColor", StringConverter.asString((RGB)deletedFile.getForeground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.deletedBackgroundColor", StringConverter.asString((RGB)deletedFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.removedForegroundColor", StringConverter.asString((RGB)deletedFile.getForeground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.removedBackgroundColor", StringConverter.asString((RGB)deletedFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownForegroundColor", StringConverter.asString((RGB)theme.getForeground()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.unknownBackgroundColor", StringConverter.asString((RGB)theme.getBackground()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictForegroundColor", StringConverter.asString((RGB)conflictFile.getForeground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.conflictBackgroundColor", StringConverter.asString((RGB)conflictFile.getBackground().getRGB()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.IgnoredForegroundColor", StringConverter.asString((RGB)theme.getForeground()));
            prefs.put("com.vectrace.mercurialeclipse.ui.colorsandfonts.IgnoredBackgroundColor", StringConverter.asString((RGB)theme.getBackground()));
        }
    }

    protected void setPDEEditorValues(Theme theme, IEclipsePreferences pdePrefs, boolean revertToDefaults) {
        if (pdePrefs == null) {
            return;
        }
        if (revertToDefaults) {
            pdePrefs.remove("editor.color.xml_comment");
            pdePrefs.remove("editor.color.instr");
            pdePrefs.remove("editor.color.string");
            pdePrefs.remove("editor.color.externalized_string");
            pdePrefs.remove("editor.color.default");
            pdePrefs.remove("editor.color.tag");
            pdePrefs.remove("editor.color.header_key");
            pdePrefs.remove("editor.color.header_value");
            pdePrefs.remove("editor.color.header_assignment");
            pdePrefs.remove("editor.color.header_osgi");
            pdePrefs.remove("editor.color.header_attributes");
        } else {
            this.setToken(pdePrefs, theme, "comment.block.xml", "editor.color.xml_comment", revertToDefaults);
            this.setToken(pdePrefs, theme, "meta.tag.preprocessor.xml", "editor.color.instr", revertToDefaults);
            this.setToken(pdePrefs, theme, "string.quoted.double.xml", "editor.color.string", revertToDefaults);
            this.setToken(pdePrefs, theme, "string.interpolated.xml", "editor.color.externalized_string", revertToDefaults);
            this.setToken(pdePrefs, theme, "text.xml", "editor.color.default", revertToDefaults);
            this.setToken(pdePrefs, theme, "entity.name.tag.xml", "editor.color.tag", revertToDefaults);
            this.setToken(pdePrefs, theme, "keyword.other.manifest", "editor.color.header_key", revertToDefaults);
            this.setToken(pdePrefs, theme, "source.manifest", "editor.color.header_value", revertToDefaults);
            this.setToken(pdePrefs, theme, "punctuation.separator.key-value.manifest", "editor.color.header_assignment", revertToDefaults);
            this.setToken(pdePrefs, theme, "keyword.other.manifest.osgi", "editor.color.header_osgi", revertToDefaults);
            this.setToken(pdePrefs, theme, "string.manifest", "editor.color.header_attributes", revertToDefaults);
        }
        try {
            pdePrefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void setHyperlinkValues(Theme theme, IEclipsePreferences prefs, boolean revertToDefaults) {
        if (prefs == null || theme == null) {
            return;
        }
        if (revertToDefaults) {
            prefs.remove("HYPERLINK_COLOR");
            prefs.remove("ACTIVE_HYPERLINK_COLOR");
            prefs.remove("hyperlinkColor.SystemDefault");
            prefs.remove("hyperlinkColor");
        } else {
            TextAttribute editorHyperlink = theme.getTextAttribute("hyperlink");
            prefs.put("HYPERLINK_COLOR", StringConverter.asString((RGB)editorHyperlink.getForeground().getRGB()));
            JFaceResources.getColorRegistry().put("HYPERLINK_COLOR", editorHyperlink.getForeground().getRGB());
            prefs.put("ACTIVE_HYPERLINK_COLOR", StringConverter.asString((RGB)editorHyperlink.getForeground().getRGB()));
            JFaceResources.getColorRegistry().put("ACTIVE_HYPERLINK_COLOR", editorHyperlink.getForeground().getRGB());
            prefs.putBoolean("hyperlinkColor.SystemDefault", false);
            prefs.put("hyperlinkColor", StringConverter.asString((RGB)editorHyperlink.getForeground().getRGB()));
        }
    }

    protected void setGeneralEditorValues(Theme theme, IEclipsePreferences prefs, boolean revertToDefaults) {
        if (prefs == null) {
            return;
        }
        if (revertToDefaults) {
            prefs.remove("AbstractTextEditor.Color.SelectionBackground");
            prefs.remove("AbstractTextEditor.Color.SelectionForeground");
            prefs.remove("AbstractTextEditor.Color.Background");
            prefs.remove("AbstractTextEditor.Color.Foreground");
            prefs.remove("currentLineColor");
        } else {
            prefs.put("AbstractTextEditor.Color.SelectionBackground", StringConverter.asString((RGB)theme.getSelectionAgainstBG()));
            prefs.put("AbstractTextEditor.Color.SelectionForeground", StringConverter.asString((RGB)theme.getForeground()));
            prefs.put("AbstractTextEditor.Color.Background", StringConverter.asString((RGB)theme.getBackground()));
            prefs.put("AbstractTextEditor.Color.Foreground", StringConverter.asString((RGB)theme.getForeground()));
            prefs.put("currentLineColor", StringConverter.asString((RGB)theme.getLineHighlightAgainstBG()));
        }
        prefs.putBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault", revertToDefaults);
        prefs.putBoolean("AbstractTextEditor.Color.Background.SystemDefault", revertToDefaults);
        prefs.putBoolean("AbstractTextEditor.Color.Foreground.SystemDefault", revertToDefaults);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void setEditorValues(Theme theme, IEclipsePreferences prefs, boolean revertToDefaults) {
        if (revertToDefaults) {
            prefs.remove("occurrenceIndicationColor");
            prefs.remove("writeOccurrenceIndicationColor");
            prefs.remove("currentIPColor");
            prefs.remove("secondaryIPColor");
            prefs.putBoolean("AbstractTextEditor.Color.Background.SystemDefault", true);
            prefs.remove("AbstractTextEditor.Color.Background");
            prefs.putBoolean("AbstractTextEditor.Color.Foreground.SystemDefault", true);
            prefs.remove("AbstractTextEditor.Color.Foreground");
            prefs.putBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault", true);
            prefs.remove("AbstractTextEditor.Color.SelectionBackground");
            prefs.putBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault", true);
            prefs.remove("AbstractTextEditor.Color.SelectionForeground");
            prefs.remove("currentLineColor");
        } else {
            prefs.putBoolean("AbstractTextEditor.Color.Background.SystemDefault", false);
            prefs.put("AbstractTextEditor.Color.Background", StringConverter.asString((RGB)theme.getBackground()));
            prefs.putBoolean("AbstractTextEditor.Color.Foreground.SystemDefault", false);
            prefs.put("AbstractTextEditor.Color.Foreground", StringConverter.asString((RGB)theme.getForeground()));
            prefs.putBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault", false);
            prefs.put("AbstractTextEditor.Color.SelectionBackground", StringConverter.asString((RGB)theme.getSelectionAgainstBG()));
            prefs.putBoolean("AbstractTextEditor.Color.SelectionForeground.SystemDefault", false);
            prefs.put("AbstractTextEditor.Color.SelectionForeground", StringConverter.asString((RGB)theme.getForeground()));
            prefs.put("currentLineColor", StringConverter.asString((RGB)theme.getLineHighlightAgainstBG()));
            prefs.put("occurrenceIndicationColor", StringConverter.asString((RGB)theme.getSelectionAgainstBG()));
            prefs.put("writeOccurrenceIndicationColor", StringConverter.asString((RGB)theme.getSelectionAgainstBG()));
            prefs.put("currentIPColor", StringConverter.asString((RGB)theme.getBackgroundAsRGB("meta.diff.header")));
            prefs.put("secondaryIPColor", StringConverter.asString((RGB)theme.getBackgroundAsRGB("meta.diff.header")));
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void setAntEditorValues(Theme theme, IEclipsePreferences prefs, boolean revertToDefaults) {
        if (prefs == null) {
            return;
        }
        if (revertToDefaults) {
            prefs.remove("org.eclipse.ant.ui.commentsColor");
            prefs.remove("org.eclipse.ant.ui.processingInstructionsColor");
            prefs.remove("org.eclipse.ant.ui.constantStringsColor");
            prefs.remove("org.eclipse.ant.ui.textColor");
            prefs.remove("org.eclipse.ant.ui.tagsColor");
            prefs.remove("org.eclipse.ant.ui.dtdColor");
        } else {
            this.setToken(prefs, theme, "comment.block.xml.ant", "org.eclipse.ant.ui.commentsColor", revertToDefaults);
            this.setToken(prefs, theme, "meta.tag.preprocessor.xml.ant", "org.eclipse.ant.ui.processingInstructionsColor", revertToDefaults);
            this.setToken(prefs, theme, "string.quoted.double.xml.ant", "org.eclipse.ant.ui.constantStringsColor", revertToDefaults);
            this.setToken(prefs, theme, "text.xml.ant", "org.eclipse.ant.ui.textColor", revertToDefaults);
            this.setToken(prefs, theme, "entity.name.tag.target.xml.ant", "org.eclipse.ant.ui.tagsColor", revertToDefaults);
            this.setToken(prefs, theme, "meta.tag.preprocessor.xml.ant", "org.eclipse.ant.ui.dtdColor", revertToDefaults);
        }
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    protected void setToken(IEclipsePreferences prefs, Theme theme, String ourTokenType, String jdtToken, boolean revertToDefaults) {
        if (revertToDefaults) {
            prefs.remove(jdtToken);
            prefs.remove(String.valueOf(jdtToken) + "_bold");
            prefs.remove(String.valueOf(jdtToken) + "_italic");
            prefs.remove(String.valueOf(jdtToken) + "_underline");
            prefs.remove(String.valueOf(jdtToken) + "_strikethrough");
        } else {
            TextAttribute attr = theme.getTextAttribute(ourTokenType);
            prefs.put(jdtToken, StringConverter.asString((RGB)attr.getForeground().getRGB()));
            prefs.putBoolean(String.valueOf(jdtToken) + "_bold", (attr.getStyle() & 1) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + "_italic", (attr.getStyle() & 2) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + "_underline", (attr.getStyle() & 0x40000000) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + "_strikethrough", (attr.getStyle() & 0x20000000) != 0);
        }
    }

    protected void setWSTToken(IEclipsePreferences prefs, Theme theme, String ourEquivalentScope, String prefKey, boolean revertToDefaults) {
        if (revertToDefaults) {
            prefs.remove(prefKey);
        } else {
            TextAttribute attr = theme.getTextAttribute(ourEquivalentScope);
            boolean bold = (attr.getStyle() & 1) != 0;
            boolean italic = (attr.getStyle() & 2) != 0;
            boolean strikethrough = (attr.getStyle() & 0x20000000) != 0;
            boolean underline = (attr.getStyle() & 0x40000000) != 0;
            StringBuilder value = new StringBuilder();
            value.append(Theme.toHex(attr.getForeground().getRGB()));
            value.append('|');
            value.append(Theme.toHex(attr.getBackground().getRGB()));
            value.append('|');
            value.append(bold);
            value.append('|');
            value.append(italic);
            value.append('|');
            value.append(strikethrough);
            value.append('|');
            value.append(underline);
            prefs.put(prefKey, value.toString());
        }
    }

    protected void setSemanticToken(IEclipsePreferences prefs, Theme theme, String ourTokenType, String jdtToken, boolean revertToDefaults) {
        String prefix = "semanticHighlighting.";
        jdtToken = String.valueOf(prefix) + jdtToken;
        if (revertToDefaults) {
            prefs.remove(String.valueOf(jdtToken) + ".color");
            prefs.remove(String.valueOf(jdtToken) + ".bold");
            prefs.remove(String.valueOf(jdtToken) + ".italic");
            prefs.remove(String.valueOf(jdtToken) + ".underline");
            prefs.remove(String.valueOf(jdtToken) + ".strikethrough");
            prefs.remove(String.valueOf(jdtToken) + ".enabled");
        } else {
            TextAttribute attr = theme.getTextAttribute(ourTokenType);
            prefs.put(String.valueOf(jdtToken) + ".color", StringConverter.asString((RGB)attr.getForeground().getRGB()));
            prefs.putBoolean(String.valueOf(jdtToken) + ".bold", (attr.getStyle() & 1) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + ".italic", (attr.getStyle() & 2) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + ".underline", (attr.getStyle() & 0x40000000) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + ".strikethrough", (attr.getStyle() & 0x20000000) != 0);
            prefs.putBoolean(String.valueOf(jdtToken) + ".enabled", true);
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("enable_invasive_themes") || event.getKey().equals("apply_to_all_editors") || event.getKey().equals("THEME_CHANGED") && this.applyToViews()) {
            this.cancel();
            this.schedule();
        }
    }

    protected void overrideSelectionColor(AbstractTextEditor editor) {
        try {
            if (Class.forName("com.aptana.editor.common.extensions.IThemeableEditor").isInstance(editor)) {
                return;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {}
        ISourceViewer sourceViewer = null;
        try {
            Method m = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
            m.setAccessible(true);
            sourceViewer = (ISourceViewer)m.invoke((Object)editor, new Object[0]);
        }
        catch (Exception exception) {}
        if (sourceViewer == null || sourceViewer.getTextWidget() == null) {
            return;
        }
        ThemePlugin.getDefault().getControlThemerFactory().apply((Viewer)sourceViewer);
    }

    protected ColorManager getColorManager() {
        return ThemePlugin.getDefault().getColorManager();
    }

    protected void hijackEditor(IEditorPart part, boolean revertToDefaults) {
        if (this.applyToAllEditors()) {
            return;
        }
        if (part instanceof AbstractTextEditor) {
            this.overrideSelectionColor((AbstractTextEditor)part);
        }
    }

    protected void hijackConsole(IViewPart view) {
        IPage currentPage;
        if (view instanceof ConsoleView && (currentPage = ((ConsoleView)view).getCurrentPage()) != null) {
            this.hookTheme(currentPage.getControl(), false);
        }
    }

    protected void hijackOutline() {
        IWorkbenchPage page = UIUtils.getActivePage();
        if (page != null) {
            IViewReference[] refs;
            IViewReference[] iViewReferenceArray = refs = page.getViewReferences();
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                IViewReference ref = iViewReferenceArray[n2];
                if (ref.getId().equals("org.eclipse.ui.views.ContentOutline")) {
                    this.hijackView(ref.getView(false), false);
                    return;
                }
                ++n2;
            }
        }
    }

    public synchronized void earlyStartup() {
        if (ranEarlyStartup) {
            return;
        }
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.theme");
        prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        ranEarlyStartup = true;
        if (this.applyToViews()) {
            this.schedule();
        }
    }

    public void dispose() {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode("com.aptana.theme");
        prefs.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.pageListener = null;
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IViewReference viewRef;
        String id;
        if (partRef instanceof IViewReference && ("org.eclipse.ui.console.ConsoleView".equals(id = (viewRef = (IViewReference)partRef).getId()) || "org.eclipse.jdt.ui.TypeHierarchy".equals(id) || "org.eclipse.jdt.callhierarchy.view".equals(id))) {
            final IViewPart part = viewRef.getView(false);
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    InvasiveThemeHijacker.this.hijackView(part, false);
                }
            });
            return;
        }
        if (partRef instanceof IEditorReference) {
            this.hijackOutline();
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
        this.partActivated(partRef);
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IViewPart view;
        if (partRef instanceof IEditorReference) {
            IEditorPart part = (IEditorPart)partRef.getPart(false);
            if (part instanceof MultiPageEditorPart) {
                MultiPageEditorPart multi = (MultiPageEditorPart)part;
                if (this.pageListener != null) {
                    multi.getSite().getSelectionProvider().removeSelectionChangedListener(this.pageListener);
                }
            }
        } else if (partRef instanceof IViewReference && this.queryListeners.containsKey(view = (IViewPart)partRef.getPart(false))) {
            NewSearchUI.removeQueryListener((IQueryListener)this.queryListeners.remove(view));
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
        if (partRef instanceof IEditorReference) {
            this.hijackOutline();
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        if (partRef instanceof IEditorReference) {
            IEditorPart editorPart = (IEditorPart)partRef.getPart(false);
            this.hijackEditor(editorPart, false);
            if (editorPart instanceof MultiPageEditorPart) {
                MultiPageEditorPart multi = (MultiPageEditorPart)editorPart;
                if (this.pageListener == null) {
                    this.pageListener = new ISelectionChangedListener(){

                        public void selectionChanged(SelectionChangedEvent event) {
                            InvasiveThemeHijacker.this.hijackOutline();
                        }
                    };
                }
                multi.getSite().getSelectionProvider().addSelectionChangedListener(this.pageListener);
            }
            return;
        }
        if (partRef instanceof IViewReference) {
            IViewPart view = (IViewPart)partRef.getPart(false);
            this.hijackView(view, false);
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        this.partActivated(partRef);
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void pageChanged(PageChangedEvent event) {
    }
}

