/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.theme;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.scope.IScopeSelector;
import com.aptana.scope.ISelectorNode;
import com.aptana.scope.ScopeSelector;
import com.aptana.theme.ColorManager;
import com.aptana.theme.DelayedTextAttribute;
import com.aptana.theme.IThemeManager;
import com.aptana.theme.RGBa;
import com.aptana.theme.ThemeGetTextAttribute;
import com.aptana.theme.ThemePlugin;
import com.aptana.theme.ThemeRule;
import com.aptana.theme.internal.OrderedProperties;
import com.aptana.theme.internal.ThemeManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class Theme {
    static final String SELECTOR_DELIMITER = "^";
    static final String DELIMETER = ",";
    private static final String UNDERLINE = "underline";
    private static final String BOLD = "bold";
    private static final String ITALIC = "italic";
    public static final String THEME_NAME_PROP_KEY = "name";
    public static final String THEME_EXTENDS_PROP_KEY = "extends_theme";
    static final String FOREGROUND_PROP_KEY = "foreground";
    private static final String BACKGROUND_PROP_KEY = "background";
    private static final String FRAME_PROP_KEY = "framecolor";
    private static final String SELECTION_PROP_KEY = "selection";
    private static final String SELECTION_FG_PROP_KEY = "selection_foreground";
    private static final String LINE_HIGHLIGHT_PROP_KEY = "lineHighlight";
    private static final String CARET_PROP_KEY = "caret";
    private static final String TAB_PROP_KEY = "tabcolor";
    private static final String THEME_VERSION = "version";
    private List<ThemeRule> coloringRules;
    private ColorManager colorManager;
    private RGB defaultFG;
    private RGB selectionFG;
    private RGBa lineHighlight;
    private RGB defaultBG;
    private RGB frameBG;
    private RGBa selection;
    private RGB caret;
    private RGB tabcolor;
    private String name;
    private String gray;
    private double version;
    private RGB searchResultBG;
    private ThemeGetTextAttribute themeGetTextAttribute;

    public String getGray() {
        return this.gray;
    }

    public void setGray(String gray) {
        this.gray = gray;
    }

    public Theme(ColorManager colormanager, Properties props) {
        this.colorManager = colormanager;
        this.coloringRules = new ArrayList<ThemeRule>();
        this.parseProps(props);
        this.storeDefaults();
    }

    private ThemeGetTextAttribute obtainGetThemeTextAttribute() {
        if (this.themeGetTextAttribute == null) {
            this.themeGetTextAttribute = new ThemeGetTextAttribute(this);
        }
        return this.themeGetTextAttribute;
    }

    private void parseProps(Properties props) {
        String o = (String)props.remove(THEME_VERSION);
        if (StringUtil.isNotEmpty((String)o)) {
            try {
                this.version = Double.valueOf(o);
            }
            catch (NumberFormatException e) {
                IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
            }
        }
        this.name = (String)props.remove(THEME_NAME_PROP_KEY);
        if (this.name == null) {
            String properties;
            block29: {
                properties = "";
                PrintWriter pw = null;
                try {
                    try {
                        StringWriter sw = new StringWriter();
                        pw = new PrintWriter(sw);
                        props.list(pw);
                        properties = sw.toString();
                    }
                    catch (Exception exception) {
                        if (pw != null) {
                            pw.close();
                        }
                        break block29;
                    }
                }
                catch (Throwable throwable) {
                    if (pw != null) {
                        pw.close();
                    }
                    throw throwable;
                }
                if (pw != null) {
                    pw.close();
                }
            }
            throw new IllegalStateException("Invalid theme properties. No theme 'name' provided. Properties may be corrupted: " + properties);
        }
        this.defaultFG = this.parseHexRGB((String)props.remove(FOREGROUND_PROP_KEY));
        this.defaultBG = this.parseHexRGB((String)props.remove(BACKGROUND_PROP_KEY));
        this.frameBG = this.parseHexRGB((String)props.remove(FRAME_PROP_KEY));
        this.lineHighlight = this.parseHexRGBa((String)props.remove(LINE_HIGHLIGHT_PROP_KEY));
        this.selection = this.parseHexRGBa((String)props.remove(SELECTION_PROP_KEY));
        try {
            this.selectionFG = this.parseHexRGB((String)props.remove(SELECTION_FG_PROP_KEY));
        }
        catch (Exception exception) {
            this.selectionFG = this.defaultFG;
        }
        this.caret = this.parseHexRGB((String)props.remove(CARET_PROP_KEY), true);
        this.tabcolor = this.parseHexRGB((String)props.remove(TAB_PROP_KEY), true);
        Set<Object> propertyNames = props.keySet();
        for (Object key : propertyNames) {
            String displayName = (String)key;
            int style = 0;
            RGBa foreground = null;
            RGBa background = null;
            String value = props.getProperty(displayName);
            String scopeSelector = displayName;
            int selectorIndex = value.indexOf(SELECTOR_DELIMITER);
            if (selectorIndex != -1) {
                scopeSelector = value.substring(selectorIndex + 1);
                if ("null".equals(scopeSelector)) {
                    scopeSelector = null;
                }
                value = value.substring(0, selectorIndex);
            }
            List<String> values = this.tokenize(value);
            int num = 0;
            boolean skipFG = false;
            for (String token : values) {
                if ((token = token.trim()).length() == 0 && num == 0) {
                    skipFG = true;
                } else if (token.length() > 0 && token.charAt(0) == '#') {
                    if (foreground == null && !skipFG) {
                        foreground = this.parseHexRGBa(token);
                    } else {
                        background = this.parseHexRGBa(token);
                    }
                } else if (token.equalsIgnoreCase(ITALIC)) {
                    style |= 2;
                } else if (token.equalsIgnoreCase(UNDERLINE)) {
                    style |= 0x40000000;
                } else if (token.equalsIgnoreCase(BOLD)) {
                    style |= 1;
                }
                ++num;
            }
            DelayedTextAttribute attribute = new DelayedTextAttribute(foreground, background, style);
            this.coloringRules.add(new ThemeRule(displayName, (IScopeSelector)(scopeSelector == null ? null : new ScopeSelector(scopeSelector)), attribute));
        }
    }

    private List<String> tokenize(String value) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (!value.contains(DELIMETER)) {
            tokens.add(value);
            return tokens;
        }
        return Arrays.asList(value.split(DELIMETER));
    }

    private RGB parseHexRGB(String hex) {
        return this.parseHexRGB(hex, false);
    }

    private RGB parseHexRGB(String hex, boolean alphaMergeWithBG) {
        RGBa a = this.parseHexRGBa(hex);
        RGB rgb = a.toRGB();
        if (alphaMergeWithBG) {
            return Theme.alphaBlend(this.defaultBG, rgb, a.getAlpha());
        }
        return rgb;
    }

    private RGBa parseHexRGBa(String hex) {
        if (hex == null) {
            return new RGBa(0, 0, 0);
        }
        if (hex.length() != 7 && hex.length() != 9) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (String)MessageFormat.format("Received RGBa Hex value with invalid length: {0}", hex));
            if (this.defaultFG != null) {
                return new RGBa(this.defaultFG);
            }
            return new RGBa(0, 0, 0);
        }
        String s = hex.substring(1, 3);
        int r = Integer.parseInt(s, 16);
        s = hex.substring(3, 5);
        int g = Integer.parseInt(s, 16);
        s = hex.substring(5, 7);
        int b = Integer.parseInt(s, 16);
        if (hex.length() == 9) {
            s = hex.substring(7, 9);
            int a = Integer.parseInt(s, 16);
            return new RGBa(r, g, b, a);
        }
        return new RGBa(r, g, b);
    }

    public static RGB alphaBlend(RGB base, RGB top, int alpha) {
        int newRed = Theme.alphaBlend(base.red, top.red, alpha);
        int newGreen = Theme.alphaBlend(base.green, top.green, alpha);
        int newBlue = Theme.alphaBlend(base.blue, top.blue, alpha);
        return new RGB(newRed, newGreen, newBlue);
    }

    private static int alphaBlend(int base, int top, int alpha) {
        int oneMinusAlpha = 255 - alpha;
        int r = oneMinusAlpha * base + alpha * top + 128;
        return r + (r >> 8) >> 8;
    }

    public TextAttribute getTextAttribute(String scope) {
        ThemeGetTextAttribute themeGetTextAttribute = this.obtainGetThemeTextAttribute();
        return themeGetTextAttribute.getTextAttribute(scope);
    }

    ThemeRule winningRule(String scope) {
        ThemeGetTextAttribute themeGetTextAttribute = this.obtainGetThemeTextAttribute();
        IScopeSelector match = themeGetTextAttribute.findMatch(scope);
        if (match == null) {
            return null;
        }
        return this.getRuleForSelector(match);
    }

    public ThemeRule getRuleForSelector(IScopeSelector match) {
        ArrayList<ThemeRule> reversed = new ArrayList<ThemeRule>(this.coloringRules);
        Collections.reverse(reversed);
        for (ThemeRule rule : reversed) {
            if (rule.isSeparator() || !rule.getScopeSelector().equals(match)) continue;
            return rule;
        }
        return null;
    }

    public RGB getBackground() {
        return this.defaultBG;
    }

    public RGB getFrame() {
        return this.frameBG;
    }

    public RGBa getSelection() {
        return this.selection;
    }

    public RGB getSelectionFG() {
        return this.selectionFG;
    }

    public RGB getForeground() {
        return this.defaultFG;
    }

    public RGBa getLineHighlight() {
        return this.lineHighlight;
    }

    public RGB getCaret() {
        return this.caret;
    }

    public RGB getTabcolor() {
        return this.tabcolor;
    }

    public RGB getCharacterPairColor() {
        return Theme.alphaBlend(this.defaultBG, this.getCaret(), 128);
    }

    public RGB getOccurenceHighlightColor() {
        return this.getCharacterPairColor();
    }

    public String getName() {
        return this.name;
    }

    public List<ThemeRule> getTokens() {
        return Collections.unmodifiableList(this.coloringRules);
    }

    public Properties toProps() {
        OrderedProperties props = new OrderedProperties();
        ((Properties)props).put(THEME_NAME_PROP_KEY, this.getName());
        ((Properties)props).put(THEME_VERSION, String.valueOf(this.getVersion()));
        ((Properties)props).put(SELECTION_PROP_KEY, Theme.toHex(this.getSelection()));
        ((Properties)props).put(SELECTION_FG_PROP_KEY, Theme.toHex(this.getSelectionFG()));
        ((Properties)props).put(LINE_HIGHLIGHT_PROP_KEY, Theme.toHex(this.getLineHighlight()));
        ((Properties)props).put(FOREGROUND_PROP_KEY, Theme.toHex(this.getForeground()));
        ((Properties)props).put(BACKGROUND_PROP_KEY, Theme.toHex(this.getBackground()));
        ((Properties)props).put(FRAME_PROP_KEY, Theme.toHex(this.getFrame()));
        ((Properties)props).put(CARET_PROP_KEY, Theme.toHex(this.caret));
        ((Properties)props).put(TAB_PROP_KEY, Theme.toHex(this.tabcolor));
        for (ThemeRule rule : this.coloringRules) {
            int style;
            if (rule == null) continue;
            StringBuilder value = new StringBuilder();
            DelayedTextAttribute attr = rule.getTextAttribute();
            RGBa color = attr.foreground;
            if (color != null) {
                value.append(Theme.toHex(color)).append(DELIMETER);
            }
            if ((color = attr.background) != null) {
                value.append(Theme.toHex(color)).append(DELIMETER);
            }
            if (((style = attr.style) & 2) != 0) {
                value.append(ITALIC).append(DELIMETER);
            }
            if ((style & 0x40000000) != 0) {
                value.append(UNDERLINE).append(DELIMETER);
            }
            if ((style & 1) != 0) {
                value.append(BOLD).append(DELIMETER);
            }
            if (value.length() > 0) {
                value.deleteCharAt(value.length() - 1);
            }
            value.append(SELECTOR_DELIMITER);
            value.append(rule.getScopeSelector().toString());
            ((Properties)props).put(rule.getName(), value.toString());
        }
        return props;
    }

    static String toHex(RGBa color) {
        String rgbString = Theme.toHex(color.toRGB());
        if (color.getAlpha() == 0) {
            return rgbString;
        }
        return String.valueOf(rgbString) + Theme.pad(Integer.toHexString(color.getAlpha()), 2, '0');
    }

    public static String toHex(RGB rgb) {
        return MessageFormat.format("#{0}{1}{2}", Theme.pad(Integer.toHexString(rgb.red), 2, '0'), Theme.pad(Integer.toHexString(rgb.green), 2, '0'), Theme.pad(Integer.toHexString(rgb.blue), 2, '0'));
    }

    private static String pad(String string, int desiredLength, char padChar) {
        while (string.length() < desiredLength) {
            string = String.valueOf(padChar) + string;
        }
        return string;
    }

    protected void storeDefaults() {
        if (this.getThemeManager().isBuiltinTheme(this.getName())) {
            return;
        }
        IEclipsePreferences prefs = EclipseUtil.defaultScope().getNode("com.aptana.theme");
        if (prefs == null) {
            return;
        }
        Preferences preferences = prefs.node("themes");
        if (preferences == null) {
            return;
        }
        String value = preferences.get(this.getName(), null);
        if (value == null) {
            this.save((IScopeContext)EclipseUtil.defaultScope());
        }
    }

    public void save(boolean fromDefaultThemeUI) {
        this.save((IScopeContext)EclipseUtil.instanceScope());
        if (this.getThemeManager().getCurrentTheme().equals(this)) {
            this.getThemeManager().setCurrentTheme(this);
        }
        if (fromDefaultThemeUI) {
            RGB bg_rgb = this.getBackground();
            String backRGB = String.valueOf(bg_rgb.red) + DELIMETER + bg_rgb.green + DELIMETER + bg_rgb.blue;
            PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_TAB_BG_START", backRGB);
            PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_TAB_BG_END", backRGB);
            PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_START", backRGB);
            PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_BG_END", backRGB);
            PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.INACTIVE_TAB_BG_START", backRGB);
            PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.INACTIVE_TAB_BG_END", backRGB);
        }
    }

    protected IThemeManager getThemeManager() {
        return ThemePlugin.getDefault().getThemeManager();
    }

    private void save(IScopeContext scope) {
        block14: {
            ByteArrayOutputStream os = null;
            try {
                try {
                    os = new ByteArrayOutputStream();
                    this.toProps().store(os, null);
                    IEclipsePreferences prefs = scope.getNode("com.aptana.theme");
                    Preferences preferences = prefs.node("themes");
                    preferences.putByteArray(this.getName(), os.toByteArray());
                    prefs.flush();
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void loadFromDefaults() throws InvalidPropertiesFormatException, UnsupportedEncodingException, IOException {
        block32: {
            props = null;
            if (this.getThemeManager().isBuiltinTheme(this.getName())) {
                builtin = ((ThemeManager)this.getThemeManager()).loadBuiltinTheme(this.getName());
                props = builtin.toProps();
            } else {
                block30: {
                    block31: {
                        prefs = EclipseUtil.defaultScope().getNode("com.aptana.theme");
                        preferences = prefs.node("themes");
                        byteStream = null;
                        array = preferences.getByteArray(this.getName(), null);
                        if (array != null) break block30;
                        if (byteStream == null) break block31;
                        try {
                            byteStream.close();
                        }
                        catch (Exception v0) {}
                    }
                    return;
                }
                try {
                    props = new OrderedProperties();
                    byteStream = new ByteArrayInputStream(array);
                    props.load(byteStream);
                }
                catch (IllegalArgumentException v1) {
                    xml = preferences.get(this.getName(), null);
                    if (xml == null) {
                        if (byteStream != null) {
                            try {
                                byteStream.close();
                            }
                            catch (Exception v2) {}
                        }
                        return;
                    }
                    try {
                        xmlStream = null;
                        try {
                            xmlStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
                            props = new OrderedProperties();
                            props.loadFromXML(xmlStream);
                            this.save((IScopeContext)EclipseUtil.defaultScope());
                        }
                        catch (Throwable var7_8) {
                            if (xmlStream != null) {
                                try {
                                    xmlStream.close();
                                }
                                catch (Exception v3) {}
                            }
                            throw var7_8;
                        }
                        if (xmlStream != null) {
                            try {
                                xmlStream.close();
                            }
                            catch (Exception v4) {}
                        }
                        ** if (byteStream == null) goto lbl-1000
                    }
                    catch (Throwable var8_9) {
                        if (byteStream != null) {
                            try {
                                byteStream.close();
                            }
                            catch (Exception v6) {}
                        }
                        throw var8_9;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            byteStream.close();
                        }
                        catch (Exception v5) {}
                    }
lbl-1000:
                    // 2 sources

                    {
                        break block32;
                    }
                }
                if (byteStream == null) break block32;
                try {
                    byteStream.close();
                }
                catch (Exception v7) {}
            }
        }
        this.coloringRules.clear();
        this.wipeCache();
        this.parseProps(props);
        this.deleteCustomVersion();
    }

    private void deleteCustomVersion() {
        this.delete((IScopeContext)EclipseUtil.instanceScope());
    }

    private void deleteDefaultVersion() {
        this.delete((IScopeContext)EclipseUtil.defaultScope());
    }

    private void delete(IScopeContext context) {
        try {
            IEclipsePreferences prefs = context.getNode("com.aptana.theme");
            Preferences preferences = prefs.node("themes");
            preferences.remove(this.getName());
            preferences.flush();
        }
        catch (BackingStoreException e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
        }
    }

    public void reorderRule(int startIndex, int endIndex) {
        if (endIndex > startIndex) {
            --endIndex;
        }
        ThemeRule selected = this.coloringRules.remove(startIndex);
        this.coloringRules.add(endIndex, selected);
        this.save(false);
    }

    public void addNewDefaultToken(int index, String newTokenName) {
        this.addNewRule(index, newTokenName, null, new DelayedTextAttribute(null));
    }

    public void addNewRule(int index, String ruleName, ScopeSelector selector, DelayedTextAttribute attr) {
        this.coloringRules.add(index, new ThemeRule(ruleName, (IScopeSelector)selector, attr));
        this.wipeCache();
        this.save(false);
    }

    public void updateRule(int index, ThemeRule newRule) {
        this.coloringRules.remove(index);
        if (index >= this.coloringRules.size()) {
            this.coloringRules.add(newRule);
        } else {
            this.coloringRules.add(index, newRule);
        }
        this.wipeCache();
        this.save(false);
    }

    public void updateCaret(RGB newColor) {
        if (newColor == null || this.caret != null && this.caret.equals((Object)newColor)) {
            return;
        }
        this.caret = newColor;
        this.save(false);
    }

    public void updateTabcolor(RGB newColor) {
        if (newColor == null || this.tabcolor != null && this.tabcolor.equals((Object)newColor)) {
            return;
        }
        this.tabcolor = newColor;
        this.save(false);
    }

    public void updateFG(RGB newColor) {
        if (newColor == null || this.defaultFG != null && this.defaultFG.equals((Object)newColor)) {
            return;
        }
        this.wipeCache();
        this.defaultFG = newColor;
        this.save(false);
    }

    public void updateBG(RGB newColor) {
        if (newColor == null || this.defaultBG != null && this.defaultBG.equals((Object)newColor)) {
            return;
        }
        this.wipeCache();
        this.defaultBG = newColor;
        this.save(false);
    }

    private void wipeCache() {
        this.themeGetTextAttribute = null;
    }

    public void updateLineHighlight(RGB newColor) {
        if (newColor == null || this.lineHighlight != null && this.lineHighlight.toRGB().equals((Object)newColor)) {
            return;
        }
        this.lineHighlight = new RGBa(newColor);
        this.save(false);
    }

    public void updateSelection(RGB newColor) {
        if (newColor == null || this.selection != null && this.selection.toRGB().equals((Object)newColor)) {
            return;
        }
        this.selection = new RGBa(newColor);
        this.searchResultBG = null;
        this.save(false);
    }

    public Theme copy(String value) {
        if (value == null) {
            return null;
        }
        try {
            Properties props = this.toProps();
            props.setProperty(THEME_NAME_PROP_KEY, value);
            Theme newTheme = new Theme(this.colorManager, props);
            this.addTheme(newTheme);
            return newTheme;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)ThemePlugin.getDefault(), (Throwable)e);
            return null;
        }
    }

    protected void addTheme(Theme newTheme) {
        this.getThemeManager().addTheme(newTheme);
    }

    public void delete() {
        this.removeTheme();
        this.deleteCustomVersion();
        this.deleteDefaultVersion();
    }

    protected void removeTheme() {
        this.getThemeManager().removeTheme(this);
    }

    public boolean hasEntry(String scopeSelector) {
        ScopeSelector selector = new ScopeSelector(scopeSelector);
        ThemeRule rule = this.getRuleForSelector((IScopeSelector)selector);
        return rule != null;
    }

    public Color getForeground(String scope) {
        TextAttribute attr = this.getTextAttribute(scope);
        if (attr == null) {
            return null;
        }
        return attr.getForeground();
    }

    public RGB getForegroundAsRGB(String scope) {
        Color fg = this.getForeground(scope);
        if (fg == null) {
            return null;
        }
        return fg.getRGB();
    }

    public Color getBackground(String scope) {
        TextAttribute attr = this.getTextAttribute(scope);
        if (attr == null) {
            return null;
        }
        return attr.getBackground();
    }

    public RGB getBackgroundAsRGB(String scope) {
        Color bg = this.getBackground(scope);
        if (bg == null) {
            return null;
        }
        return bg.getRGB();
    }

    public RGB getSearchResultColor() {
        if (this.searchResultBG == null) {
            this.searchResultBG = this.isDark(this.getSelectionAgainstBG()) ? this.lighten(this.getSelectionAgainstBG()) : this.darken(this.getSelectionAgainstBG());
        }
        return this.searchResultBG;
    }

    RGB lighten(RGB color) {
        float[] hsb = color.getHSB();
        return new RGB(hsb[0], hsb[1], Math.min(1.0f, (float)((double)hsb[2] + 0.15)));
    }

    RGB darken(RGB color) {
        float[] hsb = color.getHSB();
        return new RGB(hsb[0], hsb[1], Math.max(0.0f, (float)((double)hsb[2] - 0.15)));
    }

    public boolean hasDarkBG() {
        return this.isDark(this.getBackground());
    }

    public boolean hasLightFG() {
        return !this.isDark(this.getForeground());
    }

    private boolean isDark(RGB color) {
        double grey = 0.3 * (double)color.red + 0.59 * (double)color.green + 0.11 * (double)color.blue;
        return grey <= 128.0;
    }

    public RGB getSelectionAgainstBG() {
        return Theme.alphaBlend(this.defaultBG, this.selection.toRGB(), this.selection.getAlpha());
    }

    public RGB getLineHighlightAgainstBG() {
        return Theme.alphaBlend(this.defaultBG, this.lineHighlight.toRGB(), this.lineHighlight.getAlpha());
    }

    public void remove(ThemeRule entry) {
        this.coloringRules.remove(entry);
        this.wipeCache();
        this.save(false);
    }

    public boolean isInvasive() {
        return ThemePlugin.applyToViews();
    }

    public Color getForegroundColor() {
        return this.getColorManager().getColor(this.getForeground());
    }

    public Color getBackgroundColor() {
        return this.getColorManager().getColor(this.getBackground());
    }

    public Color getFrameColor() {
        return this.getColorManager().getColor(this.getFrame());
    }

    protected ColorManager getColorManager() {
        return ThemePlugin.getDefault().getColorManager();
    }

    public double getVersion() {
        return this.version;
    }

    public void printSummary(boolean complete) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        int total = 0;
        for (ThemeRule themeRule : this.getTokens()) {
            if (themeRule.isSeparator()) continue;
            ++total;
            ISelectorNode root = ((ScopeSelector)themeRule.getScopeSelector()).getRoot();
            Class<?> class1 = root.getClass();
            Integer i = (Integer)counts.get(class1.getName());
            if (i == null) {
                i = 0;
            }
            counts.put(class1.getName(), i + 1);
            if (!complete) continue;
            System.out.println();
            System.out.println(themeRule);
            System.out.println(root.toString());
            System.out.println(class1);
        }
        System.out.println("Theme: " + this.getName());
        System.out.println("Non-separator rules: " + total);
        for (Map.Entry entry : counts.entrySet()) {
            System.out.println(String.valueOf((String)entry.getKey()) + ": " + entry.getValue());
        }
    }
}

