/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import java.util.ArrayList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NonExistingFileEditorInput;
import org.eclipse.ui.internal.editors.text.TextEditorMessages;

public class UntitledTextFileWizard
extends Wizard
implements INewWizard {
    private IWorkbenchWindow fWindow;

    public void dispose() {
        this.fWindow = null;
    }

    private IFileStore queryFileStore() {
        IPath stateLocation = EditorsPlugin.getDefault().getStateLocation();
        IPath path = stateLocation.append("/_" + new Object().hashCode());
        return EFS.getLocalFileSystem().getStore(path);
    }

    private String getEditorId(IFileStore fileStore) {
        IWorkbench workbench = this.fWindow.getWorkbench();
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(fileStore.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return "com.aptana.editor.html";
    }

    private IEditorInput createEditorInput(IFileStore fileStore, IWorkbenchPage page) {
        IEditorReference[] editorReference = page.getEditorReferences();
        ArrayList<String> names = new ArrayList<String>();
        int i = 0;
        while (i < editorReference.length) {
            names.add(editorReference[i].getName());
            ++i;
        }
        return new NonExistingFileEditorInput(fileStore, TextEditorMessages.NewTextEditorAction_namePrefix, names);
    }

    public boolean performFinish() {
        IFileStore fileStore = this.queryFileStore();
        IWorkbenchPage page = this.fWindow.getActivePage();
        IEditorInput input = this.createEditorInput(fileStore, page);
        String editorId = this.getEditorId(fileStore);
        try {
            page.openEditor(input, editorId);
        }
        catch (PartInitException e) {
            EditorsPlugin.log(e);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWindow = workbench.getActiveWorkbenchWindow();
    }
}

