/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.rcp.HBuilderStartUtils;
import com.aptana.rcp.IDETray;
import com.aptana.rcp.IDEWorkbenchAdvisor;
import com.aptana.rcp.IdePlugin;
import com.aptana.rcp.InitializationUtils;
import com.aptana.rcp.PandoraWorkbenchActionBarAdvisor;
import com.aptana.rcp.ReadyFileUtils;
import com.aptana.rcp.SystemUtils;
import com.aptana.rcp.actions.NewWizardMenu;
import com.aptana.theme.ThemePlugin;
import com.pandora.core.CoreActivator;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.log.HBLog;
import com.pandora.core.stats.Stats;
import com.pandora.core.utils.PlatformUtil;
import com.pandora.core.utils.ReflectUtils;
import com.pandora.rcp.upgrade.StartupCheckUpadte;
import com.pandora.ui.DefaultThemeUI;
import com.pandora.ui.HomeControlContribution;
import com.pandora.ui.ScheduleEventAction;
import com.pandora.ui.UiActivator;
import com.pandora.ui.action.ImportFolderAction;
import com.pandora.ui.startpage.BrowserEditorUtil;
import com.pandora.ui.startpage.WelcomeWizardDesktop;
import com.pandora.ui.utils.IDEUtils;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.CoolBarManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.AbstractEnabledHandler;
import org.eclipse.ui.internal.UIPlugin;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.handlers.HandlerProxy;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.EditorAreaDropAdapter;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.dialogs.WelcomeEditorInput;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.part.EditorInputTransfer;
import org.eclipse.ui.part.MarkerTransfer;
import org.eclipse.ui.part.ResourceTransfer;

public class IDEWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final double INITIAL_WINDOW_WIDTH_PROPORTION = 0.9;
    private static final double INITIAL_WINDOW_HEIGHT_PROPORTION = 0.9;
    private static Point INITIAL_WINDOW_SIZE = new Point(1200, 900);
    private static final Color SHELL_BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 255, 252, 245);
    private static final Color TABFOLDER_BACKGROUND_COLOR = new Color((Device)Display.getDefault(), 238, 232, 216);
    private static final String TAB_FOREGROUND_COLOR = "70,56,17";
    private static final String SHOW_COOLBAR = "SHOW_COOLBAR";
    private static final String SHOW_PERSPECTIVEBAR = "SHOW_PERSPECTIVEBAR";
    private static final String TOOLBAR_MANUALLY_ADJUSTED = "TOOLBAR_MANUALLY_ADJUSTED";
    private static final String PERSPECTIVE_MANUALLY_ADJUSTED = "PERSPECTIVE_MANUALLY_ADJUSTED";
    private static final String WELCOME_EDITOR_ID = "org.eclipse.ui.internal.ide.dialogs.WelcomeEditor";
    private static final String WEB_PERSPECTIVE_ID = "com.aptana.ui.WebPerspective";
    private static final List<String> TO_REMOVE = new ArrayList<String>();
    private IDEWorkbenchAdvisor wbAdvisor;
    private boolean editorsAndIntrosOpened = false;
    private IEditorPart lastActiveEditor = null;
    private IPerspectiveDescriptor lastPerspective = null;
    private IDETray dragonSysTray;
    private IWorkbenchPage lastActivePage;
    private String lastEditorTitle = "";
    private IPropertyListener editorPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1 && IDEWorkbenchWindowAdvisor.this.lastActiveEditor != null) {
                String newTitle = IDEWorkbenchWindowAdvisor.getTitle(IDEWorkbenchWindowAdvisor.this.lastActiveEditor);
                if (!IDEWorkbenchWindowAdvisor.this.lastEditorTitle.equals(newTitle)) {
                    IDEWorkbenchWindowAdvisor.this.recomputeTitle();
                }
            }
        }
    };
    private IAdaptable lastInput;
    private ActionFactory.IWorkbenchAction openPerspectiveAction;
    private boolean isToolbarProgrammaticSet;
    private boolean showFeedbackHTML = false;

    public IDEWorkbenchWindowAdvisor(IDEWorkbenchAdvisor wbAdvisor, IWorkbenchWindowConfigurer configurer) {
        super(configurer);
        this.wbAdvisor = wbAdvisor;
        try {
            INITIAL_WINDOW_SIZE = this.getInitWindowSize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Point getInitWindowSize() {
        Point screenSize = this.getScreenSize();
        return new Point((int)((double)screenSize.x * 0.9), (int)((double)screenSize.y * 0.9));
    }

    private Point getScreenSize() {
        int screenWidth = 0;
        int screenHeight = 0;
        try {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            screenWidth = dimension.width;
            screenHeight = dimension.height;
        }
        catch (Throwable throwable) {
            Rectangle rectangle = Display.getCurrent().getActiveShell().getMonitor().getBounds();
            screenWidth = rectangle.width;
            screenHeight = rectangle.height;
        }
        return new Point(screenWidth, screenHeight);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new PandoraWorkbenchActionBarAdvisor(configurer);
    }

    private IWorkbench getWorkbench() {
        return this.getWindowConfigurer().getWorkbenchConfigurer().getWorkbench();
    }

    public boolean preWindowShellClose() {
        if (this.getWorkbench().getWorkbenchWindowCount() > 1) {
            return true;
        }
        if (!this.showFeedbackHTML && PlatformUtil.isWindows()) {
            try {
                ScheduleEventAction e = ScheduleEventAction.getInstance();
                if (e.isNotifyCreateShortcut()) {
                    if (e.isChangeInstallLocation() && e.isUserLoveShortcutFeature() && !e.hasShortcut()) {
                        e.notifyCreateShortcut(true);
                    }
                } else if (!e.hasShortcut()) {
                    e.notifyCreateShortcut(false);
                }
                e.saveState();
            }
            catch (Throwable e) {
                IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
            }
        }
        return IDEWorkbenchWindowAdvisor.promptOnExit(this.getWindowConfigurer().getWindow().getShell());
    }

    static boolean promptOnExit(Shell parentShell) {
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean promptOnExit = store.getBoolean("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW");
        promptOnExit = false;
        if (promptOnExit) {
            String message;
            MessageDialogWithToggle dlg;
            IWorkbenchWindow workbenchWindow;
            if (parentShell == null && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                parentShell = workbenchWindow.getShell();
            }
            if (parentShell != null) {
                parentShell.setMinimized(false);
                parentShell.forceActive();
            }
            String productName = null;
            IProduct product = Platform.getProduct();
            if (product != null) {
                productName = product.getName();
            }
            if ((dlg = MessageDialogWithToggle.openOkCancelConfirm((Shell)parentShell, (String)IDEWorkbenchMessages.PromptOnExitDialog_shellTitle, (String)(message = productName == null ? IDEWorkbenchMessages.PromptOnExitDialog_message0 : NLS.bind((String)IDEWorkbenchMessages.PromptOnExitDialog_message1, (Object)productName)), (String)IDEWorkbenchMessages.PromptOnExitDialog_choice, (boolean)true, null, null)).getReturnCode() != 0) {
                return false;
            }
            if (dlg.getToggleState()) {
                store.setValue("EXIT_PROMPT_ON_CLOSE_LAST_WINDOW", false);
            }
        }
        return true;
    }

    public void preWindowOpen() {
        boolean profile = Profile.STARTUP;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchWindowAdvisor.preWindowOpen.start", sdf.format(new Date()));
        IEclipsePreferences prefs = EclipseUtil.defaultScope().getNode(UIPlugin.getDefault().getBundle().getSymbolicName());
        prefs.putBoolean("ENABLE_ANIMATIONS", false);
        int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
        if (PlatformUtil.isWindows()) {
            Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
            if (dpi > 96 && screensize.width >= 1920) {
                System.setProperty("dpi-scale", String.valueOf((double)dpi / 96.0));
            }
        }
        try {
            Class<?> dpiUtilClass = Class.forName("org.eclipse.swt.internal.DPIUtil");
            Method mapDPIToZoom = dpiUtilClass.getDeclaredMethod("mapDPIToZoom", Integer.TYPE);
            mapDPIToZoom.setAccessible(true);
            Method setDeviceZoom = dpiUtilClass.getDeclaredMethod("setDeviceZoom", Integer.TYPE);
            setDeviceZoom.setAccessible(true);
            Integer dpiZoom = (Integer)mapDPIToZoom.invoke(null, dpi);
            setDeviceZoom.invoke(null, dpiZoom);
        }
        catch (Throwable throwable) {
            HBLog.logError((Plugin)IdePlugin.getDefault(), (String)"init dpi: DPIUtil class not found");
        }
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
        configurer.setShowPerspectiveBar(false);
        configurer.setShowFastViewBars(true);
        configurer.setShowProgressIndicator(true);
        configurer.setInitialSize(INITIAL_WINDOW_SIZE);
        configurer.setShowStatusLine(true);
        configurer.addEditorAreaTransfer((Transfer)EditorInputTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)ResourceTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)FileTransfer.getInstance());
        configurer.addEditorAreaTransfer((Transfer)MarkerTransfer.getInstance());
        configurer.configureEditorAreaDropListener((DropTargetListener)new EditorAreaDropAdapter2(configurer.getWindow()));
        this.hookTitleUpdateListeners(configurer);
        final IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean showToolbar = store.getBoolean(SHOW_COOLBAR);
        boolean showPerspectiveBar = store.getBoolean(SHOW_PERSPECTIVEBAR);
        final WorkbenchWindow workbenchWindow = (WorkbenchWindow)configurer.getWindow();
        if (!showToolbar) {
            workbenchWindow.setCoolBarVisible(false);
        }
        if (!showPerspectiveBar) {
            workbenchWindow.setPerspectiveBarVisible(false);
        }
        workbenchWindow.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                Object newValue = event.getNewValue();
                if (event.getProperty().equals("coolbarVisible") && newValue instanceof Boolean) {
                    store.setValue(IDEWorkbenchWindowAdvisor.SHOW_COOLBAR, ((Boolean)newValue).booleanValue());
                    if (!IDEWorkbenchWindowAdvisor.this.isToolbarProgrammaticSet) {
                        store.setValue(IDEWorkbenchWindowAdvisor.TOOLBAR_MANUALLY_ADJUSTED, true);
                    }
                }
                if (event.getProperty().equals("perspectiveBarVisible") && newValue instanceof Boolean) {
                    store.setValue(IDEWorkbenchWindowAdvisor.SHOW_PERSPECTIVEBAR, ((Boolean)newValue).booleanValue());
                    if (!IDEWorkbenchWindowAdvisor.this.isToolbarProgrammaticSet) {
                        store.setValue(IDEWorkbenchWindowAdvisor.TOOLBAR_MANUALLY_ADJUSTED, true);
                    }
                }
            }
        });
        workbenchWindow.addPerspectiveListener(new IPerspectiveListener(){
            private boolean resetting;

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (!store.getBoolean(IDEWorkbenchWindowAdvisor.TOOLBAR_MANUALLY_ADJUSTED)) {
                    boolean showToolbar = true;
                    IDEWorkbenchWindowAdvisor.this.isToolbarProgrammaticSet = true;
                    workbenchWindow.setCoolBarVisible(showToolbar);
                    workbenchWindow.setPerspectiveBarVisible(showToolbar);
                    IDEWorkbenchWindowAdvisor.this.isToolbarProgrammaticSet = false;
                }
                String id = perspective.getId();
                if (this.resetting) {
                    store.setValue(MessageFormat.format("{0}:{1}", id, IDEWorkbenchWindowAdvisor.PERSPECTIVE_MANUALLY_ADJUSTED), false);
                    IDEWorkbenchWindowAdvisor.this.customizePerspective(page);
                } else if (!store.getBoolean(MessageFormat.format("{0}:{1}", id, IDEWorkbenchWindowAdvisor.PERSPECTIVE_MANUALLY_ADJUSTED))) {
                    IDEWorkbenchWindowAdvisor.this.customizePerspective(page);
                }
                IDEWorkbenchWindowAdvisor.this.setEditorTabFolderColor();
            }

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                String id = perspective.getId();
                boolean isAptanaPerspective = id.equals(IDEWorkbenchWindowAdvisor.WEB_PERSPECTIVE_ID);
                if (isAptanaPerspective) {
                    if (changeId.equals("reset")) {
                        store.setValue(MessageFormat.format("{0}:{1}", perspective.getId(), IDEWorkbenchWindowAdvisor.PERSPECTIVE_MANUALLY_ADJUSTED), true);
                        this.resetting = true;
                    } else if (changeId.equals("resetComplete")) {
                        this.resetting = false;
                    }
                }
                IDEWorkbenchWindowAdvisor.this.setEditorTabFolderColor();
            }
        });
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_NOFOCUS_TAB_TEXT_COLOR", TAB_FOREGROUND_COLOR);
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.INACTIVE_TAB_TEXT_COLOR", TAB_FOREGROUND_COLOR);
        PlatformUI.getWorkbench().getPreferenceStore().setValue("org.eclipse.ui.workbench.ACTIVE_TAB_TEXT_COLOR", TAB_FOREGROUND_COLOR);
        PlatformUI.getWorkbench().getPreferenceStore().setDefault("REUSE_OPEN_EDITORS_BOOLEAN", true);
        PlatformUI.getWorkbench().getPreferenceStore().setDefault("REUSE_DIRTY_EDITORS", false);
        PlatformUI.getWorkbench().getPreferenceStore().setDefault("REUSE_OPEN_EDITORS", 20);
        ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchWindowAdvisor.preWindowOpen.end", sdf.format(new Date()));
        if (profile) {
            Profile.logEnter((String)"hbuilder.WindowCreate");
        }
    }

    public void postWindowCreate() {
        boolean profile;
        boolean bl = profile = Profile.STARTUP;
        if (profile) {
            Profile.logExit((String)"hbuilder.WindowCreate");
        }
        if (profile) {
            Profile.logEnter((String)"hbuilder.postWindowCreate");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchWindowAdvisor.postWindowCreate.start", sdf.format(new Date()));
        super.postWindowCreate();
        this.initCommands();
        this.initMenus();
        this.initCoolBars();
        this.initPreferences();
        if (profile) {
            Profile.logTime((String)"hbuilder.postWindowCreate", (String)"init");
        }
        this.setShellStyle();
        if (profile) {
            Profile.logTime((String)"hbuilder.postWindowCreate", (String)"setShellStyle");
        }
        ThemePlugin.getDefault().initApplyTeme();
        if (profile) {
            Profile.logTime((String)"hbuilder.postWindowCreate", (String)"initApplyTeme");
        }
        ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchWindowAdvisor.postWindowCreate.end", sdf.format(new Date()));
        if (profile) {
            Profile.logExit((String)"hbuilder.postWindowCreate");
        }
    }

    protected void initPopupMenus() {
        IWorkbenchPage page = this.getWindowConfigurer().getWindow().getActivePage();
        IViewPart part = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
        if (part instanceof CommonNavigator) {
            CommonNavigator cn = (CommonNavigator)part;
            cn.getCommonViewer().getTree().getMenu().addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    Menu menu = (Menu)e.getSource();
                    IDEWorkbenchWindowAdvisor.this.manageProjectExplorerPopupMenu(menu);
                }

                public void menuHidden(MenuEvent e) {
                }
            });
            ViewerSorter viewerSorter = cn.getCommonViewer().getSorter();
            if (viewerSorter == null) {
                IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)"\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u89c6\u56fe\u6392\u5e8f\u5668\uff1aorg.eclipse.ui.navigator.ProjectExplorer");
            }
        }
    }

    protected void forceOurNewFileWizard(Menu menu) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contrib;
            MenuItem menuItem = menuItemArray[n2];
            Object data = menuItem.getData();
            if (data instanceof IContributionItem && "common.new.menu".equals((contrib = (IContributionItem)data).getId())) {
                MenuManager manager = (MenuManager)contrib;
                manager.removeAll();
                NewWizardMenu newMenu = new NewWizardMenu(this.getWindowConfigurer().getWindow());
                manager.add((IContributionItem)newMenu);
                manager.update(true);
                break;
            }
            ++n2;
        }
    }

    protected void manageProjectExplorerPopupMenu(Menu menu) {
        if (menu != null) {
            this.forceOurNewFileWizard(menu);
            this.replaceOpenWithMenu(menu);
            MenuItem[] items = menu.getItems();
            if (TO_REMOVE == null || TO_REMOVE.isEmpty()) {
                return;
            }
            MenuItem[] menuItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem contrib;
                String itemId;
                MenuItem menuItem = menuItemArray[n2];
                Object data = menuItem.getData();
                if (data instanceof IContributionItem && TO_REMOVE.contains(itemId = (contrib = (IContributionItem)data).getId())) {
                    IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)("\u79fb\u9664\u53f3\u952e\u83dc\u5355\u9879\uff1a" + menuItem.getText()));
                    menuItem.dispose();
                }
                ++n2;
            }
        }
    }

    protected void replaceOpenWithMenu(Menu menu) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem menuItem = menuItemArray[n2];
            Object data = menuItem.getData();
            if (data instanceof MenuManager) {
                MenuManager contrib = (MenuManager)data;
                IContributionItem[] items = contrib.getItems();
                Object openWithMenu = null;
                IContributionItem[] iContributionItemArray = items;
                int n3 = items.length;
                int n4 = 0;
                while (n4 < n3) {
                    IContributionItem item = iContributionItemArray[n4];
                    if (item instanceof OpenWithMenu) {
                        openWithMenu = item;
                        break;
                    }
                    ++n4;
                }
                if (openWithMenu != null) {
                    try {
                        Field f = openWithMenu.getClass().getDeclaredField("page");
                        f.setAccessible(true);
                        IWorkbenchPage page = (IWorkbenchPage)f.get(openWithMenu);
                        f = openWithMenu.getClass().getDeclaredField("file");
                        f.setAccessible(true);
                        IAdaptable file = (IAdaptable)f.get(openWithMenu);
                        contrib.remove("org.eclipse.ui.OpenWithMenu");
                        contrib.add((IContributionItem)new com.pandora.ui.action.OpenWithMenu(page, file));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
            }
            ++n2;
        }
    }

    private void customizePerspective(IWorkbenchPage page) {
        IActionSetDescriptor[] actionSetDescriptors;
        IActionSetDescriptor[] iActionSetDescriptorArray = actionSetDescriptors = ((WorkbenchPage)page).getActivePerspective().getAlwaysOnActionSets();
        int n = actionSetDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IActionSetDescriptor actionSetDescriptor = iActionSetDescriptorArray[n2];
            if (actionSetDescriptor.getId().equals("org.eclipse.search.searchActionSet") || actionSetDescriptor.getId().equals("org.eclipse.debug.ui.launchActionSet") || actionSetDescriptor.getId().equals("org.eclipse.ui.edit.text.actionSet.annotationNavigation") || actionSetDescriptor.getId().equals("org.eclipse.ui.externaltools.ExternalToolsSet") || actionSetDescriptor.getId().equals("org.eclipse.ui.edit.text.actionSet.navigation")) {
                ((WorkbenchPage)page).getActivePerspective().turnOffActionSet(actionSetDescriptor);
            }
            ++n2;
        }
    }

    public void postWindowOpen() {
        boolean profile;
        CoreActivator.getDefault().setIdeStarted(true);
        super.postWindowOpen();
        boolean bl = profile = Profile.STARTUP;
        if (profile) {
            Profile.logEnter((String)"hbuilder.postWindowOpen");
        }
        ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchWindowAdvisor.postWindowOpen.start", String.valueOf(System.currentTimeMillis()));
        HBuilderStartUtils.ISIDEWINDOWOPEN = true;
        try {
            IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
            if (window != null && window.getShell() != null) {
                window.getShell().forceActive();
                if (window.getActivePage() != null && window.getActivePage().getActiveEditor() != null) {
                    ReadyFileUtils.loginAnalysisMap.put("activeEditor", window.getActivePage().getActiveEditor().getClass().getName());
                    IViewReference outline = window.getActivePage().findViewReference("org.eclipse.ui.views.ContentOutline");
                    ReadyFileUtils.loginAnalysisMap.put("outline", String.valueOf(outline != null && !outline.isFastView()));
                }
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
        }
        String install_location = "";
        try {
            install_location = ResourceUtil.resourcePathToString((URL)FileLocator.toFileURL((URL)Platform.getInstallLocation().getURL()));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String configurationdir = String.valueOf(install_location) + "/configuration";
        File updateFile = new File(String.valueOf(configurationdir) + "/update_show_md.txt");
        if (updateFile.exists()) {
            BrowserEditorUtil.showUpgradeLog();
        }
        updateFile.delete();
        this.startupReady();
        if (profile) {
            Profile.logTime((String)"hbuilder.postWindowOpen", (String)"startupReady");
        }
        this.initPopupMenus();
        if (profile) {
            Profile.logTime((String)"hbuilder.postWindowOpen", (String)"initPopupMenus");
        }
        this.createEmptyEditorArea();
        if (profile) {
            Profile.logTime((String)"hbuilder.postWindowOpen", (String)"createEmptyEditorArea");
        }
        String isSetTheme = UiActivator.getDefault().getPreferenceStore().getString(UiActivator.SETTHEMEKEY);
        this.setUpDefaultTheme();
        if (profile) {
            Profile.logTime((String)"hbuilder.postWindowOpen", (String)"setUpDefaultTheme");
        }
        this.setEditorTabFolderColor();
        if (profile) {
            Profile.logTime((String)"hbuilder.postWindowOpen", (String)"setEditorTabFolderColor");
        }
        new Thread(){

            @Override
            public void run() {
                StartupCheckUpadte.checkUpdate();
            }
        }.start();
        if (profile) {
            Profile.logTime((String)"hbuilder.postWindowOpen", (String)"StartupCheckUpadte.checkUpdate");
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    ReadyFileUtils.postStartInfoStats();
                    File workspace = new File(Platform.getInstanceLocation().getURL().toString());
                    IdeLog.logError((Plugin)IdePlugin.getDefault(), (String)("workspace : " + workspace));
                    if (!"default".equals(workspace.getName())) {
                        FileUtils.deleteQuietly((File)new File(workspace.getParent(), "default"));
                    }
                }
                catch (Exception e) {
                    IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
                }
            }
        }.start();
        UserAuth.initUserAuth((String)UserAuth.getUsername(), (String)"");
        HomeControlContribution.updateStatus();
        if (profile) {
            Profile.logExit((String)"hbuilder.postWindowOpen");
        }
        this.checkStartTime("true".equals(isSetTheme));
    }

    private void checkStartTime(boolean openedThemeDialog) {
        try {
            if (!openedThemeDialog) {
                return;
            }
            String starttime = ReadyFileUtils.getTimeBeyond(ReadyFileUtils.loginAnalysisMap.get("HBuilderStartTime"), ReadyFileUtils.loginAnalysisMap.get("IDEWorkbenchWindowAdvisor.postWindowOpen.start"));
            long lStartTime = 0L;
            lStartTime = Platform.inDevelopmentMode() ? 100000L : Long.parseLong(starttime);
            if (lStartTime < 10000L) {
                return;
            }
            ScheduleEventAction e = ScheduleEventAction.getInstance();
            if (!e.enable()) {
                return;
            }
            if (e.isAvalied()) {
                return;
            }
            if (e.isNotifyOpened()) {
                if (e.isChangeInstallLocation() && e.isUserLoveThisFeature()) {
                    e.notifyOpen();
                }
            } else {
                e.notifyOpen();
            }
            e.saveState();
        }
        catch (NumberFormatException e) {
            IdeLog.logError((Plugin)CorePlugin.getDefault(), (Throwable)e);
        }
    }

    private void changeFileEncodingWithoutException(File file) {
        try {
            String content = FileUtils.readFileToString((File)file, (String)"utf-8");
            String workspaceEncoding = ResourcesPlugin.getPlugin().getPluginPreferences().getString("encoding");
            FileUtils.write((File)file, (CharSequence)content, (String)workspaceEncoding);
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
            Stats.addExceptionInfo((Throwable)e);
        }
    }

    protected void startupReady() {
        String tmppath = PlatformUtil.isWindows() ? System.getenv().get("APPDATA") : System.getenv().get("HOME");
        File readyFile = new File(String.valueOf(tmppath) + "/HBuilder/HBuilder User/ready.properties");
        File parentFile = readyFile.getParentFile();
        if (!parentFile.exists() || !parentFile.isDirectory()) {
            readyFile.getParentFile().mkdirs();
        }
        if (!readyFile.exists()) {
            try {
                readyFile.createNewFile();
                ReadyFileUtils.loginAnalysisMap.put("readytime", String.valueOf(System.currentTimeMillis()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void setEditorTabFolderColor() {
        Control[] children;
        if (this.getWindowConfigurer().getWindow() == null) {
            return;
        }
        if (this.getWindowConfigurer().getWindow().getActivePage() == null) {
            return;
        }
        WorkbenchPage page = (WorkbenchPage)this.getWindowConfigurer().getWindow().getActivePage();
        Composite client = page.getClientComposite();
        Control[] controlArray = children = client.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            if (control instanceof Composite) {
                Control[] subchildren;
                Control[] controlArray2 = subchildren = ((Composite)control).getChildren();
                int n3 = subchildren.length;
                int n4 = 0;
                while (n4 < n3) {
                    Control subcontrol = controlArray2[n4];
                    if (subcontrol instanceof CTabFolder) {
                        ((CTabFolder)subcontrol).setBackgroundMode(2);
                    }
                    ++n4;
                }
            }
            if (control instanceof CTabFolder) {
                ((CTabFolder)control).setBackgroundMode(2);
            }
            if (control instanceof ToolBar) {
                ((ToolBar)control).setBackgroundMode(2);
            }
            ++n2;
        }
    }

    protected void createEmptyEditorArea() {
        IWorkbenchPage page = this.getWindowConfigurer().getWindow().getActivePage();
        if (page != null && page instanceof WorkbenchPage) {
            IEditorReference[] editorReferences = page.getEditorReferences();
            WelcomeWizardDesktop wizardContents = new WelcomeWizardDesktop();
            if (editorReferences == null || editorReferences.length == 0) {
                WorkbenchPage workbenchPage = (WorkbenchPage)page;
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IProject[] projects = root.getProjects();
                try {
                    wizardContents.createContents(workbenchPage, projects == null || projects.length == 0);
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
                }
            }
            page.addPartListener((IPartListener)wizardContents);
        }
    }

    protected void initMenus() {
        try {
            IContributionItem[] items;
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getWindowConfigurer().getWindow();
            MenuManager menuManager = workbenchWindow.getMenuBarManager();
            menuManager.remove("org.eclipse.ui.run");
            menuManager.remove("com.aptana.source.menu");
            menuManager.remove("org.eclipse.search.menu");
            menuManager.remove("io.emmet.eclipse.menus.emmetMenu");
            IContributionItem[] iContributionItemArray = items = menuManager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                if (item instanceof MenuManager) {
                    if (item.getId().equals("help") && item instanceof MenuManager) {
                        ((MenuManager)item).remove("org.eclipse.equinox.p2.ui.sdk.install");
                        ((MenuManager)item).remove("org.eclipse.equinox.p2.ui.sdk.update");
                        ((MenuManager)item).remove("org.eclipse.epp.mpc.ui.command.showMarketplaceWizard");
                        ((MenuManager)item).remove("helpContents");
                        ((MenuManager)item).remove("dynamicHelp");
                        ((MenuManager)item).remove("helpSearch");
                        ((MenuManager)item).remove("tipsAndTricks");
                        ((MenuManager)item).remove("org.eclipse.ui.cheatsheets.actions.CheatSheetHelpMenuAction");
                        ((MenuManager)item).remove("org.eclipse.ui.actions.showKeyAssistHandler");
                    }
                    if (item.getId().equals("window") && item instanceof MenuManager) {
                        ((MenuManager)item).remove("org.eclipse.ui.window.closePerspective");
                        ((MenuManager)item).remove("org.eclipse.ui.window.closeAllPerspectives");
                    }
                    ((MenuManager)item).addMenuListener(new IMenuListener(){

                        public void menuAboutToShow(IMenuManager manager) {
                            IContributionItem[] iContributionItemArray = manager.getItems();
                            int n = iContributionItemArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IContributionItem item = iContributionItemArray[n2];
                                if (item != null && item.getId() != null && item instanceof CommandContributionItem && item.getId().indexOf(".ruby.") > 0) {
                                    HandlerProxy handlerProxy = (HandlerProxy)((CommandContributionItem)item).getCommand().getCommand().getHandler();
                                    IHandler handler = handlerProxy.getHandler();
                                    if (handler instanceof AbstractEnabledHandler) {
                                        ((AbstractEnabledHandler)handler).setEnabled((Object)handler.isEnabled());
                                        item.update();
                                    }
                                } else if (item != null && item.getId() != null && item instanceof CommandContributionItem && (item.getId().equals("copy") || item.getId().equals("cut"))) {
                                    if (PlatformUI.getWorkbench() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
                                        IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                                        CommandContributionItem commandContributionItem = (CommandContributionItem)item;
                                        String text = "\u526a\u5207(&T)";
                                        String text_ = "\u526a\u5207\u9009\u533a\u6216\u5f53\u524d\u884c(&T)";
                                        if (item.getId().equals("copy")) {
                                            text = "\u590d\u5236(&C)";
                                            text_ = "\u590d\u5236\u9009\u533a\u6216\u5f53\u524d\u884c(&T)";
                                        }
                                        if (part != null && part instanceof AbstractThemeableEditor) {
                                            commandContributionItem.setText(text_);
                                        } else {
                                            commandContributionItem.setText(text);
                                        }
                                    }
                                } else if (item instanceof MenuManager) {
                                    ((MenuManager)item).addMenuListener((IMenuListener)this);
                                }
                                ++n2;
                            }
                        }
                    });
                }
                ++n2;
            }
            menuManager.update(true);
        }
        catch (Exception e) {
            IdePlugin.getDefault().getLog().log((IStatus)new Status(4, IdePlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
    }

    protected void initCoolBars() {
        try {
            List<String> list = Arrays.asList("org.eclipse.debug.ui.launchActionSet", "org.eclipse.search.searchActionSet", "org.eclipse.ui.edit.text.actionSet.presentation", "org.eclipse.ui.edit.text.actionSet.navigation", "org.eclipse.ui.externaltools.ExternalToolsSet", "org.eclipse.ui.edit.text.actionSet.annotationNavigation");
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)this.getWindowConfigurer().getWindow();
            CoolBarManager coolBarManager = workbenchWindow.getCoolBarManager();
            for (String id : list) {
                coolBarManager.remove(id);
            }
            Object cbItemsCreationOrder = ReflectUtils.getFieldValue((Object)coolBarManager, (String[])new String[]{"cbItemsCreationOrder"});
            if (cbItemsCreationOrder instanceof ArrayList) {
                Iterator it = ((ArrayList)cbItemsCreationOrder).iterator();
                while (it.hasNext()) {
                    Object itemObject = it.next();
                    if (!list.contains(((IContributionItem)itemObject).getId())) continue;
                    it.remove();
                }
            }
            coolBarManager.update(true);
        }
        catch (Exception e) {
            IdePlugin.getDefault().getLog().log((IStatus)new Status(4, IdePlugin.PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
    }

    protected void initPreferences() {
        PreferenceManager preferenceManager = PlatformUI.getWorkbench().getPreferenceManager();
        this.removeSubPreferenceNode(preferenceManager, "org.eclipse.ui.ide.application", "org.eclipse.ui.preferencePages.Workbench", "org.eclipse.ui.preferencePages.Startup");
        this.removeSubPreferenceNode(preferenceManager, null, "org.eclipse.ui.preferencePages.Workbench", "org.eclipse.ui.preferencePages.Editors", "org.eclipse.ui.preferencePages.GeneralTextEditor", "org.eclipse.ui.editors.preferencePages.HyperlinkDetectorsPreferencePage");
        this.removeSubPreferenceNode(preferenceManager, "org.eclipse.equinox.p2.ui.sdk.scheduler", "org.eclipse.equinox.internal.p2.ui.sdk.ProvisioningPreferencePage", "org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatesPreferencePage");
    }

    protected void initCommands() {
        try {
            Category autogeneratedCategory;
            ICommandService commandService = (ICommandService)this.getWorkbench().getAdapter(ICommandService.class);
            if (commandService != null && (autogeneratedCategory = commandService.getCategory("org.eclipse.core.commands.categories.autogenerated")) != null) {
                this.clearCommandCategory("org.eclipse.ui.edit.text.toggleShowWhitespaceCharacters", commandService, autogeneratedCategory);
                this.clearCommandCategory("org.eclipse.ui.edit.text.toggleBlockSelectionMode", commandService, autogeneratedCategory);
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
        }
    }

    private void clearCommandCategory(String commandId, ICommandService commandService, Category autogeneratedCategory) {
        try {
            Command command = commandService.getCommand(commandId);
            if (command != null) {
                Class<?> c = command.getClass();
                Field field = c.getDeclaredField("category");
                field.setAccessible(true);
                field.set(command, autogeneratedCategory);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
        }
    }

    private void removeSubPreferenceNode(PreferenceManager preferenceManager, String pluginId, String ... tree) {
        if (tree == null || tree.length == 0) {
            return;
        }
        IPreferenceNode childNode = null;
        IPreferenceNode parentNode = null;
        int i = 0;
        while (i < tree.length) {
            parentNode = childNode;
            String id = tree[i];
            if (childNode == null) {
                childNode = preferenceManager.find(id);
            } else if (pluginId == null) {
                childNode = childNode.findSubNode(id);
            } else {
                IPreferenceNode[] iPreferenceNodeArray = childNode.getSubNodes();
                int n = iPreferenceNodeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    WorkbenchPreferenceNode node;
                    IPreferenceNode subNode = iPreferenceNodeArray[n2];
                    if (id.equals(subNode.getId()) && subNode instanceof WorkbenchPreferenceNode && pluginId.equals((node = (WorkbenchPreferenceNode)subNode).getPluginId())) {
                        childNode = subNode;
                        break;
                    }
                    ++n2;
                }
            }
            ++i;
        }
        if (childNode != null && parentNode != null && childNode instanceof WorkbenchPreferenceNode) {
            WorkbenchPreferenceNode node = (WorkbenchPreferenceNode)childNode;
            if (pluginId == null || pluginId.equals(node.getPluginId())) {
                parentNode.remove(childNode);
            }
        }
    }

    private void createSystemTray() {
        this.dragonSysTray = new IDETray();
        this.dragonSysTray.createSysTray(this.getWindowConfigurer().getWindow());
    }

    private void hookTitleUpdateListeners(IWorkbenchWindowConfigurer configurer) {
        configurer.getWindow().addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void pageClosed(IWorkbenchPage page) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        });
        configurer.getWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }

            public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                IDEWorkbenchWindowAdvisor.this.updateTitle();
            }
        });
        configurer.getWindow().getPartService().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    IDEWorkbenchWindowAdvisor.this.updateTitle();
                }
                IDEWorkbenchWindowAdvisor.this.setEditorTabFolderColor();
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    IDEWorkbenchWindowAdvisor.this.updateTitle();
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
                IViewPart view;
                IDEWorkbenchWindowAdvisor.this.updateTitle();
                if (ref instanceof IViewReference && (view = ((IViewReference)ref).getView(false)) instanceof CommonNavigator) {
                    IEclipsePreferences ieps = EclipseUtil.instanceScope().getNode(NavigatorPlugin.PLUGIN_ID);
                    ieps.putBoolean("setLinking", ((CommonNavigator)view).isLinkingEnabled());
                }
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
                IViewPart view;
                if (ref instanceof IViewReference && (view = ((IViewReference)ref).getView(false)) instanceof CommonNavigator) {
                    IEclipsePreferences ieps = EclipseUtil.instanceScope().getNode(NavigatorPlugin.PLUGIN_ID);
                    ((CommonNavigator)view).setLinkingEnabled(ieps.getBoolean("setLinking", true));
                }
                IDEWorkbenchWindowAdvisor.this.setEditorTabFolderColor();
            }

            public void partHidden(IWorkbenchPartReference ref) {
            }

            public void partVisible(IWorkbenchPartReference ref) {
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
            }
        });
    }

    private String computeTitle() {
        String workspaceLocation;
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchPage currentPage = configurer.getWindow().getActivePage();
        IEditorPart activeEditor = null;
        if (currentPage != null) {
            activeEditor = currentPage.getActiveEditor();
        }
        String title = "HBuilder ";
        if (currentPage != null) {
            if (activeEditor != null) {
                this.lastEditorTitle = IDEWorkbenchWindowAdvisor.getTitle(activeEditor);
                title = NLS.bind((String)IDEWorkbenchMessages.WorkbenchWindow_shellTitle, (Object)this.lastEditorTitle, (Object)title);
            }
            String label = "";
            IAdaptable input = currentPage.getInput();
            if (input != null && !input.equals(this.wbAdvisor.getDefaultPageInput())) {
                label = currentPage.getLabel();
            }
            if (label != null && !label.equals("")) {
                title = NLS.bind((String)IDEWorkbenchMessages.WorkbenchWindow_shellTitle, (Object)label, (Object)title);
            }
        }
        if ((workspaceLocation = this.wbAdvisor.getWorkspaceLocation()) != null) {
            title = NLS.bind((String)IDEWorkbenchMessages.WorkbenchWindow_shellTitle, (Object)title, (Object)workspaceLocation);
        }
        return title;
    }

    private void recomputeTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        String oldTitle = configurer.getTitle();
        String newTitle = this.computeTitle();
        if (!newTitle.equals(oldTitle)) {
            configurer.setTitle(newTitle);
        }
    }

    private void updateTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        IEditorPart activeEditor = null;
        IWorkbenchPage currentPage = window.getActivePage();
        IPerspectiveDescriptor persp = null;
        IAdaptable input = null;
        if (currentPage != null) {
            activeEditor = currentPage.getActiveEditor();
            persp = currentPage.getPerspective();
            input = currentPage.getInput();
        }
        if (activeEditor == this.lastActiveEditor && currentPage == this.lastActivePage && persp == this.lastPerspective && input == this.lastInput) {
            return;
        }
        if (this.lastActiveEditor != null) {
            this.lastActiveEditor.removePropertyListener(this.editorPropertyListener);
        }
        this.lastActiveEditor = activeEditor;
        this.lastActivePage = currentPage;
        this.lastPerspective = persp;
        this.lastInput = input;
        if (activeEditor != null) {
            activeEditor.addPropertyListener(this.editorPropertyListener);
        }
        this.recomputeTitle();
    }

    private static String getTitle(IEditorPart part) {
        String title = part.getTitleToolTip();
        return title.equals("") ? part.getTitle() : title;
    }

    public void postWindowRestore() throws WorkbenchException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void openIntro() {
        if (this.editorsAndIntrosOpened) {
            return;
        }
        this.editorsAndIntrosOpened = true;
        if (this.wbAdvisor.hasIntro()) {
            super.openIntro();
        } else {
            this.openWelcomeEditors(this.getWindowConfigurer().getWindow());
        }
        if (ReadyFileUtils.hasqs) {
            SystemUtils.exit();
        }
        if (!Platform.inDevelopmentMode()) {
            ReadyFileUtils.startCheckFile();
        }
        IdePlugin.getDefault().getLog().log((IStatus)new Status(4, IdePlugin.PLUGIN_ID, "check mode"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchWindowAdvisor.locktime.start", sdf.format(new Date()));
        if (!Platform.inDevelopmentMode() && HBuilderStartUtils.START_TYPE == 1) {
            Object object = InitializationUtils.lock;
            synchronized (object) {
                while (!InitializationUtils.canOpen) {
                    try {
                        InitializationUtils.lock.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            IdePlugin.getDefault().getLog().log((IStatus)new Status(4, IdePlugin.PLUGIN_ID, "IDE lock"));
        }
        ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchWindowAdvisor.unlocktime.start", sdf.format(new Date()));
    }

    protected void setShellStyle() {
        Shell shell = this.getWindowConfigurer().getWindow().getShell();
        shell.setBackground(SHELL_BACKGROUND_COLOR);
        shell.setBackgroundMode(2);
    }

    private void setUpDefaultTheme() {
        final Shell shell = this.getWindowConfigurer().getWindow().getShell();
        boolean notMax = IdePlugin.getDefault().getPreferenceStore().getBoolean("NOT_MAX_WINDOWS");
        if (!notMax) {
            shell.setMaximized(true);
            IdePlugin.getDefault().getPreferenceStore().setValue("NOT_MAX_WINDOWS", true);
            shell.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    if (!shell.getMinimized()) {
                        Point screenSize = IDEWorkbenchWindowAdvisor.this.getScreenSize();
                        shell.setBounds((int)((double)(screenSize.x - INITIAL_WINDOW_SIZE.x) / 2.0), (int)((double)(screenSize.y - INITIAL_WINDOW_SIZE.y) / 2.0), INITIAL_WINDOW_SIZE.x, INITIAL_WINDOW_SIZE.y);
                    }
                    shell.removeControlListener((ControlListener)this);
                }
            });
        }
        new DefaultThemeUI(shell, false);
    }

    private void openWelcomeEditors(IWorkbenchWindow window) {
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("WELCOME_DIALOG")) {
            IDEWorkbenchPlugin.getDefault().getPreferenceStore().setValue("WELCOME_DIALOG", false);
            BrowserEditorUtil.showTutorial();
        } else {
            ArrayList<AboutInfo> welcomeFeatures = new ArrayList<AboutInfo>();
            Map<String, AboutInfo> groups = this.wbAdvisor.getNewlyAddedBundleGroups();
            for (AboutInfo info : groups.values()) {
                if (info == null || info.getWelcomePageURL() == null) continue;
                welcomeFeatures.add(info);
            }
            int wCount = this.getWorkbench().getWorkbenchWindowCount();
            int i = 0;
            while (i < welcomeFeatures.size()) {
                AboutInfo newInfo = (AboutInfo)welcomeFeatures.get(i);
                String id = newInfo.getWelcomePerspectiveId();
                if (id == null || i >= wCount) {
                    this.openWelcomeEditor(window, new WelcomeEditorInput(newInfo), id);
                }
                ++i;
            }
        }
    }

    private void openWelcomeEditor(IWorkbenchWindow window, WelcomeEditorInput input, String perspectiveId) {
        if (this.getWorkbench().getWorkbenchWindowCount() == 0) {
            return;
        }
        IWorkbenchWindow win = window;
        if (perspectiveId != null) {
            try {
                win = this.getWorkbench().openWorkbenchWindow(perspectiveId, this.wbAdvisor.getDefaultPageInput());
                if (win == null) {
                    win = window;
                }
            }
            catch (WorkbenchException e) {
                IDEWorkbenchPlugin.log((String)"Error opening window with welcome perspective.", (IStatus)e.getStatus());
                return;
            }
        }
        if (win == null) {
            win = this.getWorkbench().getWorkbenchWindows()[0];
        }
        IWorkbenchPage page = win.getActivePage();
        String id = perspectiveId;
        if (id == null) {
            id = this.getWorkbench().getPerspectiveRegistry().getDefaultPerspective();
        }
        if (page == null) {
            try {
                page = win.openPage(id, this.wbAdvisor.getDefaultPageInput());
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Problems_Opening_Page, (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            try {
                page = this.getWorkbench().showPerspective(id, win);
            }
            catch (WorkbenchException e) {
                ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogTitle, (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogMessage, (IStatus)e.getStatus());
                return;
            }
        }
        page.setEditorAreaVisible(true);
        IEditorPart editor = page.findEditor((IEditorInput)input);
        if (editor != null) {
            page.activate((IWorkbenchPart)editor);
            return;
        }
        try {
            page.openEditor((IEditorInput)input, WELCOME_EDITOR_ID);
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)win.getShell(), (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogTitle, (String)IDEWorkbenchMessages.Workbench_openEditorErrorDialogMessage, (IStatus)e.getStatus());
        }
    }

    public Control createEmptyWindowContents(Composite parent) {
        IWorkbenchWindow window = this.getWindowConfigurer().getWindow();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Display display = composite.getDisplay();
        Color bgCol = display.getSystemColor(34);
        composite.setBackground(bgCol);
        Label label = new Label(composite, 64);
        label.setForeground(display.getSystemColor(33));
        label.setBackground(bgCol);
        label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        String msg = IDEWorkbenchMessages.IDEWorkbenchAdvisor_noPerspective;
        label.setText(msg);
        ToolBarManager toolBarManager = new ToolBarManager();
        this.openPerspectiveAction = ActionFactory.OPEN_PERSPECTIVE_DIALOG.create(window);
        toolBarManager.add((IAction)this.openPerspectiveAction);
        ToolBar toolBar = toolBarManager.createControl(composite);
        toolBar.setBackground(bgCol);
        return composite;
    }

    public void dispose() {
        if (this.openPerspectiveAction != null) {
            this.openPerspectiveAction.dispose();
            this.openPerspectiveAction = null;
        }
        if (this.dragonSysTray != null) {
            this.dragonSysTray.dispose();
        }
        super.dispose();
    }

    class EditorAreaDropAdapter2
    extends EditorAreaDropAdapter {
        IWorkbenchWindow window;

        public EditorAreaDropAdapter2(IWorkbenchWindow window) {
            super(window);
            this.window = window;
        }

        public void drop(DropTargetEvent event) {
            TransferData currentTransfer = event.currentDataType;
            if (FileTransfer.getInstance().isSupportedType(currentTransfer)) {
                String[] names = (String[])event.data;
                File[] files = new File[names.length];
                int i = 0;
                while (i < files.length) {
                    File file = new File(names[i]);
                    if (file.isFile()) {
                        IDEUtils.openLocalFile((File)file, (IWorkbenchWindow)this.window);
                    } else if (file.isDirectory()) {
                        ImportFolderAction action = new ImportFolderAction(file);
                        action.run();
                    }
                    ++i;
                }
            } else {
                super.drop(event);
            }
        }
    }
}

