/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp;

import com.aptana.commandline.launcher.server.SocketUtils;
import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.ObjectUtil;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.editor.common.CommonEditorPlugin;
import com.aptana.rcp.DelayedEventsProcessor;
import com.aptana.rcp.ExitUtils;
import com.aptana.rcp.IDEIdleHelper;
import com.aptana.rcp.IDEWorkbenchWindowAdvisor;
import com.aptana.rcp.IdePlugin;
import com.aptana.rcp.InitializationUtils;
import com.aptana.rcp.Messages;
import com.aptana.rcp.ReadyFileUtils;
import com.ibm.icu.text.Collator;
import com.pandora.core.utils.CrashUtil;
import com.pandora.core.utils.IDEExitUtils;
import com.pandora.rcp.upgrade.P2UpgradeUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.PluginActionBuilder;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDESelectionConversionService;
import org.eclipse.ui.internal.ide.IDEWorkbenchActivityHelper;
import org.eclipse.ui.internal.ide.IDEWorkbenchErrorHandler;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.undo.WorkspaceUndoMonitor;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.internal.util.PrefUtil;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;

public class IDEWorkbenchAdvisor
extends WorkbenchAdvisor {
    public static final String OPEN_EDITORS_XML = "open_editors.xml";
    private static final String WORKBENCH_PREFERENCE_CATEGORY_ID = "org.eclipse.ui.preferencePages.Workbench";
    private static final String HAS_CHANGE_NEW_ID = "hasChangeNewID20150908";
    private static final String HAS_RESET_PHP_DEFAULT_EDITOR = "hasResetPhpDefaultEditor20160918";
    private static final String HAS_SET_BUILT_IN_PHP_EDITOR = "hasSetBuiltInPhpEditor";
    private static final String HAS_RESET_SEARCHBAR_POINT = "hasResetSearchBarPoint20150923";
    private static final String HAS_RESET_OPENWITH_POINT = "hasResetOpenWithPoint20160627";
    private static final String HAS_RESET_OPEN_DEFAULT_EDITOR = "hasResetOpenDefaultEditor20150626";
    private static final String INSTALLED_FEATURES = "installedFeatures";
    private static final String[] IGNORED_STATUS_MESSAGES = new String[]{"Keybinding conflicts occurred"};
    private static IDEWorkbenchAdvisor workbenchAdvisor = null;
    private WorkbenchWindowAdvisor workbenchWindowAdvisor;
    private String workspaceLocation = null;
    private Map<String, AboutInfo> newlyAddedBundleGroups;
    private AboutInfo[] welcomePerspectiveInfos = null;
    private IDEWorkbenchActivityHelper activityHelper = null;
    private IDEIdleHelper idleHelper;
    private Listener settingsChangeListener;
    private WorkspaceUndoMonitor workspaceUndoMonitor;
    private AbstractStatusHandler ideWorkbenchErrorHandler;
    private DelayedEventsProcessor delayedEventsProcessor;
    private final String[] args;

    public IDEWorkbenchAdvisor(DelayedEventsProcessor processor, String[] args) {
        this.delayedEventsProcessor = processor;
        this.args = args;
        IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)("start args:" + StringUtil.join((String)",", (String[])this.args)));
        if (workbenchAdvisor != null) {
            throw new IllegalStateException();
        }
        workbenchAdvisor = this;
        final Listener closeListener = new Listener(){

            public void handleEvent(Event event) {
                boolean doExit;
                event.doit = doExit = IDEWorkbenchWindowAdvisor.promptOnExit(null);
                if (!doExit) {
                    event.type = 0;
                }
            }
        };
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().addListener(21, closeListener);
            }
        });
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchAdvisor.initialize.start", String.valueOf(System.currentTimeMillis()));
        PluginActionBuilder.setAllowIdeLogging((boolean)true);
        configurer.setSaveAndRestore(true);
        IDE.registerAdapters();
        String[] cmdLineArgs = Platform.getCommandLineArgs();
        int i = 0;
        while (i < cmdLineArgs.length) {
            if ("-showlocation".equalsIgnoreCase(cmdLineArgs[i])) {
                String name = null;
                if (cmdLineArgs.length > i + 1) {
                    name = cmdLineArgs[i + 1];
                }
                if (name != null && name.indexOf("-") == -1) {
                    this.workspaceLocation = name;
                    break;
                }
                this.workspaceLocation = Platform.getLocation().toOSString();
                break;
            }
            ++i;
        }
        this.declareWorkbenchImages();
        this.activityHelper = IDEWorkbenchActivityHelper.getInstance();
        this.idleHelper = new IDEIdleHelper(configurer);
        this.workspaceUndoMonitor = WorkspaceUndoMonitor.getInstance();
        TrayDialog.setDialogHelpAvailable((boolean)true);
        Policy.setComparator((Comparator)Collator.getInstance());
        ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchAdvisor.initialize.end", String.valueOf(System.currentTimeMillis()));
    }

    public void preStartup() {
        block23: {
            ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchAdvisor.preStartup.start", String.valueOf(System.currentTimeMillis()));
            Job.getJobManager().suspend();
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            ImageDescriptor newImage = IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_BUILD_EXEC");
            service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_MANUAL_BUILD);
            service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_AUTO_BUILD);
            String productVersion = EclipseUtil.getProductVersion();
            if (productVersion == null) {
                productVersion = "";
            }
            FrameworkProperties.setProperty((String)"eclipse.buildId", (String)productVersion);
            PrefUtil.getAPIPreferenceStore().setValue("DISABLE_OPEN_EDITOR_IN_PLACE", true);
            File configFile = null;
            File backupFile = null;
            try {
                Document configXml = null;
                IPath path = WorkbenchPlugin.getDefault().getDataLocation();
                if (path != null && (configFile = (path = path.append("workbench.xml")).toFile()).exists()) {
                    backupFile = new File(configFile.getParentFile(), String.valueOf(configFile.getName()) + ".bakup");
                    backupFile.createNewFile();
                    IdeLog.logInfo((Plugin)IdePlugin.getDefault(), (String)"\u5907\u4efd  workbench.xml \u6587\u4ef6");
                    FileUtil.copyFile((File)configFile, (File)backupFile);
                    try {
                        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(IdePlugin.PLUGIN_ID);
                        if (!prefs.getBoolean(HAS_CHANGE_NEW_ID, false)) {
                            String xml = FileUtils.readFileToString((File)configFile, (String)"utf-8");
                            boolean hasOldId = false;
                            if (xml.contains("com.aptana.browser.views.webbrowser")) {
                                xml = xml.replace("com.aptana.browser.views.webbrowser", "com.pandora.view.browser.view.WebBrowserView");
                                hasOldId = true;
                            }
                            if (xml.contains("com.pandora.projects.ui.wizards.NewMKeyProjectWizard")) {
                                xml = xml.replace("com.pandora.projects.ui.wizards.NewMKeyProjectWizard", "com.pandora.projects.ui.wizards.NewHMobileProjectWizard");
                                hasOldId = true;
                            }
                            if (PlatformUtil.isMac() && xml.contains("\"org.eclipse.ui.browser.view\"")) {
                                xml = xml.replace("\"org.eclipse.ui.browser.view\"", "\"com.pandora.view.browser.view.WebBrowserView\"");
                                xml = xml.replace("\"\u5185\u90e8 Web \u6d4f\u89c8\u5668\"", "\"Web\u6d4f\u89c8\u5668\"");
                                hasOldId = true;
                            }
                            if (hasOldId) {
                                FileUtils.write((File)configFile, (CharSequence)xml, (String)"utf-8");
                            }
                            prefs.putBoolean(HAS_CHANGE_NEW_ID, true);
                            prefs.flush();
                        }
                    }
                    catch (Throwable e) {
                        IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
                    }
                    SAXReader reader = new SAXReader();
                    reader.setEncoding("utf-8");
                    configXml = reader.read(configFile);
                }
                boolean changed = this.updateChangeDefaultEditor(configXml);
                changed = this.updateSearchBarPoint(configXml) || changed;
                changed = this.updateOpenwithPoint(configXml) || changed;
                boolean bl = changed = this.updateEditorsPoint(configXml) || changed;
                if (!changed || configXml == null) break block23;
                XMLWriter writer = null;
                try {
                    OutputFormat out = new OutputFormat("", true, "utf-8");
                    writer = new XMLWriter((OutputStream)new FileOutputStream(configFile), out);
                    writer.write(configXml);
                    writer.close();
                }
                finally {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
                        }
                    }
                }
            }
            catch (Throwable e) {
                try {
                    IdeLog.logError((Plugin)IdePlugin.getDefault(), (String)"\u4fee\u6539workbench.xml\u5931\u8d25, \u8fd8\u539f\u6587\u4ef6", (Throwable)e);
                    if (backupFile != null && backupFile.exists()) {
                        if (configFile != null && configFile.exists()) {
                            configFile.delete();
                        }
                        backupFile.renameTo(configFile);
                    }
                }
                catch (Throwable ex) {
                    IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)ex);
                }
            }
        }
        ReadyFileUtils.loginAnalysisMap.put("IDEWorkbenchAdvisor.preStartup.end", String.valueOf(System.currentTimeMillis()));
    }

    protected boolean updateChangeDefaultEditor(Document configXml) throws Exception {
        boolean changed = false;
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(IdePlugin.PLUGIN_ID);
        String[] extensions = new String[]{"php", "phtml", "inc", "ctp"};
        boolean hasSetBuiltInPhp = prefs.getBoolean(HAS_SET_BUILT_IN_PHP_EDITOR, false);
        boolean hasSet = prefs.getBoolean(HAS_RESET_PHP_DEFAULT_EDITOR, false);
        boolean isPhpChange = false;
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor htmlEditor = editorRegistry.findEditor("com.aptana.editor.html");
        IEditorDescriptor builtInPhpEditor = editorRegistry.findEditor("com.pandora.editor.php");
        IEditorDescriptor phpEditor = editorRegistry.findEditor("com.aptana.editor.php");
        if (phpEditor != null || !hasSetBuiltInPhp) {
            FileEditorMapping[] fms;
            FileEditorMapping[] fileEditorMappingArray = fms = (FileEditorMapping[])editorRegistry.getFileEditorMappings();
            int n = fms.length;
            int n2 = 0;
            while (n2 < n) {
                FileEditorMapping fm = fileEditorMappingArray[n2];
                if (StringUtil.contains((String[])extensions, (String)fm.getExtension())) {
                    if (!hasSetBuiltInPhp) {
                        fm.removeEditor((EditorDescriptor)htmlEditor);
                    }
                    if (phpEditor != null) {
                        fm.setDefaultEditor((EditorDescriptor)phpEditor);
                    } else if (builtInPhpEditor != null) {
                        fm.setDefaultEditor((EditorDescriptor)builtInPhpEditor);
                    }
                }
                ++n2;
            }
            ((EditorRegistry)editorRegistry).setFileEditorMappings(fms);
            prefs.putBoolean(HAS_RESET_PHP_DEFAULT_EDITOR, true);
            prefs.putBoolean(HAS_SET_BUILT_IN_PHP_EDITOR, true);
            try {
                prefs.flush();
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
            }
            isPhpChange = !hasSet;
        } else if (hasSet && phpEditor == null) {
            isPhpChange = true;
            prefs.putBoolean(HAS_RESET_PHP_DEFAULT_EDITOR, false);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        hasSet = prefs.getBoolean(HAS_RESET_OPEN_DEFAULT_EDITOR, false);
        if (!hasSet || isPhpChange) {
            Collection elements;
            prefs.putBoolean(HAS_RESET_OPEN_DEFAULT_EDITOR, true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
            if (configXml != null && (elements = CollectionsUtil.union((Collection)configXml.selectNodes("//page/editors/editor"), (Collection)configXml.selectNodes("//mruList/file"))) != null && !elements.isEmpty()) {
                for (Element e : elements) {
                    IEditorDescriptor defaultEditor;
                    Attribute id = e.attribute("id");
                    String name = e.attributeValue("name");
                    if (id == null || !StringUtil.isNotEmpty((String)name) || (defaultEditor = editorRegistry.getDefaultEditor(name)) == null || ObjectUtil.areEqual((Object)id.getValue(), (Object)defaultEditor.getId())) continue;
                    id.setValue(defaultEditor.getId());
                    changed = true;
                    IdeLog.logInfo((Plugin)IdePlugin.getDefault(), (String)("name: " + name + "   id: " + id.getValue()));
                }
            }
        }
        return changed;
    }

    protected boolean updateSearchBarPoint(Document configXml) throws Exception {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(IdePlugin.PLUGIN_ID);
        boolean hasSet = prefs.getBoolean(HAS_RESET_SEARCHBAR_POINT, false);
        boolean changed = false;
        if (!hasSet) {
            prefs.putBoolean(HAS_RESET_SEARCHBAR_POINT, true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
            if (configXml == null) {
                return changed;
            }
            String attrName = "IMemento.internal.id";
            String topBarId = "org.eclipse.ui.internal.WorkbenchWindow.topBar";
            String searchId = "com.pandora.ui.searchbar";
            List elements = configXml.selectNodes("//trimLayout/trimArea/trimItem[@" + attrName + "='" + topBarId + "']");
            if (elements != null && !elements.isEmpty()) {
                for (Element e : elements) {
                    if (e == null) continue;
                    Element parent = e.getParent();
                    List list = parent.elements();
                    parent.clearContent();
                    int i = 0;
                    while (i < list.size()) {
                        Element element = (Element)list.get(i);
                        Attribute id = element.attribute(attrName);
                        if (id != null) {
                            String value = id.getValue();
                            if (StringUtil.isNotBlank((String)value) && !value.equals(searchId)) {
                                parent.add(element);
                            }
                            if (StringUtil.isNotBlank((String)value) && value.equals(topBarId)) {
                                Element ne = parent.addElement("trimItem");
                                ne.addAttribute(attrName, searchId);
                                changed = true;
                            }
                        }
                        ++i;
                    }
                    break block2;
                }
            }
        }
        return changed;
    }

    protected boolean updateOpenwithPoint(Document configXml) throws Exception {
        IEclipsePreferences prefs = EclipseUtil.instanceScope().getNode(IdePlugin.PLUGIN_ID);
        boolean hasSet = prefs.getBoolean(HAS_RESET_OPENWITH_POINT, false);
        boolean changed = false;
        if (!hasSet) {
            prefs.putBoolean(HAS_RESET_OPENWITH_POINT, true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
            if (configXml == null) {
                return changed;
            }
            String attrName = "IMemento.internal.id";
            String homeId = "com.appcelerator.ui.trim";
            String openWithId = "com.pandora.ui.openWith";
            List elements = configXml.selectNodes("//trimLayout/trimArea/trimItem[@" + attrName + "='" + homeId + "']");
            if (elements != null && !elements.isEmpty()) {
                for (Element e : elements) {
                    if (e == null) continue;
                    Element parent = e.getParent();
                    List list = parent.elements();
                    parent.clearContent();
                    int i = 0;
                    while (i < list.size()) {
                        Element element = (Element)list.get(i);
                        Attribute id = element.attribute(attrName);
                        if (id != null) {
                            String value = id.getValue();
                            if (StringUtil.isNotBlank((String)value) && value.equals(homeId)) {
                                Element ne = parent.addElement("trimItem");
                                ne.addAttribute(attrName, openWithId);
                                changed = true;
                            }
                            if (StringUtil.isNotBlank((String)value) && !value.equals(openWithId)) {
                                parent.add(element);
                            }
                        }
                        ++i;
                    }
                    break block2;
                }
            }
        }
        return changed;
    }

    protected boolean updateEditorsPoint(Document configXml) throws Exception {
        boolean changed = false;
        if (configXml == null) {
            return changed;
        }
        if (CommonEditorPlugin.TEMP_FILES == null) {
            CommonEditorPlugin.initTempFile();
        }
        if (CollectionsUtil.isEmpty((Map)CommonEditorPlugin.TEMP_FILES)) {
            return changed;
        }
        String attr_partName = "partName";
        String attr_title = "title";
        String attr_tooltip = "tooltip";
        String attr_activePart = "activePart";
        String attr_temp = "istemp";
        List elements = configXml.selectNodes("//page/editors/editor");
        if (elements != null && !elements.isEmpty()) {
            for (Element element : elements) {
                if (element == null) continue;
                element.getParent();
                Attribute tooltipAttribute = element.attribute(attr_tooltip);
                if (tooltipAttribute == null) continue;
                String tooltipvalue = tooltipAttribute.getValue();
                Attribute tempAttribute = element.attribute(attr_temp);
                if (tempAttribute != null && tempAttribute.getValue().equals("true")) {
                    Element input;
                    String fileName = "\u5f10&T" + tooltipvalue;
                    if (!CommonEditorPlugin.TEMP_FILES.containsKey(fileName) || (input = element.element("input")) == null) continue;
                    input.addAttribute("uri", ((File)CommonEditorPlugin.TEMP_FILES.get(fileName)).toURI().toString());
                } else {
                    String fileName;
                    Attribute activePartAttribute = element.attribute(attr_activePart);
                    if (activePartAttribute != null && activePartAttribute.getValue().equals("true") || !CommonEditorPlugin.TEMP_FILES.containsKey(fileName = CommonEditorPlugin.getTempName((String)tooltipvalue))) continue;
                }
                Attribute partNameAttribute = element.attribute(attr_partName);
                partNameAttribute.setValue(this.getAttributeValue(partNameAttribute));
                Attribute titleAttribute = element.attribute(attr_title);
                titleAttribute.setValue(this.getAttributeValue(titleAttribute));
                changed = true;
            }
        }
        return changed;
    }

    public String getAttributeValue(Attribute attribute) {
        String p = "*";
        String av = attribute.getValue();
        if (!av.startsWith(p)) {
            av = String.valueOf(p) + av;
        }
        return av;
    }

    public void postStartup() {
        PlatformUtil.expandEnvironmentStrings((String)"%DesktopDirectory%");
        try {
            this.refreshFromLocal();
            this.activateProxyService();
            ((Workbench)PlatformUI.getWorkbench()).registerService(ISelectionConversionService.class, (Object)new IDESelectionConversionService());
            this.initializeSettingsChangeListener();
            Display.getCurrent().addListener(39, this.settingsChangeListener);
            this.initPreferences();
        }
        finally {
            Job.getJobManager().resume();
        }
    }

    private void activateProxyService() {
        ServiceReference ref;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        Object proxyService = null;
        if (bundle != null && (ref = bundle.getBundleContext().getServiceReference(IProxyService.class.getName())) != null) {
            proxyService = bundle.getBundleContext().getService(ref);
        }
        if (proxyService == null) {
            IDEWorkbenchPlugin.log((String)"Proxy service could not be found.");
        }
    }

    private void initializeSettingsChangeListener() {
        this.settingsChangeListener = new Listener(){
            boolean currentHighContrast = Display.getCurrent().getHighContrast();

            public void handleEvent(Event event) {
                if (Display.getCurrent().getHighContrast() == this.currentHighContrast) {
                    return;
                }
                boolean bl = this.currentHighContrast = !this.currentHighContrast;
                if (new MessageDialog(null, IDEWorkbenchMessages.SystemSettingsChange_title, null, IDEWorkbenchMessages.SystemSettingsChange_message, 3, new String[]{IDEWorkbenchMessages.SystemSettingsChange_yes, IDEWorkbenchMessages.SystemSettingsChange_no}, 1).open() == 0) {
                    PlatformUI.getWorkbench().restart();
                }
            }
        };
    }

    public void postShutdown() {
        if (this.activityHelper != null) {
            this.activityHelper.shutdown();
            this.activityHelper = null;
        }
        if (this.idleHelper != null) {
            this.idleHelper.shutdown();
            this.idleHelper = null;
        }
        if (this.workspaceUndoMonitor != null) {
            this.workspaceUndoMonitor.shutdown();
            this.workspaceUndoMonitor = null;
        }
        if (IDEWorkbenchPlugin.getPluginWorkspace() != null) {
            this.disconnectFromWorkspace();
        }
    }

    public boolean preShutdown() {
        try {
            boolean profile;
            boolean bl = profile = Profile.STARTUP;
            if (profile) {
                Profile.logEnter((String)"hbuilder.preShutdown");
            }
            IDEExitUtils.ideExit();
            if (profile) {
                Profile.logTime((String)"hbuilder.preShutdown", (String)"IDEExitUtils.ideExit");
            }
            if (!Platform.inDevelopmentMode()) {
                CrashUtil.deleteCrashFile();
                if (profile) {
                    Profile.logTime((String)"hbuilder.preShutdown", (String)"ExitUtils.deleteCrashFile");
                }
                SocketUtils.closeServer();
                if (profile) {
                    Profile.logTime((String)"hbuilder.preShutdown", (String)"SocketUtils.closeServer");
                }
                if (!PlatformUtil.isWindowsXP()) {
                    ExitUtils.saveImg();
                    if (profile) {
                        Profile.logTime((String)"hbuilder.preShutdown", (String)"ExitUtils.saveImg");
                    }
                }
                if (!InitializationUtils.email.equals(ReadyFileUtils.tmpuser) && PlatformUtil.isWindows()) {
                    ExitUtils.changeWorkspace();
                    if (profile) {
                        Profile.logTime((String)"hbuilder.preShutdown", (String)"ExitUtils.changeWorkspace");
                    }
                }
            }
            Display.getCurrent().removeListener(39, this.settingsChangeListener);
            if (profile) {
                Profile.logExit((String)"hbuilder.preShutdown");
            }
        }
        catch (Throwable e) {
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
        }
        return super.preShutdown();
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        this.workbenchWindowAdvisor = new IDEWorkbenchWindowAdvisor(this, configurer);
        return this.workbenchWindowAdvisor;
    }

    WorkbenchWindowAdvisor getWorkbenchWindowAdvisor() {
        return this.workbenchWindowAdvisor;
    }

    public boolean hasIntro() {
        return this.getWorkbenchConfigurer().getWorkbench().getIntroManager().hasIntro();
    }

    private void refreshFromLocal() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean refresh = store.getBoolean("REFRESH_WORKSPACE_ON_STARTUP");
        if (!refresh) {
            return;
        }
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-refresh")) {
                return;
            }
            ++i;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        WorkspaceJob job = new WorkspaceJob(IDEWorkbenchMessages.Workspace_refreshing, (IContainer)root){
            private final /* synthetic */ IContainer val$root;
            {
                this.val$root = iContainer;
                super($anonymous0);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                this.val$root.refreshLocal(2, monitor);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)root);
        job.schedule();
    }

    private void disconnectFromWorkspace() {
        PlatformUtil.setClosing((boolean)true);
        final MultiStatus status = new MultiStatus("org.eclipse.ui.ide", 1, IDEWorkbenchMessages.ProblemSavingWorkbench, null);
        int returnCode = 1;
        try {
            IWorkbench w = this.getWorkbenchConfigurer().getWorkbench();
            Field f = w.getClass().getDeclaredField("returnCode");
            f.setAccessible(true);
            returnCode = f.getInt(w);
        }
        catch (Exception e) {
            IDEWorkbenchPlugin.log((String)IDEWorkbenchMessages.ProblemsSavingWorkspace, (IStatus)StatusUtil.newStatus((int)4, (String)e.getMessage(), (Throwable)e));
        }
        if (returnCode == 0) {
            try {
                Shell[] ss = Display.getDefault().getShells();
                if (ss != null) {
                    Shell[] shellArray = ss;
                    int n = ss.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Shell s = shellArray[n2];
                        s.setVisible(false);
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                IDEWorkbenchPlugin.log((String)IDEWorkbenchMessages.ProblemsSavingWorkspace, (IStatus)StatusUtil.newStatus((int)4, (String)e.getMessage(), (Throwable)e));
            }
            try {
                status.merge(ResourcesPlugin.getWorkspace().save(true, (IProgressMonitor)new NullProgressMonitor()));
                status.merge(P2UpgradeUtils.endUpdateJob((IProgressMonitor)new NullProgressMonitor()));
            }
            catch (CoreException e) {
                IDEWorkbenchPlugin.log((String)IDEWorkbenchMessages.ProblemsSavingWorkspace, (IStatus)e.getStatus());
            }
        } else {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        status.merge(ResourcesPlugin.getWorkspace().save(true, monitor));
                        status.merge(P2UpgradeUtils.endUpdateJob((IProgressMonitor)monitor));
                    }
                    catch (CoreException e) {
                        status.merge(e.getStatus());
                    }
                }
            };
            try {
                new ProgressMonitorJobsDialog(null).run(true, false, runnable);
            }
            catch (InvocationTargetException e) {
                status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.InternalError, e.getTargetException()));
            }
            catch (InterruptedException e) {
                status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.InternalError, (Throwable)e));
            }
        }
        ErrorDialog.openError(null, (String)IDEWorkbenchMessages.ProblemsSavingWorkspace, null, (IStatus)status, (int)6);
        if (!status.isOK()) {
            IDEWorkbenchPlugin.log((String)IDEWorkbenchMessages.ProblemsSavingWorkspace, (IStatus)status);
        }
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getInitialWindowPerspectiveId() {
        return "org.eclipse.ui.resourcePerspective";
    }

    private Map<String, AboutInfo> computeBundleGroupMap() {
        TreeMap<String, AboutInfo> ids = new TreeMap<String, AboutInfo>();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        int i = 0;
        while (i < providers.length) {
            IBundleGroup[] groups;
            IBundleGroup[] iBundleGroupArray = groups = providers[i].getBundleGroups();
            int n = groups.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup group = iBundleGroupArray[n2];
                AboutInfo info = new AboutInfo(group);
                String version = info.getVersionId();
                version = version == null ? "0.0.0" : new Version(version).toString();
                String versionedFeature = String.valueOf(group.getIdentifier()) + ":" + version;
                ids.put(versionedFeature, info);
                ++n2;
            }
            ++i;
        }
        return ids;
    }

    public Map<String, AboutInfo> getNewlyAddedBundleGroups() {
        if (this.newlyAddedBundleGroups == null) {
            this.newlyAddedBundleGroups = this.createNewBundleGroupsMap();
        }
        return this.newlyAddedBundleGroups;
    }

    private Map<String, AboutInfo> createNewBundleGroupsMap() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        String[] previousFeaturesArray = settings.getArray(INSTALLED_FEATURES);
        Map<String, AboutInfo> bundleGroups = this.computeBundleGroupMap();
        String[] currentFeaturesArray = new String[bundleGroups.size()];
        bundleGroups.keySet().toArray(currentFeaturesArray);
        settings.put(INSTALLED_FEATURES, currentFeaturesArray);
        if (previousFeaturesArray != null) {
            int i = 0;
            while (i < previousFeaturesArray.length) {
                bundleGroups.remove(previousFeaturesArray[i]);
                ++i;
            }
        }
        return bundleGroups;
    }

    private void declareWorkbenchImages() {
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_HOVER", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_DISABLED", "$nl$/icons/full/dtool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_HOVER", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_DISABLED", "$nl$/icons/full/dtool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_NEXT_NAV", "$nl$/icons/full/etool16/next_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PREVIOUS_NAV", "$nl$/icons/full/etool16/prev_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWPRJ_WIZ", "$nl$/icons/full/wizban/newprj_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFOLDER_WIZ", "$nl$/icons/full/wizban/newfolder_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFILE_WIZ", "$nl$/icons/full/wizban/newfile_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTDIR_WIZ", "$nl$/icons/full/wizban/importdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTZIP_WIZ", "$nl$/icons/full/wizban/importzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTDIR_WIZ", "$nl$/icons/full/wizban/exportdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/exportzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/workset_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_SAVEAS_DLG", "$nl$/icons/full/wizban/saveas_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_QUICKFIX_DLG", "$nl$/icons/full/wizban/quick_fix.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT_CLOSED", "$nl$/icons/full/obj16/cprj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OPEN_MARKER", "$nl$/icons/full/elcl16/gotoobj_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ELCL_QUICK_FIX_ENABLED", "$nl$/icons/full/elcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_DLCL_QUICK_FIX_DISABLED", "$nl$/icons/full/dlcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_TASK_TSK", "$nl$/icons/full/obj16/taskmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_BKMRK_TSK", "$nl$/icons/full/obj16/bkmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_COMPLETE_TSK", "$nl$/icons/full/obj16/complete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INCOMPLETE_TSK", "$nl$/icons/full/obj16/incomplete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_ITEM", "$nl$/icons/full/obj16/welcome_item.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_BANNER", "$nl$/icons/full/obj16/welcome_banner.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_ERROR_PATH", "$nl$/icons/full/obj16/error_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WARNING_PATH", "$nl$/icons/full/obj16/warn_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INFO_PATH", "$nl$/icons/full/obj16/info_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_FLAT_LAYOUT", "$nl$/icons/full/elcl16/flatLayout.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_HIERARCHICAL_LAYOUT", "$nl$/icons/full/elcl16/hierarchicalLayout.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEM_CATEGORY", "$nl$/icons/full/etool16/problem_category.gif", true);
    }

    private void declareWorkbenchImage(Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = FileLocator.find((Bundle)ideBundle, (IPath)new Path(path), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getWorkbenchConfigurer().declareImage(symbolicName, desc, shared);
    }

    public String getMainPreferencePageId() {
        return WORKBENCH_PREFERENCE_CATEGORY_ID;
    }

    public String getWorkspaceLocation() {
        return this.workspaceLocation;
    }

    public AboutInfo[] getWelcomePerspectiveInfos() {
        if (this.welcomePerspectiveInfos == null && !this.hasIntro()) {
            Map<String, AboutInfo> m = this.getNewlyAddedBundleGroups();
            ArrayList<AboutInfo> list = new ArrayList<AboutInfo>(m.size());
            for (AboutInfo info : m.values()) {
                if (info == null || info.getWelcomePerspectiveId() == null || info.getWelcomePageURL() == null) continue;
                list.add(info);
            }
            this.welcomePerspectiveInfos = new AboutInfo[list.size()];
            list.toArray(this.welcomePerspectiveInfos);
        }
        return this.welcomePerspectiveInfos;
    }

    public AbstractStatusHandler getWorkbenchErrorHandler() {
        if (this.ideWorkbenchErrorHandler == null) {
            this.ideWorkbenchErrorHandler = new IDEWorkbenchErrorHandler(this.getWorkbenchConfigurer()){

                public void handle(StatusAdapter statusAdapter, int style) {
                    if (!this.isIgnored(statusAdapter)) {
                        super.handle(statusAdapter, style);
                    }
                }

                private boolean isIgnored(StatusAdapter statusAdapter) {
                    IStatus status = statusAdapter.getStatus();
                    if (status.getSeverity() == 4) {
                        return false;
                    }
                    String message = status.getMessage();
                    if (message != null) {
                        String[] stringArray = IGNORED_STATUS_MESSAGES;
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String ignored = stringArray[n2];
                            if (message.indexOf(ignored) > -1) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                    return false;
                }
            };
        }
        return this.ideWorkbenchErrorHandler;
    }

    public void eventLoopIdle(Display display) {
        if (this.delayedEventsProcessor != null) {
            this.delayedEventsProcessor.catchUp(display);
        }
        super.eventLoopIdle(display);
    }

    public List<String> getOpenEditors(IWorkbenchWindow[] windows) {
        ArrayList<String> openFiles = new ArrayList<String>();
        int i = 0;
        while (i < windows.length) {
            openFiles.addAll(this.getOpenEditors(windows[i].getPages()));
            ++i;
        }
        return openFiles;
    }

    public List<String> getOpenEditors(IWorkbenchPage[] pages) {
        ArrayList<String> openFiles = new ArrayList<String>();
        int i = 0;
        while (i < pages.length) {
            openFiles.addAll(this.getEditorReferences(pages[i]));
            ++i;
        }
        return openFiles;
    }

    public List<String> getEditorReferences(IWorkbenchPage page) {
        IEditorReference[] refs = page.getEditorReferences();
        if (refs == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> openFiles = new ArrayList<String>();
        int i = 0;
        while (i < refs.length) {
            try {
                String path;
                URI uri;
                IEditorInput input = refs[i].getEditorInput();
                if (input instanceof IURIEditorInput && "file".equals((uri = ((IURIEditorInput)input).getURI()).getScheme()) && !(path = new File(uri).getAbsolutePath()).startsWith(System.getProperty("java.io.tmpdir"))) {
                    openFiles.add(path);
                }
            }
            catch (PartInitException e) {
                IdePlugin.getDefault().getLog().log((IStatus)new Status(4, IdePlugin.getDefault().getBundle().getSymbolicName(), 0, Messages.ApplicationWorkbenchAdvisor_ErrorGettingCurrentEditorReferences, (Throwable)e));
            }
            ++i;
        }
        return openFiles;
    }

    private void initPreferences() {
        IEclipsePreferences prefs;
        if (!Platform.getPreferencesService().getBoolean(IdePlugin.PLUGIN_ID, "WORKSPACE_ENCODING_SET", false, null)) {
            try {
                ResourcesPlugin.getWorkspace().getRoot().setDefaultCharset("UTF-8", null);
            }
            catch (CoreException e) {
                IdePlugin.getDefault().getLog().log((IStatus)new Status(4, IdePlugin.PLUGIN_ID, 0, Messages.PreferenceInitializer_Cannot_Set_Default_Encoding, (Throwable)e));
            }
            prefs = EclipseUtil.instanceScope().getNode(IdePlugin.PLUGIN_ID);
            prefs.putBoolean("WORKSPACE_ENCODING_SET", true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        prefs = EclipseUtil.instanceScope().getNode("org.eclipse.ui.editors");
        if (!Platform.getPreferencesService().getBoolean(IdePlugin.PLUGIN_ID, "EDITOR_LINE_NUMBER_SET", false, null)) {
            prefs.putBoolean("lineNumberRuler", true);
            prefs = EclipseUtil.instanceScope().getNode(IdePlugin.PLUGIN_ID);
            prefs.putBoolean("EDITOR_LINE_NUMBER_SET", true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        prefs = EclipseUtil.instanceScope().getNode("org.eclipse.debug.ui");
        if (!Platform.getPreferencesService().getBoolean(IdePlugin.PLUGIN_ID, "BUILD_BEFORE_LAUNCH", false, null)) {
            prefs.putBoolean("org.eclipse.debug.ui.build_before_launch", false);
            prefs.put("org.eclipse.debug.ui.wait_for_build", "never");
            prefs = EclipseUtil.instanceScope().getNode(IdePlugin.PLUGIN_ID);
            prefs.putBoolean("BUILD_BEFORE_LAUNCH", true);
            try {
                prefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
        prefs = EclipseUtil.defaultScope().getNode("org.tigris.subversion.subclipse.tools.usage");
        prefs.putBoolean("ask_user_for_usage_report_preference", false);
        try {
            prefs.flush();
        }
        catch (BackingStoreException backingStoreException) {}
        IDEEncoding.addIDEEncoding((String)"GBK");
        IDEEncoding.addIDEEncoding((String)"GB2312");
    }
}

