/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp;

import com.aptana.rcp.IdePlugin;
import com.aptana.rcp.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;

public class IDETray {
    private TrayItem trayItem;
    private Image trayImage;
    private Menu trayMenu;
    private MenuItem showMenuItem;
    private boolean alwayShow = IdePlugin.getDefault().getPreferenceStore().getBoolean("ALWAYS_SHOW_TRAY");

    public void createSysTray(IWorkbenchWindow window) {
        this.trayItem = this.initTrayItem(window);
        if (this.trayItem != null) {
            this.initPopupMenu(window);
        }
    }

    private TrayItem initTrayItem(final IWorkbenchWindow window) {
        Tray tray = window.getShell().getDisplay().getSystemTray();
        if (tray == null) {
            return null;
        }
        this.trayItem = new TrayItem(tray, 0);
        this.trayItem.setVisible(this.alwayShow);
        this.trayItem.setImage(ResourceManager.getPluginImage((String)IdePlugin.PLUGIN_ID, (String)"/content/window1616.png"));
        this.trayItem.setToolTipText(Platform.getProduct().getName());
        window.getShell().addShellListener((ShellListener)new ShellAdapter(){

            public void shellIconified(ShellEvent e) {
                IDETray.this.toggleDisplay(window.getShell(), IDETray.this.trayItem, true);
            }
        });
        this.trayItem.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IDETray.this.toggleDisplay(window.getShell(), IDETray.this.trayItem, false);
            }
        });
        this.trayItem.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                System.out.println(1);
            }
        });
        return this.trayItem;
    }

    private void initPopupMenu(final IWorkbenchWindow window) {
        this.trayMenu = new Menu((Decorations)window.getShell(), 8);
        this.showMenuItem = new MenuItem(this.trayMenu, 8);
        this.showMenuItem.setText(Messages.IDETray_Hidden_Window);
        this.showMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IDETray.this.toggleDisplay(window.getShell(), IDETray.this.trayItem, true);
            }
        });
        new MenuItem(this.trayMenu, 2);
        MenuItem exitMenuItem = new MenuItem(this.trayMenu, 8);
        exitMenuItem.setText(Messages.IDETray_Exit);
        exitMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PlatformUI.getWorkbench().close();
            }
        });
        this.trayItem.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                IDETray.this.trayMenu.setVisible(true);
            }
        });
    }

    private synchronized void toggleDisplay(Shell shell, TrayItem tray, boolean reverse) {
        try {
            if (!reverse && shell.getVisible()) {
                return;
            }
            shell.setVisible(!shell.isVisible());
            tray.setVisible(!shell.isVisible() || this.alwayShow);
            if (shell.getVisible()) {
                shell.setMinimized(false);
                shell.setActive();
                this.showMenuItem.setText(Messages.IDETray_Hidden_Window);
            } else {
                this.showMenuItem.setText(Messages.IDETray_Show_Window);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        if (this.trayMenu != null) {
            this.trayMenu.dispose();
        }
        if (this.trayItem != null) {
            this.trayItem.dispose();
        }
        if (this.trayImage != null) {
            this.trayImage.dispose();
        }
    }
}

