/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rcp;

import com.aptana.core.CorePlugin;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.PlatformUtil;
import com.aptana.core.util.ResourceUtil;
import com.aptana.rcp.ChooseWorkspaceDialog;
import com.aptana.rcp.DelayedEventsProcessor;
import com.aptana.rcp.HBuilderStartUtils;
import com.aptana.rcp.IDEWorkbenchAdvisor;
import com.aptana.rcp.IdePlugin;
import com.aptana.rcp.Messages;
import com.aptana.rcp.ReadyFileUtils;
import com.aptana.rcp.SystemUtils;
import com.pandora.cef3.CEF3Browser;
import com.pandora.core.CoreActivator;
import com.pandora.core.auth.UserAuth;
import com.pandora.core.stats.Stats;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;

public class IDEApplication
implements IApplication,
IExecutableExtension {
    public static final String METADATA_FOLDER = ".metadata";
    private static final String VERSION_FILENAME = "version.ini";
    private static final String WORKSPACE_VERSION_KEY = "org.eclipse.core.runtime";
    private static final String WORKSPACE_VERSION_VALUE = "1";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    public static final String PLUGIN_ID = IdePlugin.PLUGIN_ID;

    public Object start(IApplicationContext appContext) throws Exception {
        boolean profile;
        boolean bl = profile = Profile.STARTUP;
        if (profile) {
            Profile.logEnter((String)"hbuilder.IDEApplication");
        }
        System.setProperty("IDEApplication.start", String.valueOf(System.currentTimeMillis()));
        Display display = this.createDisplay();
        if (profile) {
            Profile.logTime((String)"hbuilder.IDEApplication", (String)"createDisplay");
        }
        ReadyFileUtils.loginAnalysisMap.put("createDisplay.end", String.valueOf(System.currentTimeMillis()));
        if (PlatformUtil.isMac() && !Platform.inDevelopmentMode()) {
            try {
                String installDir = ResourceUtil.resourcePathToString((URL)FileLocator.toFileURL((URL)Platform.getInstallLocation().getURL()));
                String path = String.valueOf(installDir) + "/bkLogin";
                String[] cmds = new String[]{"chmod", "+x", path};
                Runtime.getRuntime().exec(cmds);
                String launcherpath = String.valueOf(installDir) + "/Lancher/Lancher.app/Contents/MacOS/Lancher";
                String[] lcmds = new String[]{"chmod", "+x", launcherpath};
                Runtime.getRuntime().exec(lcmds);
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
            }
            if (profile) {
                Profile.logTime((String)"hbuilder.IDEApplication", (String)"chmod bkLogin & Lancher");
            }
        }
        EclipseEnvironmentInfo eclipseEnvironmentInfo = EclipseEnvironmentInfo.getDefault();
        String[] args_ = eclipseEnvironmentInfo.getNonFrameworkArgs();
        if (profile) {
            Profile.logTime((String)"hbuilder.IDEApplication", (String)"EclipseEnvironmentInfo.getDefault");
        }
        IdeLog.logInfo((Plugin)CorePlugin.getDefault(), (String)"ide start check begin");
        ReadyFileUtils.USERPROFILES = PlatformUtil.isWindows() ? String.valueOf(System.getenv().get("APPDATA")) + "/HBuilder/userprofiles" : String.valueOf(System.getenv().get("HOME")) + "/HBuilder/userprofiles";
        ResourcesPlugin.getPlugin();
        URI uri = ResourcesPlugin.getWorkspace().getRoot().getRawLocationURI();
        if (profile) {
            Profile.logTime((String)"hbuilder.IDEApplication", (String)"ResourcesPlugin.getRawLocationURI");
        }
        IdeLog.logError((Plugin)IdePlugin.getDefault(), (String)("getRawLocationURI: " + uri));
        ReadyFileUtils.loginAnalysisMap.put("getRawLocationURI.end", String.valueOf(System.currentTimeMillis()));
        File tmpfile = new File(uri);
        String workspaceurl = tmpfile.getPath();
        workspaceurl = workspaceurl.replace("\\", "/");
        String[] tmpstrings = workspaceurl.split("/");
        ReadyFileUtils.tmpuser = tmpstrings[tmpstrings.length - 1];
        if (!Platform.inDevelopmentMode()) {
            if (PlatformUtil.isWindows()) {
                UserAuth.initUserAuth((String)ReadyFileUtils.tmpuser, (String)"");
            } else {
                ReadyFileUtils.tmpuser = ReadyFileUtils.getLastloginUser();
                UserAuth.initUserAuth((String)ReadyFileUtils.tmpuser, (String)"");
            }
        }
        if (profile) {
            Profile.logTime((String)"hbuilder.IDEApplication", (String)"UserAuth.initUserAuth");
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z]+:[\\\\/]?[\\S\\s]+$");
        String[] stringArray = args_;
        int n = args_.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                ReadyFileUtils.filepath = string;
            }
            if (string.indexOf("-ready") >= 0) {
                HBuilderStartUtils.START_TYPE = 0;
            }
            if (string.indexOf("-qs") >= 0) {
                ReadyFileUtils.hasqs = true;
            }
            if (string.indexOf("-logindebug") >= 0) {
                ReadyFileUtils.isLoginDebug = true;
            }
            if (string.indexOf("-login") >= 0) {
                HBuilderStartUtils.START_TYPE = 1;
            }
            ++n2;
        }
        if (profile) {
            Profile.logTime((String)"hbuilder.IDEApplication", (String)"check args");
        }
        if (!ReadyFileUtils.hasqs && HBuilderStartUtils.START_TYPE != 1 && HBuilderStartUtils.START_TYPE != 0 && !Platform.inDevelopmentMode()) {
            ReadyFileUtils.startHBuilder(false, false);
            if (profile) {
                Profile.logTime((String)"hbuilder.IDEApplication", (String)"ReadyFileUtils.startHBuilder");
            }
            return EXIT_OK;
        }
        DelayedEventsProcessor processor = new DelayedEventsProcessor(display);
        try {
            Shell shell = WorkbenchPlugin.getSplashShell((Display)display);
            if (profile) {
                Profile.logTime((String)"hbuilder.IDEApplication", (String)"get Shell");
            }
            if (shell != null) {
                shell.setText(ChooseWorkspaceDialog.getWindowTitle());
                shell.setImages(Dialog.getDefaultImages());
            }
            if (profile) {
                Profile.logTime((String)"hbuilder.IDEApplication", (String)"config Shell");
            }
            ReadyFileUtils.loginAnalysisMap.put("checkInstanceLocation.start", String.valueOf(System.currentTimeMillis()));
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (String)"checkInstanceLocation");
            if (!this.checkInstanceLocation(shell)) {
                WorkbenchPlugin.unsetSplashShell((Display)display);
                appContext.applicationRunning();
                Integer n3 = EXIT_OK;
                return n3;
            }
            if (profile) {
                Profile.logTime((String)"hbuilder.IDEApplication", (String)"checkInstanceLocation()");
            }
            ReadyFileUtils.loginAnalysisMap.put("checkInstanceLocation.end", String.valueOf(System.currentTimeMillis()));
            Object args = appContext.getArguments().get("application.args");
            if (PlatformUtil.isWindows() && !Platform.inDevelopmentMode()) {
                try {
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                CEF3Browser.initCEF();
                                IdeLog.logError((Plugin)IdePlugin.getDefault(), (String)"init CEF");
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
                }
            }
            ReadyFileUtils.loginAnalysisMap.put("IDEApplication.end", String.valueOf(System.currentTimeMillis()));
            if (profile) {
                Profile.logExit((String)"hbuilder.IDEApplication");
            }
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new IDEWorkbenchAdvisor(processor, args instanceof String[] ? (String[])args : new String[]{}));
            if (PlatformUtil.isWindows()) {
                try {
                    CEF3Browser.closeAll();
                    IdeLog.logInfo((Plugin)IdePlugin.getDefault(), (String)"close CEF");
                }
                catch (Throwable e) {
                    IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
                }
            }
            if (returnCode != 1) {
                ReadyFileUtils.startHBuilder(true, false);
                Integer n4 = EXIT_OK;
                return n4;
            }
            if (!PlatformUtil.isMac()) {
                ReadyFileUtils.startHBuilder(false, true);
                Integer n5 = EXIT_OK;
                return n5;
            }
            Integer n6 = EXIT_RESTART;
            return n6;
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)IdePlugin.getDefault(), (Throwable)e);
            Stats.addExceptionInfo((Throwable)e);
            throw e;
        }
        finally {
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc != null) {
                instanceLoc.release();
            }
        }
    }

    protected Display createDisplay() {
        return PlatformUI.createDisplay();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
    }

    private boolean checkInstanceLocation(Shell shell) {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            ReadyFileUtils.saveError(IDEWorkbenchMessages.IDEApplication_workspaceMandatoryMessage);
            return false;
        }
        if (instanceLoc.isSet()) {
            block24: {
                if (!this.checkValidWorkspace(shell, instanceLoc.getURL())) {
                    return false;
                }
                if (!instanceLoc.lock()) break block24;
                IDEApplication.writeWorkspaceVersion();
                return true;
            }
            try {
                File workspaceDirectory = new File(instanceLoc.getURL().getFile());
                long freeSpace = workspaceDirectory.getFreeSpace() / 0x100000L;
                if (freeSpace < CoreActivator.FREE_SPACE) {
                    ReadyFileUtils.saveError(Messages.IDEApplication_WorkspaceLackOfSpace);
                }
                if (workspaceDirectory.exists()) {
                    if (ReadyFileUtils.hasqs) {
                        SystemUtils.exit();
                    } else {
                        ReadyFileUtils.saveError("DUPLICATE_DIR");
                    }
                } else if (ReadyFileUtils.hasqs) {
                    SystemUtils.exit();
                } else {
                    ReadyFileUtils.saveError("DUPLICATE_DIR");
                }
            }
            catch (IOException e) {
                IDEWorkbenchPlugin.log((String)"Could not obtain lock for workspace location", (Throwable)e);
                ReadyFileUtils.saveError(e.getMessage());
            }
            return false;
        }
        String userHome = System.getProperty("user.home");
        URL url = null;
        try {
            String path = String.valueOf(userHome) + "/HBuilder/userprofiles";
            File workspaceDir = new File(path);
            if (!workspaceDir.exists() || !workspaceDir.isDirectory()) {
                workspaceDir.mkdirs();
            }
            url = new URL(path);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
            url = instanceLoc.getDefault();
        }
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(url);
        launchData.toggleShowDialog();
        boolean force = false;
        while (true) {
            URL workspaceUrl;
            block25: {
                if ((workspaceUrl = this.promptForWorkspace(shell, launchData, force)) == null) {
                    return false;
                }
                force = true;
                try {
                    if (!instanceLoc.isSet()) break block25;
                    return true;
                }
                catch (IOException iOException) {
                    if (ReadyFileUtils.hasqs) {
                        SystemUtils.exit();
                    } else {
                        ReadyFileUtils.saveError("DUPLICATE_DIR");
                    }
                    return false;
                }
            }
            if (instanceLoc.set(workspaceUrl, true)) {
                launchData.writePersistedData();
                IDEApplication.writeWorkspaceVersion();
                return true;
            }
            ReadyFileUtils.saveError(IDEWorkbenchMessages.IDEApplication_workspaceInUseMessage);
        }
    }

    private URL promptForWorkspace(Shell shell, ChooseWorkspaceData launchData, boolean force) {
        URL url = null;
        do {
            new ChooseWorkspaceDialog(shell, launchData, false, true).prompt(force);
            String instancePath = launchData.getSelection();
            if (instancePath == null) {
                return null;
            }
            force = true;
            if (instancePath.length() <= 0) {
                ReadyFileUtils.saveError(IDEWorkbenchMessages.IDEApplication_workspaceEmptyMessage);
                continue;
            }
            File workspace = new File(instancePath);
            if (!workspace.exists()) {
                workspace.mkdir();
            }
            try {
                String path = workspace.getAbsolutePath().replace(File.separatorChar, '/');
                url = new URL("file", null, path);
            }
            catch (MalformedURLException malformedURLException) {
                ReadyFileUtils.saveError(IDEWorkbenchMessages.IDEApplication_workspaceInvalidMessage);
            }
        } while (!this.checkValidWorkspace(shell, url));
        return url;
    }

    private boolean checkValidWorkspace(Shell shell, URL url) {
        if (url == null) {
            return false;
        }
        String version = IDEApplication.readWorkspaceVersion(url);
        if (version == null) {
            return true;
        }
        int ide_version = Integer.parseInt(WORKSPACE_VERSION_VALUE);
        int workspace_version = Integer.parseInt(version);
        if (workspace_version == ide_version) {
            return true;
        }
        String title = IDEWorkbenchMessages.IDEApplication_versionTitle;
        String message = NLS.bind((String)IDEWorkbenchMessages.IDEApplication_versionMessage, (Object)url.getFile());
        MessageBox mbox = new MessageBox(shell, 65832);
        mbox.setText(title);
        mbox.setMessage(message);
        return mbox.open() == 32;
    }

    private static String readWorkspaceVersion(URL workspace) {
        File versionFile = IDEApplication.getVersionFile(workspace, false);
        if (versionFile == null || !versionFile.exists()) {
            return null;
        }
        try {
            Properties props = new Properties();
            FileInputStream is = new FileInputStream(versionFile);
            try {
                props.load(is);
            }
            finally {
                is.close();
            }
            return props.getProperty(WORKSPACE_VERSION_KEY);
        }
        catch (IOException e) {
            IDEWorkbenchPlugin.log((String)"Could not read version file", (IStatus)new Status(4, "org.eclipse.ui.ide", 4, e.getMessage() == null ? "" : e.getMessage(), (Throwable)e));
            return null;
        }
    }

    private static void writeWorkspaceVersion() {
        block16: {
            Location instanceLoc = Platform.getInstanceLocation();
            if (instanceLoc == null || instanceLoc.isReadOnly()) {
                return;
            }
            File versionFile = IDEApplication.getVersionFile(instanceLoc.getURL(), true);
            if (versionFile == null) {
                return;
            }
            OutputStream output = null;
            try {
                try {
                    String versionLine = "org.eclipse.core.runtime=1";
                    output = new FileOutputStream(versionFile);
                    output.write(versionLine.getBytes("UTF-8"));
                }
                catch (IOException e) {
                    IDEWorkbenchPlugin.log((String)"Could not write version file", (IStatus)StatusUtil.newStatus((int)4, (String)e.getMessage(), (Throwable)e));
                    try {
                        if (output != null) {
                            output.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static File getVersionFile(URL workspaceUrl, boolean create) {
        File versionFile;
        block6: {
            File metaDir;
            block5: {
                if (workspaceUrl == null) {
                    return null;
                }
                try {
                    metaDir = new File(workspaceUrl.getPath(), METADATA_FOLDER);
                    if (metaDir.exists() || create && metaDir.mkdir()) break block5;
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            versionFile = new File(metaDir, VERSION_FILENAME);
            if (versionFile.exists() || create && versionFile.createNewFile()) break block6;
            return null;
        }
        return versionFile;
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }
}

