/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.index.application;

import com.aptana.index.core.AbstractRemoteFileIndexingParticipant;
import com.aptana.index.core.IFileStoreIndexingParticipant;
import com.aptana.index.core.IndexManager;
import com.aptana.index.core.IndexPlugin;
import com.pandora.core.log.HBLog;
import com.pandora.core.utils.Activator;
import com.pandora.core.utils.CollectionsUtil;
import com.pandora.index.service.IndexRequest;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class IndexJob
extends Job {
    private boolean debug = Platform.inDebugMode();
    LinkedBlockingDeque<IndexRequest> fRequestQueue;

    protected IndexJob(LinkedBlockingDeque<IndexRequest> requestQueue) {
        super("process index request queue");
        this.fRequestQueue = requestQueue;
    }

    protected IndexManager getIndexManager() {
        IndexPlugin plugin = IndexPlugin.getDefault();
        return plugin != null ? plugin.getIndexManager() : null;
    }

    protected void indexFile(IndexRequest request) throws CoreException {
        if (request == null) {
            return;
        }
        IFileStore store = EFS.getStore((URI)request.getIndexURI());
        if (store == null) {
            return;
        }
        boolean deleted = false;
        List<IFileStoreIndexingParticipant> indexers = this.getIndexParticipants(store);
        if (!CollectionsUtil.isEmpty(indexers)) {
            for (IFileStoreIndexingParticipant indexer : indexers) {
                try {
                    if (!(indexer instanceof AbstractRemoteFileIndexingParticipant)) continue;
                    AbstractRemoteFileIndexingParticipant remoteIndexer = (AbstractRemoteFileIndexingParticipant)indexer;
                    if (!deleted) {
                        deleted = remoteIndexer.deleteFileIndex(request);
                    }
                    remoteIndexer.requestIndex(request, (IProgressMonitor)new NullProgressMonitor());
                    remoteIndexer.submitIndex(request);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected List<IFileStoreIndexingParticipant> getIndexParticipants(IFileStore file) {
        IndexManager indexManager = this.getIndexManager();
        if (indexManager != null) {
            return indexManager.getIndexParticipants(file.getName());
        }
        return Collections.emptyList();
    }

    protected IStatus run(IProgressMonitor monitor) {
        while (this.getState() == 4 && !monitor.isCanceled()) {
            IndexRequest request = null;
            try {
                request = this.fRequestQueue.take();
                long time = 0L;
                if (this.debug) {
                    time = System.currentTimeMillis();
                    HBLog.logError((Plugin)Activator.getDefault(), (String)("=== start === " + request.getIndexURI()));
                }
                this.indexFile(request);
                if (!this.debug) continue;
                HBLog.logError((Plugin)Activator.getDefault(), (String)("=== end === " + request.getIndexURI() + "  " + (System.currentTimeMillis() - time)));
            }
            catch (Throwable e) {
                HBLog.logError((Plugin)Activator.getDefault(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }
}

